/*
 *  acm : an aerial combat simulator for X
 *  Null weapon module.
 *  Copyright (C) 2009 Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#include <string.h>
#include "pm.h"

#define weapon_null_IMPORT
#include "weapon_null.h"

static int
select_null(craft * c)
{
	return 1;
}

static int
update_null(craft * c)
{
	return 1;
}

static int
fire_null(craft * c)
{
	return 1;
}

/*
 *  Display function
 *
 *  Update the HUD display strings associated with this weapon system.
 *  c = the aircraft.
 *  w = the weapon's description record.
 *  fpm_x, fpm_y = position of the FPM in HUD
 *
 *  This code may be called by drones.  Return a nonzero value if
 *  have a reasonable chance of scoring a kill.
 */

static int
display_null(craft * c, craftType * w, viewer * u, int fpm_x, int fpm_y)
{
	/*
		HUD strings c->leftHUD[2, ..., 5] are reserved to the currently
		selected weapon.
		(leftHUD[1] is the Mach number,
	*/

	strcpy(c->leftHUD[2], "");  /* shot hint */
	strcpy(c->leftHUD[3], "");  /* weapon name */
	strcpy(c->leftHUD[4], "");  /* "FIRING", ecc. */
	strcpy(c->leftHUD[5], "");  /* ??? */

	/* Return TRUE if we are recommending a weapon shot. */
	return 0;
}


static weapon_Type nullDesc =
{
	select_null,				/* select */
	update_null,				/* update */
	display_null,				/* display procedure */
	fire_null,					/* fire */
	(int (*)(craft *)) NULL,	/* fire button release */
};


weapon_Type *
weapon_null_new(void)
{
	nullDesc.w = NULL;
	return &nullDesc;
}
