/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.Rect;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PixMap {
    public static final int PACK_TYPE_PACKBITS = 0;
    public static final int PACK_TYPE_UNPACKED = 1;
    public static final int PACK_TYPE_UNPACKED_NO_PADDING = 2;
    public static final int PACK_TYPE_BY_PIXEL = 3;
    public static final int PACK_TYPE_BY_COMPONENT = 4;
    public static final int PIXEL_TYPE_INDEXED = 0;
    public static final int PIXEL_TYPE_RGBDIRECT = 16;
    public static final int PIXEL_SIZE_1BIT = 1;
    public static final int PIXEL_SIZE_2BIT = 2;
    public static final int PIXEL_SIZE_4BIT = 4;
    public static final int PIXEL_SIZE_8BIT = 8;
    public static final int PIXEL_SIZE_16BIT = 16;
    public static final int PIXEL_SIZE_32BIT = 32;
    public static final int COMPONENT_COUNT_INDEXED = 1;
    public static final int COMPONENT_COUNT_RGB = 3;
    public static final int COMPONENT_COUNT_ARGB = 4;
    public static final int COMPONENT_SIZE_1BIT = 1;
    public static final int COMPONENT_SIZE_2BIT = 2;
    public static final int COMPONENT_SIZE_4BIT = 4;
    public static final int COMPONENT_SIZE_8BIT = 8;
    public static final int COMPONENT_SIZE_16BIT = 5;
    public static final int COMPONENT_SIZE_32BIT = 8;
    public int baseAddr = 0;
    public int rowBytes = 0;
    public Rect bounds = new Rect();
    public int pmVersion = 0;
    public int packType = 0;
    public int packSize = 0;
    public float hRes = 72.0f;
    public float vRes = 72.0f;
    public int pixelType = 0;
    public int pixelSize = 1;
    public int cmpCount = 1;
    public int cmpSize = 1;
    public int planeBytes = 0;
    public int pmTable = 0;
    public int pmReserved = 0;

    public static PixMap read(DataInputStream in, boolean withBaseAddr) throws IOException {
        PixMap p = new PixMap();
        p.baseAddr = withBaseAddr ? in.readInt() : 0;
        p.rowBytes = in.readUnsignedShort();
        p.bounds = Rect.read(in);
        if ((p.rowBytes & 0x8000) != 0) {
            p.pmVersion = in.readShort();
            p.packType = in.readShort();
            p.packSize = in.readInt();
            p.hRes = (float)in.readInt() / 65536.0f;
            p.vRes = (float)in.readInt() / 65536.0f;
            p.pixelType = in.readShort();
            p.pixelSize = in.readShort();
            p.cmpCount = in.readShort();
            p.cmpSize = in.readShort();
            p.planeBytes = in.readInt();
            p.pmTable = in.readInt();
            p.pmReserved = in.readInt();
        } else {
            p.pmVersion = 0;
            p.packType = 0;
            p.packSize = 0;
            p.hRes = 72.0f;
            p.vRes = 72.0f;
            p.pixelType = 0;
            p.pixelSize = 1;
            p.cmpCount = 1;
            p.cmpSize = 1;
            p.planeBytes = 0;
            p.pmTable = 0;
            p.pmReserved = 0;
        }
        return p;
    }

    public void write(DataOutputStream out, boolean withBaseAddr) throws IOException {
        if ((this.rowBytes & 0x8000) == 0 && (this.pmVersion != 0 || this.packType != 0 || this.packSize != 0 || this.hRes != 72.0f || this.vRes != 72.0f || this.pixelType != 0 || this.pixelSize != 1 || this.cmpCount != 1 || this.cmpSize != 1 || this.planeBytes != 0 || this.pmTable != 0 || this.pmReserved != 0)) {
            this.rowBytes |= 0x8000;
        }
        if (withBaseAddr) {
            out.writeInt(this.baseAddr);
        }
        out.writeShort(this.rowBytes);
        this.bounds.write(out);
        if ((this.rowBytes & 0x8000) != 0) {
            out.writeShort(this.pmVersion);
            out.writeShort(this.packType);
            out.writeInt(this.packSize);
            out.writeInt((int)(this.hRes * 65536.0f));
            out.writeInt((int)(this.vRes * 65536.0f));
            out.writeShort(this.pixelType);
            out.writeShort(this.pixelSize);
            out.writeShort(this.cmpCount);
            out.writeShort(this.cmpSize);
            out.writeInt(this.planeBytes);
            out.writeInt(this.pmTable);
            out.writeInt(this.pmReserved);
        }
    }

    public String toString() {
        return String.valueOf((this.rowBytes & 0x8000) == 0 ? "Bitmap" : "Pixmap") + "[" + this.bounds.toString() + "]";
    }

    public boolean hasColorTable() {
        return this.pixelType == 0 && (this.rowBytes & 0x8000) != 0;
    }

    public byte[] readPixData(DataInputStream in, boolean packed) throws IOException {
        if (this.packType == 0 && !packed || this.packType == 1 || (this.rowBytes & Short.MAX_VALUE) < 8) {
            byte[] data = new byte[(this.rowBytes & Short.MAX_VALUE) * (this.bounds.bottom - this.bounds.top)];
            in.readFully(data);
            return data;
        }
        if (this.packType == 2) {
            byte[] data = new byte[(this.rowBytes & Short.MAX_VALUE) * (this.bounds.bottom - this.bounds.top) * 3 / 4];
            in.readFully(data);
            return data;
        }
        if ((this.rowBytes & Short.MAX_VALUE) > 250) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            int y = this.bounds.top;
            while (y < this.bounds.bottom) {
                byte[] scanline = new byte[in.readUnsignedShort()];
                in.readFully(scanline);
                dout.writeShort(scanline.length);
                dout.write(scanline);
                ++y;
            }
            dout.close();
            bout.close();
            return bout.toByteArray();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        int y = this.bounds.top;
        while (y < this.bounds.bottom) {
            byte[] scanline = new byte[in.readUnsignedByte()];
            in.readFully(scanline);
            dout.writeByte(scanline.length);
            dout.write(scanline);
            ++y;
        }
        dout.close();
        bout.close();
        return bout.toByteArray();
    }

    public void writePixData(DataOutputStream out, byte[] data) throws IOException {
        out.write(data);
    }
}

