#ifndef _DEFINITION_H_
#define _DEFINITION_H_

#include "xml/stream.h"
#include <boost/ptr_container/ptr_vector.hpp>
#include <boost/scoped_ptr.hpp>


class xhex;
class platform;
class programmer;
class device;
class segment;
class data;
class info;


class xhex {
  private:
    static xhex * createFromStream(std::istream & in);
    static xhex * createFromSRec(const std::string & filename, const std::string & defPlatform);
    static xhex * createFromHex(const std::string & filename, const std::string & defPlatform);
    static xhex * createFromXHex(const std::string & filename);
  public:
    boost::scoped_ptr<platform> platformPtr;
    boost::scoped_ptr<programmer> programmerPtr;
    boost::scoped_ptr<device> devicePtr;
    boost::ptr_vector<info> infoVec;
    info * getInfo(const std::string & id);
    xhex(nicai::xml::ixmlstream & xin);
    static xhex * create(const std::string & filename, const std::string & defPlatform);
};


class info {
  public:
    std::string id;
    std::string content;
    info(nicai::xml::ixmlstream & xin);
};


class platform {
  public:
    std::string content;
    platform(nicai::xml::ixmlstream & xin);
};


class programmer {
  public:
    std::string type;
    std::string baudrate;
    std::string bitclock;
    programmer(nicai::xml::ixmlstream & xin);
};


class device {
  public:
    std::string part;
    bool erase;
    device(nicai::xml::ixmlstream & xin);
    boost::ptr_vector<segment> segmentVec;
    segment * getSegment(const std::string & id);
};


class segment {
    public:
        // xml data
        std::string id;
        std::string format;
        bool verify;
        std::string content;
        unsigned int baseAddress;
        
        // derived data
        int byteSize;
        std::vector<uint8_t> memory;
        
        // childs
        boost::ptr_vector<data> dataVec;
        
        segment(nicai::xml::ixmlstream & xin);
};


class data {
  public:
    std::string address;
    std::string content;
    data(nicai::xml::ixmlstream & xin);
};








#endif
