{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetInternal: boolean;
    procedure SetInternal(const Value: boolean);
  public
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;
    property Direction: TVector3 read GetDirection write SetDirection;
    procedure SetCoordIndex(const Value: array of LongInt);
    procedure SetCoordIndex(const Value: TLongIntList);
    property Internal: boolean read GetInternal write SetInternal;

{$endif read_interface}

{$ifdef read_implementation}

{ TVolumeEmitterNode ----------------------------------------------- }

function TVolumeEmitterNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure TVolumeEmitterNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

function TVolumeEmitterNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TVolumeEmitterNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

procedure TVolumeEmitterNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure TVolumeEmitterNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

function TVolumeEmitterNode.GetInternal: boolean;
begin
  Result := FdInternal.Value;
end;

procedure TVolumeEmitterNode.SetInternal(const Value: boolean);
begin
  FdInternal.Send(Value);
end;

{$endif read_implementation}
