/*
    Jonathan "lonesock" Dummer
    Signed Distance Font Tool

    C header
    font: "Bitstream Vera Sans Mono"
*/

#ifndef HEADER_SIGNED_DISTANCE_FONT_XXX
#define HEADER_SIGNED_DISTANCE_FONT_XXX

/* array size information */
const int sdf_tex_width = 128;
const int sdf_tex_height = 128;
const int sdf_num_chars = 95;
/* 'unsigned char sdf_data[]' is defined last */

/*
    The following array holds the spacing info for rendering.
    Note that the final 3 values need sub-pixel accuracy, so
    they are multiplied by a scaling factor.  Make sure to
    divide by scale_factor before using the 'offset' and
    'advance' values.

    Here is the data order in the following array:
    [0] Unicode character ID
    [1] X position in this texture
    [2] Y position in this texture
    [3] Width of this glyph in the texture
    [4] Height of this glyph in the texture
    [5] X Offset * scale_factor  | Draw the glyph at X,Y offset
    [6] Y Offset * scale_factor  | relative to the cursor, then
    [7] X Advance * scale_factor | advance the cursor by this.
*/
const float scale_factor = 1000.000000;
const int sdf_spacing[] = {
  32,17,105,4,4,-1500,1500,8437,
  33,120,42,7,14,750,11750,8437,
  34,43,0,9,7,62,11750,8437,
  35,59,56,13,14,-1812,11625,8437,
  36,72,71,11,16,-1250,12187,8437,
  37,46,56,12,13,-1312,11312,8437,
  38,59,98,12,14,-1750,11937,8437,
  39,17,98,5,7,1812,11750,8437,
  40,22,31,9,16,750,12187,8437,
  41,22,47,9,16,-750,12187,8437,
  42,11,88,10,10,-687,11937,8437,
  43,11,53,11,11,-1062,9687,8437,
  44,64,0,7,8,-125,4000,8437,
  45,71,0,8,6,125,6562,8437,
  46,86,0,6,6,875,4000,8437,
  47,83,87,11,15,-1500,11750,8437,
  48,81,28,11,14,-937,11937,8437,
  49,118,99,10,14,-1250,11750,8437,
  50,96,42,12,14,-1750,11937,8437,
  51,92,28,11,14,-1750,11937,8437,
  52,103,28,11,14,-1437,11750,8437,
  53,114,28,11,14,-1500,11750,8437,
  54,33,42,11,14,-875,11875,8437,
  55,33,56,11,14,-812,11750,8437,
  56,33,70,11,14,-1125,11937,8437,
  57,33,84,11,14,-1125,11937,8437,
  58,25,0,7,11,562,8812,8437,
  59,120,56,8,13,-375,8750,8437,
  60,11,31,11,11,-937,9625,8437,
  61,11,113,11,8,-937,8250,8437,
  62,22,117,11,11,-937,9625,8437,
  63,118,71,9,14,437,11937,8437,
  64,72,56,12,15,-1625,11062,8437,
  65,106,113,12,14,-2312,11812,8437,
  66,94,113,12,14,-1687,11750,8437,
  67,33,98,11,14,-625,11937,8437,
  68,106,85,12,14,-1562,11750,8437,
  69,106,71,12,14,-1312,11750,8437,
  70,84,56,12,14,-1187,11812,8437,
  71,33,112,11,14,-812,11937,8437,
  72,108,56,12,14,-1562,11750,8437,
  73,59,70,12,14,-1375,11750,8437,
  74,96,56,12,14,-1687,11750,8437,
  75,46,42,13,14,-1625,11750,8437,
  76,118,113,10,14,-1000,11750,8437,
  77,46,28,13,14,-1937,11750,8437,
  78,94,71,12,14,-1687,11750,8437,
  79,72,101,11,14,-1125,11937,8437,
  80,94,99,12,14,-1437,11687,8437,
  81,83,71,11,16,-1125,11937,8437,
  82,106,99,12,14,-1500,11750,8437,
  83,59,28,11,14,-1500,11937,8437,
  84,46,97,11,14,-312,11750,8437,
  85,108,42,12,14,-1250,11750,8437,
  86,72,87,11,14,-125,11750,8437,
  87,59,42,13,14,-1250,11750,8437,
  88,11,0,14,14,-2500,11750,8437,
  89,84,42,12,14,-562,11750,8437,
  90,33,14,13,14,-1750,11750,8437,
  91,22,63,9,16,0,12187,8437,
  92,11,98,6,15,812,11750,8437,
  93,22,79,9,16,-812,12187,8437,
  94,11,121,11,7,-1125,11750,8437,
  95,52,0,12,5,-1500,-500,8437,
  96,79,0,7,6,1000,12812,8437,
  97,59,14,11,12,-1187,9375,8437,
  98,46,69,11,14,-1187,12187,8437,
  99,11,64,10,12,-500,9375,8437,
  100,59,112,12,14,-1062,12187,8437,
  101,72,115,11,12,-1000,9375,8437,
  102,46,111,11,14,62,12187,8437,
  103,59,84,12,14,-1437,9375,8437,
  104,46,83,11,14,-1125,12187,8437,
  105,83,102,11,15,-1437,12937,8437,
  106,0,0,11,18,-1937,12937,8437,
  107,94,85,12,14,-1000,12187,8437,
  108,105,14,9,14,62,12187,8437,
  109,82,14,12,11,-1750,9375,8437,
  110,114,14,11,11,-1125,9375,8437,
  111,94,14,11,12,-937,9375,8437,
  112,72,42,12,14,-1812,9375,8437,
  113,70,28,11,14,-1062,9375,8437,
  114,83,117,11,11,-500,9375,8437,
  115,11,76,10,12,-937,9375,8437,
  116,118,85,10,13,-437,11375,8437,
  117,22,95,11,11,-812,9187,8437,
  118,22,106,11,11,-375,9187,8437,
  119,70,14,12,11,-937,9187,8437,
  120,46,14,13,11,-2062,9187,8437,
  121,33,28,13,14,-2125,9187,8437,
  122,11,42,11,11,-1187,9187,8437,
  123,22,14,11,17,-625,12187,8437,
  124,0,18,5,18,1875,12250,8437,
  125,11,14,11,17,-1750,12187,8437,
  126,32,0,11,6,-937,7125,8437,
  0
};

/* Signed Distance Field: edges are at 127.5 */
const unsigned char sdf_data[] = {
  0,0,0,0,0,0,8,32,32,32,15,0,0,0,21,32,32,30,0,0,28,32,32,29,0,0,0,15,
  32,32,32,17,0,0,13,27,28,17,0,0,19,26,0,0,27,32,32,19,32,32,30,0,0,27,
  32,32,32,32,32,32,32,32,32,8,0,0,10,32,32,32,19,0,15,32,32,32,32,32,17,
  0,25,32,32,25,0,0,0,13,32,32,32,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,95,96,96,60,0,0,
  11,70,96,96,90,40,36,85,96,96,88,34,0,3,61,96,96,96,63,0,41,72,90,92,
  77,54,42,72,86,36,27,82,96,96,67,96,96,90,38,27,82,96,96,96,96,96,96,
  96,96,95,49,0,0,53,95,96,96,67,3,61,96,96,96,96,96,63,23,80,96,96,80,
  24,0,0,58,96,96,96,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,67,131,163,124,63,0,0,11,70,131,163,
  122,63,74,124,163,142,88,34,0,15,78,143,163,133,68,27,88,131,154,156,
  139,113,104,124,108,44,32,96,163,143,76,131,163,108,44,32,96,163,163,
  163,163,163,163,163,163,120,56,0,5,67,131,163,135,71,15,77,143,163,163,
  163,135,69,24,82,133,163,111,56,0,11,73,139,163,136,72,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,
  78,143,178,112,51,0,0,0,47,106,167,148,87,113,165,153,99,49,0,0,27,90,
  154,183,120,56,28,92,158,139,139,154,177,171,163,108,44,32,96,163,143,
  76,131,175,108,44,31,92,112,112,112,112,112,112,112,112,110,54,0,19,80,
  143,184,120,59,27,88,154,159,159,159,120,58,0,43,93,144,144,86,30,23,
  86,151,187,124,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,12,45,48,82,116,116,101,39,0,0,0,24,83,144,
  172,111,154,163,111,61,10,0,0,36,99,124,124,107,44,27,90,102,73,72,93,
  115,120,104,73,27,32,96,163,143,76,131,175,108,44,3,42,48,48,48,48,48,
  48,48,48,47,20,0,45,103,163,147,94,40,22,77,92,92,92,92,88,42,0,4,54,
  104,135,116,52,32,95,124,124,111,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,102,112,112,112,112,81,
  19,0,0,0,0,59,119,179,151,175,122,72,22,0,0,0,22,54,60,60,57,20,2,44,
  47,15,11,35,52,56,44,19,0,32,96,147,143,76,131,147,108,44,0,0,0,0,0,0,
  0,0,0,0,0,0,13,70,131,163,110,58,6,0,22,28,28,28,28,27,0,0,0,15,60,68,
  67,31,10,53,60,60,58,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,116,179,179,179,140,76,14,0,0,0,0,
  36,95,156,186,136,83,33,0,0,0,0,61,108,108,108,72,10,0,0,0,0,0,0,0,0,
  0,0,0,21,70,80,80,57,80,80,76,31,0,0,0,0,0,0,0,0,0,0,0,0,28,91,124,124,
  73,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,111,112,
  124,191,131,65,2,0,0,0,17,68,116,170,183,122,63,4,0,0,0,13,75,139,175,
  135,72,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,7,51,60,60,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,23,48,76,140,179,115,52,0,0,0,6,57,106,159,159,167,147,86,28,0,0,0,
  24,87,151,179,120,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,26,88,152,167,103,40,0,0,0,46,96,147,170,116,144,170,110,
  51,0,0,0,31,92,112,112,105,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,38,100,164,155,91,28,0,0,35,85,136,181,131,79,119,
  179,135,74,15,0,0,3,42,48,48,46,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,112,176,143,79,16,0,19,74,124,175,142,
  90,40,95,157,158,97,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,124,188,131,67,4,0,26,86,108,108,99,
  51,13,72,108,108,102,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,29,44,44,76,139,181,116,55,0,0,0,36,44,44,41,
  9,0,29,44,44,42,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,11,72,108,108,116,163,163,101,40,0,0,0,0,0,10,32,
  32,31,19,0,0,0,0,0,0,0,0,4,23,32,32,31,6,0,0,0,22,32,32,32,32,32,32,32,
  27,0,0,0,0,30,32,32,22,8,32,32,32,24,0,0,0,0,2,18,29,32,28,15,0,0,0,25,
  32,32,19,0,0,3,31,32,32,10,0,0,2,20,20,25,32,19,30,32,13,0,0,0,0,0,19,
  32,32,23,1,0,0,0,19,32,32,32,32,31,6,0,0,0,2,20,20,20,26,32,24,0,0,0,
  0,0,24,87,151,175,179,168,131,76,19,0,0,0,0,0,53,95,96,92,81,46,0,0,0,
  0,0,0,18,61,85,95,96,93,45,0,0,18,74,96,96,96,96,96,96,96,82,27,0,0,38,
  90,96,96,73,51,95,96,96,76,19,0,0,26,63,80,92,96,92,76,45,1,23,80,96,
  96,67,8,0,42,92,96,95,53,0,0,50,84,84,86,96,76,91,95,68,23,0,0,15,52,
  79,95,96,85,58,18,0,8,67,96,96,96,96,93,45,0,0,0,50,84,84,83,87,96,85,
  51,4,0,0,0,31,93,116,116,116,106,79,37,0,0,0,0,0,6,68,133,163,159,139,
  86,27,0,0,0,0,0,56,108,148,159,163,112,50,0,0,31,93,158,163,163,163,163,
  163,155,91,29,0,0,39,97,156,160,101,93,144,163,124,76,19,0,0,53,115,143,
  158,163,156,135,91,38,28,92,159,139,75,32,32,63,124,163,113,53,0,7,70,
  135,151,144,162,119,154,158,111,52,0,11,60,105,140,159,162,145,108,61,
  8,21,83,147,163,163,163,112,50,0,0,7,69,135,151,120,149,163,142,92,33,
  0,0,0,6,45,52,52,52,44,24,0,0,0,0,0,0,11,73,112,115,160,163,96,32,0,0,
  0,0,20,81,143,171,122,112,99,38,0,0,43,104,147,147,147,147,159,192,143,
  79,16,0,0,12,69,131,186,131,136,181,133,82,34,0,0,2,65,131,144,131,124,
  150,182,120,58,28,92,159,139,80,96,96,83,145,152,91,31,0,19,82,147,161,
  124,172,153,131,181,124,60,0,45,99,153,175,139,139,178,151,92,32,28,92,
  131,131,156,163,99,38,0,0,19,82,147,183,151,136,170,175,108,45,0,0,0,
  0,25,32,32,15,0,0,0,0,0,0,0,0,0,32,48,92,156,154,88,27,0,0,0,0,34,96,
  160,151,87,48,44,9,0,0,31,76,80,80,80,124,174,150,99,51,0,0,0,0,42,99,
  158,159,176,142,91,42,0,0,0,12,68,107,99,108,108,131,187,120,59,28,92,
  159,135,108,163,135,103,165,131,68,9,0,32,95,159,139,104,168,131,112,
  178,116,55,10,70,131,188,135,82,88,151,172,108,44,9,54,64,103,167,151,
  87,24,0,0,31,93,158,167,108,85,151,171,107,44,0,0,0,23,80,96,96,60,0,
  0,0,0,0,0,0,0,0,0,41,104,168,142,77,15,0,0,0,0,45,108,172,139,74,11,0,
  0,0,0,0,14,20,69,116,167,156,105,57,9,0,0,0,0,26,74,131,191,147,96,49,
  1,0,0,0,53,102,140,163,173,175,176,176,112,49,28,92,159,135,133,136,139,
  124,167,106,47,0,0,43,106,170,124,116,179,116,124,170,106,43,24,87,151,
  171,107,47,81,147,175,108,44,0,0,54,116,180,139,73,11,0,0,43,106,170,
  149,85,95,159,160,96,34,0,0,0,28,92,159,135,68,0,0,0,0,0,0,0,0,0,0,52,
  116,180,131,66,43,17,0,31,44,62,120,185,124,63,0,0,0,0,0,0,15,63,111,
  161,161,111,63,15,0,0,0,0,20,68,116,167,180,158,99,42,0,0,0,22,83,144,
  184,136,112,108,154,164,100,38,28,92,159,131,157,120,143,145,145,83,24,
  0,0,55,116,177,112,131,167,103,139,159,95,32,28,92,159,163,96,33,93,156,
  165,101,39,0,5,67,131,187,122,61,0,0,0,55,116,182,139,73,108,172,147,
  83,21,0,0,0,28,92,159,135,68,0,0,0,0,0,0,0,0,0,0,56,119,179,142,111,106,
  53,14,76,108,115,153,161,104,45,0,0,0,0,0,9,57,105,156,167,116,68,20,
  0,0,0,0,12,60,108,159,159,131,186,131,70,12,0,0,32,96,160,167,100,63,
  113,172,152,88,26,28,92,159,124,145,120,143,167,120,62,2,0,6,68,131,165,
  100,142,155,91,151,147,82,19,28,92,158,165,102,72,119,177,145,85,24,0,
  18,80,144,174,110,47,0,0,5,68,131,188,124,61,120,183,135,72,10,0,0,0,
  28,92,159,135,68,0,0,0,0,0,0,0,0,0,1,54,99,131,175,167,112,48,27,88,153,
  174,136,108,68,19,0,0,0,0,2,50,99,147,173,122,74,26,4,0,0,0,5,54,102,
  153,165,115,99,160,156,97,40,0,0,30,92,156,177,124,120,156,197,140,76,
  13,28,92,159,175,120,116,178,160,99,39,0,0,17,80,143,153,90,154,143,98,
  163,135,70,7,17,78,139,189,147,135,164,164,113,58,1,0,31,93,158,160,96,
  34,0,0,17,80,143,175,112,69,135,187,120,59,0,0,0,0,28,92,159,135,68,0,
  0,0,0,0,0,0,0,0,24,85,144,169,119,100,91,36,28,85,100,113,173,144,80,
  16,0,0,0,0,43,91,142,177,131,80,68,68,68,37,0,0,28,91,139,139,122,74,
  72,131,139,124,64,0,0,12,69,119,156,163,145,124,151,124,64,2,28,92,139,
  139,97,116,139,139,77,17,0,0,30,92,151,142,101,151,131,111,151,120,58,
  0,0,49,96,139,159,162,147,113,71,24,0,0,44,107,171,147,83,24,24,4,28,
  92,151,151,100,81,145,151,110,47,0,0,0,0,28,92,159,135,68,0,0,0,0,0,0,
  0,0,0,39,102,167,144,82,38,33,1,0,30,43,104,171,140,76,13,0,0,0,13,76,
  136,184,145,135,135,135,135,124,60,0,0,13,61,72,72,69,32,43,72,72,72,
  43,0,0,0,29,69,92,96,85,84,84,83,45,0,13,61,72,72,61,69,72,72,46,0,0,
  0,22,73,84,84,78,84,83,81,84,82,40,0,0,6,50,79,95,96,85,60,25,0,0,0,56,
  120,183,135,88,88,87,49,19,71,84,84,73,66,84,84,78,29,0,0,0,0,28,92,159,
  135,68,0,0,0,0,0,0,0,0,0,51,113,178,131,67,5,0,0,0,0,55,116,181,124,64,
  2,0,0,0,25,87,151,175,175,175,175,175,175,113,51,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,12,30,32,24,20,20,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,19,32,32,23,3,0,0,0,0,56,119,181,169,155,155,
  120,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,92,159,135,68,0,0,0,0,0,0,0,36,
  52,66,124,182,116,55,0,0,0,0,4,67,131,179,115,52,47,9,0,0,30,90,108,108,
  108,108,108,108,108,96,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,37,88,124,139,139,139,108,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,
  92,159,135,68,0,0,0,0,0,0,15,77,116,119,153,162,101,40,0,0,0,0,8,72,139,
  183,131,116,97,35,0,0,0,38,44,44,44,44,44,44,44,40,6,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,63,72,72,72,67,24,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,28,92,159,135,68,0,0,0,0,0,0,27,90,154,159,149,120,
  73,17,0,0,0,0,0,58,113,149,159,156,92,30,0,0,0,0,10,32,32,32,15,0,24,
  32,32,29,0,0,0,0,27,32,32,32,8,31,32,32,30,0,0,0,0,0,0,20,31,32,27,13,
  0,0,0,0,3,25,32,25,19,20,20,6,0,0,0,0,10,28,32,26,6,0,0,0,0,0,0,15,27,
  32,31,19,0,0,0,0,0,0,0,0,13,32,32,32,15,0,0,0,19,32,32,32,32,32,32,22,
  0,0,0,28,92,159,135,68,0,0,0,0,0,0,22,77,92,92,85,67,32,0,0,0,0,0,0,23,
  63,85,92,92,71,15,0,0,0,0,53,95,96,96,60,24,77,96,96,88,34,0,0,27,82,
  96,96,95,49,92,96,96,90,38,0,0,0,21,56,81,93,96,90,74,49,0,0,18,58,86,
  96,85,82,84,84,57,0,0,0,34,67,91,96,87,62,23,0,0,0,4,53,77,90,96,93,79,
  50,9,0,0,0,0,0,11,60,96,96,96,60,0,0,8,67,96,96,96,96,96,96,73,0,0,0,
  28,92,159,135,68,0,0,0,0,0,0,0,22,28,28,23,8,0,0,0,0,0,0,0,0,6,23,28,
  28,19,0,0,0,0,0,55,116,163,139,76,54,110,163,151,93,36,0,0,40,103,163,
  163,124,67,124,163,163,103,40,0,0,20,68,111,143,159,163,154,135,87,0,
  11,63,108,147,163,144,122,151,135,68,0,0,34,82,122,153,163,151,113,65,
  10,0,0,24,87,140,155,163,159,140,99,51,0,0,0,0,3,51,99,151,163,124,63,
  0,0,21,83,147,163,163,163,163,143,79,0,0,0,28,92,159,135,68,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,20,26,0,0,0,0,0,10,32,32,28,0,0,0,0,0,42,104,168,151,
  87,85,142,174,116,62,7,0,0,52,115,179,165,131,93,154,179,155,91,29,0,
  0,53,108,161,165,142,139,153,142,77,0,42,99,153,173,139,145,135,183,120,
  57,0,12,69,122,175,153,139,175,154,93,33,0,0,37,99,159,144,139,149,187,
  140,79,0,0,0,0,43,92,144,192,176,112,50,0,0,34,96,160,149,147,147,147,
  131,67,0,0,0,28,92,159,135,68,0,0,0,0,0,0,0,0,0,0,0,9,32,56,79,86,36,
  0,0,0,8,57,95,96,85,30,0,0,0,0,30,91,155,163,98,115,172,144,86,31,0,0,
  2,64,131,173,139,135,120,153,157,143,79,16,0,10,72,136,178,116,78,75,
  92,131,65,6,67,124,186,133,80,101,164,172,108,44,0,37,95,156,162,104,
  87,151,172,108,44,0,0,41,99,95,80,72,97,163,151,84,0,0,0,34,83,135,156,
  151,164,100,38,0,0,45,108,172,124,80,80,80,80,45,0,0,0,28,92,159,135,
  68,0,0,0,0,0,0,0,0,0,21,44,68,91,115,140,108,44,0,0,0,47,96,147,140,85,
  30,0,0,0,0,16,79,143,174,108,147,167,110,54,0,0,0,14,76,140,162,135,139,
  148,124,169,131,67,5,0,12,76,143,179,122,86,62,37,64,37,21,83,147,170,
  107,47,96,163,159,95,33,0,57,116,179,140,78,82,147,175,108,44,0,0,9,41,
  77,92,95,122,174,135,74,0,0,26,74,124,163,111,163,152,88,26,0,0,58,120,
  175,124,131,115,83,40,0,0,0,0,23,80,96,96,60,0,0,0,0,0,0,0,33,57,81,103,
  131,153,176,158,108,44,0,0,30,83,136,159,102,49,0,0,0,0,0,4,67,131,185,
  120,177,136,79,24,0,0,0,26,88,152,151,131,145,158,116,182,116,55,0,0,
  6,67,124,176,176,147,119,88,46,0,28,92,159,163,96,47,107,170,147,83,20,
  10,72,135,185,120,135,105,155,168,104,40,0,0,0,38,100,159,159,152,131,
  94,45,0,18,67,116,167,119,110,174,140,76,14,0,7,69,135,175,171,182,174,
  131,76,19,0,0,0,0,25,32,32,15,0,0,0,0,0,0,25,84,116,142,164,163,142,119,
  97,76,31,0,6,62,116,173,124,70,15,0,0,0,0,0,0,54,116,180,179,160,102,
  47,0,0,0,0,38,100,164,139,120,187,133,131,169,104,43,0,0,0,39,85,120,
  149,174,177,139,84,27,32,95,159,163,99,81,133,190,135,71,9,20,84,148,
  172,108,165,122,164,159,95,32,0,0,0,51,112,151,157,164,133,83,28,0,58,
  108,159,131,80,120,186,124,76,42,0,19,82,131,111,104,122,170,162,98,36,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,92,159,154,124,102,79,58,37,15,0,0,33,
  90,151,157,97,40,0,0,0,0,0,0,0,41,104,168,184,131,72,16,0,0,0,0,50,112,
  176,124,115,124,104,143,158,93,31,0,0,25,44,33,63,90,116,164,169,106,
  43,23,86,148,187,144,139,151,186,120,59,0,28,92,156,164,100,100,115,178,
  144,81,19,0,0,12,40,82,84,95,145,170,107,44,13,75,139,160,143,143,145,
  186,143,122,60,0,8,60,72,49,41,84,149,171,104,40,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,28,92,140,163,162,140,116,95,74,53,17,0,56,116,177,135,72,13,
  0,0,0,0,0,15,28,45,101,160,153,95,40,0,0,0,0,0,62,124,175,112,59,60,92,
  156,145,81,19,0,5,65,107,71,44,38,83,147,175,108,44,4,62,113,154,160,
  135,147,173,108,47,0,28,92,159,163,96,74,135,185,122,63,2,0,51,76,54,
  40,38,77,140,175,111,48,25,87,151,163,163,163,173,178,163,110,47,0,57,
  83,59,48,57,96,157,160,97,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,54,79,102,
  124,151,174,158,136,106,43,11,74,136,176,112,52,0,0,0,0,0,7,65,92,95,
  136,176,119,65,8,0,0,0,0,11,74,139,164,100,38,42,104,168,135,69,7,0,17,
  80,143,131,106,100,120,167,156,95,36,0,23,67,91,96,93,158,162,96,34,0,
  25,88,152,172,113,113,163,156,97,40,0,13,75,139,116,104,100,119,164,158,
  97,37,23,80,96,96,96,96,160,155,96,88,34,15,77,142,120,112,119,144,187,
  136,78,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,67,90,113,139,162,108,
  44,24,87,151,163,99,36,0,0,0,0,0,21,83,147,159,181,142,86,33,0,0,0,0,
  0,23,86,151,152,88,26,55,116,175,120,57,0,0,28,91,155,183,171,167,179,
  161,116,68,12,0,0,10,30,43,104,170,149,85,23,0,10,69,124,174,170,172,
  163,116,68,12,0,26,87,151,179,168,167,179,161,119,69,13,0,25,32,32,45,
  108,172,143,79,29,0,27,88,154,180,179,183,167,136,94,45,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,8,30,54,77,101,104,43,28,92,159,155,91,28,0,0,
  0,0,0,32,96,135,135,124,95,49,0,0,0,0,0,0,26,86,108,108,74,13,57,107,
  108,102,45,0,0,20,74,101,120,131,135,124,102,71,26,0,0,0,0,0,55,116,147,
  136,72,10,0,0,37,82,116,135,131,106,71,28,0,0,24,82,110,124,135,135,124,
  102,71,29,0,0,0,0,0,50,108,112,112,66,4,0,22,77,103,116,120,116,104,81,
  46,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,42,49,15,28,92,159,
  155,88,24,0,0,0,0,0,15,60,68,68,63,42,6,0,0,0,0,0,0,0,36,44,44,29,0,20,
  44,44,42,12,0,0,0,19,40,58,68,68,62,44,17,0,0,0,0,0,0,41,79,80,80,51,
  0,0,0,0,31,57,68,66,49,20,0,0,0,0,31,48,60,68,68,61,44,17,0,0,0,0,0,0,
  18,47,48,48,28,0,0,0,24,41,52,56,54,43,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,6,31,32,32,32,32,32,32,21,23,85,151,159,92,31,0,0,0,0,0,0,0,
  0,0,0,18,30,32,27,10,0,0,0,0,0,0,28,32,32,25,0,25,32,32,32,8,0,3,31,32,
  32,8,0,0,19,32,32,28,0,0,0,0,13,20,20,16,31,32,17,0,0,0,25,32,32,27,0,
  0,24,32,32,31,3,0,0,0,0,10,24,32,32,21,0,0,0,0,0,15,32,32,32,10,15,32,
  32,32,8,0,0,0,25,32,32,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,93,96,96,96,
  96,96,96,70,10,72,135,168,104,41,0,0,0,0,0,0,0,0,20,54,78,92,96,88,70,
  33,0,0,0,0,30,85,96,96,80,34,80,96,96,95,49,0,42,92,96,95,49,0,9,67,96,
  96,85,30,0,0,15,68,84,84,76,92,95,76,34,0,23,80,96,96,82,28,24,77,96,
  96,92,42,0,0,4,49,72,87,96,96,82,56,15,0,0,0,60,96,96,95,53,60,96,96,
  95,49,0,0,25,80,96,96,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,124,163,163,163,
  163,163,139,75,0,54,115,176,119,57,0,0,0,0,0,0,0,20,68,108,140,158,163,
  153,116,52,0,0,0,0,43,106,163,151,87,80,124,163,147,99,49,0,52,116,163,
  120,56,0,25,87,151,154,91,30,0,0,32,95,151,151,122,156,159,124,76,20,
  24,85,147,163,107,45,58,111,163,153,97,43,0,0,26,87,135,151,160,160,144,
  105,59,3,0,12,75,139,163,116,55,77,142,163,115,52,0,0,38,100,163,143,
  79,0,0,0,0,0,0,0,0,0,0,0,0,0,8,72,124,124,124,124,155,173,124,63,0,32,
  90,131,131,72,8,0,0,0,0,0,4,59,111,160,163,139,135,153,103,40,0,0,0,0,
  55,116,182,139,80,124,173,147,99,54,9,0,56,120,179,112,56,56,52,103,167,
  135,73,11,0,0,44,107,171,156,145,136,173,163,102,40,5,66,124,187,124,
  63,92,147,167,113,61,9,0,0,38,100,162,143,135,145,185,147,86,25,0,24,
  87,151,169,104,43,90,154,167,103,40,0,0,51,112,177,131,67,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,40,60,60,102,149,173,124,80,37,0,4,50,64,64,43,0,0,0,
  0,0,0,33,90,149,163,111,76,71,94,88,29,0,0,0,5,67,131,188,124,124,173,
  147,99,54,9,0,0,60,124,171,107,119,120,102,120,177,115,54,0,0,0,56,119,
  183,149,94,85,147,178,112,48,0,47,107,169,144,81,124,181,131,78,25,0,
  0,0,43,104,101,79,68,96,163,159,92,28,0,37,99,163,158,93,39,101,167,155,
  91,28,0,1,63,124,181,116,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,60,105,150,
  170,122,80,34,0,0,0,0,15,32,32,25,0,0,0,0,0,57,116,177,135,113,120,106,
  71,34,0,0,0,0,16,80,143,177,124,173,147,99,54,9,0,0,2,65,131,167,100,
  145,175,108,139,159,95,36,0,0,6,68,133,186,122,62,80,147,175,108,47,0,
  28,88,151,162,106,162,147,93,41,0,0,0,0,15,49,42,19,66,116,174,136,78,
  18,0,48,111,175,145,81,51,113,178,143,78,15,0,13,76,139,169,104,43,0,
  0,0,0,0,0,0,0,0,0,0,0,0,18,63,105,153,167,122,77,32,4,0,0,0,0,60,96,96,
  80,24,0,0,0,13,74,139,179,139,175,185,163,113,58,0,0,0,0,29,91,155,195,
  178,185,124,65,9,0,0,0,7,70,135,159,107,167,167,108,155,140,77,17,0,0,
  18,80,144,179,112,48,91,155,164,100,38,0,8,69,131,179,142,163,108,57,
  5,0,0,0,0,0,0,18,63,108,158,153,102,49,0,0,61,124,187,133,68,64,124,190,
  131,67,4,0,24,87,151,157,92,31,0,0,0,0,0,0,0,0,0,0,0,0,5,62,108,156,164,
  119,84,84,84,53,0,0,0,0,61,122,163,108,49,0,0,0,24,87,151,194,144,110,
  131,185,142,77,15,0,0,0,40,103,167,192,147,172,148,86,28,0,0,0,12,75,
  139,154,131,142,159,108,172,120,59,0,0,0,30,92,157,180,116,70,116,176,
  144,83,22,0,0,49,111,173,179,124,72,20,0,0,0,0,0,0,24,66,108,156,156,
  108,63,13,0,10,72,139,183,120,56,76,140,180,116,54,0,0,28,92,159,139,
  76,15,0,0,0,0,0,0,0,0,0,0,0,0,19,82,147,201,154,151,151,151,131,65,2,
  0,0,0,43,104,168,131,69,9,0,0,28,92,159,168,106,51,104,171,147,80,16,
  0,0,0,53,116,179,147,99,151,170,110,49,0,0,0,16,80,143,147,154,116,159,
  124,164,101,40,0,0,0,42,104,168,151,153,135,161,167,113,58,1,0,0,38,100,
  164,155,91,37,0,0,0,0,0,0,29,71,113,159,153,108,65,20,0,0,23,85,149,171,
  107,44,88,152,168,104,41,0,0,36,98,155,120,59,0,0,0,0,0,0,0,0,0,0,0,0,
  0,32,95,139,139,139,139,139,139,115,52,0,0,0,0,30,92,157,149,85,23,0,
  0,31,92,159,159,92,56,113,177,142,77,15,0,0,2,65,131,190,124,67,124,187,
  133,72,13,0,0,20,84,149,147,154,93,159,147,145,82,22,0,0,0,54,116,181,
  139,133,162,154,119,77,26,0,0,0,50,112,176,143,79,16,0,0,0,0,0,34,77,
  119,164,144,102,60,56,43,0,0,28,92,159,163,97,59,106,167,153,91,29,0,
  0,48,79,88,85,38,0,0,0,0,0,0,0,0,0,0,0,0,0,17,63,72,72,72,72,72,72,69,
  30,0,0,0,0,20,84,151,159,95,32,0,0,24,87,151,168,111,102,145,176,119,
  61,0,0,0,14,76,142,179,115,52,103,164,156,95,36,0,0,24,88,154,188,131,
  92,157,187,124,63,3,0,0,4,67,131,188,124,79,96,91,67,31,0,0,0,0,63,124,
  188,131,67,4,0,0,0,0,9,70,124,170,140,120,120,120,120,83,20,0,27,88,153,
  179,133,120,147,185,131,70,11,0,10,72,139,143,107,44,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,28,32,32,13,0,0,0,0,0,0,20,84,151,163,96,32,0,0,8,67,
  122,171,168,164,176,136,86,33,0,0,0,27,88,153,167,103,40,81,142,175,116,
  58,0,0,28,92,159,165,104,88,155,168,106,45,0,0,0,15,78,143,177,112,51,
  32,29,10,0,0,0,0,11,74,139,175,116,55,0,0,0,0,0,21,83,147,187,187,187,
  187,187,139,76,13,0,10,69,122,165,183,186,170,140,94,42,0,0,23,85,149,
  159,95,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,85,96,96,56,0,0,0,0,0,0,
  26,88,155,160,96,32,0,0,0,33,80,113,131,135,116,86,43,0,0,0,0,30,90,108,
  108,86,28,58,107,108,108,65,2,0,26,86,108,108,79,83,108,108,86,27,0,0,
  0,28,91,147,147,100,38,0,0,0,0,0,0,0,14,76,108,108,99,41,0,0,0,0,0,28,
  91,120,120,120,120,120,120,120,63,2,0,0,32,74,104,119,120,108,85,49,4,
  0,0,26,86,108,108,79,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,100,163,131,
  64,0,0,0,0,0,0,38,100,164,149,86,23,0,0,0,0,28,54,68,68,57,31,0,0,0,0,
  0,0,38,44,44,36,0,20,44,44,44,25,0,0,0,36,44,44,33,35,44,44,36,0,0,0,
  0,17,68,80,80,70,21,0,0,0,0,0,0,0,0,31,44,44,41,9,0,0,0,0,0,5,47,56,56,
  56,56,56,56,56,32,0,0,0,0,21,44,56,56,47,28,0,0,0,0,0,36,44,44,33,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,30,36,36,100,167,131,64,36,36,14,0,0,0,57,116,
  179,133,69,9,0,0,0,0,24,32,32,32,32,32,32,32,17,0,0,0,0,10,29,32,19,0,
  0,0,0,0,0,0,0,0,0,0,10,32,32,27,32,32,25,0,0,0,0,0,0,0,11,27,32,28,11,
  0,0,0,0,0,27,32,32,32,32,32,32,31,6,0,0,0,0,10,32,32,32,32,32,27,0,0,
  0,0,27,32,32,25,13,32,32,32,13,0,0,0,17,32,32,32,15,0,0,0,0,0,0,0,0,0,
  0,0,28,85,100,100,100,167,131,100,100,99,54,0,0,22,79,140,167,108,49,
  0,0,0,0,22,77,96,96,96,96,96,96,96,63,0,0,0,26,67,91,96,78,40,0,0,0,0,
  0,0,0,0,0,0,53,95,96,82,96,96,80,23,0,0,0,0,7,42,70,90,96,91,70,37,0,
  0,0,28,82,96,96,96,96,96,96,93,45,0,0,0,0,53,95,96,96,96,96,82,27,0,0,
  28,82,96,96,80,56,96,96,96,56,0,0,7,65,96,96,96,60,0,0,0,0,0,0,0,0,0,
  0,0,32,96,163,167,167,184,168,167,167,124,60,0,0,51,106,165,139,81,24,
  0,0,0,0,35,97,162,163,163,163,163,163,131,68,0,0,8,65,116,154,160,133,
  85,29,0,0,0,0,0,0,0,0,10,71,135,154,91,140,148,85,23,0,0,0,9,54,96,131,
  154,163,154,124,82,29,0,0,41,104,163,163,163,163,163,163,108,47,0,0,0,
  5,67,131,163,163,163,155,91,29,0,0,41,104,163,152,88,71,135,163,120,59,
  0,0,19,82,147,163,131,65,0,0,0,0,0,0,0,0,0,0,0,32,96,131,131,131,168,
  133,131,131,124,60,0,28,82,139,159,104,50,0,0,0,0,0,47,108,147,147,147,
  147,165,174,116,55,0,0,27,90,153,131,113,162,113,51,10,24,6,0,0,0,0,45,
  60,87,151,139,92,156,133,69,51,7,0,0,50,99,147,156,124,112,124,172,115,
  54,0,0,54,116,180,151,147,147,147,147,97,35,0,0,0,16,80,143,147,147,187,
  143,80,17,0,0,54,116,180,139,76,83,147,173,108,47,0,0,31,93,158,179,116,
  52,0,0,0,0,0,0,0,0,0,0,0,13,56,64,64,100,167,131,64,64,64,34,13,65,116,
  171,119,68,16,0,0,0,0,0,35,77,80,80,80,120,176,142,85,29,0,0,28,92,158,
  115,96,155,116,53,69,88,52,0,0,0,19,81,124,124,165,124,124,172,124,124,
  91,28,0,29,85,142,150,102,92,104,95,151,124,60,0,3,66,131,190,124,80,
  80,80,80,68,17,0,0,0,6,60,80,80,124,188,131,67,5,0,3,67,131,190,124,64,
  95,159,162,96,34,0,0,40,103,124,124,103,40,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,36,100,167,131,64,0,0,0,32,96,131,131,80,30,0,0,0,0,0,0,0,15,16,43,
  97,154,164,108,53,0,0,0,17,76,131,165,156,149,96,104,131,139,78,15,0,
  0,34,96,160,163,178,163,164,173,163,142,78,16,0,54,113,169,111,111,151,
  171,153,158,120,56,0,15,78,143,179,115,96,96,96,88,34,0,0,0,0,0,6,16,
  75,139,181,116,55,0,0,15,78,143,178,113,104,108,172,149,85,23,0,0,28,
  56,60,60,56,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,100,131,131,64,0,0,0,13,
  56,64,64,37,0,0,0,0,0,0,0,0,0,21,76,133,186,133,76,21,0,0,0,0,40,82,111,
  116,116,142,136,111,87,57,4,0,0,30,85,96,135,154,96,140,148,96,96,60,
  0,13,75,139,143,93,151,139,106,131,171,107,44,0,27,90,154,187,163,163,
  163,163,99,37,0,0,0,0,0,0,25,87,151,169,104,43,0,0,28,91,155,192,171,
  171,171,192,136,72,10,0,5,66,112,112,112,69,7,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,16,58,64,64,37,0,0,0,0,0,0,15,32,32,32,32,24,0,0,0,0,0,53,108,164,
  156,99,44,0,0,0,0,1,62,104,131,149,124,105,131,131,99,54,2,0,3,61,92,
  92,151,139,92,156,133,92,82,29,0,25,88,153,124,112,165,102,50,112,159,
  95,32,0,39,102,167,159,147,147,147,147,87,25,0,0,0,8,0,0,37,100,164,157,
  92,31,0,0,39,102,167,154,139,139,142,187,124,61,0,0,17,80,143,179,131,
  67,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,28,32,29,15,0,0,0,0,0,60,96,96,
  96,96,76,0,0,0,0,31,85,142,177,120,67,12,0,0,0,0,2,63,122,111,88,97,153,
  144,147,145,88,28,0,18,80,144,159,173,160,159,178,159,157,93,32,0,32,
  95,159,116,116,160,96,77,131,147,83,20,0,51,113,178,143,80,80,80,80,63,
  10,0,0,43,72,43,0,49,112,175,144,80,18,0,0,52,115,179,143,77,81,145,175,
  111,48,0,0,33,92,156,174,116,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,47,74,91,
  96,92,76,48,0,0,0,13,75,139,163,163,147,83,0,0,0,8,63,119,174,145,88,
  35,0,0,0,0,0,0,34,67,53,48,112,159,95,104,167,100,36,0,28,92,131,131,
  169,131,131,164,131,131,79,17,0,29,92,159,116,108,169,139,135,170,135,
  70,8,2,64,124,190,131,67,16,16,16,8,0,0,6,68,135,88,60,69,124,188,131,
  68,6,0,2,64,124,190,131,66,93,158,163,99,37,0,0,57,116,177,139,84,31,
  0,0,0,0,0,0,0,0,0,0,0,0,0,8,54,99,135,155,163,156,136,83,0,0,0,25,87,
  151,156,112,112,69,0,0,0,41,95,153,169,111,57,2,0,0,0,0,0,0,0,4,0,40,
  102,161,131,136,153,92,32,0,9,54,71,135,154,91,140,148,85,64,45,0,0,23,
  85,148,133,78,122,143,131,135,120,59,0,13,76,139,180,116,54,0,0,0,0,0,
  0,18,80,145,144,122,124,159,172,112,52,0,0,14,76,140,180,116,53,104,169,
  151,87,24,0,20,79,140,153,99,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,96,147,
  182,148,135,143,140,76,0,0,0,37,99,163,144,80,48,30,0,0,19,74,131,179,
  136,80,25,0,0,0,0,0,0,0,0,0,0,17,70,115,143,142,108,62,8,0,0,26,87,151,
  139,92,156,133,69,8,0,0,0,7,67,124,161,111,77,76,85,108,67,34,0,26,88,
  152,168,104,42,0,0,0,0,0,0,28,92,151,173,185,183,168,133,82,28,0,0,26,
  88,152,168,104,55,116,175,139,75,13,0,26,86,108,107,63,11,0,0,0,0,0,0,
  0,0,0,0,0,0,0,10,70,131,186,139,91,68,81,116,63,0,0,0,49,112,175,131,
  68,6,0,0,0,27,88,112,112,102,48,0,0,0,0,0,0,0,0,0,0,0,0,26,60,80,77,56,
  18,0,0,0,28,85,100,100,88,100,98,53,0,0,0,0,0,38,91,142,163,139,135,147,
  144,82,21,0,31,92,112,112,90,30,0,0,0,0,0,0,13,62,91,110,120,120,107,
  80,40,0,0,0,30,90,108,108,90,57,107,108,108,61,0,0,0,36,44,44,20,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,24,87,151,170,107,49,6,29,52,29,0,0,0,61,124,
  183,119,56,0,0,0,0,0,40,48,48,45,12,0,0,0,0,0,0,0,0,0,0,25,32,32,27,0,
  0,0,0,0,0,0,0,30,36,36,32,36,36,11,0,0,0,0,0,2,49,90,120,139,143,131,
  108,74,18,0,3,42,48,48,40,0,0,0,0,0,0,0,0,6,32,47,56,56,45,24,0,0,0,0,
  0,38,44,44,38,20,44,44,44,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,32,95,159,163,96,32,19,45,38,0,0,0,11,73,139,170,106,43,0,0,0,0,0,0,
  0,0,9,27,32,28,11,0,0,0,0,0,0,23,80,96,96,82,27,0,0,0,0,0,0,0,0,25,32,
  32,32,32,32,32,28,0,0,0,0,2,36,61,74,76,67,49,22,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,28,92,158,168,106,68,78,104,85,23,0,0,23,85,149,
  159,95,32,0,0,0,0,0,0,0,34,67,88,96,91,69,34,0,0,0,0,0,37,99,163,156,
  92,30,0,0,0,0,0,0,0,25,80,96,96,96,96,96,96,85,30,0,0,0,0,0,0,10,32,32,
  10,0,0,0,0,0,0,9,27,32,28,12,0,0,0,0,0,27,32,32,27,0,27,32,32,19,0,0,
  0,27,32,32,32,32,32,32,31,6,0,0,0,17,30,32,25,4,0,0,0,0,0,0,0,0,0,0,0,
  0,0,17,77,136,187,153,135,140,143,79,16,0,0,35,97,162,147,82,19,0,0,0,
  0,0,0,34,82,122,152,163,154,122,78,24,0,0,0,0,48,111,175,144,80,44,36,
  9,0,0,0,0,0,39,101,163,163,163,163,163,159,95,32,0,0,0,0,0,0,53,95,95,
  53,0,0,0,0,0,33,67,88,96,91,70,34,0,0,0,27,82,96,96,82,29,82,96,96,67,
  0,0,29,82,96,96,96,96,96,96,93,45,0,25,56,78,92,96,87,60,20,0,0,0,0,0,
  0,0,0,0,0,0,0,0,47,94,136,158,163,153,131,66,3,0,0,47,108,174,135,70,
  8,0,0,0,0,0,8,67,122,175,149,135,159,169,108,47,0,0,0,0,61,124,187,131,
  98,108,95,60,13,0,0,0,0,51,112,147,147,187,153,147,147,83,20,0,0,0,0,
  12,39,68,133,120,58,32,0,0,0,34,82,122,152,163,155,124,80,28,0,0,41,104,
  163,163,104,42,104,163,136,72,0,0,43,104,163,163,163,163,163,163,108,
  47,0,62,113,140,158,163,149,111,59,0,0,0,0,0,0,0,0,0,0,0,0,0,4,47,77,
  92,96,90,72,40,0,0,0,59,120,184,120,58,4,0,0,0,0,0,22,84,149,160,99,69,
  122,183,116,52,0,0,0,10,72,139,182,116,158,175,153,101,45,0,0,0,0,38,
  78,80,124,187,133,80,80,57,4,0,0,0,20,63,97,116,145,120,111,88,34,0,13,
  70,122,174,163,147,170,171,113,53,0,0,53,116,179,181,116,55,116,181,124,
  61,0,0,55,116,181,149,147,147,147,147,96,34,13,75,139,152,135,140,183,
  144,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,31,32,27,11,0,0,0,9,72,135,172,
  108,80,57,2,0,0,0,0,22,84,151,158,96,87,135,167,107,46,0,0,0,23,85,149,
  183,147,120,150,188,124,64,0,0,0,0,0,15,73,139,183,120,56,16,4,0,0,0,
  1,58,110,156,170,176,169,164,100,38,0,39,97,158,169,113,81,135,194,131,
  67,0,3,66,131,182,160,131,67,131,175,112,48,0,4,67,131,190,124,80,80,
  80,80,68,17,24,87,119,90,72,103,167,147,82,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,18,31,32,28,17,0,0,21,83,147,172,147,139,75,12,0,0,0,0,8,65,116,
  154,152,149,156,122,76,22,0,0,0,34,96,162,163,105,59,120,187,135,68,0,
  0,0,0,0,23,85,149,171,107,44,0,0,0,0,0,20,82,144,162,110,148,104,124,
  88,26,0,59,120,182,145,83,60,124,191,135,68,0,15,77,143,164,135,143,80,
  143,163,99,37,0,16,79,143,178,113,96,96,96,88,34,0,8,56,63,57,99,144,
  170,116,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,51,78,92,96,92,79,57,0,32,96,
  131,131,131,124,63,0,0,0,0,0,45,94,136,162,151,163,147,104,51,0,0,0,0,
  47,108,173,143,80,59,120,187,133,68,0,0,0,0,0,35,97,162,159,95,32,0,0,
  0,0,0,24,88,155,153,116,135,72,68,57,6,13,75,139,189,124,65,68,131,194,
  131,64,0,27,90,154,153,120,156,92,155,151,87,25,0,28,91,155,187,163,163,
  163,162,97,35,0,0,4,57,102,149,163,119,77,29,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,57,102,140,159,163,156,142,87,0,13,56,64,64,64,64,34,0,0,0,0,15,76,
  135,165,111,84,111,172,135,72,9,0,0,0,59,120,186,136,72,74,136,182,120,
  58,0,0,0,0,4,47,108,174,147,83,20,0,0,0,0,0,18,78,139,184,163,143,116,
  82,36,0,24,87,151,176,112,50,80,143,184,120,57,0,39,101,167,140,108,168,
  104,167,139,75,13,0,40,103,167,159,147,147,147,147,86,23,0,0,30,90,147,
  164,113,71,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,87,147,165,131,120,135,139,
  75,0,0,0,0,15,32,32,32,32,24,0,0,28,92,156,151,84,42,103,167,142,76,12,
  0,0,9,71,135,197,144,85,105,162,160,99,40,0,0,0,46,68,68,120,186,135,
  71,68,37,0,0,0,0,3,48,93,124,153,164,173,124,66,5,28,92,159,167,103,40,
  95,159,169,106,44,0,51,113,178,131,96,160,116,179,124,63,1,0,52,115,179,
  143,80,80,80,80,60,8,0,0,47,108,173,135,74,23,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,32,96,163,151,97,77,74,100,60,0,0,0,0,60,96,96,96,96,76,0,0,28,
  92,156,160,108,98,133,185,124,66,4,0,0,20,83,147,172,139,147,158,176,
  124,73,17,0,0,11,73,135,135,139,188,135,135,122,60,0,0,0,1,54,79,49,91,
  155,106,165,143,76,12,28,92,159,167,100,60,116,177,149,88,27,1,64,124,
  179,115,83,147,139,178,113,51,0,2,64,124,191,131,68,68,68,68,46,0,0,0,
  59,120,139,120,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,88,147,187,158,139,
  115,76,24,0,0,0,13,75,139,163,163,147,83,0,0,15,74,131,175,168,163,179,
  144,94,40,0,0,0,32,95,139,139,105,144,148,124,85,37,0,0,0,23,85,149,175,
  175,175,175,175,111,48,0,0,0,15,78,139,106,104,151,113,169,136,73,11,
  24,87,149,181,124,112,153,178,122,63,6,13,76,139,167,103,70,135,196,165,
  101,39,0,14,76,140,184,135,135,135,135,135,72,8,0,9,71,131,131,108,44,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,57,99,124,145,170,167,110,49,0,0,0,
  19,81,112,112,172,135,71,0,0,0,40,85,116,133,135,119,92,51,6,0,0,0,17,
  63,72,72,61,81,84,67,36,0,0,0,0,26,86,108,108,108,108,108,108,93,36,0,
  0,0,28,91,155,168,155,160,167,156,106,51,0,8,65,122,170,182,175,175,136,
  88,35,0,25,88,152,155,91,57,120,175,154,90,27,0,26,88,152,175,175,175,
  175,175,124,63,0,0,21,83,147,160,96,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  6,68,106,76,66,83,131,183,120,56,0,0,0,0,37,59,120,185,120,59,0,0,0,0,
  31,57,68,68,58,35,3,0,0,0,0,0,0,0,25,32,32,27,0,0,0,0,0,0,0,36,44,44,
  44,44,44,44,39,3,0,0,0,27,82,111,131,140,135,124,102,63,17,0,0,32,80,
  113,131,144,163,111,62,10,0,30,90,108,108,76,44,99,108,108,76,14,0,30,
  90,108,108,108,108,108,108,104,49,0,0,28,91,120,120,83,22,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,19,81,145,136,120,124,153,163,106,45,0,0,0,0,8,70,135,
  173,108,47,0,0,0,0,0,0,17,31,32,25,4,0,0,0,0,0,0,23,80,96,96,82,27,0,
  0,0,0,0,0,0,0,0,15,32,32,15,20,20,15,0,0,0,28,52,76,142,112,63,44,14,
  0,0,0,0,28,54,68,106,160,139,87,24,0,0,38,44,44,31,9,41,44,44,31,0,0,
  0,38,44,44,44,44,44,44,43,15,0,0,5,47,56,56,43,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,28,92,142,155,163,159,147,115,71,20,0,0,0,0,20,83,147,162,97,
  35,0,0,0,0,4,45,76,92,96,87,62,23,0,0,0,0,0,35,97,162,157,92,31,0,0,0,
  0,0,0,0,0,42,74,95,95,71,84,84,73,22,0,0,0,24,88,143,100,38,0,0,0,0,0,
  0,0,0,18,70,112,82,48,2,0,0,0,0,24,32,32,28,0,0,0,0,0,0,0,0,27,32,32,
  32,27,11,0,0,0,0,0,0,3,31,32,32,19,0,0,0,0,0,0,0,0,0,0,0,0,0,11,58,78,
  91,96,95,83,62,26,0,0,0,0,0,32,95,159,149,85,23,0,0,0,0,49,94,135,158,
  163,149,113,65,10,0,0,0,0,47,110,174,145,81,44,36,9,0,0,0,0,0,42,88,133,
  158,158,119,151,151,95,32,0,0,0,12,62,76,67,19,0,0,0,0,0,0,0,0,0,28,48,
  28,0,0,0,0,0,20,76,96,96,85,30,0,0,0,0,0,0,28,82,96,96,96,88,72,42,1,
  0,0,0,0,44,92,96,96,67,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,28,32,32,22,3,
  0,0,0,0,0,0,44,107,171,139,72,10,0,0,0,28,85,140,184,144,135,170,154,
  95,34,0,0,0,0,59,120,186,133,99,108,95,60,10,0,0,0,19,76,133,181,153,
  139,149,172,147,82,19,0,0,27,32,32,25,0,8,32,32,32,17,0,0,0,0,0,0,0,30,
  32,31,3,0,0,34,96,160,159,95,32,0,0,0,0,0,0,41,104,163,163,163,153,131,
  91,43,0,0,6,20,59,120,163,135,71,20,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  30,32,25,0,0,0,0,0,0,0,56,119,183,124,61,0,0,0,0,50,111,172,148,92,79,
  140,175,110,47,0,0,0,10,72,135,183,120,160,175,153,97,37,0,0,0,43,103,
  163,158,102,78,139,196,135,70,8,0,27,82,96,96,80,23,51,95,96,96,63,0,
  0,0,0,0,0,40,90,96,92,42,0,0,46,108,172,147,83,30,32,32,31,3,0,0,54,116,
  180,149,147,167,184,133,74,14,2,57,84,84,135,185,120,84,84,68,0,0,0,0,
  0,0,0,0,0,0,0,0,6,24,38,90,96,80,23,22,0,0,0,0,6,68,133,175,111,48,0,
  0,0,0,60,124,188,131,66,77,142,179,112,48,0,0,0,21,83,147,188,142,120,
  162,175,110,47,0,0,0,60,122,186,133,70,72,135,184,120,58,0,0,32,95,159,
  159,92,28,74,135,163,122,63,0,0,0,0,0,12,69,124,160,101,43,0,0,59,120,
  185,135,71,90,96,96,92,42,0,3,67,131,189,124,83,116,177,155,91,28,17,
  80,143,151,156,185,151,151,149,85,0,0,0,0,0,0,0,0,0,0,0,0,52,88,63,108,
  159,92,72,83,37,0,0,4,18,80,144,163,99,37,0,0,0,0,60,124,189,131,78,105,
  162,175,111,48,0,0,0,34,96,160,162,101,87,151,169,104,42,0,0,6,68,135,
  187,120,58,85,147,172,108,45,0,0,28,92,159,160,96,40,99,160,158,97,38,
  0,0,0,0,0,40,97,156,131,72,15,0,8,70,135,185,120,97,142,163,136,94,42,
  0,15,78,143,177,112,51,100,167,159,92,28,28,91,143,143,167,163,143,143,
  139,73,0,0,0,0,0,0,0,0,0,0,0,24,83,142,120,108,159,97,131,124,67,0,4,
  57,80,92,156,151,87,24,0,0,0,0,50,111,170,167,143,156,175,165,101,39,
  0,0,0,45,108,172,147,83,97,163,158,93,31,0,0,7,70,135,191,131,81,116,
  172,160,96,34,0,0,24,88,155,163,96,63,122,183,133,72,13,0,0,0,0,12,69,
  124,160,101,44,0,0,19,82,147,173,108,147,170,131,85,46,4,0,28,91,155,
  165,101,41,104,170,155,90,27,15,65,76,106,170,149,85,76,76,48,0,0,0,0,
  0,0,0,0,0,0,0,24,82,115,147,147,163,156,139,108,69,0,20,83,147,147,172,
  139,75,13,0,0,0,0,26,80,124,151,151,124,165,148,86,25,0,0,0,58,120,184,
  135,71,110,174,145,81,19,0,0,0,59,119,175,167,147,150,178,147,83,21,0,
  0,23,85,151,163,96,87,148,165,104,47,0,0,0,0,0,40,97,156,131,72,15,0,
  0,32,95,159,165,156,162,119,77,37,0,0,0,39,102,167,154,88,54,116,179,
  144,80,18,0,7,55,116,182,136,72,12,12,0,0,0,0,0,0,0,0,0,0,0,0,15,61,90,
  120,153,182,144,111,82,49,0,28,92,131,131,131,124,63,0,0,0,0,0,51,70,
  69,87,87,131,183,124,65,6,0,0,7,69,135,186,120,59,120,187,135,69,7,0,
  0,0,34,84,124,147,139,120,183,135,71,10,0,0,20,84,151,163,96,111,172,
  140,79,22,0,0,0,0,12,69,124,158,101,44,0,0,0,43,106,170,192,168,169,108,
  51,0,0,0,0,52,115,179,142,77,73,135,189,131,66,4,0,6,68,131,187,124,61,
  12,1,0,0,0,0,0,0,0,0,0,0,0,0,32,95,149,147,113,159,122,156,139,76,0,9,
  54,64,64,64,64,34,0,0,0,0,15,77,131,102,97,120,165,150,95,38,0,0,0,19,
  82,147,173,108,72,135,184,120,57,0,0,0,8,70,120,95,84,95,144,177,116,
  56,0,0,0,16,80,147,167,100,136,174,113,54,0,0,0,0,0,40,97,156,131,70,
  13,0,0,0,56,119,183,144,122,183,136,76,18,0,0,2,64,124,190,131,72,105,
  160,167,107,47,0,0,16,80,143,175,111,76,76,54,1,0,0,0,0,0,0,0,0,0,0,0,
  10,67,116,88,108,159,92,97,105,51,0,0,0,24,32,32,28,21,32,32,30,0,27,
  90,154,167,163,179,151,108,60,7,0,0,0,28,92,139,139,97,83,139,139,108,
  45,0,0,0,20,83,147,159,151,157,185,144,90,33,0,0,0,13,76,143,167,100,
  160,149,88,29,0,0,0,0,13,69,124,158,99,42,0,0,0,6,68,131,187,124,97,158,
  162,102,44,0,0,14,76,140,184,135,136,158,183,135,79,22,0,0,20,83,147,
  188,147,143,139,75,12,0,0,0,0,0,0,0,0,0,0,0,0,29,52,44,107,124,91,42,
  49,15,0,0,19,76,96,96,85,70,96,96,90,38,30,90,119,135,133,120,95,60,18,
  0,0,0,0,13,61,72,72,63,57,72,72,67,24,0,0,0,28,91,131,143,147,143,124,
  95,51,2,0,0,0,12,76,142,167,124,182,122,63,4,0,0,0,0,42,99,158,131,70,
  13,0,0,0,17,80,143,175,112,73,133,188,131,69,12,0,26,88,152,175,175,171,
  158,131,91,43,0,0,0,7,65,113,143,151,151,124,63,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,20,57,60,51,7,0,0,0,0,34,96,160,159,95,86,151,163,104,42,0,38,
  58,68,68,58,38,8,0,0,0,0,0,0,17,32,32,32,32,32,32,32,32,15,0,0,5,47,67,
  76,80,76,66,40,6,0,0,0,0,8,72,139,172,149,156,97,38,0,0,0,0,13,70,131,
  158,99,42,0,0,0,0,28,92,139,139,100,48,107,139,139,95,32,0,30,90,108,
  108,108,104,95,74,41,1,0,0,0,0,23,62,80,84,84,83,43,0,0,0,0,0,0,0,0,0,
  0,0,0,0,27,32,31,6,0,0,27,32,32,19,0,46,108,172,147,83,98,163,157,92,
  30,0,0,0,0,0,18,31,32,26,9,0,0,0,4,63,96,96,96,96,96,96,96,96,60,0,0,
  0,0,0,0,0,11,27,32,30,18,0,0,0,4,68,135,175,175,131,70,13,0,0,0,0,42,
  99,158,131,70,13,0,0,0,0,13,61,72,72,63,21,65,72,72,63,17,0,0,38,44,44,
  44,40,33,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,82,96,
  93,47,0,27,82,96,96,67,0,58,120,184,135,71,110,174,144,80,18,0,0,0,20,
  54,79,92,96,87,69,32,0,0,18,80,144,163,163,163,163,163,163,124,63,0,0,
  0,0,0,0,39,70,90,96,92,80,45,0,0,2,65,108,108,108,102,45,0,0,0,0,13,70,
  131,158,99,42,0,0,0,0,0,0,0,0,27,32,32,32,32,23,4,0,0,0,0,0,25,32,32,
  32,32,22,1,0,0,0,0,0,0,10,25,32,32,30,0,0,0,0,0,0,0,0,0,0,0,0,29,92,158,
  122,60,0,32,96,163,143,76,8,70,135,186,120,60,122,187,133,68,6,0,0,23,
  68,108,140,159,163,151,120,56,0,0,28,92,143,143,143,189,147,143,143,112,
  51,0,0,0,0,0,38,85,131,154,163,159,124,60,0,0,0,25,44,44,44,42,12,0,0,
  0,0,32,96,131,124,69,13,0,0,0,0,0,0,0,27,82,96,96,96,96,85,62,26,0,0,
  0,25,80,96,96,96,95,83,58,18,0,0,0,9,54,72,87,96,96,90,38,0,0,0,0,0,0,
  0,0,0,0,0,22,84,151,131,67,3,32,96,163,143,76,20,83,147,174,108,73,135,
  183,119,56,0,0,8,62,113,161,177,151,148,169,110,47,0,0,15,65,76,76,131,
  190,124,76,76,72,30,0,0,0,0,5,66,124,178,145,131,140,112,50,0,0,0,0,0,
  0,9,27,32,28,13,0,0,13,56,64,64,34,0,0,0,0,0,0,0,0,39,101,163,163,163,
  160,148,115,69,15,0,0,39,101,163,163,163,159,145,108,60,3,0,0,30,92,136,
  151,163,163,102,39,0,0,0,0,0,0,0,0,0,0,0,15,77,143,139,73,11,32,96,163,
  143,76,28,92,159,171,104,101,156,171,107,44,0,0,37,93,151,177,131,90,
  84,113,97,35,0,0,0,7,15,78,143,179,115,52,12,10,0,0,0,0,0,12,76,143,175,
  108,64,79,88,35,0,0,0,0,0,33,67,88,96,91,70,34,0,0,0,0,0,0,3,31,32,32,
  19,0,0,0,51,113,178,144,139,147,182,159,98,37,0,0,51,112,177,147,139,
  149,190,147,83,22,0,0,42,104,167,151,172,155,91,28,0,0,0,0,0,0,0,0,0,
  0,0,7,70,135,147,80,18,32,96,147,143,76,28,92,156,190,151,154,164,159,
  95,32,0,0,61,120,181,147,88,37,24,65,63,17,0,0,0,0,27,90,154,167,102,
  39,0,0,0,0,0,0,0,17,72,135,188,131,69,24,29,12,0,0,0,0,34,82,122,152,
  163,155,124,80,27,0,0,0,0,0,44,92,96,96,67,8,0,1,64,124,190,131,72,92,
  157,171,104,40,0,1,63,124,189,131,72,104,171,155,88,24,0,0,46,105,102,
  111,175,143,78,15,0,0,0,0,0,0,0,0,0,0,0,0,63,124,155,88,25,21,70,80,80,
  57,14,71,122,149,144,111,139,139,83,20,0,16,78,142,184,120,62,3,0,5,4,
  0,0,0,0,0,39,101,167,155,91,28,0,0,0,0,0,0,17,63,106,145,190,154,95,69,
  76,76,45,0,0,13,69,122,174,163,147,170,170,112,53,0,0,0,0,0,58,120,163,
  135,71,9,0,13,76,139,180,116,55,97,160,163,99,37,0,13,75,139,182,116,
  68,112,174,145,83,20,0,0,15,46,60,122,187,131,67,4,0,0,0,0,0,0,0,0,0,
  0,0,0,56,119,162,96,32,0,0,0,0,0,0,32,67,84,80,68,72,72,54,3,0,27,88,
  155,169,104,43,0,0,0,0,0,0,0,0,0,51,113,178,143,78,15,0,0,0,0,0,0,53,
  105,156,147,142,181,120,100,143,124,64,0,0,38,97,157,169,113,81,135,193,
  131,67,0,0,0,0,8,70,135,183,120,59,0,0,26,88,152,168,116,116,142,185,
  140,81,20,0,25,87,151,172,131,133,156,159,113,60,2,0,0,0,10,72,136,180,
  116,54,0,0,0,0,0,0,0,0,0,0,0,0,0,48,112,168,104,40,0,0,0,0,0,0,25,32,
  32,25,0,22,32,32,30,0,32,96,160,163,96,33,2,36,33,0,0,0,0,0,1,63,124,
  190,131,67,3,0,0,0,0,0,19,79,140,165,106,113,174,149,115,177,115,53,0,
  0,59,120,182,145,83,60,124,191,135,68,0,0,0,40,48,74,116,116,108,47,0,
  0,38,100,164,187,183,182,172,145,102,52,0,0,37,99,163,177,171,184,135,
  101,68,23,0,0,0,0,22,84,148,168,104,42,0,0,0,0,0,0,0,0,0,0,0,0,0,40,104,
  168,112,48,0,0,0,0,0,23,80,96,96,80,23,74,96,96,90,38,31,93,159,167,103,
  47,58,91,84,25,0,0,0,0,13,76,139,180,116,54,0,0,0,0,0,0,31,93,159,159,
  92,87,147,176,147,150,92,34,0,13,75,139,189,124,65,68,131,195,131,65,
  0,0,30,90,112,112,112,112,88,27,0,0,50,112,176,143,116,116,108,88,56,
  12,0,0,49,112,175,144,104,140,183,120,61,0,0,0,0,4,34,96,160,156,92,30,
  0,0,0,0,0,0,0,0,0,0,0,0,0,32,96,162,116,55,0,0,0,0,0,27,90,155,160,96,
  44,102,162,158,97,39,22,83,147,188,139,108,116,145,87,25,0,0,0,0,25,87,
  151,168,104,42,0,0,0,0,0,0,29,92,157,174,119,96,119,183,158,108,60,6,
  0,24,87,151,176,112,50,80,143,184,120,58,0,0,41,104,168,179,179,149,85,
  23,0,0,62,124,188,131,68,52,45,29,2,0,0,0,61,124,188,133,68,113,176,142,
  79,18,0,0,46,68,68,108,172,144,80,68,46,0,0,0,0,0,0,0,0,0,0,0,0,25,88,
  155,124,63,0,0,0,0,0,19,82,147,167,100,69,131,186,131,70,13,3,60,115,
  164,190,175,180,139,76,13,0,0,0,0,30,90,108,108,90,30,0,0,0,0,0,0,15,
  74,131,175,176,163,174,160,172,112,54,0,0,28,92,159,167,103,40,95,159,
  169,106,45,0,0,46,105,112,116,183,139,72,10,0,11,74,139,182,116,55,0,
  0,0,0,0,0,11,73,139,183,119,56,95,159,160,97,37,0,11,74,135,135,135,185,
  139,135,135,72,0,0,0,0,0,0,0,0,0,0,0,0,18,80,147,135,69,0,0,0,0,0,11,
  74,139,171,107,95,156,158,99,42,0,0,26,71,108,131,135,124,104,62,1,0,
  0,0,0,0,38,44,44,38,0,0,0,0,0,0,0,0,40,85,116,135,131,113,120,120,120,
  71,8,0,28,92,159,167,100,60,116,177,149,88,28,0,0,15,46,68,131,187,124,
  61,0,0,24,87,151,170,106,43,0,0,0,0,0,0,23,85,151,171,107,44,79,142,175,
  116,56,0,23,86,151,175,175,175,175,175,124,63,0,0,0,0,0,0,0,0,0,0,0,0,
  11,73,131,131,76,0,0,0,0,0,3,67,131,179,112,120,181,131,70,13,0,0,0,21,
  49,65,68,63,45,18,0,0,0,0,0,0,0,0,0,20,31,32,32,28,0,0,0,0,0,32,57,68,
  67,53,56,56,56,37,0,0,23,86,149,181,124,112,153,177,120,63,6,0,0,0,17,
  80,144,175,112,48,0,0,26,86,108,108,90,30,0,0,0,0,0,0,26,86,108,108,90,
  32,61,108,108,108,61,0,26,86,108,108,108,108,108,108,104,49,0,0,0,0,0,
  0,0,0,0,0,0,0,0,43,64,64,45,0,0,0,0,0,0,59,120,183,116,149,160,101,44,
  0,0,0,0,0,0,0,18,31,32,26,9,0,0,0,0,0,0,6,51,81,92,96,96,85,30,0,0,0,
  0,0,0,0,0,0,21,32,32,30,0,0,7,65,122,170,182,175,175,136,88,35,0,0,26,
  40,40,92,156,163,99,40,38,9,0,36,44,44,38,0,0,0,0,0,0,0,0,36,44,44,38,
  0,22,44,44,44,22,0,0,36,44,44,44,44,44,44,43,15,0,0,0,0,0,0,0,0,0,0,0,
  0,25,32,32,32,32,32,32,32,30,0,0,51,112,179,124,174,131,72,15,0,0,0,0,
  0,19,53,78,92,96,87,69,32,0,0,0,0,0,42,96,142,159,163,159,93,31,0,0,0,
  0,0,0,0,0,11,70,96,96,90,38,0,0,32,80,113,133,133,115,85,43,0,0,10,70,
  104,104,104,168,151,104,104,99,44,0,0,0,27,32,32,32,32,27,10,0,0,0,0,
  0,0,0,0,30,32,32,30,0,0,0,0,0,27,32,32,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  23,80,96,96,96,96,96,96,96,90,38,0,43,106,171,163,160,101,44,0,0,0,0,
  0,22,68,108,140,159,163,151,120,56,0,0,0,19,32,66,124,186,142,131,131,
  82,19,0,0,0,0,0,0,0,0,26,88,152,163,103,40,0,0,0,28,54,68,68,56,31,0,
  0,0,23,85,149,171,171,187,176,171,169,104,43,0,0,27,82,96,96,96,96,90,
  69,34,0,0,0,0,0,0,40,90,96,96,90,38,0,0,0,27,82,96,96,82,27,0,0,0,0,0,
  0,0,0,0,0,0,0,0,28,92,159,163,163,163,163,163,163,108,44,0,36,98,139,
  139,133,74,17,0,0,0,0,7,61,111,161,177,151,147,169,108,47,0,0,9,67,96,
  96,144,175,111,96,95,53,0,0,0,0,0,0,13,37,44,38,100,164,155,91,29,0,0,
  0,0,0,17,31,32,24,4,0,0,28,91,120,120,120,120,120,120,120,93,31,0,0,39,
  102,163,163,163,163,153,122,76,21,0,0,0,0,10,67,124,163,163,112,48,0,
  0,0,39,101,163,155,91,28,0,0,0,0,0,0,0,0,0,0,0,0,0,28,92,135,135,135,
  135,135,135,135,108,44,0,17,63,72,72,72,43,0,0,0,0,0,37,93,151,177,124,
  90,83,113,96,34,0,0,22,84,148,163,171,184,163,163,120,58,0,0,0,0,0,29,
  69,97,108,97,112,176,143,79,16,0,0,0,12,49,77,92,96,86,60,23,0,5,47,56,
  56,56,56,56,56,56,47,6,0,0,51,113,178,142,135,139,170,165,103,40,0,0,
  0,0,37,93,154,164,183,116,52,0,0,0,51,113,178,143,78,15,0,0,0,0,0,0,0,
  0,0,0,0,0,0,20,74,88,88,88,88,88,88,88,83,35,0,22,24,2,0,0,0,0,0,0,0,
  0,61,120,181,145,88,36,36,65,61,15,0,0,32,96,131,131,172,152,131,131,
  108,46,0,0,0,0,19,71,119,158,175,153,124,188,131,67,5,0,0,9,57,102,139,
  158,163,147,113,68,15,0,0,0,20,20,20,21,32,31,15,0,0,1,64,124,188,124,
  68,83,147,172,108,44,0,0,0,5,63,120,181,122,179,120,56,0,0,1,63,124,190,
  131,67,4,0,0,0,0,0,0,0,0,0,0,0,0,0,28,92,155,155,155,155,155,155,155,
  108,44,22,77,85,62,38,14,0,0,0,0,0,16,78,142,185,120,91,100,100,100,85,
  28,0,0,13,56,64,116,181,139,75,64,61,22,0,0,0,0,49,106,162,164,124,135,
  142,181,116,55,0,0,0,43,97,150,173,139,131,161,158,99,40,0,0,48,83,84,
  84,82,96,93,74,33,0,13,76,139,176,112,96,111,162,153,93,34,0,0,0,32,90,
  149,156,112,179,124,62,0,0,13,76,139,180,116,54,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,28,92,143,143,143,143,143,143,143,108,44,28,92,145,120,97,73,51,
  27,3,0,0,28,91,155,170,106,112,167,167,153,88,27,0,0,0,4,67,131,188,124,
  63,0,0,0,0,0,0,10,70,133,186,124,72,98,163,169,104,43,0,0,9,69,131,186,
  133,84,84,131,181,116,52,0,5,67,131,151,124,142,160,158,116,52,0,25,88,
  152,184,163,163,165,139,108,62,8,0,0,1,59,116,176,131,108,175,131,68,
  4,0,25,88,152,168,104,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,65,76,76,76,76,
  76,76,76,72,29,28,92,153,174,158,135,110,86,62,39,6,32,96,163,163,96,
  124,135,168,140,76,14,0,0,0,16,79,143,177,112,51,0,0,0,0,0,0,24,87,151,
  168,104,43,96,163,157,92,31,0,0,24,87,151,185,151,151,151,152,182,116,
  52,0,17,80,143,182,147,144,139,152,104,41,0,38,100,164,153,135,135,153,
  156,113,58,0,0,0,28,86,145,164,104,108,175,139,72,8,0,38,100,164,156,
  92,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,32,32,17,0,0,0,17,68,92,
  113,136,158,170,147,122,96,40,31,93,159,167,103,68,111,175,124,64,2,0,
  0,0,28,91,155,164,100,38,0,0,0,0,0,0,32,95,159,163,96,53,111,173,145,
  81,19,0,0,32,96,160,162,139,139,139,139,139,108,45,0,29,92,156,177,122,
  82,72,94,90,30,0,49,112,176,140,76,69,116,179,139,76,12,0,0,54,112,172,
  170,159,159,182,143,76,12,0,49,112,176,144,80,18,4,4,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,35,82,96,96,66,15,0,0,0,10,32,53,74,95,119,142,175,108,
  44,21,82,144,188,139,108,124,179,115,52,0,0,0,0,40,103,167,153,88,27,
  0,0,0,0,0,0,32,95,159,165,104,91,142,195,133,68,6,0,0,30,92,159,159,97,
  72,72,90,116,67,25,0,41,104,168,154,92,33,10,38,38,0,0,62,124,188,124,
  64,67,120,184,139,74,11,0,24,81,142,172,143,143,143,170,147,80,17,0,62,
  124,188,131,68,68,68,68,48,0,0,0,0,0,0,0,0,0,0,0,0,0,24,74,124,163,156,
  105,54,5,0,5,47,69,91,112,135,157,169,145,108,44,1,58,111,160,189,175,
  182,163,102,39,0,0,0,0,52,115,139,139,76,14,0,0,0,0,0,0,22,83,144,194,
  154,151,142,183,120,57,0,0,0,18,78,139,187,149,135,139,152,124,60,0,0,
  54,116,180,139,76,13,0,0,0,0,11,73,139,179,120,120,124,159,175,119,59,
  0,0,51,108,168,147,86,76,100,167,151,86,23,11,74,139,188,135,135,135,
  135,135,76,0,0,0,0,0,0,0,0,0,0,0,0,14,63,113,164,153,170,145,94,43,0,
  28,91,131,153,174,156,133,108,85,62,22,0,23,68,104,131,135,124,106,71,
  22,0,0,0,0,33,70,72,72,49,0,0,0,0,0,0,0,0,56,105,143,148,122,139,139,
  107,44,0,0,0,0,49,96,136,157,163,158,143,111,48,0,3,66,131,190,124,64,
  1,0,0,0,0,23,86,151,175,175,175,171,158,131,84,32,0,19,78,136,179,120,
  62,32,96,163,155,91,28,23,86,151,175,175,175,175,175,124,63,0,0,0,0,0,
  0,0,0,0,0,0,2,52,102,154,150,104,122,167,136,82,33,28,92,159,144,119,
  95,72,49,25,2,0,0,0,18,47,64,68,63,47,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,15,56,80,84,67,72,72,67,24,0,0,0,0,6,48,77,92,96,92,80,59,23,
  0,15,78,143,178,113,51,0,0,0,0,0,26,86,108,108,108,108,104,95,74,39,0,
  0,27,88,112,112,93,36,31,92,112,112,88,27,26,86,108,108,108,108,108,108,
  104,51,0,0,0,0,0,0,0,0,0,0,0,27,90,144,147,102,57,74,119,147,122,66,27,
  90,106,83,59,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,29,32,28,18,0,0,0,27,90,
  151,151,102,39,0,0,0,0,0,0,36,44,44,44,44,42,34,15,0,0,0,0,40,48,48,42,
  3,3,42,48,48,40,0,0,36,44,44,44,44,44,44,43,15,0,0,0,0,0,0,0,0,0,0,0,
  17,68,80,80,54,12,29,70,80,80,51,2,44,47,24,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,19,71,84,84,73,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  255
};

#endif /* HEADER_SIGNED_DISTANCE_FONT_XXX */
