#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import print_function

from os.path import dirname, exists, join
import sys, subprocess

from setuptools import find_packages, setup

setup_dir = dirname(__file__)
git_dir = join(setup_dir, ".git")
version_file = join(setup_dir, "cxxheaderparser", "version.py")

# Automatically generate a version.py based on the git version
if exists(git_dir):
    p = subprocess.Popen(
        ["git", "describe", "--tags", "--long", "--dirty=-dirty"],
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
    )
    out, err = p.communicate()
    # Make sure the git version has at least one tag
    if err:
        print("Error: You need to create a tag for this repo to use the builder")
        sys.exit(1)

    # Convert git version to PEP440 compliant version
    # - Older versions of pip choke on local identifiers, so we can't include the git commit
    v, commits, local = out.decode("utf-8").rstrip().split("-", 2)
    if commits != "0" or "-dirty" in local:
        v = "%s.post0.dev%s" % (v, commits)

    # Create the version.py file
    with open(version_file, "w") as fp:
        fp.write("# Autogenerated by setup.py\n__version__ = '{0}'".format(v))

with open(version_file, "r") as fp:
    exec(fp.read(), globals())

DESCRIPTION = (
    "Parse C++ header files and generate a data structure representing the class"
)


CLASSIFIERS = [
    "Development Status :: 4 - Beta",
    "Operating System :: OS Independent",
    "Programming Language :: Python",
    "Programming Language :: Python :: 3",
    "Programming Language :: C++",
    "License :: OSI Approved :: BSD License",
    "Intended Audience :: Developers",
    "Topic :: Software Development",
    "Topic :: Software Development :: Code Generators",
    "Topic :: Software Development :: Compilers",
]

setup(
    name="cxxheaderparser",
    version=__version__,
    author="Dustin Spicuzza",
    author_email="dustin@virtualroadside.com",
    maintainer="RobotPy Development Team",
    maintainer_email="robotpy@googlegroups.com",
    url="https://github.com/robotpy/cxxheaderparser",
    description=DESCRIPTION,
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    install_requires=["dataclasses; python_version < '3.7'"],
    extras_require={"pcpp": ["pcpp~=1.30"]},
    license="BSD",
    platforms="Platform Independent",
    packages=find_packages(),
    package_data={"cxxheaderparser": ["py.typed"]},
    keywords="c++ header parser ply",
    python_requires=">= 3.6",
    classifiers=CLASSIFIERS,
)
