/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "drone.h"
#include "din.h"

extern int BOTTOM;
extern float DELTA_VOLUME;

void drone::set_xy (din& board, const int& xx, const int& yy) {
		
		// position
    x = xx;
    y = yy;
    
    // height, volume
    dy = y - BOTTOM;
    vol = dy * DELTA_VOLUME;
		
		// locate range on microtonal-keyboard
    range = board.find_range (x, range);
		
		// locate pitch on microtonal-keyboard
    ::range& dr = board.ranges[range];
    int delta_left = x - dr.extents.left;
    if (board.snap_drones) { // pitch is either left or right notes of a range
      int delta_right = dr.extents.right - x;
      int note_num = 0; if (delta_right < delta_left) note_num = 1;
      if (note_num) { pos = 1; x = dr.extents.right; } else { pos = 0; x = dr.extents.left;}
      step = dr.notes[note_num].step;
    } else {
      pos = delta_left * 1. / dr.extents.width;
      float one_rpos = 1 - pos;
      step = one_rpos * dr.notes[0].step + pos * dr.notes[1].step;
    }

    calc_handle (); // update drone handle
		
		// update pitch & vol on drone's player
		float v = board.drone_master_volume * vol;
    player.set (step, v, v);
    

}
