/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.Atom;
import MCview.PDBChain;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import jalview.schemes.ColourSchemeI;
import java.awt.Color;
import java.io.IOException;
import java.util.Vector;

public class PDBfile
extends AlignFile {
    public Vector chains;
    public String id;
    boolean VisibleChainAnnotation = false;

    public PDBfile(String inFile, String inType) throws IOException {
        super(inFile, inType);
    }

    public PDBfile(FileParse source) throws IOException {
        super(source);
    }

    public String print() {
        return null;
    }

    public void parse() throws IOException {
        this.id = this.inFile == null || this.inFile.getName() == null || this.inFile.getName().length() == 0 ? "PDBFILE" : this.inFile.getName();
        try {
            String line;
            this.chains = new Vector();
            boolean modelFlag = false;
            boolean terFlag = false;
            int index = 0;
            while ((line = this.nextLine()) != null) {
                if (line.indexOf("HEADER") == 0) {
                    String tid;
                    if (line.length() <= 62 || (tid = line.length() > 67 ? line.substring(62, 67).trim() : line.substring(62).trim()).length() <= 0) continue;
                    this.id = tid;
                    continue;
                }
                if (line.indexOf("SEQRES") == 0) {
                    // empty if block
                }
                if (line.indexOf("MODEL") == 0) {
                    modelFlag = true;
                }
                if (line.indexOf("TER") == 0) {
                    terFlag = true;
                }
                if (modelFlag && line.indexOf("ENDMDL") == 0) break;
                if (line.indexOf("ATOM") == 0 || line.indexOf("HETATM") == 0 && !terFlag) {
                    terFlag = false;
                    if (!line.substring(12, 15).trim().equals("CA")) continue;
                    Atom tmpatom = new Atom(line);
                    PDBChain tmpchain = this.findChain(tmpatom.chain);
                    if (tmpchain != null) {
                        tmpchain.atoms.addElement(tmpatom);
                    } else {
                        tmpchain = new PDBChain(this.id, tmpatom.chain);
                        this.chains.addElement(tmpchain);
                        tmpchain.atoms.addElement(tmpatom);
                    }
                }
                ++index;
            }
            this.makeResidueList();
            this.makeCaBondList();
            if (this.id == null) {
                this.id = this.inFile.getName();
            }
            for (int i = 0; i < this.chains.size(); ++i) {
                Sequence dataset = ((PDBChain)this.chains.elementAt((int)i)).sequence;
                dataset.setName(this.id + "|" + dataset.getName());
                PDBEntry entry = new PDBEntry();
                entry.setId(this.id);
                if (this.inFile != null) {
                    entry.setFile(this.inFile.getAbsolutePath());
                }
                dataset.addPDBId(entry);
                SequenceI chainseq = dataset.deriveSequence();
                this.seqs.addElement(chainseq);
                AlignmentAnnotation[] chainannot = chainseq.getAnnotation();
                if (chainannot == null) continue;
                for (int ai = 0; ai < chainannot.length; ++ai) {
                    chainannot[ai].visible = this.VisibleChainAnnotation;
                    this.annotations.addElement(chainannot[ai]);
                }
            }
        }
        catch (OutOfMemoryError er) {
            System.out.println("OUT OF MEMORY LOADING PDB FILE");
            throw new IOException("Out of memory loading PDB File");
        }
    }

    public void makeResidueList() {
        for (int i = 0; i < this.chains.size(); ++i) {
            ((PDBChain)this.chains.elementAt(i)).makeResidueList();
        }
    }

    public void makeCaBondList() {
        for (int i = 0; i < this.chains.size(); ++i) {
            ((PDBChain)this.chains.elementAt(i)).makeCaBondList();
        }
    }

    public PDBChain findChain(String id) {
        for (int i = 0; i < this.chains.size(); ++i) {
            if (!((PDBChain)this.chains.elementAt((int)i)).id.equals(id)) continue;
            return (PDBChain)this.chains.elementAt(i);
        }
        return null;
    }

    public void setChargeColours() {
        for (int i = 0; i < this.chains.size(); ++i) {
            ((PDBChain)this.chains.elementAt(i)).setChargeColours();
        }
    }

    public void setColours(ColourSchemeI cs) {
        for (int i = 0; i < this.chains.size(); ++i) {
            ((PDBChain)this.chains.elementAt(i)).setChainColours(cs);
        }
    }

    public void setChainColours() {
        for (int i = 0; i < this.chains.size(); ++i) {
            ((PDBChain)this.chains.elementAt(i)).setChainColours(Color.getHSBColor(1.0f / (float)i, 0.4f, 1.0f));
        }
    }
}

