/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.parameters;

import geotrans3.parameters.CoordinateSystemParameters;

public class MercatorStandardParallelParameters
extends CoordinateSystemParameters {
    private double centralMeridian;
    private double standardParallel;
    private double scaleFactor;
    private double falseEasting;
    private double falseNorthing;

    public MercatorStandardParallelParameters(int n, double d, double d2, double d3, double d4, double d5) {
        super(n);
        this.centralMeridian = d;
        this.standardParallel = d2;
        this.scaleFactor = d3;
        this.falseEasting = d4;
        this.falseNorthing = d5;
    }

    public boolean equal(MercatorStandardParallelParameters mercatorStandardParallelParameters) {
        return super.equal(mercatorStandardParallelParameters) && this.centralMeridian == mercatorStandardParallelParameters.getCentralMeridian() && this.standardParallel == mercatorStandardParallelParameters.getStandardParallel() && this.scaleFactor == mercatorStandardParallelParameters.getScaleFactor() && this.falseEasting == mercatorStandardParallelParameters.getFalseEasting() && this.falseNorthing == mercatorStandardParallelParameters.getFalseNorthing();
    }

    public double getCentralMeridian() {
        return this.centralMeridian;
    }

    public double getStandardParallel() {
        return this.standardParallel;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public String toString() {
        return "MercatorStandardParallelParameters: CentralMeridian = " + this.centralMeridian + " StandardParallel = " + this.standardParallel + " ScaleFactor = " + this.scaleFactor + " FalseEasting = " + this.falseEasting + " FalseNorthing = " + this.falseNorthing;
    }
}

