//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccountResource.
func (a AccountResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AccountSKU.
func (a AccountSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capabilities", a.Capabilities)
	populate(objectMap, "locations", a.Locations)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "resourceType", a.ResourceType)
	populate(objectMap, "tier", a.Tier)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AccountUpdateParameters.
func (a AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AnalysisResultSingletonResource.
func (a AnalysisResultSingletonResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AnalysisResultSingletonResource.
func (a *AnalysisResultSingletonResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			a.Properties, err = unmarshalAnalysisResultSingletonResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CPURegressionResultSingletonResourceProperties.
func (c CPURegressionResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["analysisResultType"] = AnalysisResultTypeCPURegression
	populate(objectMap, "cpuRegressionResults", c.CPURegressionResults)
	populate(objectMap, "grade", c.Grade)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CPURegressionResultSingletonResourceProperties.
func (c *CPURegressionResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &c.AnalysisResultType)
			delete(rawMsg, key)
		case "cpuRegressionResults":
			err = unpopulate(val, "CPURegressionResults", &c.CPURegressionResults)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &c.Grade)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CPUUtilizationResultSingletonResourceProperties.
func (c CPUUtilizationResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["analysisResultType"] = AnalysisResultTypeCPUUtilization
	populate(objectMap, "cpuUtilizationResults", c.CPUUtilizationResults)
	populate(objectMap, "grade", c.Grade)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CPUUtilizationResultSingletonResourceProperties.
func (c *CPUUtilizationResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &c.AnalysisResultType)
			delete(rawMsg, key)
		case "cpuUtilizationResults":
			err = unpopulate(val, "CPUUtilizationResults", &c.CPUUtilizationResults)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &c.Grade)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerEventProperties.
func (c CustomerEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eventName", c.EventName)
	populate(objectMap, "receivers", c.Receivers)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DistributionGroupListReceiverValue.
func (d DistributionGroupListReceiverValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "distributionGroups", d.DistributionGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DownloadURLResponse.
func (d *DownloadURLResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downloadUrl":
			err = unpopulate(val, "DownloadURL", &d.DownloadURL)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateTimeRFC3339(val, "ExpirationTime", &d.ExpirationTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MemoryRegressionResultSingletonResourceProperties.
func (m MemoryRegressionResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["analysisResultType"] = AnalysisResultTypeMemoryRegression
	populate(objectMap, "grade", m.Grade)
	populate(objectMap, "memoryRegressionResults", m.MemoryRegressionResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MemoryRegressionResultSingletonResourceProperties.
func (m *MemoryRegressionResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &m.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &m.Grade)
			delete(rawMsg, key)
		case "memoryRegressionResults":
			err = unpopulate(val, "MemoryRegressionResults", &m.MemoryRegressionResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MemoryUtilizationResultSingletonResourceProperties.
func (m MemoryUtilizationResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["analysisResultType"] = AnalysisResultTypeMemoryUtilization
	populate(objectMap, "grade", m.Grade)
	populate(objectMap, "memoryUtilizationResults", m.MemoryUtilizationResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MemoryUtilizationResultSingletonResourceProperties.
func (m *MemoryUtilizationResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &m.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &m.Grade)
			delete(rawMsg, key)
		case "memoryUtilizationResults":
			err = unpopulate(val, "MemoryUtilizationResults", &m.MemoryUtilizationResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpdateProperties.
func (o OSUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "buildRevision", o.BuildRevision)
	populate(objectMap, "buildVersion", o.BuildVersion)
	populate(objectMap, "flightingRing", o.FlightingRing)
	populate(objectMap, "osName", o.OSName)
	populate(objectMap, "release", o.Release)
	populateTimeRFC3339(objectMap, "releaseVersionDate", o.ReleaseVersionDate)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSUpdateProperties.
func (o *OSUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "buildRevision":
			err = unpopulate(val, "BuildRevision", &o.BuildRevision)
			delete(rawMsg, key)
		case "buildVersion":
			err = unpopulate(val, "BuildVersion", &o.BuildVersion)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &o.FlightingRing)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &o.OSName)
			delete(rawMsg, key)
		case "release":
			err = unpopulate(val, "Release", &o.Release)
			delete(rawMsg, key)
		case "releaseVersionDate":
			err = unpopulateTimeRFC3339(val, "ReleaseVersionDate", &o.ReleaseVersionDate)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpdateTestSummary.
func (o OSUpdateTestSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "buildRevision", o.BuildRevision)
	populate(objectMap, "buildVersion", o.BuildVersion)
	populate(objectMap, "executionStatus", o.ExecutionStatus)
	populate(objectMap, "flightingRing", o.FlightingRing)
	populate(objectMap, "grade", o.Grade)
	populate(objectMap, "osName", o.OSName)
	populate(objectMap, "releaseName", o.ReleaseName)
	populateTimeRFC3339(objectMap, "releaseVersionDate", o.ReleaseVersionDate)
	populate(objectMap, "testRunTime", o.TestRunTime)
	populate(objectMap, "testStatus", o.TestStatus)
	populate(objectMap, "testType", o.TestType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSUpdateTestSummary.
func (o *OSUpdateTestSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "buildRevision":
			err = unpopulate(val, "BuildRevision", &o.BuildRevision)
			delete(rawMsg, key)
		case "buildVersion":
			err = unpopulate(val, "BuildVersion", &o.BuildVersion)
			delete(rawMsg, key)
		case "executionStatus":
			err = unpopulate(val, "ExecutionStatus", &o.ExecutionStatus)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &o.FlightingRing)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &o.Grade)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &o.OSName)
			delete(rawMsg, key)
		case "releaseName":
			err = unpopulate(val, "ReleaseName", &o.ReleaseName)
			delete(rawMsg, key)
		case "releaseVersionDate":
			err = unpopulateTimeRFC3339(val, "ReleaseVersionDate", &o.ReleaseVersionDate)
			delete(rawMsg, key)
		case "testRunTime":
			err = unpopulate(val, "TestRunTime", &o.TestRunTime)
			delete(rawMsg, key)
		case "testStatus":
			err = unpopulate(val, "TestStatus", &o.TestStatus)
			delete(rawMsg, key)
		case "testType":
			err = unpopulate(val, "TestType", &o.TestType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSUpdatesTestSummary.
func (o OSUpdatesTestSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "executionStatus", o.ExecutionStatus)
	populate(objectMap, "grade", o.Grade)
	populate(objectMap, "osUpdateTestSummaries", o.OSUpdateTestSummaries)
	populate(objectMap, "testRunTime", o.TestRunTime)
	populate(objectMap, "testStatus", o.TestStatus)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PackageProperties.
func (p PackageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationName", p.ApplicationName)
	populate(objectMap, "blobPath", p.BlobPath)
	populate(objectMap, "flightingRing", p.FlightingRing)
	populate(objectMap, "isEnabled", p.IsEnabled)
	populateTimeRFC3339(objectMap, "lastModifiedTime", p.LastModifiedTime)
	populate(objectMap, "packageStatus", p.PackageStatus)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "targetOSList", p.TargetOSList)
	populate(objectMap, "testTypes", p.TestTypes)
	populate(objectMap, "tests", p.Tests)
	populate(objectMap, "validationResults", p.ValidationResults)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PackageProperties.
func (p *PackageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &p.ApplicationName)
			delete(rawMsg, key)
		case "blobPath":
			err = unpopulate(val, "BlobPath", &p.BlobPath)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &p.FlightingRing)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &p.IsEnabled)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &p.LastModifiedTime)
			delete(rawMsg, key)
		case "packageStatus":
			err = unpopulate(val, "PackageStatus", &p.PackageStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "targetOSList":
			err = unpopulate(val, "TargetOSList", &p.TargetOSList)
			delete(rawMsg, key)
		case "testTypes":
			err = unpopulate(val, "TestTypes", &p.TestTypes)
			delete(rawMsg, key)
		case "tests":
			err = unpopulate(val, "Tests", &p.Tests)
			delete(rawMsg, key)
		case "validationResults":
			err = unpopulate(val, "ValidationResults", &p.ValidationResults)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PackageResource.
func (p PackageResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PackageUpdateParameterProperties.
func (p PackageUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobPath", p.BlobPath)
	populate(objectMap, "flightingRing", p.FlightingRing)
	populate(objectMap, "isEnabled", p.IsEnabled)
	populate(objectMap, "targetOSList", p.TargetOSList)
	populate(objectMap, "tests", p.Tests)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PackageUpdateParameters.
func (p PackageUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PackageValidationResult.
func (p PackageValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errors", p.Errors)
	populate(objectMap, "isValid", p.IsValid)
	populate(objectMap, "validationName", p.ValidationName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReliabilityResultSingletonResourceProperties.
func (r ReliabilityResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["analysisResultType"] = AnalysisResultTypeReliability
	populate(objectMap, "grade", r.Grade)
	populate(objectMap, "reliabilityResults", r.ReliabilityResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReliabilityResultSingletonResourceProperties.
func (r *ReliabilityResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &r.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &r.Grade)
			delete(rawMsg, key)
		case "reliabilityResults":
			err = unpopulate(val, "ReliabilityResults", &r.ReliabilityResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptExecutionResult.
func (s ScriptExecutionResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", s.EndTime)
	populate(objectMap, "exitCode", s.ExitCode)
	populate(objectMap, "scriptName", s.ScriptName)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "timedOut", s.TimedOut)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptExecutionResult.
func (s *ScriptExecutionResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "exitCode":
			err = unpopulate(val, "ExitCode", &s.ExitCode)
			delete(rawMsg, key)
		case "scriptName":
			err = unpopulate(val, "ScriptName", &s.ScriptName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "timedOut":
			err = unpopulate(val, "TimedOut", &s.TimedOut)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptExecutionResultSingletonResourceProperties.
func (s ScriptExecutionResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["analysisResultType"] = AnalysisResultTypeScriptExecution
	populate(objectMap, "grade", s.Grade)
	populate(objectMap, "scriptExecutionResults", s.ScriptExecutionResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptExecutionResultSingletonResourceProperties.
func (s *ScriptExecutionResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &s.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &s.Grade)
			delete(rawMsg, key)
		case "scriptExecutionResults":
			err = unpopulate(val, "ScriptExecutionResults", &s.ScriptExecutionResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetOSInfo.
func (t TargetOSInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "osUpdateType", t.OSUpdateType)
	populate(objectMap, "targetOSs", t.TargetOSs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Test.
func (t Test) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "commands", t.Commands)
	populate(objectMap, "isActive", t.IsActive)
	populate(objectMap, "testType", t.TestType)
	populate(objectMap, "validationRunStatus", t.ValidationRunStatus)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TestAnalysisResult.
func (t TestAnalysisResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "blobData", t.BlobData)
	populate(objectMap, "identifiedFailures", t.IdentifiedFailures)
	populate(objectMap, "testAnalysisStatus", t.TestAnalysisStatus)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TestAnalysisResultSingletonResourceProperties.
func (t TestAnalysisResultSingletonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["analysisResultType"] = AnalysisResultTypeTestAnalysis
	populate(objectMap, "grade", t.Grade)
	populate(objectMap, "testAnalysisResult", t.TestAnalysisResult)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestAnalysisResultSingletonResourceProperties.
func (t *TestAnalysisResultSingletonResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisResultType":
			err = unpopulate(val, "AnalysisResultType", &t.AnalysisResultType)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &t.Grade)
			delete(rawMsg, key)
		case "testAnalysisResult":
			err = unpopulate(val, "TestAnalysisResult", &t.TestAnalysisResult)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestResultProperties.
func (t TestResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "analysisSummaries", t.AnalysisSummaries)
	populate(objectMap, "applicationName", t.ApplicationName)
	populate(objectMap, "applicationVersion", t.ApplicationVersion)
	populate(objectMap, "baselineTestResultId", t.BaselineTestResultID)
	populate(objectMap, "buildRevision", t.BuildRevision)
	populate(objectMap, "buildVersion", t.BuildVersion)
	populate(objectMap, "executionStatus", t.ExecutionStatus)
	populate(objectMap, "flightingRing", t.FlightingRing)
	populate(objectMap, "grade", t.Grade)
	populate(objectMap, "isDownloadDataAvailable", t.IsDownloadDataAvailable)
	populate(objectMap, "isVideoAvailable", t.IsVideoAvailable)
	populate(objectMap, "kbNumber", t.KbNumber)
	populate(objectMap, "osName", t.OSName)
	populate(objectMap, "packageId", t.PackageID)
	populate(objectMap, "packageVersion", t.PackageVersion)
	populate(objectMap, "releaseName", t.ReleaseName)
	populateTimeRFC3339(objectMap, "releaseVersionDate", t.ReleaseVersionDate)
	populate(objectMap, "testRunTime", t.TestRunTime)
	populate(objectMap, "testStatus", t.TestStatus)
	populate(objectMap, "testType", t.TestType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestResultProperties.
func (t *TestResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "analysisSummaries":
			err = unpopulate(val, "AnalysisSummaries", &t.AnalysisSummaries)
			delete(rawMsg, key)
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &t.ApplicationName)
			delete(rawMsg, key)
		case "applicationVersion":
			err = unpopulate(val, "ApplicationVersion", &t.ApplicationVersion)
			delete(rawMsg, key)
		case "baselineTestResultId":
			err = unpopulate(val, "BaselineTestResultID", &t.BaselineTestResultID)
			delete(rawMsg, key)
		case "buildRevision":
			err = unpopulate(val, "BuildRevision", &t.BuildRevision)
			delete(rawMsg, key)
		case "buildVersion":
			err = unpopulate(val, "BuildVersion", &t.BuildVersion)
			delete(rawMsg, key)
		case "executionStatus":
			err = unpopulate(val, "ExecutionStatus", &t.ExecutionStatus)
			delete(rawMsg, key)
		case "flightingRing":
			err = unpopulate(val, "FlightingRing", &t.FlightingRing)
			delete(rawMsg, key)
		case "grade":
			err = unpopulate(val, "Grade", &t.Grade)
			delete(rawMsg, key)
		case "isDownloadDataAvailable":
			err = unpopulate(val, "IsDownloadDataAvailable", &t.IsDownloadDataAvailable)
			delete(rawMsg, key)
		case "isVideoAvailable":
			err = unpopulate(val, "IsVideoAvailable", &t.IsVideoAvailable)
			delete(rawMsg, key)
		case "kbNumber":
			err = unpopulate(val, "KbNumber", &t.KbNumber)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &t.OSName)
			delete(rawMsg, key)
		case "packageId":
			err = unpopulate(val, "PackageID", &t.PackageID)
			delete(rawMsg, key)
		case "packageVersion":
			err = unpopulate(val, "PackageVersion", &t.PackageVersion)
			delete(rawMsg, key)
		case "releaseName":
			err = unpopulate(val, "ReleaseName", &t.ReleaseName)
			delete(rawMsg, key)
		case "releaseVersionDate":
			err = unpopulateTimeRFC3339(val, "ReleaseVersionDate", &t.ReleaseVersionDate)
			delete(rawMsg, key)
		case "testRunTime":
			err = unpopulate(val, "TestRunTime", &t.TestRunTime)
			delete(rawMsg, key)
		case "testStatus":
			err = unpopulate(val, "TestStatus", &t.TestStatus)
			delete(rawMsg, key)
		case "testType":
			err = unpopulate(val, "TestType", &t.TestType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UserObjectReceiverValue.
func (u UserObjectReceiverValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "userObjectIds", u.UserObjectIDs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UtilizationEntry.
func (u UtilizationEntry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "timestamp", u.Timestamp)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UtilizationEntry.
func (u *UtilizationEntry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &u.Timestamp)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UtilizationResult.
func (u UtilizationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "lowerBound", u.LowerBound)
	populate(objectMap, "process", u.Process)
	populate(objectMap, "upperBound", u.UpperBound)
	populate(objectMap, "utilization", u.Utilization)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
