// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the activation status of Amazon Inspector deep inspection and custom
// paths associated with your account.
func (c *Client) GetEc2DeepInspectionConfiguration(ctx context.Context, params *GetEc2DeepInspectionConfigurationInput, optFns ...func(*Options)) (*GetEc2DeepInspectionConfigurationOutput, error) {
	if params == nil {
		params = &GetEc2DeepInspectionConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEc2DeepInspectionConfiguration", params, optFns, c.addOperationGetEc2DeepInspectionConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEc2DeepInspectionConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEc2DeepInspectionConfigurationInput struct {
	noSmithyDocumentSerde
}

type GetEc2DeepInspectionConfigurationOutput struct {

	// An error message explaining why Amazon Inspector deep inspection configurations
	// could not be retrieved for your account.
	ErrorMessage *string

	// The Amazon Inspector deep inspection custom paths for your organization.
	OrgPackagePaths []string

	// The Amazon Inspector deep inspection custom paths for your account.
	PackagePaths []string

	// The activation status of Amazon Inspector deep inspection in your account.
	Status types.Ec2DeepInspectionStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEc2DeepInspectionConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEc2DeepInspectionConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEc2DeepInspectionConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEc2DeepInspectionConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEc2DeepInspectionConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEc2DeepInspectionConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEc2DeepInspectionConfiguration",
	}
}
