// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the status of Service Catalog in SageMaker. Service Catalog is used to
// create SageMaker projects.
func (c *Client) GetSagemakerServicecatalogPortfolioStatus(ctx context.Context, params *GetSagemakerServicecatalogPortfolioStatusInput, optFns ...func(*Options)) (*GetSagemakerServicecatalogPortfolioStatusOutput, error) {
	if params == nil {
		params = &GetSagemakerServicecatalogPortfolioStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSagemakerServicecatalogPortfolioStatus", params, optFns, c.addOperationGetSagemakerServicecatalogPortfolioStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSagemakerServicecatalogPortfolioStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSagemakerServicecatalogPortfolioStatusInput struct {
	noSmithyDocumentSerde
}

type GetSagemakerServicecatalogPortfolioStatusOutput struct {

	// Whether Service Catalog is enabled or disabled in SageMaker.
	Status types.SagemakerServicecatalogStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSagemakerServicecatalogPortfolioStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetSagemakerServicecatalogPortfolioStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetSagemakerServicecatalogPortfolioStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSagemakerServicecatalogPortfolioStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSagemakerServicecatalogPortfolioStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSagemakerServicecatalogPortfolioStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSagemakerServicecatalogPortfolioStatus",
	}
}
