# frozen_string_literal: true

class SetMissingTraversalIdsForVulnerabilityReads < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.1'

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  class VulnerabilityRead < MigrationRecord
    include EachBatch

    self.table_name = 'vulnerability_reads'
  end

  def up
    return unless Gitlab.com?

    VulnerabilityRead.where(traversal_ids: [], archived: false).each_batch(of: 50) do |batch|
      vulnerability_ids = batch.pluck(:vulnerability_id)

      update_records(vulnerability_ids)
    end
  end

  def down
    # no-op
  end

  private

  def update_records(vulnerability_ids)
    execute(<<~SQL)
      UPDATE
        vulnerability_reads
      SET
        traversal_ids = namespaces.traversal_ids
      FROM
        namespaces
      WHERE
        vulnerability_reads.vulnerability_id IN (#{vulnerability_ids.join(', ')}) AND
        namespaces.id = vulnerability_reads.namespace_id
    SQL
  end
end
