// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/appconfig"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To create an application
// The following create-application example creates an application in AWS AppConfig.
func ExampleAppConfig_CreateApplication_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.CreateApplicationInput{
		Description: aws.String("An application used for creating an example."),
		Name:        aws.String("example-application"),
	}

	result, err := svc.CreateApplication(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a configuration profile
// The following create-configuration-profile example creates a configuration profile
// using a configuration stored in Parameter Store, a capability of Systems Manager.
func ExampleAppConfig_CreateConfigurationProfile_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.CreateConfigurationProfileInput{
		ApplicationId:    aws.String("339ohji"),
		LocationUri:      aws.String("ssm-parameter://Example-Parameter"),
		Name:             aws.String("Example-Configuration-Profile"),
		RetrievalRoleArn: aws.String("arn:aws:iam::111122223333:role/Example-App-Config-Role"),
	}

	result, err := svc.CreateConfigurationProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a deployment strategy
// The following create-deployment-strategy example creates a deployment strategy called
// Example-Deployment that takes 15 minutes and deploys the configuration to 25% of
// the application at a time. The strategy is also copied to an SSM Document.
func ExampleAppConfig_CreateDeploymentStrategy_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.CreateDeploymentStrategyInput{
		DeploymentDurationInMinutes: aws.Int64(15),
		GrowthFactor:                aws.Float64(25.000000),
		Name:                        aws.String("Example-Deployment"),
		ReplicateTo:                 aws.String("SSM_DOCUMENT"),
	}

	result, err := svc.CreateDeploymentStrategy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an environment
// The following create-environment example creates an AWS AppConfig environment named
// Example-Environment using the application you created using create-application
func ExampleAppConfig_CreateEnvironment_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.CreateEnvironmentInput{
		ApplicationId: aws.String("339ohji"),
		Name:          aws.String("Example-Environment"),
	}

	result, err := svc.CreateEnvironment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a hosted configuration version
// The following create-hosted-configuration-version example creates a new configuration
// in the AWS AppConfig configuration store.
func ExampleAppConfig_CreateHostedConfigurationVersion_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.CreateHostedConfigurationVersionInput{
		ApplicationId:          aws.String("339ohji"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
		Content:                []byte("eyAiTmFtZSI6ICJFeGFtcGxlQXBwbGljYXRpb24iLCAiSWQiOiBFeGFtcGxlSUQsICJSYW5rIjogNyB9"),
		ContentType:            aws.String("text"),
		LatestVersionNumber:    aws.Int64(1),
	}

	result, err := svc.CreateHostedConfigurationVersion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeServiceQuotaExceededException:
				fmt.Println(appconfig.ErrCodeServiceQuotaExceededException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeConflictException:
				fmt.Println(appconfig.ErrCodeConflictException, aerr.Error())
			case appconfig.ErrCodePayloadTooLargeException:
				fmt.Println(appconfig.ErrCodePayloadTooLargeException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an application
// The following delete-application example deletes the specified application.
func ExampleAppConfig_DeleteApplication_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.DeleteApplicationInput{
		ApplicationId: aws.String("339ohji"),
	}

	result, err := svc.DeleteApplication(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a configuration profile
// The following delete-configuration-profile example deletes the specified configuration
// profile.
func ExampleAppConfig_DeleteConfigurationProfile_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.DeleteConfigurationProfileInput{
		ApplicationId:          aws.String("339ohji"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
	}

	result, err := svc.DeleteConfigurationProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeConflictException:
				fmt.Println(appconfig.ErrCodeConflictException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a deployment strategy
// The following delete-deployment-strategy example deletes the specified deployment
// strategy.
func ExampleAppConfig_DeleteDeploymentStrategy_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.DeleteDeploymentStrategyInput{
		DeploymentStrategyId: aws.String("1225qzk"),
	}

	result, err := svc.DeleteDeploymentStrategy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an environment
// The following delete-environment example deletes the specified application environment.
func ExampleAppConfig_DeleteEnvironment_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.DeleteEnvironmentInput{
		ApplicationId: aws.String("339ohji"),
		EnvironmentId: aws.String("54j1r29"),
	}

	result, err := svc.DeleteEnvironment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeConflictException:
				fmt.Println(appconfig.ErrCodeConflictException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a hosted configuration version
// The following delete-hosted-configuration-version example deletes a configuration
// version hosted in the AWS AppConfig configuration store.
func ExampleAppConfig_DeleteHostedConfigurationVersion_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.DeleteHostedConfigurationVersionInput{
		ApplicationId:          aws.String("339ohji"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
		VersionNumber:          aws.Int64(1),
	}

	result, err := svc.DeleteHostedConfigurationVersion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list details of an application
// The following get-application example lists the details of the specified application.
func ExampleAppConfig_GetApplication_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.GetApplicationInput{
		ApplicationId: aws.String("339ohji"),
	}

	result, err := svc.GetApplication(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve configuration details
// The following get-configuration example returns the configuration details of the
// example application. On subsequent calls to get-configuration, use the client-configuration-version
// parameter to only update the configuration of your application if the version has
// changed. Only updating the configuration when the version has changed avoids excess
// charges incurred by calling get-configuration.
func ExampleAppConfig_GetConfiguration_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.GetConfigurationInput{
		Application:   aws.String("example-application"),
		ClientId:      aws.String("example-id"),
		Configuration: aws.String("Example-Configuration-Profile"),
		Environment:   aws.String("Example-Environment"),
	}

	result, err := svc.GetConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve configuration profile details
// The following get-configuration-profile example returns the details of the specified
// configuration profile.
func ExampleAppConfig_GetConfigurationProfile_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.GetConfigurationProfileInput{
		ApplicationId:          aws.String("339ohji"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
	}

	result, err := svc.GetConfigurationProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve deployment details
// The following get-deployment example lists details of the deployment to the application
// in the specified environment and deployment.
func ExampleAppConfig_GetDeployment_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.GetDeploymentInput{
		ApplicationId:    aws.String("339ohji"),
		DeploymentNumber: aws.Int64(1),
		EnvironmentId:    aws.String("54j1r29"),
	}

	result, err := svc.GetDeployment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve details of a deployment strategy
// The following get-deployment-strategy example lists the details of the specified
// deployment strategy.
func ExampleAppConfig_GetDeploymentStrategy_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.GetDeploymentStrategyInput{
		DeploymentStrategyId: aws.String("1225qzk"),
	}

	result, err := svc.GetDeploymentStrategy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve environment details
// The following get-environment example returns the details and state of the specified
// environment.
func ExampleAppConfig_GetEnvironment_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.GetEnvironmentInput{
		ApplicationId: aws.String("339ohji"),
		EnvironmentId: aws.String("54j1r29"),
	}

	result, err := svc.GetEnvironment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve hosted configuration details
// The following get-hosted-configuration-version example retrieves the configuration
// details of the AWS AppConfig hosted configuration.
func ExampleAppConfig_GetHostedConfigurationVersion_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.GetHostedConfigurationVersionInput{
		ApplicationId:          aws.String("339ohji"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
		VersionNumber:          aws.Int64(1),
	}

	result, err := svc.GetHostedConfigurationVersion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the available applications
// The following list-applications example lists the available applications in your
// AWS account.
func ExampleAppConfig_ListApplications_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.ListApplicationsInput{}

	result, err := svc.ListApplications(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the available configuration profiles
// The following list-configuration-profiles example lists the available configuration
// profiles for the specified application.
func ExampleAppConfig_ListConfigurationProfiles_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.ListConfigurationProfilesInput{
		ApplicationId: aws.String("339ohji"),
	}

	result, err := svc.ListConfigurationProfiles(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the available deployment strategies
// The following list-deployment-strategies example lists the available deployment strategies
// in your AWS account.
func ExampleAppConfig_ListDeploymentStrategies_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.ListDeploymentStrategiesInput{}

	result, err := svc.ListDeploymentStrategies(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the available deployments
// The following list-deployments example lists the available deployments in your AWS
// account for the specified application and environment.
func ExampleAppConfig_ListDeployments_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.ListDeploymentsInput{
		ApplicationId: aws.String("339ohji"),
		EnvironmentId: aws.String("54j1r29"),
	}

	result, err := svc.ListDeployments(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the available environments
// The following list-environments example lists the available environments in your
// AWS account for the specified application.
func ExampleAppConfig_ListEnvironments_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.ListEnvironmentsInput{
		ApplicationId: aws.String("339ohji"),
	}

	result, err := svc.ListEnvironments(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the available hosted configuration versions
// The following list-hosted-configuration-versions example lists the configurations
// versions hosted in the AWS AppConfig hosted configuration store for the specified
// application and configuration profile.
func ExampleAppConfig_ListHostedConfigurationVersions_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.ListHostedConfigurationVersionsInput{
		ApplicationId:          aws.String("339ohji"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
	}

	result, err := svc.ListHostedConfigurationVersions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the tags of an application
// The following list-tags-for-resource example lists the tags of a specified application.
func ExampleAppConfig_ListTagsForResource_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.ListTagsForResourceInput{
		ResourceArn: aws.String("arn:aws:appconfig:us-east-1:111122223333:application/339ohji"),
	}

	result, err := svc.ListTagsForResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To start a configuration deployment
// The following start-deployment example starts a deployment to the application using
// the specified environment, deployment strategy, and configuration profile.
func ExampleAppConfig_StartDeployment_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.StartDeploymentInput{
		ApplicationId:          aws.String("339ohji"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
		ConfigurationVersion:   aws.String("1"),
		DeploymentStrategyId:   aws.String("1225qzk"),
		Description:            aws.String(""),
		EnvironmentId:          aws.String("54j1r29"),
		Tags:                   map[string]*string{},
	}

	result, err := svc.StartDeployment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeConflictException:
				fmt.Println(appconfig.ErrCodeConflictException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To stop configuration deployment
// The following stop-deployment example stops the deployment of an application configuration
// to the specified environment.
func ExampleAppConfig_StopDeployment_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.StopDeploymentInput{
		ApplicationId:    aws.String("339ohji"),
		DeploymentNumber: aws.Int64(2),
		EnvironmentId:    aws.String("54j1r29"),
	}

	result, err := svc.StopDeployment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To tag an application
// The following tag-resource example tags an application resource.
func ExampleAppConfig_TagResource_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.TagResourceInput{
		ResourceArn: aws.String("arn:aws:appconfig:us-east-1:111122223333:application/339ohji"),
		Tags: map[string]*string{
			"group1": aws.String("1"),
		},
	}

	result, err := svc.TagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a tag from an application
// The following untag-resource example removes the group1 tag from the specified application.
func ExampleAppConfig_UntagResource_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.UntagResourceInput{
		ResourceArn: aws.String("arn:aws:appconfig:us-east-1:111122223333:application/339ohji"),
		TagKeys: []*string{
			aws.String("group1"),
		},
	}

	result, err := svc.UntagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an application
// The following update-application example updates the name of the specified application.
func ExampleAppConfig_UpdateApplication_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.UpdateApplicationInput{
		ApplicationId: aws.String("339ohji"),
		Description:   aws.String(""),
		Name:          aws.String("Example-Application"),
	}

	result, err := svc.UpdateApplication(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a configuration profile
// The following update-configuration-profile example updates the description of the
// specified configuration profile.
func ExampleAppConfig_UpdateConfigurationProfile_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.UpdateConfigurationProfileInput{
		ApplicationId:          aws.String("339ohji"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
		Description:            aws.String("Configuration profile used for examples."),
	}

	result, err := svc.UpdateConfigurationProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a deployment strategy
// The following update-deployment-strategy example updates final bake time to 20 minutes
// in the specified deployment strategy. ::
func ExampleAppConfig_UpdateDeploymentStrategy_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.UpdateDeploymentStrategyInput{
		DeploymentStrategyId:   aws.String("1225qzk"),
		FinalBakeTimeInMinutes: aws.Int64(20),
	}

	result, err := svc.UpdateDeploymentStrategy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an environment
// The following update-environment example updates an environment's description.
func ExampleAppConfig_UpdateEnvironment_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.UpdateEnvironmentInput{
		ApplicationId: aws.String("339ohji"),
		Description:   aws.String("An environment for examples."),
		EnvironmentId: aws.String("54j1r29"),
	}

	result, err := svc.UpdateEnvironment(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To validate a configuration
// The following validate-configuration example uses the validators in a configuration
// profile to validate a configuration.
func ExampleAppConfig_ValidateConfiguration_shared00() {
	svc := appconfig.New(session.New())
	input := &appconfig.ValidateConfigurationInput{
		ApplicationId:          aws.String("abc1234"),
		ConfigurationProfileId: aws.String("ur8hx2f"),
		ConfigurationVersion:   aws.String("1"),
	}

	result, err := svc.ValidateConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case appconfig.ErrCodeBadRequestException:
				fmt.Println(appconfig.ErrCodeBadRequestException, aerr.Error())
			case appconfig.ErrCodeResourceNotFoundException:
				fmt.Println(appconfig.ErrCodeResourceNotFoundException, aerr.Error())
			case appconfig.ErrCodeInternalServerException:
				fmt.Println(appconfig.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
