package catalog

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ACLType enumerates the values for acl type.
type ACLType string

const (
	// Group ...
	Group ACLType = "Group"
	// GroupObj ...
	GroupObj ACLType = "GroupObj"
	// Other ...
	Other ACLType = "Other"
	// User ...
	User ACLType = "User"
	// UserObj ...
	UserObj ACLType = "UserObj"
)

// PossibleACLTypeValues returns an array of possible values for the ACLType const type.
func PossibleACLTypeValues() []ACLType {
	return []ACLType{Group, GroupObj, Other, User, UserObj}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// Assembly ...
	Assembly FileType = "Assembly"
	// Nodeploy ...
	Nodeploy FileType = "Nodeploy"
	// Resource ...
	Resource FileType = "Resource"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{Assembly, Nodeploy, Resource}
}

// PermissionType enumerates the values for permission type.
type PermissionType string

const (
	// All ...
	All PermissionType = "All"
	// Alter ...
	Alter PermissionType = "Alter"
	// Create ...
	Create PermissionType = "Create"
	// Drop ...
	Drop PermissionType = "Drop"
	// None ...
	None PermissionType = "None"
	// Use ...
	Use PermissionType = "Use"
	// Write ...
	Write PermissionType = "Write"
)

// PossiblePermissionTypeValues returns an array of possible values for the PermissionType const type.
func PossiblePermissionTypeValues() []PermissionType {
	return []PermissionType{All, Alter, Create, Drop, None, Use, Write}
}
