/*
 ----------------------------------------------------------------------------
 |    Copyright (C) 1999   Raytheon Systems Company                         |
 ----------------------------------------------------------------------------
 */

#include     <HE5_HdfEosDef.h>

/*
 * In this example we will open an HDF-EOS file and attach to UTM and Polar
 * Stereographic grid structures within the file to write a dimension scales
 * using GDdefdimscale, and  GDdefdimscale2 that sets dimcall for all fields 
 * in the grid. GDdefdimscale2 creates a dimscale with any size, name, or 
 * datatype for the dimscale, while GDdefdimscale uses default dimension 
 * names for the dimscale name and default values and size doe XDim and YDim
 */


int main()
{
  herr_t          status = FAIL;

  hid_t           gdfid = FAIL;
  hid_t           GDid1 = FAIL;
  hid_t           GDid2 = FAIL;
  hid_t           GDid3 = FAIL;
  int             data[10]={3,6,9,12,15,18,23,26,29,32};
  int             bands[10]={12,14,18};
  char            label[16];
  char            unit[16];
  char            format[16];
  long            xdim, ydim;
  int             ntime;
  hsize_t         count[3];
  int             lon= 20;
  int             i;
  float           lonarray[20];

  for(i=0; i<20; i++) lonarray[i] = (2.0 * (i*i)); 

  /*
   * We first open the HDF-EOS grid file, "Grid.h5".  Because this file
   * already exist and we wish to write to it, we use the H5F_ACC_RDWR access
   * code in the open statement.  The HE5_GDopen routine returns the grid file
   * id, gdfid, which is used to identify the file in subsequent routines.
   */ 

  gdfid = HE5_GDopen("Grid.h5", H5F_ACC_RDWR);
 
  /*
   * If the grid file cannot be found, HE5_GDopen will return -1 for the file
   * handle (gdfid).  We there check that this is not the case before
   * proceeding with the other routines.
   * 
   * The HE5_GDattach routine returns the handle to the existing grid "Grid1",
   * GDid.  If the grid is not found, HE5_GDattach returns -1 for the handle.
   */ 

  if (gdfid != FAIL)
    {	  
      GDid1 = HE5_GDattach(gdfid, "UTMGrid");

      /* the field Pollution has Time,YDim,XDim dimensions. 
	 xdim = 120;
	 ydim = 200;
	 Time dim is set to 10
      */

      if (GDid1 == -1)
	{
	  printf("\t\tError: Cannot attach to grid \"UTMGrid\"\n");
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      xdim = 120;
      ydim = 200;
      ntime = 10;
      
      //status = HE5_GDdefdimscale(GDid1, "XDim", xdim, H5T_NATIVE_DOUBLE, NULL);
      status = HE5_GDdefdimscale2(GDid1, "XDim", "lon", lon, H5T_NATIVE_FLOAT, lonarray);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale for XDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      status = HE5_GDdefdimscale(GDid1, "Time", ntime, H5T_NATIVE_INT, data);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale for Time dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      //status = HE5_GDdefdimscale(GDid1, "YDim", ydim, H5T_NATIVE_DOUBLE, NULL);
      status = HE5_GDdefdimscale2(GDid1, "YDim", "lat", ydim, H5T_NATIVE_DOUBLE, NULL);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale for XDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      strcpy(label, "X Dimension");
      strcpy(unit, "meters");
      strcpy(format, "F7.2");
      
      count[0]= 12;
      status = HE5_GDwritedscaleattr(GDid1, "XDim", "label", H5T_NATIVE_CHAR, count, label);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for XDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}

      count[0]= 6;
      status = HE5_GDwritedscaleattr(GDid1, "XDim", "unit", H5T_NATIVE_CHAR, count, unit);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for XDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      count[0]= 4;
      status = HE5_GDwritedscaleattr(GDid1, "XDim", "format", H5T_NATIVE_CHAR, count, format);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for XDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
         
      float datbuf_f[1] = {-999.0};
      count[0]= 1;
      status = HE5_GDwritedscaleattr(GDid1, "XDim", "MissingValue", H5T_NATIVE_FLOAT, count, datbuf_f);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for XDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      int datbuf_i[3] = {-999,0,999};
      count[0]= 3;
      status = HE5_GDwritedscaleattr(GDid1, "XDim", "IntValues", H5T_NATIVE_INT, count, datbuf_i);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for XDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}

      strcpy(label, "Time Dim");
      strcpy(unit, "s");
      strcpy(format, "F2.3");
      
      count[0]= 8;
      status = HE5_GDwritedscaleattr(GDid1, "Time", "label", H5T_NATIVE_CHAR, count, label);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Time dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      count[0]= 1;
      status = HE5_GDwritedscaleattr(GDid1, "Time", "unit", H5T_NATIVE_CHAR, count, unit);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Time dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      count[0]= 4;
      status = HE5_GDwritedscaleattr(GDid1, "Time", "format", H5T_NATIVE_CHAR, count, format);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Time dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      int datbuf_i2[2] = {-999, +999};
      count[0] = 2;
      status = HE5_GDwritedscaleattr(GDid1, "Time", "MissingValue", H5T_NATIVE_INT, count, datbuf_i2);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Time dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid1);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      HE5_GDdetach(GDid1);
      
      /* the field Spectra has Bands,YDim,XDim dimensions. 
	 xdim = 100;
	 ydim = 100;
	 Bands dim is set to 3
      */
      
      GDid2 = HE5_GDattach(gdfid, "PolarGrid");
      if (GDid2 == -1)
	{
	  printf("\t\tError: Cannot attach to grid \"PolarGrid\"\n");
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      ydim = 100;
      int nbands = 3;
      
      status = HE5_GDdefdimscale(GDid2, "YDim", ydim, H5T_NATIVE_DOUBLE, NULL);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale for YDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid2);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      
      status = HE5_GDdefdimscale(GDid2, "Bands", nbands, H5T_NATIVE_INT, bands);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale for Bands dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid2);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      
      strcpy(label, "Y Dim");
      strcpy(unit, "meters");
      strcpy(format, "F7.2");
      
      count[0]= 5;
      status = HE5_GDwritedscaleattr(GDid2, "YDim", "Label", H5T_NATIVE_CHAR, count, label);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for XDim dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid2);
	  HE5_GDclose(gdfid);
	  return -1;
	}
	  
      strcpy(label, "Bands");
      strcpy(unit, "None");
      strcpy(format, "F7.2");
      
      count[0] = 4;
      status = HE5_GDwritedscaleattr(GDid2, "Bands", "Units", H5T_NATIVE_CHAR, count, unit);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Time dimemnsion in grid fields\n");
	  HE5_GDdetach(GDid2);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      
      HE5_GDdetach(GDid2);
      
      /* the field GeoSpectra has YDim,XDim dimensions. 
	 xdim = 100;
	 ydim = 100;
	 Bands dim is set to 3
      */
      
	xdim = 60;
	ydim = 40;
	
	GDid3 = HE5_GDattach(gdfid, "GEOGrid");
	if (GDid3 == -1)
	  {
	    printf("\t\tError: Cannot attach to grid \"GEOGrid\"\n");
	    HE5_GDclose(gdfid);
	    return -1;
	  }
	status = HE5_GDdefdimscale(GDid3, "YDim", ydim, H5T_NATIVE_DOUBLE, NULL);
	if (status == -1)
	  {
	    printf("\t\tError: Cannot set Dimension Scale for YDim dimemnsion in grid fields\n");
	    HE5_GDdetach(GDid3);
	    HE5_GDclose(gdfid);
	    return -1;
	  }
	
	strcpy(label, "Y Dimension");
	strcpy(unit, "Decimal Degrees");
	strcpy(format, "F7.2");

	count[0] = 15;
	status = HE5_GDwritedscaleattr(GDid3, "YDim", "Units", H5T_NATIVE_CHAR, count, unit);
	if (status == -1)
	  {
	    printf("\t\tError: Cannot set Dimension Scale strs for YDim dimemnsion in grid fields\n");
	    HE5_GDdetach(GDid3);
	    HE5_GDclose(gdfid);
	    return -1;
	  }
	
	
	HE5_GDdetach(GDid3);
	
      HE5_GDclose(gdfid);
      
      return 0;
    }
}
