;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2020-2021 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

;RUN: %opt %use_old_pass_manager% -GenXReduceIntSize -march=genx64 -mcpu=XeHPC -S < %s | FileCheck %s

declare <8 x i16> @llvm.genx.vload.v8i16.p0v8i16(<8 x i16>*)
@b = internal global <8 x i16> undef, align 16

define dllexport spir_kernel void @test_kernel1()  {
  ;COM:    ===--vector operands test--===
  ;CHECK:  ashr <8 x i64> <i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360>
  ;CHECK:  ashr <8 x i64> <i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006>
  ;CHECK:  ashr <8 x i64> <i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542>, %2
  ;CHECK:  ashr <8 x i64> <i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762>, %2
  ;CHECK:  lshr <8 x i64> <i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360>
  ;CHECK:  lshr <8 x i64> <i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006>
  ;CHECK:  lshr <8 x i64> <i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542>, %2
  ;CHECK:  lshr <8 x i64> <i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762>, %2


  %1 = call <8 x i16> @llvm.genx.vload.v8i16.p0v8i16(<8 x i16>* nonnull @b)
  %2 = zext <8 x i16> %1 to <8 x i64>

  ashr <8 x i64> <i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360>, %2
  ashr <8 x i64> <i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006>, %2
  ashr <8 x i64> <i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542>, %2
  ashr <8 x i64> <i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762>, %2

  lshr <8 x i64> <i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360, i64 -360>, %2
  lshr <8 x i64> <i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006, i64 15006>, %2
  lshr <8 x i64> <i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542, i64 80542>, %2
  lshr <8 x i64> <i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762, i64 -1576977762>, %2

  ret void
}
