/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;

import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.spi.Name;

/**
 * <code>OrConstraint</code> implements an OR constraint.
 */
public class OrConstraint implements Constraint {

    /**
     * The left operand.
     */
    private final Constraint left;

    /**
     * The right operand.
     */
    private final Constraint right;

    /**
     * Creates a new OR constraint.
     *
     * @param left the left operand.
     * @param right the right operand.
     */
    public OrConstraint(Constraint left, Constraint right) {
        this.left = left;
        this.right = right;
    }

    /**
     * {@inheritDoc}
     */
    public boolean evaluate(ScoreNode[] row,
                            Name[] selectorNames,
                            EvaluationContext context)
            throws IOException {
        return left.evaluate(row, selectorNames, context)
                || right.evaluate(row, selectorNames, context);
    }
}
