(* Labelled_X64.thy - generated by L3 - 04/11/15 *)
theory Labelled_X64
imports "$ISABELLE_HOME/src/HOL/Word/Word" "L3_Lib"
begin

ML_file "$ISABELLE_HOME/src/HOL/Word/Tools/word_lib.ML"
ML_file "L3.ML"

datatype Zreg = RAX | RCX | RDX | RBX | RSP | RBP | RSI | RDI | zR8 | zR9 | zR10 | zR11 | zR12 |
  zR13 | zR14 | zR15

datatype Zeflags = Z_CF | Z_PF | Z_AF | Z_ZF | Z_SF | Z_OF

datatype Zsize = Z16 | Z32 | Z64 | Z8 bool

datatype Zbase = ZnoBase | ZregBase Zreg | ZripBase

datatype Zrm =
    Zl string
  | Zm "((2 word \<times> Zreg) option) \<times> Zbase \<times> 64 word"
  | Zr Zreg

datatype Zdest_src =
    Zr_rm "Zreg \<times> Zrm"
  | Zrm_i "Zrm \<times> 64 word"
  | Zrm_l "Zrm \<times> string"
  | Zrm_r "Zrm \<times> Zreg"

datatype Zimm_rm = Zimm "64 word" | Zrm Zrm

datatype Zmonop_name = Zdec | Zinc | Znot | Zneg

datatype Zbinop_name = Zadd | Zor | Zadc | Zsbb | Zand | Zsub | Zxor | Zcmp | Zrol | Zror | Zrcl |
  Zrcr | Zshl | Zshr | Ztest | Zsar

datatype Zcond = Z_O | Z_NO | Z_B | Z_NB | Z_E | Z_NE | Z_NA | Z_A | Z_S | Z_NS | Z_P | Z_NP | Z_L |
  Z_NL | Z_NG | Z_G | Z_ALWAYS

datatype Zea =
    Zea_i "Zsize \<times> 64 word"
  | Zea_m "Zsize \<times> 64 word"
  | Zea_r "Zsize \<times> Zreg"

datatype instruction =
    Zbinop "Zbinop_name \<times> Zsize \<times> Zdest_src"
  | Zcall Zimm_rm
  | Zcmpxchg "Zsize \<times> Zrm \<times> Zreg"
  | Zdiv "Zsize \<times> Zrm"
  | Zjcc "Zcond \<times> 64 word"
  | Zjmp Zrm
  | Zlea "Zsize \<times> Zdest_src"
  | Zleave
  | Zloop "Zcond \<times> 64 word"
  | Zmonop "Zmonop_name \<times> Zsize \<times> Zrm"
  | Zmov "Zcond \<times> Zsize \<times> Zdest_src"
  | Zmovsx "Zsize \<times> Zdest_src \<times> Zsize"
  | Zmovzx "Zsize \<times> Zdest_src \<times> Zsize"
  | Zmul "Zsize \<times> Zrm"
  | Znop
  | Zpop Zrm
  | Zpush Zimm_rm
  | Zret "64 word"
  | Zxadd "Zsize \<times> Zrm \<times> Zreg"
  | Zxchg "Zsize \<times> Zrm \<times> Zreg"

datatype Zinst =
    Zdec_fail string
  | Zfull_inst "(8 word list) \<times> instruction \<times> 8 word list"

record REX = B :: bool R :: bool W :: bool X :: bool

datatype exception = BadFlagAccess string | BadMemAccess "64 word" | FAILURE string | NoException

record Labelled_X64_state =
  EFLAGS :: "Zeflags \<Rightarrow> (bool option)"
  MEM :: "64 word \<Rightarrow> 8 word"
  REG :: "Zreg \<Rightarrow> 64 word"
  RIP :: "64 word"
  exception :: exception

fun nat_to_Zreg :: "nat \<Rightarrow> Zreg" where
  "nat_to_Zreg x =
   (if x = 0 then Labelled_X64.RAX
    else if x = 1 then Labelled_X64.RCX
    else if x = 2 then Labelled_X64.RDX
    else if x = 3 then Labelled_X64.RBX
    else if x = 4 then Labelled_X64.RSP
    else if x = 5 then Labelled_X64.RBP
    else if x = 6 then Labelled_X64.RSI
    else if x = 7 then Labelled_X64.RDI
    else if x = 8 then Labelled_X64.zR8
    else if x = 9 then Labelled_X64.zR9
    else if x = 10 then Labelled_X64.zR10
    else if x = 11 then Labelled_X64.zR11
    else if x = 12 then Labelled_X64.zR12
    else if x = 13 then Labelled_X64.zR13
    else if x = 14 then Labelled_X64.zR14
    else if x = 15 then Labelled_X64.zR15
    else HOL.undefined)"

fun nat_to_Zeflags :: "nat \<Rightarrow> Zeflags" where
  "nat_to_Zeflags x =
   (if x = 0 then Labelled_X64.Z_CF
    else if x = 1 then Labelled_X64.Z_PF
    else if x = 2 then Labelled_X64.Z_AF
    else if x = 3 then Labelled_X64.Z_ZF
    else if x = 4 then Labelled_X64.Z_SF
    else if x = 5 then Labelled_X64.Z_OF
    else HOL.undefined)"

fun nat_to_Zmonop_name :: "nat \<Rightarrow> Zmonop_name" where
  "nat_to_Zmonop_name x =
   (if x = 0 then Labelled_X64.Zdec
    else if x = 1 then Labelled_X64.Zinc
    else if x = 2 then Labelled_X64.Znot
    else if x = 3 then Labelled_X64.Zneg
    else HOL.undefined)"

fun nat_to_Zbinop_name :: "nat \<Rightarrow> Zbinop_name" where
  "nat_to_Zbinop_name x =
   (if x = 0 then Labelled_X64.Zadd
    else if x = 1 then Labelled_X64.Zor
    else if x = 2 then Labelled_X64.Zadc
    else if x = 3 then Labelled_X64.Zsbb
    else if x = 4 then Labelled_X64.Zand
    else if x = 5 then Labelled_X64.Zsub
    else if x = 6 then Labelled_X64.Zxor
    else if x = 7 then Labelled_X64.Zcmp
    else if x = 8 then Labelled_X64.Zrol
    else if x = 9 then Labelled_X64.Zror
    else if x = 10 then Labelled_X64.Zrcl
    else if x = 11 then Labelled_X64.Zrcr
    else if x = 12 then Labelled_X64.Zshl
    else if x = 13 then Labelled_X64.Zshr
    else if x = 14 then Labelled_X64.Ztest
    else if x = 15 then Labelled_X64.Zsar
    else HOL.undefined)"

fun nat_to_Zcond :: "nat \<Rightarrow> Zcond" where
  "nat_to_Zcond x =
   (if x = 0 then Labelled_X64.Z_O
    else if x = 1 then Labelled_X64.Z_NO
    else if x = 2 then Labelled_X64.Z_B
    else if x = 3 then Labelled_X64.Z_NB
    else if x = 4 then Labelled_X64.Z_E
    else if x = 5 then Labelled_X64.Z_NE
    else if x = 6 then Labelled_X64.Z_NA
    else if x = 7 then Labelled_X64.Z_A
    else if x = 8 then Labelled_X64.Z_S
    else if x = 9 then Labelled_X64.Z_NS
    else if x = 10 then Labelled_X64.Z_P
    else if x = 11 then Labelled_X64.Z_NP
    else if x = 12 then Labelled_X64.Z_L
    else if x = 13 then Labelled_X64.Z_NL
    else if x = 14 then Labelled_X64.Z_NG
    else if x = 15 then Labelled_X64.Z_G
    else if x = 16 then Labelled_X64.Z_ALWAYS
    else HOL.undefined)"

fun Zreg_to_nat :: "Zreg \<Rightarrow> nat" where
  "Zreg_to_nat x =
   (case x of
       Labelled_X64.RAX => 0
     | Labelled_X64.RCX => 1
     | Labelled_X64.RDX => 2
     | Labelled_X64.RBX => 3
     | Labelled_X64.RSP => 4
     | Labelled_X64.RBP => 5
     | Labelled_X64.RSI => 6
     | Labelled_X64.RDI => 7
     | Labelled_X64.zR8 => 8
     | Labelled_X64.zR9 => 9
     | Labelled_X64.zR10 => 10
     | Labelled_X64.zR11 => 11
     | Labelled_X64.zR12 => 12
     | Labelled_X64.zR13 => 13
     | Labelled_X64.zR14 => 14
     | Labelled_X64.zR15 => 15)"

fun Zeflags_to_nat :: "Zeflags \<Rightarrow> nat" where
  "Zeflags_to_nat x =
   (case x of
       Labelled_X64.Z_CF => 0
     | Labelled_X64.Z_PF => 1
     | Labelled_X64.Z_AF => 2
     | Labelled_X64.Z_ZF => 3
     | Labelled_X64.Z_SF => 4
     | Labelled_X64.Z_OF => 5)"

fun Zmonop_name_to_nat :: "Zmonop_name \<Rightarrow> nat" where
  "Zmonop_name_to_nat x =
   (case x of
       Labelled_X64.Zdec => 0
     | Labelled_X64.Zinc => 1
     | Labelled_X64.Znot => 2
     | Labelled_X64.Zneg => 3)"

fun Zbinop_name_to_nat :: "Zbinop_name \<Rightarrow> nat" where
  "Zbinop_name_to_nat x =
   (case x of
       Labelled_X64.Zadd => 0
     | Labelled_X64.Zor => 1
     | Labelled_X64.Zadc => 2
     | Labelled_X64.Zsbb => 3
     | Labelled_X64.Zand => 4
     | Labelled_X64.Zsub => 5
     | Labelled_X64.Zxor => 6
     | Labelled_X64.Zcmp => 7
     | Labelled_X64.Zrol => 8
     | Labelled_X64.Zror => 9
     | Labelled_X64.Zrcl => 10
     | Labelled_X64.Zrcr => 11
     | Labelled_X64.Zshl => 12
     | Labelled_X64.Zshr => 13
     | Labelled_X64.Ztest => 14
     | Labelled_X64.Zsar => 15)"

fun Zcond_to_nat :: "Zcond \<Rightarrow> nat" where
  "Zcond_to_nat x =
   (case x of
       Labelled_X64.Z_O => 0
     | Labelled_X64.Z_NO => 1
     | Labelled_X64.Z_B => 2
     | Labelled_X64.Z_NB => 3
     | Labelled_X64.Z_E => 4
     | Labelled_X64.Z_NE => 5
     | Labelled_X64.Z_NA => 6
     | Labelled_X64.Z_A => 7
     | Labelled_X64.Z_S => 8
     | Labelled_X64.Z_NS => 9
     | Labelled_X64.Z_P => 10
     | Labelled_X64.Z_NP => 11
     | Labelled_X64.Z_L => 12
     | Labelled_X64.Z_NL => 13
     | Labelled_X64.Z_NG => 14
     | Labelled_X64.Z_G => 15
     | Labelled_X64.Z_ALWAYS => 16)"

fun Zreg_to_string :: "Zreg \<Rightarrow> string" where
  "Zreg_to_string x =
   (case x of
       Labelled_X64.RAX => ''RAX''
     | Labelled_X64.RCX => ''RCX''
     | Labelled_X64.RDX => ''RDX''
     | Labelled_X64.RBX => ''RBX''
     | Labelled_X64.RSP => ''RSP''
     | Labelled_X64.RBP => ''RBP''
     | Labelled_X64.RSI => ''RSI''
     | Labelled_X64.RDI => ''RDI''
     | Labelled_X64.zR8 => ''zR8''
     | Labelled_X64.zR9 => ''zR9''
     | Labelled_X64.zR10 => ''zR10''
     | Labelled_X64.zR11 => ''zR11''
     | Labelled_X64.zR12 => ''zR12''
     | Labelled_X64.zR13 => ''zR13''
     | Labelled_X64.zR14 => ''zR14''
     | Labelled_X64.zR15 => ''zR15'')"

fun Zeflags_to_string :: "Zeflags \<Rightarrow> string" where
  "Zeflags_to_string x =
   (case x of
       Labelled_X64.Z_CF => ''Z_CF''
     | Labelled_X64.Z_PF => ''Z_PF''
     | Labelled_X64.Z_AF => ''Z_AF''
     | Labelled_X64.Z_ZF => ''Z_ZF''
     | Labelled_X64.Z_SF => ''Z_SF''
     | Labelled_X64.Z_OF => ''Z_OF'')"

fun Zmonop_name_to_string :: "Zmonop_name \<Rightarrow> string" where
  "Zmonop_name_to_string x =
   (case x of
       Labelled_X64.Zdec => ''Zdec''
     | Labelled_X64.Zinc => ''Zinc''
     | Labelled_X64.Znot => ''Znot''
     | Labelled_X64.Zneg => ''Zneg'')"

fun Zbinop_name_to_string :: "Zbinop_name \<Rightarrow> string" where
  "Zbinop_name_to_string x =
   (case x of
       Labelled_X64.Zadd => ''Zadd''
     | Labelled_X64.Zor => ''Zor''
     | Labelled_X64.Zadc => ''Zadc''
     | Labelled_X64.Zsbb => ''Zsbb''
     | Labelled_X64.Zand => ''Zand''
     | Labelled_X64.Zsub => ''Zsub''
     | Labelled_X64.Zxor => ''Zxor''
     | Labelled_X64.Zcmp => ''Zcmp''
     | Labelled_X64.Zrol => ''Zrol''
     | Labelled_X64.Zror => ''Zror''
     | Labelled_X64.Zrcl => ''Zrcl''
     | Labelled_X64.Zrcr => ''Zrcr''
     | Labelled_X64.Zshl => ''Zshl''
     | Labelled_X64.Zshr => ''Zshr''
     | Labelled_X64.Ztest => ''Ztest''
     | Labelled_X64.Zsar => ''Zsar'')"

fun Zcond_to_string :: "Zcond \<Rightarrow> string" where
  "Zcond_to_string x =
   (case x of
       Labelled_X64.Z_O => ''Z_O''
     | Labelled_X64.Z_NO => ''Z_NO''
     | Labelled_X64.Z_B => ''Z_B''
     | Labelled_X64.Z_NB => ''Z_NB''
     | Labelled_X64.Z_E => ''Z_E''
     | Labelled_X64.Z_NE => ''Z_NE''
     | Labelled_X64.Z_NA => ''Z_NA''
     | Labelled_X64.Z_A => ''Z_A''
     | Labelled_X64.Z_S => ''Z_S''
     | Labelled_X64.Z_NS => ''Z_NS''
     | Labelled_X64.Z_P => ''Z_P''
     | Labelled_X64.Z_NP => ''Z_NP''
     | Labelled_X64.Z_L => ''Z_L''
     | Labelled_X64.Z_NL => ''Z_NL''
     | Labelled_X64.Z_NG => ''Z_NG''
     | Labelled_X64.Z_G => ''Z_G''
     | Labelled_X64.Z_ALWAYS => ''Z_ALWAYS'')"

fun string_to_Zreg :: "string \<Rightarrow> Zreg" where
  "string_to_Zreg x =
   (if x = ''RAX'' then Labelled_X64.RAX
    else if x = ''RCX'' then Labelled_X64.RCX
    else if x = ''RDX'' then Labelled_X64.RDX
    else if x = ''RBX'' then Labelled_X64.RBX
    else if x = ''RSP'' then Labelled_X64.RSP
    else if x = ''RBP'' then Labelled_X64.RBP
    else if x = ''RSI'' then Labelled_X64.RSI
    else if x = ''RDI'' then Labelled_X64.RDI
    else if x = ''zR8'' then Labelled_X64.zR8
    else if x = ''zR9'' then Labelled_X64.zR9
    else if x = ''zR10'' then Labelled_X64.zR10
    else if x = ''zR11'' then Labelled_X64.zR11
    else if x = ''zR12'' then Labelled_X64.zR12
    else if x = ''zR13'' then Labelled_X64.zR13
    else if x = ''zR14'' then Labelled_X64.zR14
    else if x = ''zR15'' then Labelled_X64.zR15
    else HOL.undefined)"

fun string_to_Zeflags :: "string \<Rightarrow> Zeflags" where
  "string_to_Zeflags x =
   (if x = ''Z_CF'' then Labelled_X64.Z_CF
    else if x = ''Z_PF'' then Labelled_X64.Z_PF
    else if x = ''Z_AF'' then Labelled_X64.Z_AF
    else if x = ''Z_ZF'' then Labelled_X64.Z_ZF
    else if x = ''Z_SF'' then Labelled_X64.Z_SF
    else if x = ''Z_OF'' then Labelled_X64.Z_OF
    else HOL.undefined)"

fun string_to_Zmonop_name :: "string \<Rightarrow> Zmonop_name" where
  "string_to_Zmonop_name x =
   (if x = ''Zdec'' then Labelled_X64.Zdec
    else if x = ''Zinc'' then Labelled_X64.Zinc
    else if x = ''Znot'' then Labelled_X64.Znot
    else if x = ''Zneg'' then Labelled_X64.Zneg
    else HOL.undefined)"

fun string_to_Zbinop_name :: "string \<Rightarrow> Zbinop_name" where
  "string_to_Zbinop_name x =
   (if x = ''Zadd'' then Labelled_X64.Zadd
    else if x = ''Zor'' then Labelled_X64.Zor
    else if x = ''Zadc'' then Labelled_X64.Zadc
    else if x = ''Zsbb'' then Labelled_X64.Zsbb
    else if x = ''Zand'' then Labelled_X64.Zand
    else if x = ''Zsub'' then Labelled_X64.Zsub
    else if x = ''Zxor'' then Labelled_X64.Zxor
    else if x = ''Zcmp'' then Labelled_X64.Zcmp
    else if x = ''Zrol'' then Labelled_X64.Zrol
    else if x = ''Zror'' then Labelled_X64.Zror
    else if x = ''Zrcl'' then Labelled_X64.Zrcl
    else if x = ''Zrcr'' then Labelled_X64.Zrcr
    else if x = ''Zshl'' then Labelled_X64.Zshl
    else if x = ''Zshr'' then Labelled_X64.Zshr
    else if x = ''Ztest'' then Labelled_X64.Ztest
    else if x = ''Zsar'' then Labelled_X64.Zsar
    else HOL.undefined)"

fun string_to_Zcond :: "string \<Rightarrow> Zcond" where
  "string_to_Zcond x =
   (if x = ''Z_O'' then Labelled_X64.Z_O
    else if x = ''Z_NO'' then Labelled_X64.Z_NO
    else if x = ''Z_B'' then Labelled_X64.Z_B
    else if x = ''Z_NB'' then Labelled_X64.Z_NB
    else if x = ''Z_E'' then Labelled_X64.Z_E
    else if x = ''Z_NE'' then Labelled_X64.Z_NE
    else if x = ''Z_NA'' then Labelled_X64.Z_NA
    else if x = ''Z_A'' then Labelled_X64.Z_A
    else if x = ''Z_S'' then Labelled_X64.Z_S
    else if x = ''Z_NS'' then Labelled_X64.Z_NS
    else if x = ''Z_P'' then Labelled_X64.Z_P
    else if x = ''Z_NP'' then Labelled_X64.Z_NP
    else if x = ''Z_L'' then Labelled_X64.Z_L
    else if x = ''Z_NL'' then Labelled_X64.Z_NL
    else if x = ''Z_NG'' then Labelled_X64.Z_NG
    else if x = ''Z_G'' then Labelled_X64.Z_G
    else if x = ''Z_ALWAYS'' then Labelled_X64.Z_ALWAYS
    else HOL.undefined)"

fun boolify'8 :: "8 word \<Rightarrow>
  (bool \<times>
   bool \<times> bool \<times> bool \<times> bool \<times> bool \<times> bool \<times> bool)" where
  "boolify'8 w =
   (case to_bl w of
     [b0,b1,b2,b3,b4,b5,b6,b7] \<Rightarrow>
     (b0,b1,b2,b3,b4,b5,b6,b7))"

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("raise'exception",
   close
     (var("e",@{typ exception}),
      mb(mr(close
              (var("s",qTy),
               call("Labelled_X64_state.exception",@{typ exception},var("s",qTy),@{theory}))),
         close
           (var("v",@{typ exception}),
            mb(mb(mu(eq(var("v",@{typ exception}),
                        Term.Const(@{const_name "NoException"},@{typ exception})),qTy),
                  close
                    (var_b"b",
                     ite(var_b"b",
                         mw(close
                              (var("s",qTy),
                               rupd
                                 ("Labelled_X64_state.exception",
                                  tp[var("s",qTy),var("e",@{typ exception})],@{theory}))),mu(lu,qTy)))),
               close(var_a HOLogic.unitT,mu(lx(@{typ 'a}),qTy)))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("mem8",
   close
     (var_w("addr",64),
      mb(mr(close
              (var("s",qTy),
               call
                 ("Labelled_X64_state.MEM",@{typ "64 word \<Rightarrow> 8 word"},var("s",qTy),
                  @{theory}))),
         close
           (var("v",@{typ "64 word \<Rightarrow> 8 word"}),
            mu(apply(var("v",@{typ "64 word \<Rightarrow> 8 word"}),var_w("addr",64)),qTy)))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("write'mem8",
   close
     (tp[var_w("b",8),var_w("addr",64)],
      mb(mr(close
              (var("s",qTy),
               call
                 ("Labelled_X64_state.MEM",@{typ "64 word \<Rightarrow> 8 word"},var("s",qTy),
                  @{theory}))),
         close
           (var("v",@{typ "64 word \<Rightarrow> 8 word"}),
            mb(mu(fupd(var("v",@{typ "64 word \<Rightarrow> 8 word"}),var_w("addr",64),var_w("b",8)),
                  qTy),
               close
                 (var("v",@{typ "64 word \<Rightarrow> 8 word"}),
                  mw(close
                       (var("s",qTy),
                        rupd
                          ("Labelled_X64_state.MEM",
                           tp[var("s",qTy),var("v",@{typ "64 word \<Rightarrow> 8 word"})],@{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("mem16",
   close
     (var_w("addr",64),
      mb(call
           ("mem8",@{typ "Labelled_X64_state \<Rightarrow> (8 word \<times> Labelled_X64_state)"},
            bop(Add,var_w("addr",64),lw(1,64)),@{theory}),
         close
           (var_w("v",8),
            mb(call
                 ("mem8",
                  @{typ "Labelled_X64_state \<Rightarrow> (8 word \<times> Labelled_X64_state)"},
                  var_w("addr",64),@{theory}),
               close(var_w("v0",8),mu(cc[var_w("v",8),var_w("v0",8)],qTy)))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'mem16",
   close
     (tp[var_w("w",16),var_w("addr",64)],
      mb(call
           ("write'mem8",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            tp[ex(var_w("w",16),ln 7,ln 0,w8),var_w("addr",64)],@{theory}),
         close
           (var_a HOLogic.unitT,
            call
              ("write'mem8",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               tp[ex(var_w("w",16),ln 15,ln 8,w8),bop(Add,var_w("addr",64),lw(1,64))],@{theory})))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("mem32",
   close
     (var_w("addr",64),
      mb(call
           ("mem16",@{typ "Labelled_X64_state \<Rightarrow> (16 word \<times> Labelled_X64_state)"},
            bop(Add,var_w("addr",64),lw(2,64)),@{theory}),
         close
           (var_w("v",16),
            mb(call
                 ("mem16",
                  @{typ "Labelled_X64_state \<Rightarrow> (16 word \<times> Labelled_X64_state)"},
                  var_w("addr",64),@{theory}),
               close(var_w("v0",16),mu(cc[var_w("v",16),var_w("v0",16)],qTy)))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'mem32",
   close
     (tp[var_w("w",32),var_w("addr",64)],
      mb(call
           ("write'mem16",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            tp[ex(var_w("w",32),ln 15,ln 0,w16),var_w("addr",64)],@{theory}),
         close
           (var_a HOLogic.unitT,
            call
              ("write'mem16",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               tp[ex(var_w("w",32),ln 31,ln 16,w16),bop(Add,var_w("addr",64),lw(2,64))],@{theory})))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("mem64",
   close
     (var_w("addr",64),
      mb(call
           ("mem32",@{typ "Labelled_X64_state \<Rightarrow> (32 word \<times> Labelled_X64_state)"},
            bop(Add,var_w("addr",64),lw(4,64)),@{theory}),
         close
           (var_w("v",32),
            mb(call
                 ("mem32",
                  @{typ "Labelled_X64_state \<Rightarrow> (32 word \<times> Labelled_X64_state)"},
                  var_w("addr",64),@{theory}),
               close(var_w("v0",32),mu(cc[var_w("v",32),var_w("v0",32)],qTy)))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'mem64",
   close
     (tp[var_w("w",64),var_w("addr",64)],
      mb(call
           ("write'mem32",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            tp[ex(var_w("w",64),ln 31,ln 0,w32),var_w("addr",64)],@{theory}),
         close
           (var_a HOLogic.unitT,
            call
              ("write'mem32",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               tp[ex(var_w("w",64),ln 63,ln 32,w32),bop(Add,var_w("addr",64),lw(4,64))],@{theory})))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("Eflag",
   close
     (var("flag",@{typ Zeflags}),
      mb(mr(close
              (var("s",qTy),
               call
                 ("Labelled_X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                  var("s",qTy),@{theory}))),
         close
           (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
            mb(mu(apply
                    (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                     var("flag",@{typ Zeflags})),qTy),
               close
                 (var("x",@{typ "bool option"}),
                  cs(var("x",@{typ "bool option"}),
                     [(mop(Some,var_b"b"),mu(var_b"b",qTy)),
                      (lo HOLogic.boolT,
                       call
                         ("raise'exception",
                          @{typ
                          "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                          call
                            ("exception.BadFlagAccess",@{typ exception},
                             mop(Cast(@{typ string}),var("flag",@{typ Zeflags})),@{theory}),
                          @{theory}))],@{context})))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("write'Eflag",
   close
     (tp[var_b"b",var("flag",@{typ Zeflags})],
      mb(mr(close
              (var("s",qTy),
               call
                 ("Labelled_X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                  var("s",qTy),@{theory}))),
         close
           (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
            mb(mu(fupd
                    (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                     var("flag",@{typ Zeflags}),mop(Some,var_b"b")),qTy),
               close
                 (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                  mw(close
                       (var("s",qTy),
                        rupd
                          ("Labelled_X64_state.EFLAGS",
                           tp[var("s",qTy),var("v",@{typ "Zeflags \<Rightarrow> (bool option)"})],
                           @{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("FlagUnspecified",
   close
     (var("flag",@{typ Zeflags}),
      mb(mr(close
              (var("s",qTy),
               call
                 ("Labelled_X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                  var("s",qTy),@{theory}))),
         close
           (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
            mb(mu(fupd
                    (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                     var("flag",@{typ Zeflags}),lo HOLogic.boolT),qTy),
               close
                 (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                  mw(close
                       (var("s",qTy),
                        rupd
                          ("Labelled_X64_state.EFLAGS",
                           tp[var("s",qTy),var("v",@{typ "Zeflags \<Rightarrow> (bool option)"})],
                           @{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("CF",
   call
     ("Eflag",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
      lc("Z_CF","Zeflags",@{theory}),@{theory}))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'CF",
   close
     (var_b"b",
      call
        ("write'Eflag",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         tp[var_b"b",lc("Z_CF","Zeflags",@{theory})],@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("PF",
   call
     ("Eflag",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
      lc("Z_PF","Zeflags",@{theory}),@{theory}))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'PF",
   close
     (var_b"b",
      call
        ("write'Eflag",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         tp[var_b"b",lc("Z_PF","Zeflags",@{theory})],@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("AF",
   call
     ("Eflag",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
      lc("Z_AF","Zeflags",@{theory}),@{theory}))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'AF",
   close
     (var_b"b",
      call
        ("write'Eflag",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         tp[var_b"b",lc("Z_AF","Zeflags",@{theory})],@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("ZF",
   call
     ("Eflag",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
      lc("Z_ZF","Zeflags",@{theory}),@{theory}))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'ZF",
   close
     (var_b"b",
      call
        ("write'Eflag",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         tp[var_b"b",lc("Z_ZF","Zeflags",@{theory})],@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("SF",
   call
     ("Eflag",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
      lc("Z_SF","Zeflags",@{theory}),@{theory}))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'SF",
   close
     (var_b"b",
      call
        ("write'Eflag",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         tp[var_b"b",lc("Z_SF","Zeflags",@{theory})],@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("OF",
   call
     ("Eflag",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
      lc("Z_OF","Zeflags",@{theory}),@{theory}))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'OF",
   close
     (var_b"b",
      call
        ("write'Eflag",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         tp[var_b"b",lc("Z_OF","Zeflags",@{theory})],@{theory})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("ea_index",
   close
     (var("index",@{typ "(2 word \<times> Zreg) option"}),
      cs(var("index",@{typ "(2 word \<times> Zreg) option"}),
         [(lo(@{typ "2 word \<times> Zreg"}),mu(lw(0,64),qTy)),
          (mop(Some,tp[var_w("scale",2),var("idx",@{typ Zreg})]),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                       @{theory}))),
              close
                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                 mb(mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("idx",@{typ Zreg})),
                       qTy),
                    close
                      (var_w("v",64),
                       mu(bop(Mul,bop(Lsl,lw(1,64),mop(Cast HOLogic.natT,var_w("scale",2))),
                              var_w("v",64)),qTy))))))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("ea_base",
   close
     (var("base",@{typ Zbase}),
      cs(var("base",@{typ Zbase}),
         [(Term.Const(@{const_name "ZnoBase"},@{typ Zbase}),mu(lw(0,64),qTy)),
          (Term.Const(@{const_name "ZripBase"},@{typ Zbase}),
           mr(close(var("s",qTy),call("Labelled_X64_state.RIP",w64,var("s",qTy),@{theory})))),
          (call("Zbase.ZregBase",@{typ Zbase},var("b",@{typ Zreg}),@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                       @{theory}))),
              close
                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                 mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("b",@{typ Zreg})),qTy))))],
         @{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("ea_Zrm",
   close
     (tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
      cs(var("rm",@{typ Zrm}),
         [(call("Zrm.Zl",@{typ Zrm},var_a(@{typ string}),@{theory}),
           call
             ("raise'exception",
              @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
              call("exception.FAILURE",@{typ exception},ls"label",@{theory}),@{theory})),
          (call("Zrm.Zr",@{typ Zrm},var("r",@{typ Zreg}),@{theory}),
           mu(call
                ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
              qTy)),
          (call
             ("Zrm.Zm",@{typ Zrm},
              tp[var("index",@{typ "(2 word \<times> Zreg) option"}),var("base",@{typ Zbase}),
                 var_w("displacement",64)],@{theory}),
           mb(call
                ("ea_index",
                 @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                 var("index",@{typ "(2 word \<times> Zreg) option"}),@{theory}),
              close
                (var_w("v",64),
                 mb(mb(mb(mb(call
                               ("ea_base",
                                @{typ
                                "Labelled_X64_state \<Rightarrow>
                                 (64 word \<times> Labelled_X64_state)"},var("base",@{typ Zbase}),
                                @{theory}),
                             close(var_w("v0",64),mu(bop(Add,var_w("v",64),var_w("v0",64)),qTy))),
                          close
                            (var_w("v",64),mu(bop(Add,var_w("v",64),var_w("displacement",64)),qTy))),
                       close(var_w("v",64),mu(tp[var("size",@{typ Zsize}),var_w("v",64)],qTy))),
                    close
                      (var("v",@{typ "Zsize \<times> 64 word"}),
                       mu(call
                            ("Zea.Zea_m",@{typ Zea},var("v",@{typ "Zsize \<times> 64 word"}),
                             @{theory}),qTy))))))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("ea_Zdest",
   close
     (tp[var("size",@{typ Zsize}),var("ds",@{typ Zdest_src})],
      cs(var("ds",@{typ Zdest_src}),
         [(call
             ("Zdest_src.Zrm_l",@{typ Zdest_src},tp[var("rm",@{typ Zrm}),var_a(@{typ string})],
              @{theory}),
           call
             ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
              tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory})),
          (call("Zdest_src.Zrm_i",@{typ Zdest_src},tp[var("rm",@{typ Zrm}),var_a w64],@{theory}),
           call
             ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
              tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory})),
          (call
             ("Zdest_src.Zrm_r",@{typ Zdest_src},tp[var("rm",@{typ Zrm}),var_a @{typ Zreg}],
              @{theory}),
           call
             ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
              tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory})),
          (call
             ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var("r",@{typ Zreg}),var_a @{typ Zrm}],@{theory}),
           mu(call
                ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
              qTy))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("ea_Zsrc",
   close
     (tp[var("size",@{typ Zsize}),var("ds",@{typ Zdest_src})],
      cs(var("ds",@{typ Zdest_src}),
         [(call("Zdest_src.Zrm_l",@{typ Zdest_src},var_a(@{typ "Zrm \<times> string"}),@{theory}),
           call
             ("raise'exception",
              @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
              call("exception.FAILURE",@{typ exception},ls"label",@{theory}),@{theory})),
          (call("Zdest_src.Zrm_i",@{typ Zdest_src},tp[var_a @{typ Zrm},var_w("i",64)],@{theory}),
           mu(call("Zea.Zea_i",@{typ Zea},tp[var("size",@{typ Zsize}),var_w("i",64)],@{theory}),qTy)),
          (call
             ("Zdest_src.Zrm_r",@{typ Zdest_src},tp[var_a @{typ Zrm},var("r",@{typ Zreg})],@{theory}),
           mu(call
                ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
              qTy)),
          (call
             ("Zdest_src.Zr_rm",@{typ Zdest_src},tp[var_a @{typ Zreg},var("rm",@{typ Zrm})],
              @{theory}),
           call
             ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
              tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("ea_Zimm_rm",
   close
     (tp[var("size",@{typ Zsize}),var("imm_rm",@{typ Zimm_rm})],
      cs(var("imm_rm",@{typ Zimm_rm}),
         [(call("Zimm_rm.Zrm",@{typ Zimm_rm},var("rm",@{typ Zrm}),@{theory}),
           call
             ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
              tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory})),
          (call("Zimm_rm.Zimm",@{typ Zimm_rm},var_w("imm",64),@{theory}),
           mu(call("Zea.Zea_i",@{typ Zea},tp[var("size",@{typ Zsize}),var_w("imm",64)],@{theory}),
              qTy))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("restrictSize",
   close
     (tp[var("size",@{typ Zsize}),var_w("imm",64)],
      cs(var("size",@{typ Zsize}),
         [(call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
           bop(BAnd,var_w("imm",64),lw(255,64))),
          (Term.Const(@{const_name "Z16"},@{typ Zsize}),bop(BAnd,var_w("imm",64),lw(65535,64))),
          (Term.Const(@{const_name "Z32"},@{typ Zsize}),bop(BAnd,var_w("imm",64),lw(4294967295,64))),
          (Term.Const(@{const_name "Z64"},@{typ Zsize}),var_w("imm",64))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("EA",
   close
     (var("ea",@{typ Zea}),
      cs(var("ea",@{typ Zea}),
         [(call("Zea.Zea_i",@{typ Zea},var("i",@{typ "Zsize \<times> 64 word"}),@{theory}),
           mu(call("restrictSize",w64,var("i",@{typ "Zsize \<times> 64 word"}),@{theory}),qTy)),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[call("Zsize.Z8",@{typ Zsize},var_b"have_rex",@{theory}),var("r",@{typ Zreg})],
              @{theory}),
           mb(ite(bop(Or,var_b"have_rex",
                      mop(Not,
                          bop(In,var("r",@{typ Zreg}),
                              sl[lc("RSP","Zreg",@{theory}),lc("RBP","Zreg",@{theory}),
                                 lc("RSI","Zreg",@{theory}),lc("RDI","Zreg",@{theory})]))),
                  mb(mr(close
                          (var("s",qTy),
                           call
                             ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                              var("s",qTy),@{theory}))),
                     close
                       (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                        mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("r",@{typ Zreg})),
                           qTy))),
                  mb(mr(close
                          (var("s",qTy),
                           call
                             ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                              var("s",qTy),@{theory}))),
                     close
                       (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                        mb(mu(apply
                                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                 mop(Cast @{typ Zreg},
                                     bop(Sub,mop(Cast HOLogic.natT,var("r",@{typ Zreg})),ln 4))),qTy),
                           close(var_w("v",64),mu(bop(Lsr,var_w("v",64),ln 8),qTy)))))),
              close(var_w("v",64),mu(bop(BAnd,var_w("v",64),lw(255,64)),qTy)))),
          (call("Zea.Zea_r",@{typ Zea},tp[var("s",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                       @{theory}))),
              close
                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                 mb(mb(mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("r",@{typ Zreg})),
                          qTy),close(var_w("v",64),mu(tp[var("s",@{typ Zsize}),var_w("v",64)],qTy))),
                    close
                      (var("v",@{typ "Zsize \<times> 64 word"}),
                       mu(call
                            ("restrictSize",w64,var("v",@{typ "Zsize \<times> 64 word"}),@{theory}),
                          qTy)))))),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),var_w("a",64)],
              @{theory}),
           mb(call
                ("mem8",
                 @{typ "Labelled_X64_state \<Rightarrow> (8 word \<times> Labelled_X64_state)"},
                 var_w("a",64),@{theory}),close(var_w("v",8),mu(mop(Cast w64,var_w("v",8)),qTy)))),
          (call
             ("Zea.Zea_m",@{typ Zea},tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),var_w("a",64)],
              @{theory}),
           mb(call
                ("mem16",
                 @{typ "Labelled_X64_state \<Rightarrow> (16 word \<times> Labelled_X64_state)"},
                 var_w("a",64),@{theory}),close(var_w("v",16),mu(mop(Cast w64,var_w("v",16)),qTy)))),
          (call
             ("Zea.Zea_m",@{typ Zea},tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),var_w("a",64)],
              @{theory}),
           mb(call
                ("mem32",
                 @{typ "Labelled_X64_state \<Rightarrow> (32 word \<times> Labelled_X64_state)"},
                 var_w("a",64),@{theory}),close(var_w("v",32),mu(mop(Cast w64,var_w("v",32)),qTy)))),
          (call
             ("Zea.Zea_m",@{typ Zea},tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var_w("a",64)],
              @{theory}),
           call
             ("mem64",
              @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
              var_w("a",64),@{theory}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("write'EA",
   close
     (tp[var_w("w",64),var("ea",@{typ Zea})],
      cs(var("ea",@{typ Zea}),
         [(call("Zea.Zea_i",@{typ Zea},var("i",@{typ "Zsize \<times> 64 word"}),@{theory}),
           call
             ("raise'exception",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              call("exception.FAILURE",@{typ exception},ls"write to constant",@{theory}),@{theory})),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[call("Zsize.Z8",@{typ Zsize},var_b"have_rex",@{theory}),var("r",@{typ Zreg})],
              @{theory}),
           ite(bop(Or,var_b"have_rex",
                   mop(Not,
                       bop(In,var("r",@{typ Zreg}),
                           sl[lc("RSP","Zreg",@{theory}),lc("RBP","Zreg",@{theory}),
                              lc("RSI","Zreg",@{theory}),lc("RDI","Zreg",@{theory})]))),
               mb(mr(close
                       (var("s",qTy),
                        call
                          ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                           var("s",qTy),@{theory}))),
                  close
                    (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                     mb(mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("r",@{typ Zreg})),
                           qTy),
                        close
                          (var_w("w0",64),
                           mb(mr(close
                                   (var("s",qTy),
                                    call
                                      ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                       var("s",qTy),@{theory}))),
                              close
                                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                 mb(mu(fupd
                                         (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                          var("r",@{typ Zreg}),
                                          bfi(ln 7,ln 0,ex(var_w("w",64),ln 7,ln 0,w8),
                                              var_w("w0",64))),qTy),
                                    close
                                      (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                       mw(close
                                            (var("s",qTy),
                                             rupd
                                               ("Labelled_X64_state.REG",
                                                tp[var("s",qTy),
                                                   var("v",@{typ "Zreg \<Rightarrow> 64 word"})],
                                                @{theory}))))))))))),
               let'
                 (var("x",@{typ Zreg}),
                  mop(Cast @{typ Zreg},bop(Sub,mop(Cast HOLogic.natT,var("r",@{typ Zreg})),ln 4)),
                  mb(mr(close
                          (var("s",qTy),
                           call
                             ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                              var("s",qTy),@{theory}))),
                     close
                       (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                        mb(mu(apply
                                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("x",@{typ Zreg})),
                              qTy),
                           close
                             (var_w("w0",64),
                              mb(mr(close
                                      (var("s",qTy),
                                       call
                                         ("Labelled_X64_state.REG",
                                          @{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),@{theory}))),
                                 close
                                   (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                    mb(mu(fupd
                                            (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                             var("x",@{typ Zreg}),
                                             bfi(ln 15,ln 8,ex(var_w("w",64),ln 7,ln 0,w8),
                                                 var_w("w0",64))),qTy),
                                       close
                                         (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                          mw(close
                                               (var("s",qTy),
                                                rupd
                                                  ("Labelled_X64_state.REG",
                                                   tp[var("s",qTy),
                                                      var("v",@{typ "Zreg \<Rightarrow> 64 word"})],
                                                   @{theory})))))))))))))),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                       @{theory}))),
              close
                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                 mb(mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("r",@{typ Zreg})),qTy),
                    close
                      (var_w("w0",64),
                       mb(mr(close
                               (var("s",qTy),
                                call
                                  ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                   var("s",qTy),@{theory}))),
                          close
                            (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                             mb(mu(fupd
                                     (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                      var("r",@{typ Zreg}),
                                      bfi(ln 15,ln 0,ex(var_w("w",64),ln 15,ln 0,w16),var_w("w0",64))),
                                   qTy),
                                close
                                  (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                   mw(close
                                        (var("s",qTy),
                                         rupd
                                           ("Labelled_X64_state.REG",
                                            tp[var("s",qTy),
                                               var("v",@{typ "Zreg \<Rightarrow> 64 word"})],
                                            @{theory})))))))))))),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                       @{theory}))),
              close
                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                 mb(mu(fupd
                         (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("r",@{typ Zreg}),
                          mop(Cast w64,ex(var_w("w",64),ln 31,ln 0,w32))),qTy),
                    close
                      (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                       mw(close
                            (var("s",qTy),
                             rupd
                               ("Labelled_X64_state.REG",
                                tp[var("s",qTy),var("v",@{typ "Zreg \<Rightarrow> 64 word"})],
                                @{theory})))))))),
          (call
             ("Zea.Zea_r",@{typ Zea},
              tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                       @{theory}))),
              close
                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                 mb(mu(fupd
                         (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("r",@{typ Zreg}),
                          var_w("w",64)),qTy),
                    close
                      (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                       mw(close
                            (var("s",qTy),
                             rupd
                               ("Labelled_X64_state.REG",
                                tp[var("s",qTy),var("v",@{typ "Zreg \<Rightarrow> 64 word"})],
                                @{theory})))))))),
          (call
             ("Zea.Zea_m",@{typ Zea},
              tp[call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),var_w("a",64)],
              @{theory}),
           call
             ("write'mem8",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[ex(var_w("w",64),ln 7,ln 0,w8),var_w("a",64)],@{theory})),
          (call
             ("Zea.Zea_m",@{typ Zea},tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),var_w("a",64)],
              @{theory}),
           call
             ("write'mem16",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[ex(var_w("w",64),ln 15,ln 0,w16),var_w("a",64)],@{theory})),
          (call
             ("Zea.Zea_m",@{typ Zea},tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),var_w("a",64)],
              @{theory}),
           call
             ("write'mem32",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[ex(var_w("w",64),ln 31,ln 0,w32),var_w("a",64)],@{theory})),
          (call
             ("Zea.Zea_m",@{typ Zea},tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var_w("a",64)],
              @{theory}),
           call
             ("write'mem64",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var_w("w",64),var_w("a",64)],@{theory}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("read_dest_src_ea",
   close
     (var("sd",@{typ "Zsize \<times> Zdest_src"}),
      mb(call
           ("ea_Zdest",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
            var("sd",@{typ "Zsize \<times> Zdest_src"}),@{theory}),
         close
           (var("ea",@{typ Zea}),
            mb(call
                 ("EA",
                  @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                  var("ea",@{typ Zea}),@{theory}),
               close
                 (var_w("v",64),
                  mb(mb(call
                          ("ea_Zsrc",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                           var("sd",@{typ "Zsize \<times> Zdest_src"}),@{theory}),
                        close
                          (var("v0",@{typ Zea}),
                           mb(call
                                ("EA",
                                 @{typ
                                 "Labelled_X64_state \<Rightarrow>
                                  (64 word \<times> Labelled_X64_state)"},var("v0",@{typ Zea}),
                                 @{theory}),
                              close(var_w("v0",64),mu(tp[var_w("v",64),var_w("v0",64)],qTy))))),
                     close
                       (var("v",@{typ "64 word \<times> 64 word"}),
                        mu(tp[var("ea",@{typ Zea}),var("v",@{typ "64 word \<times> 64 word"})],qTy)))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("call_dest_from_ea",
   close
     (var("ea",@{typ Zea}),
      cs(var("ea",@{typ Zea}),
         [(call("Zea.Zea_i",@{typ Zea},tp[var_a @{typ Zsize},var_w("i",64)],@{theory}),
           mb(mr(close(var("s",qTy),call("Labelled_X64_state.RIP",w64,var("s",qTy),@{theory}))),
              close(var_w("v",64),mu(bop(Add,var_w("v",64),var_w("i",64)),qTy)))),
          (call("Zea.Zea_r",@{typ Zea},tp[var_a @{typ Zsize},var("r",@{typ Zreg})],@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                       @{theory}))),
              close
                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                 mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),var("r",@{typ Zreg})),qTy)))),
          (call("Zea.Zea_m",@{typ Zea},tp[var_a @{typ Zsize},var_w("a",64)],@{theory}),
           call
             ("mem64",
              @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
              var_w("a",64),@{theory}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("get_ea_address",
   close
     (var("ea",@{typ Zea}),
      cs(var("ea",@{typ Zea}),
         [(call("Zea.Zea_i",@{typ Zea},tp[var_a @{typ Zsize},var_w("i",64)],@{theory}),lw(0,64)),
          (call("Zea.Zea_r",@{typ Zea},tp[var_a @{typ Zsize},var("r",@{typ Zreg})],@{theory}),
           lw(0,64)),
          (call("Zea.Zea_m",@{typ Zea},tp[var_a @{typ Zsize},var_w("a",64)],@{theory}),var_w("a",64))],
         @{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("jump_to_ea",
   close
     (var("ea",@{typ Zea}),
      mb(call
           ("call_dest_from_ea",
            @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
            var("ea",@{typ Zea}),@{theory}),
         close
           (var_w("v",64),
            mw(close
                 (var("s",qTy),
                  rupd("Labelled_X64_state.RIP",tp[var("s",qTy),var_w("v",64)],@{theory})))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("ByteParity",
   close
     (var_w("b",8),
      eq(bop(Mod,
             bop(Add,
                 bop(Add,
                     bop(Add,
                         bop(Add,
                             bop(Add,
                                 bop(Add,
                                     bop(Add,mop(Cast HOLogic.natT,bop(Bit,var_w("b",8),ln 7)),
                                         mop(Cast HOLogic.natT,bop(Bit,var_w("b",8),ln 6))),
                                     mop(Cast HOLogic.natT,bop(Bit,var_w("b",8),ln 5))),
                                 mop(Cast HOLogic.natT,bop(Bit,var_w("b",8),ln 4))),
                             mop(Cast HOLogic.natT,bop(Bit,var_w("b",8),ln 3))),
                         mop(Cast HOLogic.natT,bop(Bit,var_w("b",8),ln 2))),
                     mop(Cast HOLogic.natT,bop(Bit,var_w("b",8),ln 1))),
                 mop(Cast HOLogic.natT,bop(Bit,var_w("b",8),ln 0))),ln 2),ln 0)))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("Zsize_width",
   close
     (var("size",@{typ Zsize}),
      cs(var("size",@{typ Zsize}),
         [(call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),ln 8),
          (Term.Const(@{const_name "Z16"},@{typ Zsize}),ln 16),
          (Term.Const(@{const_name "Z32"},@{typ Zsize}),ln 32),
          (Term.Const(@{const_name "Z64"},@{typ Zsize}),ln 64)],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("word_size_msb",
   close
     (tp[var("size",@{typ Zsize}),var_w("w",64)],
      bop(Bit,var_w("w",64),
          bop(Sub,call("Zsize_width",HOLogic.natT,var("size",@{typ Zsize}),@{theory}),ln 1))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_PF",
   close
     (var_w("w",64),
      call
        ("write'PF",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         call("ByteParity",HOLogic.boolT,ex(var_w("w",64),ln 7,ln 0,w8),@{theory}),@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_SF",
   close
     (var("s_w",@{typ "Zsize \<times> 64 word"}),
      call
        ("write'SF",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         call("word_size_msb",HOLogic.boolT,var("s_w",@{typ "Zsize \<times> 64 word"}),@{theory}),
         @{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_ZF",
   close
     (tp[var("size",@{typ Zsize}),var_w("w",64)],
      call
        ("write'ZF",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         cs(var("size",@{typ Zsize}),
            [(call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
              eq(mop(Cast w8,var_w("w",64)),lw(0,8))),
             (Term.Const(@{const_name "Z16"},@{typ Zsize}),eq(mop(Cast w16,var_w("w",64)),lw(0,16))),
             (Term.Const(@{const_name "Z32"},@{typ Zsize}),eq(mop(Cast w32,var_w("w",64)),lw(0,32))),
             (Term.Const(@{const_name "Z64"},@{typ Zsize}),eq(var_w("w",64),lw(0,64)))],@{context}),
         @{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_logical_eflags",
   close
     (tp[var("size",@{typ Zsize}),var_w("w",64)],
      mb(call
           ("write'CF",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            lf,@{theory}),
         close
           (var_a HOLogic.unitT,
            mb(call
                 ("write'OF",
                  @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},lf,
                  @{theory}),
               close
                 (var_a HOLogic.unitT,
                  mb(call
                       ("write_PF",
                        @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                        var_w("w",64),@{theory}),
                     close
                       (var_a HOLogic.unitT,
                        mb(call
                             ("write_SF",
                              @{typ
                              "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                              tp[var("size",@{typ Zsize}),var_w("w",64)],@{theory}),
                           close
                             (var_a HOLogic.unitT,
                              mb(call
                                   ("write_ZF",
                                    @{typ
                                    "Labelled_X64_state \<Rightarrow>
                                     (unit \<times> Labelled_X64_state)"},
                                    tp[var("size",@{typ Zsize}),var_w("w",64)],@{theory}),
                                 close
                                   (var_a HOLogic.unitT,
                                    call
                                      ("FlagUnspecified",
                                       @{typ
                                       "Labelled_X64_state \<Rightarrow>
                                        (unit \<times> Labelled_X64_state)"},
                                       lc("Z_AF","Zeflags",@{theory}),@{theory})))))))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_arith_eflags_except_CF_OF",
   close
     (tp[var("size",@{typ Zsize}),var_w("w",64)],
      mb(call
           ("write_PF",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            var_w("w",64),@{theory}),
         close
           (var_a HOLogic.unitT,
            mb(call
                 ("write_SF",
                  @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                  tp[var("size",@{typ Zsize}),var_w("w",64)],@{theory}),
               close
                 (var_a HOLogic.unitT,
                  mb(call
                       ("write_ZF",
                        @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                        tp[var("size",@{typ Zsize}),var_w("w",64)],@{theory}),
                     close
                       (var_a HOLogic.unitT,
                        call
                          ("FlagUnspecified",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                           lc("Z_AF","Zeflags",@{theory}),@{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_arith_eflags",
   close
     (tp[var("size",@{typ Zsize}),var("r",@{typ "64 word \<times> bool \<times> bool"})],
      let'
        (tp[var_w("w",64),var_b"c",var_b"x"],var("r",@{typ "64 word \<times> bool \<times> bool"}),
         mb(call
              ("write'CF",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               var_b"c",@{theory}),
            close
              (var_a HOLogic.unitT,
               mb(call
                    ("write'OF",
                     @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                     var_b"x",@{theory}),
                  close
                    (var_a HOLogic.unitT,
                     call
                       ("write_arith_eflags_except_CF_OF",
                        @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                        tp[var("size",@{typ Zsize}),var_w("w",64)],@{theory}))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("erase_eflags",
   mw(close
        (var("s",qTy),
         rupd
           ("Labelled_X64_state.EFLAGS",tp[var("s",qTy),mop(K1 @{typ Zeflags},lo HOLogic.boolT)],
            @{theory}))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("value_width",
   close
     (var("s",@{typ Zsize}),
      bop(Exp,ln 2,call("Zsize_width",HOLogic.natT,var("s",@{typ Zsize}),@{theory}))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("word_signed_overflow_add",
   close
     (tp[var("size",@{typ Zsize}),var_w("a",64),var_w("b",64)],
      bop(And,
          eq(call
               ("word_size_msb",HOLogic.boolT,tp[var("size",@{typ Zsize}),var_w("a",64)],@{theory}),
             call
               ("word_size_msb",HOLogic.boolT,tp[var("size",@{typ Zsize}),var_w("b",64)],@{theory})),
          mop(Not,
              eq(call
                   ("word_size_msb",HOLogic.boolT,
                    tp[var("size",@{typ Zsize}),bop(Add,var_w("a",64),var_w("b",64))],@{theory}),
                 call
                   ("word_size_msb",HOLogic.boolT,tp[var("size",@{typ Zsize}),var_w("a",64)],
                    @{theory}))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("word_signed_overflow_sub",
   close
     (tp[var("size",@{typ Zsize}),var_w("a",64),var_w("b",64)],
      bop(And,
          mop(Not,
              eq(call
                   ("word_size_msb",HOLogic.boolT,tp[var("size",@{typ Zsize}),var_w("a",64)],
                    @{theory}),
                 call
                   ("word_size_msb",HOLogic.boolT,tp[var("size",@{typ Zsize}),var_w("b",64)],
                    @{theory}))),
          mop(Not,
              eq(call
                   ("word_size_msb",HOLogic.boolT,
                    tp[var("size",@{typ Zsize}),bop(Sub,var_w("a",64),var_w("b",64))],@{theory}),
                 call
                   ("word_size_msb",HOLogic.boolT,tp[var("size",@{typ Zsize}),var_w("a",64)],
                    @{theory}))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("add_with_carry_out",
   close
     (tp[var("size",@{typ Zsize}),var_w("x",64),var_w("y",64)],
      tp[bop(Add,var_w("x",64),var_w("y",64)),
         bop(Le,call("value_width",HOLogic.natT,var("size",@{typ Zsize}),@{theory}),
             bop(Add,mop(Cast HOLogic.natT,var_w("x",64)),mop(Cast HOLogic.natT,var_w("y",64)))),
         call
           ("word_signed_overflow_add",HOLogic.boolT,
            tp[var("size",@{typ Zsize}),var_w("x",64),var_w("y",64)],@{theory})]))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("sub_with_borrow",
   close
     (tp[var("size",@{typ Zsize}),var_w("x",64),var_w("y",64)],
      tp[bop(Sub,var_w("x",64),var_w("y",64)),bop(Ult,var_w("x",64),var_w("y",64)),
         call
           ("word_signed_overflow_sub",HOLogic.boolT,
            tp[var("size",@{typ Zsize}),var_w("x",64),var_w("y",64)],@{theory})]))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_arith_result",
   close
     (tp[var("size",@{typ Zsize}),var("r",@{typ "64 word \<times> bool \<times> bool"}),
         var("ea",@{typ Zea})],
      mb(call
           ("write_arith_eflags",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            tp[var("size",@{typ Zsize}),var("r",@{typ "64 word \<times> bool \<times> bool"})],
            @{theory}),
         close
           (var_a HOLogic.unitT,
            call
              ("write'EA",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               tp[mop(Fst,var("r",@{typ "64 word \<times> bool \<times> bool"})),
                  var("ea",@{typ Zea})],@{theory})))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_arith_result_no_CF_OF",
   close
     (tp[var("size",@{typ Zsize}),var_w("w",64),var("ea",@{typ Zea})],
      mb(call
           ("write_arith_eflags_except_CF_OF",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            tp[var("size",@{typ Zsize}),var_w("w",64)],@{theory}),
         close
           (var_a HOLogic.unitT,
            call
              ("write'EA",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               tp[var_w("w",64),var("ea",@{typ Zea})],@{theory})))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_logical_result",
   close
     (tp[var("size",@{typ Zsize}),var_w("w",64),var("ea",@{typ Zea})],
      mb(call
           ("write_logical_eflags",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            tp[var("size",@{typ Zsize}),var_w("w",64)],@{theory}),
         close
           (var_a HOLogic.unitT,
            call
              ("write'EA",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               tp[var_w("w",64),var("ea",@{typ Zea})],@{theory})))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_result_erase_eflags",
   close
     (tp[var_w("w",64),var("ea",@{typ Zea})],
      mb(const
           ("erase_eflags",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},@{theory}),
         close
           (var_a HOLogic.unitT,
            call
              ("write'EA",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               tp[var_w("w",64),var("ea",@{typ Zea})],@{theory})))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("SignExtension",
   close
     (tp[var_w("w",64),var("size1",@{typ Zsize}),var("size2",@{typ Zsize})],
      mn(var_w("w",64),
         mb(cs(tp[var("size1",@{typ Zsize}),var("size2",@{typ Zsize})],
               [(tp[call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
                    Term.Const(@{const_name "Z16"},@{typ Zsize})],
                 mb(mr(close
                         (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                          mop(Fst,var("s",@{typ "64 word \<times> Labelled_X64_state"})))),
                    close
                      (var_w("v",64),
                       mb(mu(bfi(ln 15,ln 0,mop(SE w16,ex(var_w("w",64),ln 7,ln 0,w8)),var_w("v",64)),
                             @{typ "64 word \<times> Labelled_X64_state"}),
                          close
                            (var_w("v",64),
                             mw(close
                                  (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                                   tp[var_w("v",64),
                                      mop(Snd,var("s",@{typ "64 word \<times> Labelled_X64_state"}))]))))))),
                (tp[call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
                    Term.Const(@{const_name "Z32"},@{typ Zsize})],
                 mb(mr(close
                         (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                          mop(Fst,var("s",@{typ "64 word \<times> Labelled_X64_state"})))),
                    close
                      (var_w("v",64),
                       mb(mu(bfi(ln 31,ln 0,mop(SE w32,ex(var_w("w",64),ln 7,ln 0,w8)),var_w("v",64)),
                             @{typ "64 word \<times> Labelled_X64_state"}),
                          close
                            (var_w("v",64),
                             mw(close
                                  (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                                   tp[var_w("v",64),
                                      mop(Snd,var("s",@{typ "64 word \<times> Labelled_X64_state"}))]))))))),
                (tp[call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
                    Term.Const(@{const_name "Z64"},@{typ Zsize})],
                 mw(close
                      (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                       tp[mop(SE w64,ex(var_w("w",64),ln 7,ln 0,w8)),
                          mop(Snd,var("s",@{typ "64 word \<times> Labelled_X64_state"}))]))),
                (tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),
                    Term.Const(@{const_name "Z32"},@{typ Zsize})],
                 mb(mr(close
                         (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                          mop(Fst,var("s",@{typ "64 word \<times> Labelled_X64_state"})))),
                    close
                      (var_w("v",64),
                       mb(mu(bfi(ln 31,ln 0,mop(SE w32,ex(var_w("w",64),ln 15,ln 0,w16)),
                                 var_w("v",64)),@{typ "64 word \<times> Labelled_X64_state"}),
                          close
                            (var_w("v",64),
                             mw(close
                                  (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                                   tp[var_w("v",64),
                                      mop(Snd,var("s",@{typ "64 word \<times> Labelled_X64_state"}))]))))))),
                (tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),
                    Term.Const(@{const_name "Z64"},@{typ Zsize})],
                 mw(close
                      (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                       tp[mop(SE w64,ex(var_w("w",64),ln 15,ln 0,w16)),
                          mop(Snd,var("s",@{typ "64 word \<times> Labelled_X64_state"}))]))),
                (tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),
                    Term.Const(@{const_name "Z64"},@{typ Zsize})],
                 mw(close
                      (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                       tp[mop(SE w64,ex(var_w("w",64),ln 31,ln 0,w32)),
                          mop(Snd,var("s",@{typ "64 word \<times> Labelled_X64_state"}))]))),
                (var_a(@{typ "Zsize \<times> Zsize"}),
                 md(call
                      ("raise'exception",
                       @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                       call("exception.FAILURE",@{typ exception},ls"SignExtension",@{theory}),
                       @{theory}),w64))],@{context}),
            close
              (var_a HOLogic.unitT,
               mr(close
                    (var("s",@{typ "64 word \<times> Labelled_X64_state"}),
                     mop(Fst,var("s",@{typ "64 word \<times> Labelled_X64_state"})))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("maskShift",
   close
     (tp[var("size",@{typ Zsize}),var_w("w",64)],
      ite(eq(var("size",@{typ Zsize}),Term.Const(@{const_name "Z64"},@{typ Zsize})),
          mop(Cast HOLogic.natT,ex(var_w("w",64),ln 5,ln 0,(Word_Lib.mk_wordT 6))),
          mop(Cast HOLogic.natT,ex(var_w("w",64),ln 4,ln 0,(Word_Lib.mk_wordT 5))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("ROL",
   close
     (tp[var("size",@{typ Zsize}),var_w("x",64),var_w("y",64)],
      cs(var("size",@{typ Zsize}),
         [(call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
           mop(Cast w64,
               bop(Rol,ex(var_w("x",64),ln 7,ln 0,w8),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z16"},@{typ Zsize}),
           mop(Cast w64,
               bop(Rol,ex(var_w("x",64),ln 15,ln 0,w16),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z32"},@{typ Zsize}),
           mop(Cast w64,
               bop(Rol,ex(var_w("x",64),ln 31,ln 0,w32),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z64"},@{typ Zsize}),
           bop(Rol,var_w("x",64),
               mop(Cast HOLogic.natT,ex(var_w("y",64),ln 5,ln 0,(Word_Lib.mk_wordT 6)))))],
         @{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("ROR",
   close
     (tp[var("size",@{typ Zsize}),var_w("x",64),var_w("y",64)],
      cs(var("size",@{typ Zsize}),
         [(call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
           mop(Cast w64,
               bop(Ror,ex(var_w("x",64),ln 7,ln 0,w8),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z16"},@{typ Zsize}),
           mop(Cast w64,
               bop(Ror,ex(var_w("x",64),ln 15,ln 0,w16),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z32"},@{typ Zsize}),
           mop(Cast w64,
               bop(Ror,ex(var_w("x",64),ln 31,ln 0,w32),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z64"},@{typ Zsize}),
           bop(Ror,var_w("x",64),
               mop(Cast HOLogic.natT,ex(var_w("y",64),ln 5,ln 0,(Word_Lib.mk_wordT 6)))))],
         @{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("SAR",
   close
     (tp[var("size",@{typ Zsize}),var_w("x",64),var_w("y",64)],
      cs(var("size",@{typ Zsize}),
         [(call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
           mop(Cast w64,
               bop(Asr,ex(var_w("x",64),ln 7,ln 0,w8),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z16"},@{typ Zsize}),
           mop(Cast w64,
               bop(Asr,ex(var_w("x",64),ln 15,ln 0,w16),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z32"},@{typ Zsize}),
           mop(Cast w64,
               bop(Asr,ex(var_w("x",64),ln 31,ln 0,w32),
                   mop(Cast HOLogic.natT,ex(var_w("y",64),ln 4,ln 0,(Word_Lib.mk_wordT 5)))))),
          (Term.Const(@{const_name "Z64"},@{typ Zsize}),
           bop(Asr,var_w("x",64),
               mop(Cast HOLogic.natT,ex(var_w("y",64),ln 5,ln 0,(Word_Lib.mk_wordT 6)))))],
         @{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_binop",
   close
     (tp[var("s",@{typ Zsize}),var("bop",@{typ Zbinop_name}),var_w("x",64),var_w("y",64),
         var("ea",@{typ Zea})],
      cs(var("bop",@{typ Zbinop_name}),
         [(lc("Zadd","Zbinop_name",@{theory}),
           call
             ("write_arith_result",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),
                 call
                   ("add_with_carry_out",@{typ "64 word \<times> bool \<times> bool"},
                    tp[var("s",@{typ Zsize}),var_w("x",64),var_w("y",64)],@{theory}),
                 var("ea",@{typ Zea})],@{theory})),
          (lc("Zsub","Zbinop_name",@{theory}),
           call
             ("write_arith_result",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),
                 call
                   ("sub_with_borrow",@{typ "64 word \<times> bool \<times> bool"},
                    tp[var("s",@{typ Zsize}),var_w("x",64),var_w("y",64)],@{theory}),
                 var("ea",@{typ Zea})],@{theory})),
          (lc("Zcmp","Zbinop_name",@{theory}),
           call
             ("write_arith_eflags",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),
                 call
                   ("sub_with_borrow",@{typ "64 word \<times> bool \<times> bool"},
                    tp[var("s",@{typ Zsize}),var_w("x",64),var_w("y",64)],@{theory})],@{theory})),
          (lc("Ztest","Zbinop_name",@{theory}),
           call
             ("write_logical_eflags",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),bop(BAnd,var_w("x",64),var_w("y",64))],@{theory})),
          (lc("Zand","Zbinop_name",@{theory}),
           call
             ("write_logical_result",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),bop(BAnd,var_w("x",64),var_w("y",64)),var("ea",@{typ Zea})],
              @{theory})),
          (lc("Zxor","Zbinop_name",@{theory}),
           call
             ("write_logical_result",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),bop(BXor,var_w("x",64),var_w("y",64)),var("ea",@{typ Zea})],
              @{theory})),
          (lc("Zor","Zbinop_name",@{theory}),
           call
             ("write_logical_result",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),bop(BOr,var_w("x",64),var_w("y",64)),var("ea",@{typ Zea})],
              @{theory})),
          (lc("Zrol","Zbinop_name",@{theory}),
           call
             ("write_result_erase_eflags",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[call("ROL",w64,tp[var("s",@{typ Zsize}),var_w("x",64),var_w("y",64)],@{theory}),
                 var("ea",@{typ Zea})],@{theory})),
          (lc("Zror","Zbinop_name",@{theory}),
           call
             ("write_result_erase_eflags",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[call("ROR",w64,tp[var("s",@{typ Zsize}),var_w("x",64),var_w("y",64)],@{theory}),
                 var("ea",@{typ Zea})],@{theory})),
          (lc("Zsar","Zbinop_name",@{theory}),
           call
             ("write_result_erase_eflags",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[call("SAR",w64,tp[var("s",@{typ Zsize}),var_w("x",64),var_w("y",64)],@{theory}),
                 var("ea",@{typ Zea})],@{theory})),
          (lc("Zshl","Zbinop_name",@{theory}),
           call
             ("write_result_erase_eflags",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[bop(Lsl,var_w("x",64),
                     call
                       ("maskShift",HOLogic.natT,tp[var("s",@{typ Zsize}),var_w("y",64)],@{theory})),
                 var("ea",@{typ Zea})],@{theory})),
          (lc("Zshr","Zbinop_name",@{theory}),
           call
             ("write_result_erase_eflags",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[bop(Lsr,var_w("x",64),
                     call
                       ("maskShift",HOLogic.natT,tp[var("s",@{typ Zsize}),var_w("y",64)],@{theory})),
                 var("ea",@{typ Zea})],@{theory})),
          (lc("Zadc","Zbinop_name",@{theory}),
           mb(const
                ("CF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),
              close
                (var_b"carry",
                 mb(call
                      ("write'CF",
                       @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                       bop(Le,call("value_width",HOLogic.natT,var("s",@{typ Zsize}),@{theory}),
                           bop(Add,
                               bop(Add,mop(Cast HOLogic.natT,var_w("x",64)),
                                   mop(Cast HOLogic.natT,var_w("y",64))),
                               mop(Cast HOLogic.natT,var_b"carry"))),@{theory}),
                    close
                      (var_a HOLogic.unitT,
                       mb(call
                            ("FlagUnspecified",
                             @{typ
                             "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                             lc("Z_OF","Zeflags",@{theory}),@{theory}),
                          close
                            (var_a HOLogic.unitT,
                             call
                               ("write_arith_result_no_CF_OF",
                                @{typ
                                "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                                tp[var("s",@{typ Zsize}),
                                   bop(Add,bop(Add,var_w("x",64),var_w("y",64)),
                                       mop(Cast w64,var_b"carry")),var("ea",@{typ Zea})],@{theory})))))))),
          (lc("Zsbb","Zbinop_name",@{theory}),
           mb(const
                ("CF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),
              close
                (var_b"carry",
                 mb(call
                      ("write'CF",
                       @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                       bop(Lt,mop(Cast HOLogic.natT,var_w("x",64)),
                           bop(Add,mop(Cast HOLogic.natT,var_w("y",64)),
                               mop(Cast HOLogic.natT,var_b"carry"))),@{theory}),
                    close
                      (var_a HOLogic.unitT,
                       mb(call
                            ("FlagUnspecified",
                             @{typ
                             "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                             lc("Z_OF","Zeflags",@{theory}),@{theory}),
                          close
                            (var_a HOLogic.unitT,
                             call
                               ("write_arith_result_no_CF_OF",
                                @{typ
                                "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                                tp[var("s",@{typ Zsize}),
                                   bop(Sub,var_w("x",64),
                                       bop(Add,var_w("y",64),mop(Cast w64,var_b"carry"))),
                                   var("ea",@{typ Zea})],@{theory})))))))),
          (var_a @{typ Zbinop_name},
           call
             ("raise'exception",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              call
                ("exception.FAILURE",@{typ exception},
                 cc[ls"Binary op not implemented: ",
                    mop(Cast(@{typ string}),var("bop",@{typ Zbinop_name}))],@{theory}),@{theory}))],
         @{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write_monop",
   close
     (tp[var("s",@{typ Zsize}),var("mop",@{typ Zmonop_name}),var_w("x",64),var("ea",@{typ Zea})],
      cs(var("mop",@{typ Zmonop_name}),
         [(lc("Znot","Zmonop_name",@{theory}),
           call
             ("write'EA",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[mop(BNot,var_w("x",64)),var("ea",@{typ Zea})],@{theory})),
          (lc("Zdec","Zmonop_name",@{theory}),
           call
             ("write_arith_result_no_CF_OF",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),bop(Sub,var_w("x",64),lw(1,64)),var("ea",@{typ Zea})],
              @{theory})),
          (lc("Zinc","Zmonop_name",@{theory}),
           call
             ("write_arith_result_no_CF_OF",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              tp[var("s",@{typ Zsize}),bop(Add,var_w("x",64),lw(1,64)),var("ea",@{typ Zea})],
              @{theory})),
          (lc("Zneg","Zmonop_name",@{theory}),
           mb(call
                ("write_arith_result_no_CF_OF",
                 @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                 tp[var("s",@{typ Zsize}),mop(Neg,var_w("x",64)),var("ea",@{typ Zea})],@{theory}),
              close
                (var_a HOLogic.unitT,
                 call
                   ("FlagUnspecified",
                    @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                    lc("Z_CF","Zeflags",@{theory}),@{theory}))))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("read_cond",
   close
     (var("c",@{typ Zcond}),
      cs(var("c",@{typ Zcond}),
         [(lc("Z_O","Zcond",@{theory}),
           const
             ("OF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
              @{theory})),
          (lc("Z_NO","Zcond",@{theory}),
           mb(const
                ("OF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),close(var_b"v",mu(mop(Not,var_b"v"),qTy)))),
          (lc("Z_B","Zcond",@{theory}),
           const
             ("CF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
              @{theory})),
          (lc("Z_NB","Zcond",@{theory}),
           mb(const
                ("CF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),close(var_b"v",mu(mop(Not,var_b"v"),qTy)))),
          (lc("Z_E","Zcond",@{theory}),
           const
             ("ZF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
              @{theory})),
          (lc("Z_NE","Zcond",@{theory}),
           mb(const
                ("ZF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),close(var_b"v",mu(mop(Not,var_b"v"),qTy)))),
          (lc("Z_A","Zcond",@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("s",qTy),@{theory}))),
              close
                (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                 mb(mb(mu(apply
                            (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                             lc("Z_CF","Zeflags",@{theory})),qTy),
                       close
                         (var("v",@{typ "bool option"}),
                          mb(mr(close
                                  (var("s",qTy),
                                   call
                                     ("Labelled_X64_state.EFLAGS",
                                      @{typ "Zeflags \<Rightarrow> (bool option)"},var("s",qTy),
                                      @{theory}))),
                             close
                               (var("v0",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                mb(mu(apply
                                        (var("v0",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                         lc("Z_ZF","Zeflags",@{theory})),qTy),
                                   close
                                     (var("v0",@{typ "bool option"}),
                                      mu(tp[var("v",@{typ "bool option"}),
                                            var("v0",@{typ "bool option"})],qTy))))))),
                    close
                      (var("x",@{typ "(bool option) \<times> bool option"}),
                       cs(var("x",@{typ "(bool option) \<times> bool option"}),
                          [(tp[mop(Some,lf),mop(Some,lf)],mu(lt,qTy)),
                           (tp[mop(Some,lt),var_a(@{typ "bool option"})],mu(lf,qTy)),
                           (tp[var_a(@{typ "bool option"}),mop(Some,lt)],mu(lf,qTy)),
                           (var_a(@{typ "(bool option) \<times> bool option"}),
                            call
                              ("raise'exception",
                               @{typ
                               "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                               call
                                 ("exception.BadFlagAccess",@{typ exception},
                                  cc[ls"read_cond: ",mop(Cast(@{typ string}),var("c",@{typ Zcond}))],
                                  @{theory}),@{theory}))],@{context})))))),
          (lc("Z_NA","Zcond",@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("s",qTy),@{theory}))),
              close
                (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                 mb(mb(mu(apply
                            (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                             lc("Z_CF","Zeflags",@{theory})),qTy),
                       close
                         (var("v",@{typ "bool option"}),
                          mb(mr(close
                                  (var("s",qTy),
                                   call
                                     ("Labelled_X64_state.EFLAGS",
                                      @{typ "Zeflags \<Rightarrow> (bool option)"},var("s",qTy),
                                      @{theory}))),
                             close
                               (var("v0",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                mb(mu(apply
                                        (var("v0",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                         lc("Z_ZF","Zeflags",@{theory})),qTy),
                                   close
                                     (var("v0",@{typ "bool option"}),
                                      mu(tp[var("v",@{typ "bool option"}),
                                            var("v0",@{typ "bool option"})],qTy))))))),
                    close
                      (var("x",@{typ "(bool option) \<times> bool option"}),
                       cs(var("x",@{typ "(bool option) \<times> bool option"}),
                          [(tp[mop(Some,lt),var_a(@{typ "bool option"})],mu(lt,qTy)),
                           (tp[var_a(@{typ "bool option"}),mop(Some,lt)],mu(lt,qTy)),
                           (tp[mop(Some,lf),mop(Some,lf)],mu(lf,qTy)),
                           (var_a(@{typ "(bool option) \<times> bool option"}),
                            call
                              ("raise'exception",
                               @{typ
                               "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                               call
                                 ("exception.BadFlagAccess",@{typ exception},
                                  cc[ls"read_cond: ",mop(Cast(@{typ string}),var("c",@{typ Zcond}))],
                                  @{theory}),@{theory}))],@{context})))))),
          (lc("Z_S","Zcond",@{theory}),
           const
             ("SF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
              @{theory})),
          (lc("Z_NS","Zcond",@{theory}),
           mb(const
                ("SF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),close(var_b"v",mu(mop(Not,var_b"v"),qTy)))),
          (lc("Z_P","Zcond",@{theory}),
           const
             ("PF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
              @{theory})),
          (lc("Z_NP","Zcond",@{theory}),
           mb(const
                ("PF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),close(var_b"v",mu(mop(Not,var_b"v"),qTy)))),
          (lc("Z_L","Zcond",@{theory}),
           mb(const
                ("SF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),
              close
                (var_b"v",
                 mb(mb(const
                         ("OF",
                          @{typ
                          "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                          @{theory}),close(var_b"v0",mu(eq(var_b"v",var_b"v0"),qTy))),
                    close(var_b"v",mu(mop(Not,var_b"v"),qTy)))))),
          (lc("Z_NL","Zcond",@{theory}),
           mb(const
                ("SF",@{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                 @{theory}),
              close
                (var_b"v",
                 mb(const
                      ("OF",
                       @{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
                       @{theory}),close(var_b"v0",mu(eq(var_b"v",var_b"v0"),qTy)))))),
          (lc("Z_G","Zcond",@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("s",qTy),@{theory}))),
              close
                (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                 mb(mb(mu(apply
                            (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                             lc("Z_SF","Zeflags",@{theory})),qTy),
                       close
                         (var("v",@{typ "bool option"}),
                          mb(mr(close
                                  (var("s",qTy),
                                   call
                                     ("Labelled_X64_state.EFLAGS",
                                      @{typ "Zeflags \<Rightarrow> (bool option)"},var("s",qTy),
                                      @{theory}))),
                             close
                               (var("v0",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                mb(mu(apply
                                        (var("v0",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                         lc("Z_OF","Zeflags",@{theory})),qTy),
                                   close
                                     (var("v0",@{typ "bool option"}),
                                      mu(tp[var("v",@{typ "bool option"}),
                                            var("v0",@{typ "bool option"})],qTy))))))),
                    close
                      (var("x",@{typ "(bool option) \<times> bool option"}),
                       cs(var("x",@{typ "(bool option) \<times> bool option"}),
                          [(tp[mop(Some,var_b"a"),mop(Some,var_b"b")],
                            mb(const
                                 ("ZF",
                                  @{typ
                                  "Labelled_X64_state \<Rightarrow>
                                   (bool \<times> Labelled_X64_state)"},@{theory}),
                               close
                                 (var_b"v",
                                  mb(mu(mop(Not,var_b"v"),qTy),
                                     close(var_b"v",mu(bop(And,eq(var_b"a",var_b"b"),var_b"v"),qTy)))))),
                           (var_a(@{typ "(bool option) \<times> bool option"}),
                            mb(mr(close
                                    (var("s",qTy),
                                     call
                                       ("Labelled_X64_state.EFLAGS",
                                        @{typ "Zeflags \<Rightarrow> (bool option)"},var("s",qTy),
                                        @{theory}))),
                               close
                                 (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                  mb(mu(apply
                                          (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                           lc("Z_ZF","Zeflags",@{theory})),qTy),
                                     close
                                       (var("x",@{typ "bool option"}),
                                        cs(var("x",@{typ "bool option"}),
                                           [(mop(Some,lt),mu(lf,qTy)),
                                            (var_a(@{typ "bool option"}),
                                             call
                                               ("raise'exception",
                                                @{typ
                                                "Labelled_X64_state \<Rightarrow>
                                                 (bool \<times> Labelled_X64_state)"},
                                                call
                                                  ("exception.BadFlagAccess",@{typ exception},
                                                   cc[ls"read_cond: ",
                                                      mop(Cast(@{typ string}),var("c",@{typ Zcond}))],
                                                   @{theory}),@{theory}))],@{context}))))))],
                          @{context})))))),
          (lc("Z_NG","Zcond",@{theory}),
           mb(mr(close
                   (var("s",qTy),
                    call
                      ("Labelled_X64_state.EFLAGS",@{typ "Zeflags \<Rightarrow> (bool option)"},
                       var("s",qTy),@{theory}))),
              close
                (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                 mb(mb(mu(apply
                            (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                             lc("Z_SF","Zeflags",@{theory})),qTy),
                       close
                         (var("v",@{typ "bool option"}),
                          mb(mr(close
                                  (var("s",qTy),
                                   call
                                     ("Labelled_X64_state.EFLAGS",
                                      @{typ "Zeflags \<Rightarrow> (bool option)"},var("s",qTy),
                                      @{theory}))),
                             close
                               (var("v0",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                mb(mu(apply
                                        (var("v0",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                         lc("Z_OF","Zeflags",@{theory})),qTy),
                                   close
                                     (var("v0",@{typ "bool option"}),
                                      mu(tp[var("v",@{typ "bool option"}),
                                            var("v0",@{typ "bool option"})],qTy))))))),
                    close
                      (var("x",@{typ "(bool option) \<times> bool option"}),
                       cs(var("x",@{typ "(bool option) \<times> bool option"}),
                          [(tp[mop(Some,var_b"a"),mop(Some,var_b"b")],
                            mb(const
                                 ("ZF",
                                  @{typ
                                  "Labelled_X64_state \<Rightarrow>
                                   (bool \<times> Labelled_X64_state)"},@{theory}),
                               close
                                 (var_b"v",mu(bop(Or,mop(Not,eq(var_b"a",var_b"b")),var_b"v"),qTy)))),
                           (var_a(@{typ "(bool option) \<times> bool option"}),
                            mb(mr(close
                                    (var("s",qTy),
                                     call
                                       ("Labelled_X64_state.EFLAGS",
                                        @{typ "Zeflags \<Rightarrow> (bool option)"},var("s",qTy),
                                        @{theory}))),
                               close
                                 (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                  mb(mu(apply
                                          (var("v",@{typ "Zeflags \<Rightarrow> (bool option)"}),
                                           lc("Z_ZF","Zeflags",@{theory})),qTy),
                                     close
                                       (var("x",@{typ "bool option"}),
                                        cs(var("x",@{typ "bool option"}),
                                           [(mop(Some,lt),mu(lt,qTy)),
                                            (var_a(@{typ "bool option"}),
                                             call
                                               ("raise'exception",
                                                @{typ
                                                "Labelled_X64_state \<Rightarrow>
                                                 (bool \<times> Labelled_X64_state)"},
                                                call
                                                  ("exception.BadFlagAccess",@{typ exception},
                                                   cc[ls"read_cond: ",
                                                      mop(Cast(@{typ string}),var("c",@{typ Zcond}))],
                                                   @{theory}),@{theory}))],@{context}))))))],
                          @{context})))))),(lc("Z_ALWAYS","Zcond",@{theory}),mu(lt,qTy))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("x64_pop_aux",
   mb(mr(close
           (var("s",qTy),
            call
              ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),@{theory}))),
      close
        (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
         mb(mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),lc("RSP","Zreg",@{theory})),qTy),
            close
              (var_w("rsp",64),
               mb(call
                    ("mem64",
                     @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                     var_w("rsp",64),@{theory}),
                  close
                    (var_w("top",64),
                     mb(mr(close
                             (var("s",qTy),
                              call
                                ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                 var("s",qTy),@{theory}))),
                        close
                          (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                           mb(mb(mu(fupd
                                      (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                       lc("RSP","Zreg",@{theory}),bop(Add,var_w("rsp",64),lw(8,64))),
                                    qTy),
                                 close
                                   (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                    mw(close
                                         (var("s",qTy),
                                          rupd
                                            ("Labelled_X64_state.REG",
                                             tp[var("s",qTy),
                                                var("v",@{typ "Zreg \<Rightarrow> 64 word"})],
                                             @{theory}))))),
                              close(var_a HOLogic.unitT,mu(var_w("top",64),qTy))))))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("x64_pop",
   close
     (var("rm",@{typ Zrm}),
      mb(call
           ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
            tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
         close
           (var("x",@{typ Zea}),
            mb(const
                 ("x64_pop_aux",
                  @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                  @{theory}),
               close
                 (var_w("v",64),
                  mb(mu(tp[var_w("v",64),var("x",@{typ Zea})],qTy),
                     close
                       (var("v",@{typ "64 word \<times> Zea"}),
                        call
                          ("write'EA",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                           var("v",@{typ "64 word \<times> Zea"}),@{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("x64_pop_rip",
   mb(const
        ("x64_pop_aux",
         @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},@{theory}),
      close
        (var_w("v",64),
         mw(close
              (var("s",qTy),rupd("Labelled_X64_state.RIP",tp[var("s",qTy),var_w("v",64)],@{theory}))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("x64_push_aux",
   close
     (var_w("w",64),
      mb(mr(close
              (var("s",qTy),
               call
                 ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                  @{theory}))),
         close
           (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
            mb(mb(mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),lc("RSP","Zreg",@{theory})),
                     qTy),close(var_w("v",64),mu(bop(Sub,var_w("v",64),lw(8,64)),qTy))),
               close
                 (var_w("rsp",64),
                  mb(mr(close
                          (var("s",qTy),
                           call
                             ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                              var("s",qTy),@{theory}))),
                     close
                       (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                        mb(mb(mu(fupd
                                   (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                    lc("RSP","Zreg",@{theory}),var_w("rsp",64)),qTy),
                              close
                                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                 mw(close
                                      (var("s",qTy),
                                       rupd
                                         ("Labelled_X64_state.REG",
                                          tp[var("s",qTy),
                                             var("v",@{typ "Zreg \<Rightarrow> 64 word"})],@{theory}))))),
                           close
                             (var_a HOLogic.unitT,
                              call
                                ("write'mem64",
                                 @{typ
                                 "Labelled_X64_state \<Rightarrow>
                                  (unit \<times> Labelled_X64_state)"},
                                 tp[var_w("w",64),var_w("rsp",64)],@{theory})))))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("x64_push",
   close
     (var("imm_rm",@{typ Zimm_rm}),
      mb(call
           ("ea_Zimm_rm",
            @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
            tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("imm_rm",@{typ Zimm_rm})],@{theory}),
         close
           (var("v",@{typ Zea}),
            mb(call
                 ("EA",
                  @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                  var("v",@{typ Zea}),@{theory}),
               close
                 (var_w("v",64),
                  call
                    ("x64_push_aux",
                     @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                     var_w("v",64),@{theory})))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("x64_push_rip",
   mb(mr(close(var("s",qTy),call("Labelled_X64_state.RIP",w64,var("s",qTy),@{theory}))),
      close
        (var_w("v",64),
         call
           ("x64_push_aux",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
            var_w("v",64),@{theory}))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("x64_drop",
   close
     (var_w("imm",64),
      mb(ite(mop(Not,eq(ex(var_w("imm",64),ln 7,ln 0,w8),lw(0,8))),
             call
               ("raise'exception",
                @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                call("exception.FAILURE",@{typ exception},ls"x64_drop",@{theory}),@{theory}),
             mu(lu,qTy)),
         close
           (var_a HOLogic.unitT,
            mb(mr(close
                    (var("s",qTy),
                     call
                       ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                        @{theory}))),
               close
                 (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                  mb(mb(mr(close
                             (var("s",qTy),
                              call
                                ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                                 var("s",qTy),@{theory}))),
                        close
                          (var("v0",@{typ "Zreg \<Rightarrow> 64 word"}),
                           mb(mb(mu(apply
                                      (var("v0",@{typ "Zreg \<Rightarrow> 64 word"}),
                                       lc("RSP","Zreg",@{theory})),qTy),
                                 close(var_w("v",64),mu(bop(Add,var_w("v",64),var_w("imm",64)),qTy))),
                              close
                                (var_w("v0",64),
                                 mu(fupd
                                      (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                       lc("RSP","Zreg",@{theory}),var_w("v0",64)),qTy))))),
                     close
                       (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                        mw(close
                             (var("s",qTy),
                              rupd
                                ("Labelled_X64_state.REG",
                                 tp[var("s",qTy),var("v",@{typ "Zreg \<Rightarrow> 64 word"})],
                                 @{theory})))))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zbinop",
   close
     (tp[var("bop",@{typ Zbinop_name}),var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],
      mb(call
           ("read_dest_src_ea",
            @{typ
            "Labelled_X64_state \<Rightarrow>
             ((Zea \<times> 64 word \<times> 64 word) \<times> Labelled_X64_state)"},
            tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
         close
           (var("x",@{typ "Zea \<times> 64 word \<times> 64 word"}),
            cs(var("x",@{typ "Zea \<times> 64 word \<times> 64 word"}),
               [(tp[var("ea",@{typ Zea}),var_w("val_dst",64),var_w("val_src",64)],
                 call
                   ("write_binop",
                    @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                    tp[var("size",@{typ Zsize}),var("bop",@{typ Zbinop_name}),var_w("val_dst",64),
                       var_w("val_src",64),var("ea",@{typ Zea})],@{theory}))],@{context})))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zcall",
   close
     (var("imm_rm",@{typ Zimm_rm}),
      mb(const
           ("x64_push_rip",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},@{theory}),
         close
           (var_a HOLogic.unitT,
            mb(call
                 ("ea_Zimm_rm",
                  @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                  tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("imm_rm",@{typ Zimm_rm})],
                  @{theory}),
               close
                 (var("v",@{typ Zea}),
                  call
                    ("jump_to_ea",
                     @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                     var("v",@{typ Zea}),@{theory})))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zcmpxchg",
   close
     (tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
      let'
        (var("ea_src",@{typ Zea}),
         call("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
         mb(call
              ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
               tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
            close
              (var("ea_dst",@{typ Zea}),
               mb(call
                    ("EA",
                     @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                     var("ea_dst",@{typ Zea}),@{theory}),
                  close
                    (var_w("val_dst",64),
                     mb(call
                          ("EA",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                           var("ea_src",@{typ Zea}),@{theory}),
                        close
                          (var_w("acc",64),
                           mb(call
                                ("write_binop",
                                 @{typ
                                 "Labelled_X64_state \<Rightarrow>
                                  (unit \<times> Labelled_X64_state)"},
                                 tp[var("size",@{typ Zsize}),lc("Zcmp","Zbinop_name",@{theory}),
                                    var_w("acc",64),var_w("val_dst",64),var("ea_src",@{typ Zea})],
                                 @{theory}),
                              close
                                (var_a HOLogic.unitT,
                                 ite(eq(var_w("acc",64),var_w("val_dst",64)),
                                     mb(call
                                          ("EA",
                                           @{typ
                                           "Labelled_X64_state \<Rightarrow>
                                            (64 word \<times> Labelled_X64_state)"},
                                           var("ea_src",@{typ Zea}),@{theory}),
                                        close
                                          (var_w("v",64),
                                           mb(mu(tp[var_w("v",64),var("ea_dst",@{typ Zea})],qTy),
                                              close
                                                (var("v",@{typ "64 word \<times> Zea"}),
                                                 call
                                                   ("write'EA",
                                                    @{typ
                                                    "Labelled_X64_state \<Rightarrow>
                                                     (unit \<times> Labelled_X64_state)"},
                                                    var("v",@{typ "64 word \<times> Zea"}),@{theory}))))),
                                     call
                                       ("write'EA",
                                        @{typ
                                        "Labelled_X64_state \<Rightarrow>
                                         (unit \<times> Labelled_X64_state)"},
                                        tp[var_w("val_dst",64),
                                           call
                                             ("Zea.Zea_r",@{typ Zea},
                                              tp[var("size",@{typ Zsize}),lc("RAX","Zreg",@{theory})],
                                              @{theory})],@{theory})))))))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zdiv",
   close
     (tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
      let'
        (var_n"w",call("value_width",HOLogic.natT,var("size",@{typ Zsize}),@{theory}),
         let'
           (var("ea_eax",@{typ Zea}),
            call
              ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),lc("RAX","Zreg",@{theory})],
               @{theory}),
            let'
              (var("ea_edx",@{typ Zea}),
               call
                 ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),lc("RAX","Zreg",@{theory})],
                  @{theory}),
               mb(call
                    ("EA",
                     @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                     var("ea_eax",@{typ Zea}),@{theory}),
                  close
                    (var_w("v",64),
                     mb(mb(mb(mu(mop(Cast HOLogic.natT,var_w("v",64)),qTy),
                              close(var_n"v",mu(bop(Mul,var_n"v",var_n"w"),qTy))),
                           close
                             (var_n"v",
                              mb(call
                                   ("EA",
                                    @{typ
                                    "Labelled_X64_state \<Rightarrow>
                                     (64 word \<times> Labelled_X64_state)"},
                                    var("ea_edx",@{typ Zea}),@{theory}),
                                 close
                                   (var_w("v0",64),
                                    mb(mu(mop(Cast HOLogic.natT,var_w("v0",64)),qTy),
                                       close(var_n"v0",mu(bop(Add,var_n"v",var_n"v0"),qTy))))))),
                        close
                          (var_n"n",
                           mb(call
                                ("ea_Zrm",
                                 @{typ
                                 "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                                 tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                              close
                                (var("v",@{typ Zea}),
                                 mb(mb(call
                                         ("EA",
                                          @{typ
                                          "Labelled_X64_state \<Rightarrow>
                                           (64 word \<times> Labelled_X64_state)"},
                                          var("v",@{typ Zea}),@{theory}),
                                       close
                                         (var_w("v",64),mu(mop(Cast HOLogic.natT,var_w("v",64)),qTy))),
                                    close
                                      (var_n"d",
                                       let'
                                         (var_n"q",bop(Div,var_n"n",var_n"d"),
                                          mb(ite(bop(Or,eq(var_n"d",ln 0),bop(Le,var_n"w",var_n"q")),
                                                 call
                                                   ("raise'exception",
                                                    @{typ
                                                    "Labelled_X64_state \<Rightarrow>
                                                     (unit \<times> Labelled_X64_state)"},
                                                    call
                                                      ("exception.FAILURE",@{typ exception},
                                                       ls"division",@{theory}),@{theory}),mu(lu,qTy)),
                                             close
                                               (var_a HOLogic.unitT,
                                                mb(call
                                                     ("write'EA",
                                                      @{typ
                                                      "Labelled_X64_state \<Rightarrow>
                                                       (unit \<times> Labelled_X64_state)"},
                                                      tp[mop(Cast w64,var_n"q"),
                                                         var("ea_eax",@{typ Zea})],@{theory}),
                                                   close
                                                     (var_a HOLogic.unitT,
                                                      mb(call
                                                           ("write'EA",
                                                            @{typ
                                                            "Labelled_X64_state \<Rightarrow>
                                                             (unit \<times> Labelled_X64_state)"},
                                                            tp[mop(Cast w64,
                                                                   bop(Mod,var_n"n",var_n"d")),
                                                               var("ea_edx",@{typ Zea})],@{theory}),
                                                         close
                                                           (var_a HOLogic.unitT,
                                                            const
                                                              ("erase_eflags",
                                                               @{typ
                                                               "Labelled_X64_state \<Rightarrow>
                                                                (unit \<times> Labelled_X64_state)"},
                                                               @{theory})))))))))))))))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zjcc",
   close
     (tp[var("cond",@{typ Zcond}),var_w("imm",64)],
      mb(call
           ("read_cond",
            @{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
            var("cond",@{typ Zcond}),@{theory}),
         close
           (var_b"b",
            ite(var_b"b",
                mb(mr(close(var("s",qTy),call("Labelled_X64_state.RIP",w64,var("s",qTy),@{theory}))),
                   close
                     (var_w("v",64),
                      mb(mu(bop(Add,var_w("v",64),var_w("imm",64)),qTy),
                         close
                           (var_w("v",64),
                            mw(close
                                 (var("s",qTy),
                                  rupd
                                    ("Labelled_X64_state.RIP",tp[var("s",qTy),var_w("v",64)],
                                     @{theory}))))))),mu(lu,qTy))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zjmp",
   close
     (var("rm",@{typ Zrm}),
      mb(call
           ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
            tp[Term.Const(@{const_name "Z64"},@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
         close
           (var("v",@{typ Zea}),
            mb(call
                 ("EA",
                  @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                  var("v",@{typ Zea}),@{theory}),
               close
                 (var_w("v",64),
                  mw(close
                       (var("s",qTy),
                        rupd("Labelled_X64_state.RIP",tp[var("s",qTy),var_w("v",64)],@{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zlea",
   close
     (tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],
      mb(call
           ("ea_Zsrc",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
            tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
         close
           (var("ea_src",@{typ Zea}),
            mb(call
                 ("ea_Zdest",
                  @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                  tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
               close
                 (var("ea_dst",@{typ Zea}),
                  call
                    ("write'EA",
                     @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                     tp[call("get_ea_address",w64,var("ea_src",@{typ Zea}),@{theory}),
                        var("ea_dst",@{typ Zea})],@{theory})))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zleave",
   mb(mr(close
           (var("s",qTy),
            call
              ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),@{theory}))),
      close
        (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
         mb(mb(mb(mr(close
                       (var("s",qTy),
                        call
                          ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                           var("s",qTy),@{theory}))),
                  close
                    (var("v0",@{typ "Zreg \<Rightarrow> 64 word"}),
                     mb(mu(apply
                             (var("v0",@{typ "Zreg \<Rightarrow> 64 word"}),
                              lc("RBP","Zreg",@{theory})),qTy),
                        close
                          (var_w("v0",64),
                           mu(fupd
                                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                 lc("RSP","Zreg",@{theory}),var_w("v0",64)),qTy))))),
               close
                 (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                  mw(close
                       (var("s",qTy),
                        rupd
                          ("Labelled_X64_state.REG",
                           tp[var("s",qTy),var("v",@{typ "Zreg \<Rightarrow> 64 word"})],@{theory}))))),
            close
              (var_a HOLogic.unitT,
               call
                 ("x64_pop",
                  @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                  call("Zrm.Zr",@{typ Zrm},lc("RBP","Zreg",@{theory}),@{theory}),@{theory}))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zloop",
   close
     (tp[var("cond",@{typ Zcond}),var_w("imm",64)],
      mb(mr(close
              (var("s",qTy),
               call
                 ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},var("s",qTy),
                  @{theory}))),
         close
           (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
            mb(mb(mu(apply(var("v",@{typ "Zreg \<Rightarrow> 64 word"}),lc("RCX","Zreg",@{theory})),
                     qTy),close(var_w("v",64),mu(bop(Sub,var_w("v",64),lw(1,64)),qTy))),
               close
                 (var_w("ecx1",64),
                  mb(mr(close
                          (var("s",qTy),
                           call
                             ("Labelled_X64_state.REG",@{typ "Zreg \<Rightarrow> 64 word"},
                              var("s",qTy),@{theory}))),
                     close
                       (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                        mb(mb(mu(fupd
                                   (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                    lc("RCX","Zreg",@{theory}),var_w("ecx1",64)),qTy),
                              close
                                (var("v",@{typ "Zreg \<Rightarrow> 64 word"}),
                                 mw(close
                                      (var("s",qTy),
                                       rupd
                                         ("Labelled_X64_state.REG",
                                          tp[var("s",qTy),
                                             var("v",@{typ "Zreg \<Rightarrow> 64 word"})],@{theory}))))),
                           close
                             (var_a HOLogic.unitT,
                              mb(call
                                   ("read_cond",
                                    @{typ
                                    "Labelled_X64_state \<Rightarrow>
                                     (bool \<times> Labelled_X64_state)"},var("cond",@{typ Zcond}),
                                    @{theory}),
                                 close
                                   (var_b"v",
                                    mb(mu(bop(And,mop(Not,eq(var_w("ecx1",64),lw(0,64))),var_b"v"),
                                          qTy),
                                       close
                                         (var_b"b",
                                          ite(var_b"b",
                                              mb(mr(close
                                                      (var("s",qTy),
                                                       call
                                                         ("Labelled_X64_state.RIP",w64,var("s",qTy),
                                                          @{theory}))),
                                                 close
                                                   (var_w("v",64),
                                                    mb(mu(bop(Add,var_w("v",64),var_w("imm",64)),qTy),
                                                       close
                                                         (var_w("v",64),
                                                          mw(close
                                                               (var("s",qTy),
                                                                rupd
                                                                  ("Labelled_X64_state.RIP",
                                                                   tp[var("s",qTy),var_w("v",64)],
                                                                   @{theory}))))))),mu(lu,qTy))))))))))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zmonop",
   close
     (tp[var("mop",@{typ Zmonop_name}),var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
      mb(call
           ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
            tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
         close
           (var("ea",@{typ Zea}),
            mb(call
                 ("EA",
                  @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                  var("ea",@{typ Zea}),@{theory}),
               close
                 (var_w("v",64),
                  mb(mb(mb(mu(tp[var_w("v",64),var("ea",@{typ Zea})],qTy),
                           close
                             (var("v",@{typ "64 word \<times> Zea"}),
                              mu(tp[var("mop",@{typ Zmonop_name}),
                                    var("v",@{typ "64 word \<times> Zea"})],qTy))),
                        close
                          (var("v",@{typ "Zmonop_name \<times> 64 word \<times> Zea"}),
                           mu(tp[var("size",@{typ Zsize}),
                                 var("v",@{typ "Zmonop_name \<times> 64 word \<times> Zea"})],qTy))),
                     close
                       (var("v",@{typ "Zsize \<times> Zmonop_name \<times> 64 word \<times> Zea"}),
                        call
                          ("write_monop",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                           var("v",@{typ "Zsize \<times> Zmonop_name \<times> 64 word \<times> Zea"}),
                           @{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zmov",
   close
     (tp[var("cond",@{typ Zcond}),var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],
      mb(call
           ("read_cond",
            @{typ "Labelled_X64_state \<Rightarrow> (bool \<times> Labelled_X64_state)"},
            var("cond",@{typ Zcond}),@{theory}),
         close
           (var_b"b",
            ite(var_b"b",
                mb(call
                     ("ea_Zsrc",
                      @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                      tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
                   close
                     (var("ea_src",@{typ Zea}),
                      mb(call
                           ("ea_Zdest",
                            @{typ
                            "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                            tp[var("size",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
                         close
                           (var("ea_dst",@{typ Zea}),
                            mb(call
                                 ("EA",
                                  @{typ
                                  "Labelled_X64_state \<Rightarrow>
                                   (64 word \<times> Labelled_X64_state)"},var("ea_src",@{typ Zea}),
                                  @{theory}),
                               close
                                 (var_w("v",64),
                                  mb(mu(tp[var_w("v",64),var("ea_dst",@{typ Zea})],qTy),
                                     close
                                       (var("v",@{typ "64 word \<times> Zea"}),
                                        call
                                          ("write'EA",
                                           @{typ
                                           "Labelled_X64_state \<Rightarrow>
                                            (unit \<times> Labelled_X64_state)"},
                                           var("v",@{typ "64 word \<times> Zea"}),@{theory}))))))))),
                mu(lu,qTy))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zmovsx",
   close
     (tp[var("size1",@{typ Zsize}),var("dst_src",@{typ Zdest_src}),var("size2",@{typ Zsize})],
      mb(call
           ("ea_Zdest",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
            tp[var("size2",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
         close
           (var("x",@{typ Zea}),
            mb(call
                 ("ea_Zsrc",
                  @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                  tp[var("size1",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
               close
                 (var("v",@{typ Zea}),
                  mb(mb(mb(mb(call
                                ("EA",
                                 @{typ
                                 "Labelled_X64_state \<Rightarrow>
                                  (64 word \<times> Labelled_X64_state)"},var("v",@{typ Zea}),
                                 @{theory}),
                              close
                                (var_w("v",64),
                                 mu(tp[var_w("v",64),var("size1",@{typ Zsize}),
                                       var("size2",@{typ Zsize})],qTy))),
                           close
                             (var("v",@{typ "64 word \<times> Zsize \<times> Zsize"}),
                              call
                                ("SignExtension",
                                 @{typ
                                 "Labelled_X64_state \<Rightarrow>
                                  (64 word \<times> Labelled_X64_state)"},
                                 var("v",@{typ "64 word \<times> Zsize \<times> Zsize"}),@{theory}))),
                        close(var_w("v",64),mu(tp[var_w("v",64),var("x",@{typ Zea})],qTy))),
                     close
                       (var("v",@{typ "64 word \<times> Zea"}),
                        call
                          ("write'EA",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                           var("v",@{typ "64 word \<times> Zea"}),@{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("dfn'Zmovzx",
   close
     (tp[var("size1",@{typ Zsize}),var("dst_src",@{typ Zdest_src}),var("size2",@{typ Zsize})],
      mb(call
           ("ea_Zdest",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
            tp[var("size2",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
         close
           (var("x",@{typ Zea}),
            mb(call
                 ("ea_Zsrc",
                  @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                  tp[var("size1",@{typ Zsize}),var("dst_src",@{typ Zdest_src})],@{theory}),
               close
                 (var("v",@{typ Zea}),
                  mb(mb(call
                          ("EA",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                           var("v",@{typ Zea}),@{theory}),
                        close(var_w("v",64),mu(tp[var_w("v",64),var("x",@{typ Zea})],qTy))),
                     close
                       (var("v",@{typ "64 word \<times> Zea"}),
                        call
                          ("write'EA",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                           var("v",@{typ "64 word \<times> Zea"}),@{theory})))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zmul",
   close
     (tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],
      let'
        (var("ea_eax",@{typ Zea}),
         call
           ("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),lc("RAX","Zreg",@{theory})],@{theory}),
         mb(call
              ("EA",@{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
               var("ea_eax",@{typ Zea}),@{theory}),
            close
              (var_w("eax",64),
               mb(call
                    ("ea_Zrm",
                     @{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
                     tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
                  close
                    (var("v",@{typ Zea}),
                     mb(call
                          ("EA",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                           var("v",@{typ Zea}),@{theory}),
                        close
                          (var_w("val_src",64),
                           mb(cs(var("size",@{typ Zsize}),
                                 [(call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
                                   call
                                     ("write'EA",
                                      @{typ
                                      "Labelled_X64_state \<Rightarrow>
                                       (unit \<times> Labelled_X64_state)"},
                                      tp[bop(Mul,var_w("eax",64),var_w("val_src",64)),
                                         call
                                           ("Zea.Zea_r",@{typ Zea},
                                            tp[Term.Const(@{const_name "Z16"},@{typ Zsize}),
                                               lc("RAX","Zreg",@{theory})],@{theory})],@{theory})),
                                  (var_a @{typ Zsize},
                                   mb(call
                                        ("write'EA",
                                         @{typ
                                         "Labelled_X64_state \<Rightarrow>
                                          (unit \<times> Labelled_X64_state)"},
                                         tp[bop(Mul,var_w("eax",64),var_w("val_src",64)),
                                            var("ea_eax",@{typ Zea})],@{theory}),
                                      close
                                        (var_a HOLogic.unitT,
                                         call
                                           ("write'EA",
                                            @{typ
                                            "Labelled_X64_state \<Rightarrow>
                                             (unit \<times> Labelled_X64_state)"},
                                            tp[mop(Cast w64,
                                                   bop(Div,
                                                       bop(Mul,
                                                           mop(Cast HOLogic.natT,var_w("eax",64)),
                                                           mop(Cast HOLogic.natT,var_w("val_src",64))),
                                                       call
                                                         ("value_width",HOLogic.natT,
                                                          var("size",@{typ Zsize}),@{theory}))),
                                               call
                                                 ("Zea.Zea_r",@{typ Zea},
                                                  tp[var("size",@{typ Zsize}),
                                                     lc("RDX","Zreg",@{theory})],@{theory})],
                                            @{theory}))))],@{context}),
                              close
                                (var_a HOLogic.unitT,
                                 const
                                   ("erase_eflags",
                                    @{typ
                                    "Labelled_X64_state \<Rightarrow>
                                     (unit \<times> Labelled_X64_state)"},@{theory}))))))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def ("dfn'Znop",lu)
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zpop",
   close
     (var("rm",@{typ Zrm}),
      call
        ("x64_pop",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         var("rm",@{typ Zrm}),@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zpush",
   close
     (var("imm_rm",@{typ Zimm_rm}),
      call
        ("x64_push",@{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
         var("imm_rm",@{typ Zimm_rm}),@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zret",
   close
     (var_w("imm",64),
      mb(const
           ("x64_pop_rip",
            @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},@{theory}),
         close
           (var_a HOLogic.unitT,
            call
              ("x64_drop",
               @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
               var_w("imm",64),@{theory})))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zxadd",
   close
     (tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
      let'
        (var("ea_src",@{typ Zea}),
         call("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
         mb(call
              ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
               tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
            close
              (var("ea_dst",@{typ Zea}),
               mb(call
                    ("EA",
                     @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                     var("ea_src",@{typ Zea}),@{theory}),
                  close
                    (var_w("val_src",64),
                     mb(call
                          ("EA",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                           var("ea_dst",@{typ Zea}),@{theory}),
                        close
                          (var_w("val_dst",64),
                           mb(call
                                ("write'EA",
                                 @{typ
                                 "Labelled_X64_state \<Rightarrow>
                                  (unit \<times> Labelled_X64_state)"},
                                 tp[var_w("val_dst",64),var("ea_src",@{typ Zea})],@{theory}),
                              close
                                (var_a HOLogic.unitT,
                                 call
                                   ("write_binop",
                                    @{typ
                                    "Labelled_X64_state \<Rightarrow>
                                     (unit \<times> Labelled_X64_state)"},
                                    tp[var("size",@{typ Zsize}),lc("Zadd","Zbinop_name",@{theory}),
                                       var_w("val_src",64),var_w("val_dst",64),
                                       var("ea_dst",@{typ Zea})],@{theory}))))))))))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("dfn'Zxchg",
   close
     (tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm}),var("r",@{typ Zreg})],
      let'
        (var("ea_src",@{typ Zea}),
         call("Zea.Zea_r",@{typ Zea},tp[var("size",@{typ Zsize}),var("r",@{typ Zreg})],@{theory}),
         mb(call
              ("ea_Zrm",@{typ "Labelled_X64_state \<Rightarrow> (Zea \<times> Labelled_X64_state)"},
               tp[var("size",@{typ Zsize}),var("rm",@{typ Zrm})],@{theory}),
            close
              (var("ea_dst",@{typ Zea}),
               mb(call
                    ("EA",
                     @{typ "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                     var("ea_src",@{typ Zea}),@{theory}),
                  close
                    (var_w("val_src",64),
                     mb(call
                          ("EA",
                           @{typ
                           "Labelled_X64_state \<Rightarrow> (64 word \<times> Labelled_X64_state)"},
                           var("ea_dst",@{typ Zea}),@{theory}),
                        close
                          (var_w("val_dst",64),
                           mb(call
                                ("write'EA",
                                 @{typ
                                 "Labelled_X64_state \<Rightarrow>
                                  (unit \<times> Labelled_X64_state)"},
                                 tp[var_w("val_dst",64),var("ea_src",@{typ Zea})],@{theory}),
                              close
                                (var_a HOLogic.unitT,
                                 call
                                   ("write'EA",
                                    @{typ
                                    "Labelled_X64_state \<Rightarrow>
                                     (unit \<times> Labelled_X64_state)"},
                                    tp[var_w("val_src",64),var("ea_dst",@{typ Zea})],@{theory}))))))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("Run",
   close
     (var("v0",@{typ instruction}),
      cs(var("v0",@{typ instruction}),
         [(Term.Const(@{const_name "Zleave"},@{typ instruction}),
           const
             ("dfn'Zleave",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},@{theory})),
          (Term.Const(@{const_name "Znop"},@{typ instruction}),
           mu(const("dfn'Znop",HOLogic.unitT,@{theory}),qTy)),
          (call
             ("instruction.Zbinop",@{typ instruction},
              var("v1",@{typ "Zbinop_name \<times> Zsize \<times> Zdest_src"}),@{theory}),
           call
             ("dfn'Zbinop",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v1",@{typ "Zbinop_name \<times> Zsize \<times> Zdest_src"}),@{theory})),
          (call("instruction.Zcall",@{typ instruction},var("v2",@{typ Zimm_rm}),@{theory}),
           call
             ("dfn'Zcall",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v2",@{typ Zimm_rm}),@{theory})),
          (call
             ("instruction.Zcmpxchg",@{typ instruction},
              var("v3",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
           call
             ("dfn'Zcmpxchg",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v3",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory})),
          (call
             ("instruction.Zdiv",@{typ instruction},var("v4",@{typ "Zsize \<times> Zrm"}),@{theory}),
           call
             ("dfn'Zdiv",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v4",@{typ "Zsize \<times> Zrm"}),@{theory})),
          (call
             ("instruction.Zjcc",@{typ instruction},var("v5",@{typ "Zcond \<times> 64 word"}),
              @{theory}),
           call
             ("dfn'Zjcc",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v5",@{typ "Zcond \<times> 64 word"}),@{theory})),
          (call("instruction.Zjmp",@{typ instruction},var("v6",@{typ Zrm}),@{theory}),
           call
             ("dfn'Zjmp",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v6",@{typ Zrm}),@{theory})),
          (call
             ("instruction.Zlea",@{typ instruction},var("v7",@{typ "Zsize \<times> Zdest_src"}),
              @{theory}),
           call
             ("dfn'Zlea",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v7",@{typ "Zsize \<times> Zdest_src"}),@{theory})),
          (call
             ("instruction.Zloop",@{typ instruction},var("v8",@{typ "Zcond \<times> 64 word"}),
              @{theory}),
           call
             ("dfn'Zloop",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v8",@{typ "Zcond \<times> 64 word"}),@{theory})),
          (call
             ("instruction.Zmonop",@{typ instruction},
              var("v9",@{typ "Zmonop_name \<times> Zsize \<times> Zrm"}),@{theory}),
           call
             ("dfn'Zmonop",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v9",@{typ "Zmonop_name \<times> Zsize \<times> Zrm"}),@{theory})),
          (call
             ("instruction.Zmov",@{typ instruction},
              var("v10",@{typ "Zcond \<times> Zsize \<times> Zdest_src"}),@{theory}),
           call
             ("dfn'Zmov",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v10",@{typ "Zcond \<times> Zsize \<times> Zdest_src"}),@{theory})),
          (call
             ("instruction.Zmovsx",@{typ instruction},
              var("v11",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory}),
           call
             ("dfn'Zmovsx",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v11",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory})),
          (call
             ("instruction.Zmovzx",@{typ instruction},
              var("v12",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory}),
           call
             ("dfn'Zmovzx",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v12",@{typ "Zsize \<times> Zdest_src \<times> Zsize"}),@{theory})),
          (call
             ("instruction.Zmul",@{typ instruction},var("v13",@{typ "Zsize \<times> Zrm"}),@{theory}),
           call
             ("dfn'Zmul",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v13",@{typ "Zsize \<times> Zrm"}),@{theory})),
          (call("instruction.Zpop",@{typ instruction},var("v14",@{typ Zrm}),@{theory}),
           call
             ("dfn'Zpop",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v14",@{typ Zrm}),@{theory})),
          (call("instruction.Zpush",@{typ instruction},var("v15",@{typ Zimm_rm}),@{theory}),
           call
             ("dfn'Zpush",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v15",@{typ Zimm_rm}),@{theory})),
          (call("instruction.Zret",@{typ instruction},var_w("v16",64),@{theory}),
           call
             ("dfn'Zret",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var_w("v16",64),@{theory})),
          (call
             ("instruction.Zxadd",@{typ instruction},
              var("v17",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
           call
             ("dfn'Zxadd",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v17",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory})),
          (call
             ("instruction.Zxchg",@{typ instruction},
              var("v18",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}),
           call
             ("dfn'Zxchg",
              @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
              var("v18",@{typ "Zsize \<times> Zrm \<times> Zreg"}),@{theory}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("immediate8",
   close
     (var("strm",@{typ "8 word list"}),
      cs(var("strm",@{typ "8 word list"}),
         [(llc([var_w("b",8)],var("t",@{typ "8 word list"})),
           tp[mop(SE w64,var_w("b",8)),var("t",@{typ "8 word list"})]),
          (var_a(@{typ "8 word list"}),lx(@{typ "64 word \<times> 8 word list"}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("immediate16",
   close
     (var("strm",@{typ "8 word list"}),
      cs(var("strm",@{typ "8 word list"}),
         [(llc([var_w("b1",8),var_w("b2",8)],var("t",@{typ "8 word list"})),
           tp[mop(SE w64,cc[var_w("b2",8),var_w("b1",8)]),var("t",@{typ "8 word list"})]),
          (var_a(@{typ "8 word list"}),lx(@{typ "64 word \<times> 8 word list"}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("immediate32",
   close
     (var("strm",@{typ "8 word list"}),
      cs(var("strm",@{typ "8 word list"}),
         [(llc([var_w("b1",8),var_w("b2",8),var_w("b3",8),var_w("b4",8)],
               var("t",@{typ "8 word list"})),
           tp[mop(SE w64,cc[var_w("b4",8),var_w("b3",8),var_w("b2",8),var_w("b1",8)]),
              var("t",@{typ "8 word list"})]),
          (var_a(@{typ "8 word list"}),lx(@{typ "64 word \<times> 8 word list"}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("immediate64",
   close
     (var("strm",@{typ "8 word list"}),
      cs(var("strm",@{typ "8 word list"}),
         [(llc([var_w("b1",8),var_w("b2",8),var_w("b3",8),var_w("b4",8),var_w("b5",8),var_w("b6",8),
                var_w("b7",8),var_w("b8",8)],var("t",@{typ "8 word list"})),
           tp[cc[var_w("b8",8),var_w("b7",8),var_w("b6",8),var_w("b5",8),var_w("b4",8),
                 var_w("b3",8),var_w("b2",8),var_w("b1",8)],var("t",@{typ "8 word list"})]),
          (var_a(@{typ "8 word list"}),lx(@{typ "64 word \<times> 8 word list"}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("immediate",
   close
     (tp[var("size",@{typ Zsize}),var("strm",@{typ "8 word list"})],
      cs(var("size",@{typ Zsize}),
         [(call("Zsize.Z8",@{typ Zsize},var_a HOLogic.boolT,@{theory}),
           call
             ("immediate8",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
              @{theory})),
          (Term.Const(@{const_name "Z16"},@{typ Zsize}),
           call
             ("immediate16",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
              @{theory})),
          (var_a @{typ Zsize},
           call
             ("immediate32",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
              @{theory}))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("full_immediate",
   close
     (tp[var("size",@{typ Zsize}),var("strm",@{typ "8 word list"})],
      ite(eq(var("size",@{typ Zsize}),Term.Const(@{const_name "Z64"},@{typ Zsize})),
          call
            ("immediate64",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
             @{theory}),
          call
            ("immediate",@{typ "64 word \<times> 8 word list"},
             tp[var("size",@{typ Zsize}),var("strm",@{typ "8 word list"})],@{theory}))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("rec'REX",
   close
     (var_w("x",4),
      record
        ("REX",
         [bop(Bit,var_w("x",4),ln 0),bop(Bit,var_w("x",4),ln 2),bop(Bit,var_w("x",4),ln 3),
          bop(Bit,var_w("x",4),ln 1)],@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("reg'REX",
   close
     (var("x",@{typ REX}),
      cc[mop(Cast w1,call("REX.W",HOLogic.boolT,var("x",@{typ REX}),@{theory})),
         mop(Cast w1,call("REX.R",HOLogic.boolT,var("x",@{typ REX}),@{theory})),
         mop(Cast w1,call("REX.X",HOLogic.boolT,var("x",@{typ REX}),@{theory})),
         mop(Cast w1,call("REX.B",HOLogic.boolT,var("x",@{typ REX}),@{theory}))]))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'rec'REX",
   close(tp[var_a w4,var("x",@{typ REX})],call("reg'REX",w4,var("x",@{typ REX}),@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("write'reg'REX",
   close(tp[var_a @{typ REX},var_w("x",4)],call("rec'REX",@{typ REX},var_w("x",4),@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("RexReg",
   close(tp[var_b"b",var_w("r",3)],mop(Cast @{typ Zreg},cc[mop(Cast w1,var_b"b"),var_w("r",3)])))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("readDisplacement",
   close
     (tp[var_w("Mod",2),var("strm",@{typ "8 word list"})],
      itb([(eq(var_w("Mod",2),lw(1,2)),
            call
              ("immediate8",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
               @{theory})),
           (eq(var_w("Mod",2),lw(2,2)),
            call
              ("immediate32",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
               @{theory}))],tp[lw(0,64),var("strm",@{typ "8 word list"})])))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("readSibDisplacement",
   close
     (tp[var_b"w",var_w("Mod",2),var("strm",@{typ "8 word list"})],
      itb([(bop(And,eq(var_w("Mod",2),lw(0,2)),mop(Not,var_b"w")),
            tp[lw(0,64),var("strm",@{typ "8 word list"})]),
           (eq(var_w("Mod",2),lw(1,2)),
            call
              ("immediate8",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
               @{theory}))],
          call
            ("immediate32",@{typ "64 word \<times> 8 word list"},var("strm",@{typ "8 word list"}),
             @{theory}))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("readSIB",
   close
     (tp[var("REX",@{typ REX}),var_w("Mod",2),var("strm",@{typ "8 word list"})],
      cs(var("strm",@{typ "8 word list"}),
         [(llc([var_w("v#0",8)],var("v#1",@{typ "8 word list"})),
           cs(tp[call
                   ("boolify'8",
                    @{typ
                    "bool \<times>
                     bool \<times>
                     bool \<times> bool \<times> bool \<times> bool \<times> bool \<times> bool"},
                    var_w("v#0",8),@{theory}),var("v#1",@{typ "8 word list"})],
              [(tp[tp[var_b"SS'1",var_b"SS'0",var_b"Index'2",var_b"Index'1",var_b"Index'0",
                      var_b"Base'2",var_b"Base'1",var_b"Base'0"],var("strm1",@{typ "8 word list"})],
                let'
                  (var("base",@{typ Zreg}),
                   call
                     ("RexReg",@{typ Zreg},
                      tp[call("REX.B",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                         mop(Cast (Word_Lib.mk_wordT 3),
                             ll[var_b"Base'2",var_b"Base'1",var_b"Base'0"])],@{theory}),
                   let'
                     (var("index",@{typ Zreg}),
                      call
                        ("RexReg",@{typ Zreg},
                         tp[call("REX.X",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                            mop(Cast (Word_Lib.mk_wordT 3),
                                ll[var_b"Index'2",var_b"Index'1",var_b"Index'0"])],@{theory}),
                      let'
                        (var("scaled_index",@{typ "(2 word \<times> Zreg) option"}),
                         ite(eq(var("index",@{typ Zreg}),lc("RSP","Zreg",@{theory})),
                             lo(@{typ "2 word \<times> Zreg"}),
                             mop(Some,
                                 tp[mop(Cast (Word_Lib.mk_wordT 2),ll[var_b"SS'1",var_b"SS'0"]),
                                    var("index",@{typ Zreg})])),
                         ite(eq(var("base",@{typ Zreg}),lc("RBP","Zreg",@{theory})),
                             let'
                               (tp[var_w("displacement",64),var("strm2",@{typ "8 word list"})],
                                call
                                  ("readSibDisplacement",@{typ "64 word \<times> 8 word list"},
                                   tp[call("REX.W",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                                      var_w("Mod",2),var("strm1",@{typ "8 word list"})],@{theory}),
                                tp[call
                                     ("Zrm.Zm",@{typ Zrm},
                                      tp[var("scaled_index",@{typ "(2 word \<times> Zreg) option"}),
                                         ite(eq(var_w("Mod",2),lw(0,2)),
                                             Term.Const(@{const_name "ZnoBase"},@{typ Zbase}),
                                             call
                                               ("Zbase.ZregBase",@{typ Zbase},
                                                var("base",@{typ Zreg}),@{theory})),
                                         var_w("displacement",64)],@{theory}),
                                   var("strm2",@{typ "8 word list"})]),
                             let'
                               (tp[var_w("displacement",64),var("strm2",@{typ "8 word list"})],
                                call
                                  ("readDisplacement",@{typ "64 word \<times> 8 word list"},
                                   tp[var_w("Mod",2),var("strm1",@{typ "8 word list"})],@{theory}),
                                tp[call
                                     ("Zrm.Zm",@{typ Zrm},
                                      tp[var("scaled_index",@{typ "(2 word \<times> Zreg) option"}),
                                         call
                                           ("Zbase.ZregBase",@{typ Zbase},var("base",@{typ Zreg}),
                                            @{theory}),var_w("displacement",64)],@{theory}),
                                   var("strm2",@{typ "8 word list"})]))))))],@{context})),
          (var_a(@{typ "8 word list"}),tp[lx @{typ Zrm},var("strm",@{typ "8 word list"})])],
         @{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("readModRM",
   close
     (tp[var("REX",@{typ REX}),var("strm",@{typ "8 word list"})],
      cs(var("strm",@{typ "8 word list"}),
         [(llc([var_w("v#0",8)],var("v#1",@{typ "8 word list"})),
           cs(tp[call
                   ("boolify'8",
                    @{typ
                    "bool \<times>
                     bool \<times>
                     bool \<times> bool \<times> bool \<times> bool \<times> bool \<times> bool"},
                    var_w("v#0",8),@{theory}),var("v#1",@{typ "8 word list"})],
              [(tp[tp[lf,lf,var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0",lt,lf,lt],
                   var("strm1",@{typ "8 word list"})],
                let'
                  (tp[var_w("displacement",64),var("strm2",@{typ "8 word list"})],
                   call
                     ("immediate32",@{typ "64 word \<times> 8 word list"},
                      var("strm1",@{typ "8 word list"}),@{theory}),
                   tp[call
                        ("RexReg",@{typ Zreg},
                         tp[call("REX.R",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                            mop(Cast (Word_Lib.mk_wordT 3),
                                ll[var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0"])],@{theory}),
                      call
                        ("Zrm.Zm",@{typ Zrm},
                         tp[lo(@{typ "2 word \<times> Zreg"}),
                            Term.Const(@{const_name "ZripBase"},@{typ Zbase}),
                            var_w("displacement",64)],@{theory}),var("strm2",@{typ "8 word list"})])),
               (tp[tp[lt,lt,var_b"REG'2",var_b"REG'1",var_b"REG'0",var_b"RM'2",var_b"RM'1",
                      var_b"RM'0"],var("strm1",@{typ "8 word list"})],
                tp[call
                     ("RexReg",@{typ Zreg},
                      tp[call("REX.R",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                         mop(Cast (Word_Lib.mk_wordT 3),ll[var_b"REG'2",var_b"REG'1",var_b"REG'0"])],
                      @{theory}),
                   call
                     ("Zrm.Zr",@{typ Zrm},
                      call
                        ("RexReg",@{typ Zreg},
                         tp[call("REX.B",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                            mop(Cast (Word_Lib.mk_wordT 3),ll[var_b"RM'2",var_b"RM'1",var_b"RM'0"])],
                         @{theory}),@{theory}),var("strm1",@{typ "8 word list"})]),
               (tp[tp[var_b"Mod'1",var_b"Mod'0",var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0",lt,
                      lf,lf],var("strm1",@{typ "8 word list"})],
                let'
                  (tp[var("sib",@{typ Zrm}),var("strm2",@{typ "8 word list"})],
                   call
                     ("readSIB",@{typ "Zrm \<times> 8 word list"},
                      tp[var("REX",@{typ REX}),
                         mop(Cast (Word_Lib.mk_wordT 2),ll[var_b"Mod'1",var_b"Mod'0"]),
                         var("strm1",@{typ "8 word list"})],@{theory}),
                   tp[call
                        ("RexReg",@{typ Zreg},
                         tp[call("REX.R",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                            mop(Cast (Word_Lib.mk_wordT 3),
                                ll[var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0"])],@{theory}),
                      var("sib",@{typ Zrm}),var("strm2",@{typ "8 word list"})])),
               (tp[tp[var_b"Mod'1",var_b"Mod'0",var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0",
                      var_b"RM'2",var_b"RM'1",var_b"RM'0"],var("strm1",@{typ "8 word list"})],
                let'
                  (tp[var_w("displacement",64),var("strm2",@{typ "8 word list"})],
                   call
                     ("readDisplacement",@{typ "64 word \<times> 8 word list"},
                      tp[mop(Cast (Word_Lib.mk_wordT 2),ll[var_b"Mod'1",var_b"Mod'0"]),
                         var("strm1",@{typ "8 word list"})],@{theory}),
                   tp[call
                        ("RexReg",@{typ Zreg},
                         tp[call("REX.R",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                            mop(Cast (Word_Lib.mk_wordT 3),
                                ll[var_b"RegOpc'2",var_b"RegOpc'1",var_b"RegOpc'0"])],@{theory}),
                      call
                        ("Zrm.Zm",@{typ Zrm},
                         tp[lo(@{typ "2 word \<times> Zreg"}),
                            call
                              ("Zbase.ZregBase",@{typ Zbase},
                               call
                                 ("RexReg",@{typ Zreg},
                                  tp[call("REX.B",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                                     mop(Cast (Word_Lib.mk_wordT 3),
                                         ll[var_b"RM'2",var_b"RM'1",var_b"RM'0"])],@{theory}),
                               @{theory}),var_w("displacement",64)],@{theory}),
                      var("strm2",@{typ "8 word list"})]))],@{context})),
          (var_a(@{typ "8 word list"}),
           tp[lx @{typ Zreg},lx @{typ Zrm},var("strm",@{typ "8 word list"})])],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("readOpcodeModRM",
   close
     (tp[var("REX",@{typ REX}),var("strm",@{typ "8 word list"})],
      let'
        (tp[var("opcode",@{typ Zreg}),var("rm",@{typ Zrm}),var("strm1",@{typ "8 word list"})],
         call
           ("readModRM",@{typ "Zreg \<times> Zrm \<times> 8 word list"},
            tp[var("REX",@{typ REX}),var("strm",@{typ "8 word list"})],@{theory}),
         tp[mop(Cast (Word_Lib.mk_wordT 3),
                bop(Mod,mop(Cast HOLogic.natT,var("opcode",@{typ Zreg})),ln 8)),
            var("rm",@{typ Zrm}),var("strm1",@{typ "8 word list"})])))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("prefixGroup",
   close
     (var_w("b",8),
      itb([(eq(var_w("b",8),lw(240,8)),ln 1),(eq(var_w("b",8),lw(242,8)),ln 1),
           (eq(var_w("b",8),lw(243,8)),ln 1),(eq(var_w("b",8),lw(38,8)),ln 2),
           (eq(var_w("b",8),lw(46,8)),ln 2),(eq(var_w("b",8),lw(54,8)),ln 2),
           (eq(var_w("b",8),lw(62,8)),ln 2),(eq(var_w("b",8),lw(100,8)),ln 2),
           (eq(var_w("b",8),lw(101,8)),ln 2),(eq(var_w("b",8),lw(102,8)),ln 3),
           (eq(var_w("b",8),lw(103,8)),ln 4),(eq(ex(var_w("b",8),ln 7,ln 4,w4),lw(4,4)),ln 5)],ln 0)))
end
\<close>

ML \<open>
local 
open L3 
in
val () = function
  ("readPrefix",
   tp[var("s",@{typ "nat set"}),var("p",@{typ "8 word list"}),var("strm",@{typ "8 word list"})],
   cs(var("strm",@{typ "8 word list"}),
      [(llc([var_w("h",8)],var("strm1",@{typ "8 word list"})),
        let'
          (var_n"group",call("prefixGroup",HOLogic.natT,var_w("h",8),@{theory}),
           itb([(eq(var_n"group",ln 0),
                 mop(Some,
                     tp[var("p",@{typ "8 word list"}),lf,
                        call("rec'REX",@{typ REX},lw(0,4),@{theory}),
                        var("strm",@{typ "8 word list"})])),
                (eq(var_n"group",ln 5),
                 mop(Some,
                     tp[var("p",@{typ "8 word list"}),lt,
                        call("rec'REX",@{typ REX},ex(var_w("h",8),ln 3,ln 0,w4),@{theory}),
                        var("strm1",@{typ "8 word list"})])),
                (bop(In,var_n"group",var("s",@{typ "nat set"})),
                 lo(@{typ "(8 word list) \<times> bool \<times> REX \<times> 8 word list"}))],
               apply
                 (var("readPrefix",
                      @{typ
                      "((nat set) \<times> (8 word list) \<times> 8 word list) \<Rightarrow>
                       (((8 word list) \<times> bool \<times> REX \<times> 8 word list) option)"}),
                  tp[bop(Insert,var_n"group",var("s",@{typ "nat set"})),
                     llc([var_w("h",8)],var("p",@{typ "8 word list"})),
                     var("strm1",@{typ "8 word list"})])))),
       (lnl w8,
        mop(Some,tp[var("p",@{typ "8 word list"}),lf,lx @{typ REX},var("strm",@{typ "8 word list"})]))],
      @{context}))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("readPrefixes",
   close
     (var("strm",@{typ "8 word list"}),
      call
        ("readPrefix",
         @{typ "((8 word list) \<times> bool \<times> REX \<times> 8 word list) option"},
         tp[le HOLogic.natT,lnl w8,var("strm",@{typ "8 word list"})],@{theory})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("OpSize",
   close
     (tp[var_b"have_rex",var_b"w",var_w("v",1),var_b"override"],
      itb([(eq(var_w("v",1),lw(0,1)),call("Zsize.Z8",@{typ Zsize},var_b"have_rex",@{theory})),
           (var_b"w",Term.Const(@{const_name "Z64"},@{typ Zsize})),
           (var_b"override",Term.Const(@{const_name "Z16"},@{typ Zsize}))],
          Term.Const(@{const_name "Z32"},@{typ Zsize}))))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("isZm",
   close
     (var("rm",@{typ Zrm}),
      cs(var("rm",@{typ Zrm}),
         [(call
             ("Zrm.Zm",@{typ Zrm},
              var_a(@{typ "((2 word \<times> Zreg) option) \<times> Zbase \<times> 64 word"}),
              @{theory}),lt),(var_a @{typ Zrm},lf)],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("x64_decode",
   close
     (var("strm",@{typ "8 word list"}),
      cs(call
           ("readPrefixes",
            @{typ "((8 word list) \<times> bool \<times> REX \<times> 8 word list) option"},
            var("strm",@{typ "8 word list"}),@{theory}),
         [(lo(@{typ "(8 word list) \<times> bool \<times> REX \<times> 8 word list"}),
           call("Zinst.Zdec_fail",@{typ Zinst},ls"Bad prefix",@{theory})),
          (mop(Some,
               tp[var("p",@{typ "8 word list"}),var_b"have_rex",var("REX",@{typ REX}),
                  var("strm1",@{typ "8 word list"})]),
           let'
             (var("prefixes",@{typ "8 word set"}),mop(SofL,var("p",@{typ "8 word list"})),
              let'
                (var_b"op_size_override",bop(In,lw(102,8),var("prefixes",@{typ "8 word set"})),
                 itb([(bop(And,call("REX.W",HOLogic.boolT,var("REX",@{typ REX}),@{theory}),
                           var_b"op_size_override"),
                       call
                         ("Zinst.Zdec_fail",@{typ Zinst},ls"REX.W together with override prefix",
                          @{theory})),
                      (bop(In,lw(103,8),var("prefixes",@{typ "8 word set"})),
                       call
                         ("Zinst.Zdec_fail",@{typ Zinst},ls"address override prefix not supported",
                          @{theory}))],
                     cs(var("strm1",@{typ "8 word list"}),
                        [(llc([var_w("v#0",8)],var("v#1",@{typ "8 word list"})),
                          let'
                            (tp[tp[var_b"v#0",var_b"v#1",var_b"v#2",var_b"v#3",var_b"v#4",
                                   var_b"v#5",var_b"v#6",var_b"v#7"],var("v#8",@{typ "8 word list"})],
                             tp[call
                                  ("boolify'8",
                                   @{typ
                                   "bool \<times>
                                    bool \<times>
                                    bool \<times>
                                    bool \<times> bool \<times> bool \<times> bool \<times> bool"},
                                   var_w("v#0",8),@{theory}),var("v#1",@{typ "8 word list"})],
                             cs(var("v#8",@{typ "8 word list"}),
                                [(llc([var_w("v#9",8)],var("v#10",@{typ "8 word list"})),
                                  cs(tp[tp[var_w("v#9",8),var("v#10",@{typ "8 word list"})],
                                        var_b"v#0",var_b"v#1",var_b"v#2",var_b"v#3",var_b"v#4",
                                        var_b"v#5",var_b"v#6",var_b"v#7"],
                                     [(tp[tp[var_w("v#69",8),var("v#70",@{typ "8 word list"})],lt,
                                          lf,lt,lt,var_b"v'0",var_b"r'2",var_b"r'1",var_b"r'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                             call
                                               ("full_immediate",
                                                @{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),
                                                   llc([var_w("v#69",8)],
                                                       var("v#70",@{typ "8 word list"}))],@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zmov",@{typ instruction},
                                                      tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                         var("size",@{typ Zsize}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[call
                                                                 ("Zrm.Zr",@{typ Zrm},
                                                                  mop(Cast @{typ Zreg},
                                                                      cc[mop(Cast w1,
                                                                             call
                                                                               ("REX.B",
                                                                                HOLogic.boolT,
                                                                                var("REX",@{typ REX}),
                                                                                @{theory})),
                                                                         mop(Cast
                                                                               (Word_Lib.mk_wordT 3),
                                                                             ll[var_b"r'2",
                                                                                var_b"r'1",
                                                                                var_b"r'0"])]),
                                                                  @{theory}),var_w("imm",64)],
                                                            @{theory})],@{theory}),
                                                   var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[tp[var_w("v#53",8),var("v#54",@{typ "8 word list"})],lt,
                                          lf,lf,lf,lf,lf,lt,lt],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#53",8)],
                                                    var("v#54",@{typ "8 word list"}))],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm4",@{typ "8 word list"})],
                                             call
                                               ("immediate8",@{typ "64 word \<times> 8 word list"},
                                                var("strm3",@{typ "8 word list"}),@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zbinop",@{typ instruction},
                                                      tp[mop(Cast @{typ Zbinop_name},
                                                             var_w("opcode",3)),
                                                         call
                                                           ("OpSize",@{typ Zsize},
                                                            tp[lf,
                                                               call
                                                                 ("REX.W",HOLogic.boolT,
                                                                  var("REX",@{typ REX}),@{theory}),
                                                               lw(1,1),var_b"op_size_override"],
                                                            @{theory}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[var("rm",@{typ Zrm}),var_w("imm",64)],
                                                            @{theory})],@{theory}),
                                                   var("strm4",@{typ "8 word list"})],@{theory})))),
                                      (tp[tp[var_w("v#85",8),var("v#86",@{typ "8 word list"})],lt,
                                          lt,lt,lf,lt,lf,lf,lf],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate32",@{typ "64 word \<times> 8 word list"},
                                             llc([var_w("v#85",8)],var("v#86",@{typ "8 word list"})),
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zcall",@{typ instruction},
                                                   call
                                                     ("Zimm_rm.Zimm",@{typ Zimm_rm},var_w("imm",64),
                                                      @{theory}),@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory}))),
                                      (tp[tp[var_w("v#45",8),var("v#46",@{typ "8 word list"})],lf,
                                          lt,lt,lf,lf,lf,lt,lt],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#45",8)],
                                                    var("v#46",@{typ "8 word list"}))],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zmovsx",@{typ instruction},
                                                   tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),
                                                      call
                                                        ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                         tp[var("reg",@{typ Zreg}),
                                                            var("rm",@{typ Zrm})],@{theory}),
                                                      Term.Const(@{const_name "Z64"},@{typ Zsize})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[tp[var_w("v#77",8),var("v#78",@{typ "8 word list"})],lt,
                                          lt,lf,lf,lt,lf,lf,lt],
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             Term.Const(@{const_name "Zleave"},@{typ instruction}),
                                             llc([var_w("v#77",8)],var("v#78",@{typ "8 word list"}))],
                                          @{theory})),
                                      (tp[tp[var_w("v#61",8),var("v#62",@{typ "8 word list"})],lt,
                                          lf,lf,lf,lt,lt,lf,lt],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#61",8)],
                                                    var("v#62",@{typ "8 word list"}))],@{theory}),
                                          ite(call
                                                ("isZm",HOLogic.boolT,var("rm",@{typ Zrm}),@{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zlea",@{typ instruction},
                                                       tp[call
                                                            ("OpSize",@{typ Zsize},
                                                             tp[lt,
                                                                call
                                                                  ("REX.W",HOLogic.boolT,
                                                                   var("REX",@{typ REX}),@{theory}),
                                                                lw(1,1),var_b"op_size_override"],
                                                             @{theory}),
                                                          call
                                                            ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                             tp[var("reg",@{typ Zreg}),
                                                                var("rm",@{typ Zrm})],@{theory})],
                                                       @{theory}),var("strm3",@{typ "8 word list"})],
                                                 @{theory}),
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"LEA with register argument",@{theory})))),
                                      (tp[tp[var_w("v#93",8),var("v#94",@{typ "8 word list"})],lt,
                                          lt,lt,lt,lt,lt,lt,lt],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),lw(1,1),var_b"op_size_override"],
                                             @{theory}),
                                          let'
                                            (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                                var("strm3",@{typ "8 word list"})],
                                             call
                                               ("readOpcodeModRM",
                                                @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                                tp[var("REX",@{typ REX}),
                                                   llc([var_w("v#93",8)],
                                                       var("v#94",@{typ "8 word list"}))],@{theory}),
                                             itb([(eq(var_w("opcode",3),lw(0,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmonop",@{typ instruction},
                                                            tp[lc("Zinc","Zmonop_name",@{theory}),
                                                               var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(1,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmonop",@{typ instruction},
                                                            tp[lc("Zdec","Zmonop_name",@{theory}),
                                                               var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(2,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zcall",@{typ instruction},
                                                            call
                                                              ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                               var("rm",@{typ Zrm}),@{theory}),
                                                            @{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(4,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zjmp",@{typ instruction},
                                                            var("rm",@{typ Zrm}),@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(6,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zpush",@{typ instruction},
                                                            call
                                                              ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                               var("rm",@{typ Zrm}),@{theory}),
                                                            @{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory}))],
                                                 call
                                                   ("Zinst.Zdec_fail",@{typ Zinst},
                                                    ls"Unsupported opcode: INC/DEC Group 5",
                                                    @{theory}))))),
                                      (tp[tp[var_w("v#41",8),var("v#42",@{typ "8 word list"})],lf,
                                          lf,var_b"opc'2",var_b"opc'1",var_b"opc'0",lt,lf,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                             call
                                               ("immediate",@{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),
                                                   llc([var_w("v#41",8)],
                                                       var("v#42",@{typ "8 word list"}))],@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zbinop",@{typ instruction},
                                                      tp[mop(Cast @{typ Zbinop_name},
                                                             mop(Cast (Word_Lib.mk_wordT 3),
                                                                 ll[var_b"opc'2",var_b"opc'1",
                                                                    var_b"opc'0"])),
                                                         var("size",@{typ Zsize}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[call
                                                                 ("Zrm.Zr",@{typ Zrm},
                                                                  lc("RAX","Zreg",@{theory}),
                                                                  @{theory}),var_w("imm",64)],
                                                            @{theory})],@{theory}),
                                                   var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[tp[var_w("v#73",8),var("v#74",@{typ "8 word list"})],lt,
                                          lt,lf,lf,lf,lf,lt,var_b"v'0"],
                                       let'
                                         (var("v#28",@{typ "8 word \<times> 8 word list"}),
                                          tp[var_w("v#73",8),var("v#74",@{typ "8 word list"})],
                                          ite(eq(mop(Cast w1,ll[var_b"v'0"]),lw(0,1)),
                                              let'
                                                (tp[var_w("imm",64),
                                                    var("strm3",@{typ "8 word list"})],
                                                 call
                                                   ("immediate16",
                                                    @{typ "64 word \<times> 8 word list"},
                                                    llc([],
                                                        var("v#28",
                                                            @{typ "8 word \<times> 8 word list"})),
                                                    @{theory}),
                                                 call
                                                   ("Zinst.Zfull_inst",@{typ Zinst},
                                                    tp[var("p",@{typ "8 word list"}),
                                                       call
                                                         ("instruction.Zret",@{typ instruction},
                                                          var_w("imm",64),@{theory}),
                                                       var("strm3",@{typ "8 word list"})],@{theory})),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zret",@{typ instruction},
                                                       lw(0,64),@{theory}),
                                                    llc([],
                                                        var("v#28",
                                                            @{typ "8 word \<times> 8 word list"}))],
                                                 @{theory})))),
                                      (tp[tp[var_w("v#57",8),var("v#58",@{typ "8 word list"})],lt,
                                          lf,lf,lf,lf,lt,lt,var_b"v'0"],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#57",8)],
                                                    var("v#58",@{typ "8 word list"}))],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zxchg",@{typ instruction},
                                                   tp[call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",HOLogic.boolT,
                                                               var("REX",@{typ REX}),@{theory}),
                                                            mop(Cast w1,ll[var_b"v'0"]),
                                                            var_b"op_size_override"],@{theory}),
                                                      var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[tp[var_w("v#89",8),var("v#90",@{typ "8 word list"})],lt,
                                          lt,lt,lt,lf,lt,lt,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                                var("strm3",@{typ "8 word list"})],
                                             call
                                               ("readOpcodeModRM",
                                                @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                                tp[var("REX",@{typ REX}),
                                                   llc([var_w("v#89",8)],
                                                       var("v#90",@{typ "8 word list"}))],@{theory}),
                                             itb([(eq(var_w("opcode",3),lw(0,3)),
                                                   let'
                                                     (tp[var_w("imm",64),
                                                         var("strm4",@{typ "8 word list"})],
                                                      call
                                                        ("immediate",
                                                         @{typ "64 word \<times> 8 word list"},
                                                         tp[var("size",@{typ Zsize}),
                                                            var("strm3",@{typ "8 word list"})],
                                                         @{theory}),
                                                      call
                                                        ("Zinst.Zfull_inst",@{typ Zinst},
                                                         tp[var("p",@{typ "8 word list"}),
                                                            call
                                                              ("instruction.Zbinop",
                                                               @{typ instruction},
                                                               tp[lc("Ztest","Zbinop_name",@{theory}),
                                                                  var("size",@{typ Zsize}),
                                                                  call
                                                                    ("Zdest_src.Zrm_i",
                                                                     @{typ Zdest_src},
                                                                     tp[var("rm",@{typ Zrm}),
                                                                        var_w("imm",64)],@{theory})],
                                                               @{theory}),
                                                            var("strm4",@{typ "8 word list"})],
                                                         @{theory}))),
                                                  (eq(var_w("opcode",3),lw(2,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmonop",@{typ instruction},
                                                            tp[lc("Znot","Zmonop_name",@{theory}),
                                                               var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(3,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmonop",@{typ instruction},
                                                            tp[lc("Zneg","Zmonop_name",@{theory}),
                                                               var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(4,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmul",@{typ instruction},
                                                            tp[var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(6,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zdiv",@{typ instruction},
                                                            tp[var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory}))],
                                                 call
                                                   ("Zinst.Zdec_fail",@{typ Zinst},
                                                    ls"Unsupported opcode: Unary Group 3",@{theory}))))),
                                      (tp[tp[var_w("v#49",8),var("v#50",@{typ "8 word list"})],lf,
                                          lt,lt,lt,var_b"c'3",var_b"c'2",var_b"c'1",var_b"c'0"],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             llc([var_w("v#49",8)],var("v#50",@{typ "8 word list"})),
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zjcc",@{typ instruction},
                                                   tp[mop(Cast @{typ Zcond},
                                                          mop(Cast w4,
                                                              ll[var_b"c'3",var_b"c'2",var_b"c'1",
                                                                 var_b"c'0"])),var_w("imm",64)],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[tp[var_w("v#81",8),var("v#82",@{typ "8 word list"})],lt,
                                          lt,lt,lf,lf,lf,lf,var_b"b'0"],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             llc([var_w("v#81",8)],var("v#82",@{typ "8 word list"})),
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zloop",@{typ instruction},
                                                   tp[ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(0,1)),
                                                          lc("Z_NE","Zcond",@{theory}),
                                                          lc("Z_E","Zcond",@{theory})),
                                                      var_w("imm",64)],@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory}))),
                                      (tp[tp[var_w("v#65",8),var("v#66",@{typ "8 word list"})],lt,
                                          lf,lf,lt,lf,var_b"r'2",var_b"r'1",var_b"r'0"],
                                       let'
                                         (var("v#24",@{typ "8 word \<times> 8 word list"}),
                                          tp[var_w("v#65",8),var("v#66",@{typ "8 word list"})],
                                          let'
                                            (var("reg",@{typ Zreg}),
                                             call
                                               ("RexReg",@{typ Zreg},
                                                tp[call
                                                     ("REX.B",HOLogic.boolT,var("REX",@{typ REX}),
                                                      @{theory}),
                                                   mop(Cast (Word_Lib.mk_wordT 3),
                                                       ll[var_b"r'2",var_b"r'1",var_b"r'0"])],
                                                @{theory}),
                                             ite(eq(var("reg",@{typ Zreg}),
                                                    lc("RAX","Zreg",@{theory})),
                                                 call
                                                   ("Zinst.Zfull_inst",@{typ Zinst},
                                                    tp[var("p",@{typ "8 word list"}),
                                                       Term.Const
                                                         (@{const_name "Znop"},@{typ instruction}),
                                                       llc([],
                                                           var("v#24",
                                                               @{typ "8 word \<times> 8 word list"}))],
                                                    @{theory}),
                                                 call
                                                   ("Zinst.Zfull_inst",@{typ Zinst},
                                                    tp[var("p",@{typ "8 word list"}),
                                                       call
                                                         ("instruction.Zxchg",@{typ instruction},
                                                          tp[call
                                                               ("OpSize",@{typ Zsize},
                                                                tp[lt,
                                                                   call
                                                                     ("REX.W",HOLogic.boolT,
                                                                      var("REX",@{typ REX}),
                                                                      @{theory}),lw(1,1),
                                                                   var_b"op_size_override"],
                                                                @{theory}),
                                                             call
                                                               ("Zrm.Zr",@{typ Zrm},
                                                                lc("RAX","Zreg",@{theory}),@{theory}),
                                                             var("reg",@{typ Zreg})],@{theory}),
                                                       llc([],
                                                           var("v#24",
                                                               @{typ "8 word \<times> 8 word list"}))],
                                                    @{theory}))))),
                                      (tp[tp[var_w("opc",8),var("strm2",@{typ "8 word list"})],lf,
                                          lf,lf,lf,lt,lt,lt,lt],
                                       let'
                                         (tp[var_b"b'7",var_b"b'6",var_b"b'5",var_b"b'4",var_b"b'3",
                                             var_b"b'2",var_b"b'1",var_b"b'0"],
                                          call
                                            ("boolify'8",
                                             @{typ
                                             "bool \<times>
                                              bool \<times>
                                              bool \<times>
                                              bool \<times>
                                              bool \<times> bool \<times> bool \<times> bool"},
                                             var_w("opc",8),@{theory}),
                                          itb([(bop(And,mop(Not,var_b"b'7"),
                                                    bop(And,var_b"b'6",
                                                        bop(And,mop(Not,var_b"b'5"),
                                                            mop(Not,var_b"b'4")))),
                                                let'
                                                  (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                                      var("strm3",@{typ "8 word list"})],
                                                   call
                                                     ("readModRM",
                                                      @{typ
                                                      "Zreg \<times> Zrm \<times> 8 word list"},
                                                      tp[var("REX",@{typ REX}),
                                                         var("strm2",@{typ "8 word list"})],
                                                      @{theory}),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmov",@{typ instruction},
                                                            tp[mop(Cast @{typ Zcond},
                                                                   mop(Cast w4,
                                                                       ll[var_b"b'3",var_b"b'2",
                                                                          var_b"b'1",var_b"b'0"])),
                                                               call
                                                                 ("OpSize",@{typ Zsize},
                                                                  tp[lt,
                                                                     call
                                                                       ("REX.W",HOLogic.boolT,
                                                                        var("REX",@{typ REX}),
                                                                        @{theory}),lw(1,1),
                                                                     var_b"op_size_override"],
                                                                  @{theory}),
                                                               call
                                                                 ("Zdest_src.Zr_rm",
                                                                  @{typ Zdest_src},
                                                                  tp[var("reg",@{typ Zreg}),
                                                                     var("rm",@{typ Zrm})],@{theory})],
                                                            @{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory}))),
                                               (bop(And,var_b"b'7",
                                                    bop(And,mop(Not,var_b"b'6"),
                                                        bop(And,mop(Not,var_b"b'5"),
                                                            mop(Not,var_b"b'4")))),
                                                let'
                                                  (tp[var_w("imm",64),
                                                      var("strm3",@{typ "8 word list"})],
                                                   call
                                                     ("immediate32",
                                                      @{typ "64 word \<times> 8 word list"},
                                                      var("strm2",@{typ "8 word list"}),@{theory}),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zjcc",@{typ instruction},
                                                            tp[mop(Cast @{typ Zcond},
                                                                   mop(Cast w4,
                                                                       ll[var_b"b'3",var_b"b'2",
                                                                          var_b"b'1",var_b"b'0"])),
                                                               var_w("imm",64)],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory}))),
                                               (bop(And,var_b"b'7",
                                                    bop(And,mop(Not,var_b"b'6"),
                                                        bop(And,var_b"b'5",
                                                            bop(And,var_b"b'4",
                                                                bop(And,mop(Not,var_b"b'3"),
                                                                    bop(And,mop(Not,var_b"b'2"),
                                                                        mop(Not,var_b"b'1"))))))),
                                                let'
                                                  (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                                      var("strm3",@{typ "8 word list"})],
                                                   call
                                                     ("readModRM",
                                                      @{typ
                                                      "Zreg \<times> Zrm \<times> 8 word list"},
                                                      tp[var("REX",@{typ REX}),
                                                         var("strm2",@{typ "8 word list"})],
                                                      @{theory}),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zcmpxchg",
                                                            @{typ instruction},
                                                            tp[call
                                                                 ("OpSize",@{typ Zsize},
                                                                  tp[var_b"have_rex",
                                                                     call
                                                                       ("REX.W",HOLogic.boolT,
                                                                        var("REX",@{typ REX}),
                                                                        @{theory}),
                                                                     mop(Cast w1,ll[var_b"b'0"]),
                                                                     var_b"op_size_override"],
                                                                  @{theory}),var("rm",@{typ Zrm}),
                                                               var("reg",@{typ Zreg})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory}))),
                                               (bop(And,var_b"b'7",
                                                    bop(And,var_b"b'6",
                                                        bop(And,mop(Not,var_b"b'5"),
                                                            bop(And,mop(Not,var_b"b'4"),
                                                                bop(And,mop(Not,var_b"b'3"),
                                                                    bop(And,mop(Not,var_b"b'2"),
                                                                        mop(Not,var_b"b'1"))))))),
                                                let'
                                                  (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                                      var("strm3",@{typ "8 word list"})],
                                                   call
                                                     ("readModRM",
                                                      @{typ
                                                      "Zreg \<times> Zrm \<times> 8 word list"},
                                                      tp[var("REX",@{typ REX}),
                                                         var("strm2",@{typ "8 word list"})],
                                                      @{theory}),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zxadd",@{typ instruction},
                                                            tp[call
                                                                 ("OpSize",@{typ Zsize},
                                                                  tp[var_b"have_rex",
                                                                     call
                                                                       ("REX.W",HOLogic.boolT,
                                                                        var("REX",@{typ REX}),
                                                                        @{theory}),
                                                                     mop(Cast w1,ll[var_b"b'0"]),
                                                                     var_b"op_size_override"],
                                                                  @{theory}),var("rm",@{typ Zrm}),
                                                               var("reg",@{typ Zreg})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory}))),
                                               (bop(And,var_b"b'7",
                                                    bop(And,mop(Not,var_b"b'6"),
                                                        bop(And,var_b"b'5",
                                                            bop(And,var_b"b'4",
                                                                bop(And,var_b"b'2",var_b"b'1"))))),
                                                let'
                                                  (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                                      var("strm3",@{typ "8 word list"})],
                                                   call
                                                     ("readModRM",
                                                      @{typ
                                                      "Zreg \<times> Zrm \<times> 8 word list"},
                                                      tp[var("REX",@{typ REX}),
                                                         var("strm2",@{typ "8 word list"})],
                                                      @{theory}),
                                                   let'
                                                     (var("arg",
                                                          @{typ
                                                          "Zsize \<times> Zdest_src \<times> Zsize"}),
                                                      tp[ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(1,1)),
                                                             Term.Const
                                                               (@{const_name "Z16"},@{typ Zsize}),
                                                             call
                                                               ("Zsize.Z8",@{typ Zsize},
                                                                var_b"have_rex",@{theory})),
                                                         call
                                                           ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                            tp[var("reg",@{typ Zreg}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         call
                                                           ("OpSize",@{typ Zsize},
                                                            tp[var_b"have_rex",
                                                               call
                                                                 ("REX.W",HOLogic.boolT,
                                                                  var("REX",@{typ REX}),@{theory}),
                                                               lw(1,1),var_b"op_size_override"],
                                                            @{theory})],
                                                      call
                                                        ("Zinst.Zfull_inst",@{typ Zinst},
                                                         tp[var("p",@{typ "8 word list"}),
                                                            ite(eq(mop(Cast w1,ll[var_b"b'3"]),
                                                                   lw(1,1)),
                                                                call
                                                                  ("instruction.Zmovsx",
                                                                   @{typ instruction},
                                                                   var("arg",
                                                                       @{typ
                                                                       "Zsize \<times>
                                                                        Zdest_src \<times> Zsize"}),
                                                                   @{theory}),
                                                                call
                                                                  ("instruction.Zmovzx",
                                                                   @{typ instruction},
                                                                   var("arg",
                                                                       @{typ
                                                                       "Zsize \<times>
                                                                        Zdest_src \<times> Zsize"}),
                                                                   @{theory})),
                                                            var("strm3",@{typ "8 word list"})],
                                                         @{theory}))))],
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 cc[ls"Unsupported opcode: 0F ",
                                                    mop(Cast(@{typ string}),var_w("opc",8))],
                                                 @{theory})))),
                                      (tp[tp[var_w("v#39",8),var("v#40",@{typ "8 word list"})],lf,
                                          lf,var_b"opc'2",var_b"opc'1",var_b"opc'0",lf,var_b"x'0",
                                          var_b"v'0"],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#39",8)],
                                                    var("v#40",@{typ "8 word list"}))],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[mop(Cast @{typ Zbinop_name},
                                                          mop(Cast (Word_Lib.mk_wordT 3),
                                                              ll[var_b"opc'2",var_b"opc'1",
                                                                 var_b"opc'0"])),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",HOLogic.boolT,
                                                               var("REX",@{typ REX}),@{theory}),
                                                            mop(Cast w1,ll[var_b"v'0"]),
                                                            var_b"op_size_override"],@{theory}),
                                                      ite(eq(mop(Cast w1,ll[var_b"x'0"]),lw(0,1)),
                                                          call
                                                            ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                             tp[var("rm",@{typ Zrm}),
                                                                var("reg",@{typ Zreg})],@{theory}),
                                                          call
                                                            ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                             tp[var("reg",@{typ Zreg}),
                                                                var("rm",@{typ Zrm})],@{theory}))],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[tp[var_w("v#71",8),var("v#72",@{typ "8 word list"})],lt,
                                          lt,lf,lf,lf,lf,lf,var_b"v'0"],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#71",8)],
                                                    var("v#72",@{typ "8 word list"}))],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm4",@{typ "8 word list"})],
                                             call
                                               ("immediate8",@{typ "64 word \<times> 8 word list"},
                                                var("strm3",@{typ "8 word list"}),@{theory}),
                                             ite(eq(var_w("opcode",3),lw(6,3)),
                                                 call
                                                   ("Zinst.Zdec_fail",@{typ Zinst},
                                                    ls"Unsupported opcode: Shift Group 2",@{theory}),
                                                 call
                                                   ("Zinst.Zfull_inst",@{typ Zinst},
                                                    tp[var("p",@{typ "8 word list"}),
                                                       call
                                                         ("instruction.Zbinop",@{typ instruction},
                                                          tp[mop(Cast @{typ Zbinop_name},
                                                                 bop(Add,
                                                                     mop(Cast HOLogic.natT,
                                                                         var_w("opcode",3)),ln 8)),
                                                             call
                                                               ("OpSize",@{typ Zsize},
                                                                tp[var_b"have_rex",
                                                                   call
                                                                     ("REX.W",HOLogic.boolT,
                                                                      var("REX",@{typ REX}),
                                                                      @{theory}),
                                                                   mop(Cast w1,ll[var_b"v'0"]),
                                                                   var_b"op_size_override"],
                                                                @{theory}),
                                                             call
                                                               ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                                tp[var("rm",@{typ Zrm}),
                                                                   var_w("imm",64)],@{theory})],
                                                          @{theory}),
                                                       var("strm4",@{typ "8 word list"})],@{theory}))))),
                                      (tp[tp[var_w("v#55",8),var("v#56",@{typ "8 word list"})],lt,
                                          lf,lf,lf,lf,lt,lf,var_b"v'0"],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#55",8)],
                                                    var("v#56",@{typ "8 word list"}))],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[lc("Ztest","Zbinop_name",@{theory}),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",HOLogic.boolT,
                                                               var("REX",@{typ REX}),@{theory}),
                                                            mop(Cast w1,ll[var_b"v'0"]),
                                                            var_b"op_size_override"],@{theory}),
                                                      call
                                                        ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                         tp[var("rm",@{typ Zrm}),
                                                            var("reg",@{typ Zreg})],@{theory})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[tp[var_w("v#87",8),var("v#88",@{typ "8 word list"})],lt,
                                          lt,lt,lf,lt,lf,var_b"b'0",lt],
                                       let'
                                         (var("v#35",@{typ "8 word \<times> 8 word list"}),
                                          tp[var_w("v#87",8),var("v#88",@{typ "8 word list"})],
                                          let'
                                            (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                             ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(0,1)),
                                                 call
                                                   ("immediate32",
                                                    @{typ "64 word \<times> 8 word list"},
                                                    llc([],
                                                        var("v#35",
                                                            @{typ "8 word \<times> 8 word list"})),
                                                    @{theory}),
                                                 call
                                                   ("immediate8",
                                                    @{typ "64 word \<times> 8 word list"},
                                                    llc([],
                                                        var("v#35",
                                                            @{typ "8 word \<times> 8 word list"})),
                                                    @{theory})),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zjcc",@{typ instruction},
                                                      tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                         var_w("imm",64)],@{theory}),
                                                   var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[tp[var_w("v#47",8),var("v#48",@{typ "8 word list"})],lf,
                                          lt,lt,lf,lt,lf,var_b"b'0",lf],
                                       let'
                                         (var("v#15",@{typ "8 word \<times> 8 word list"}),
                                          tp[var_w("v#47",8),var("v#48",@{typ "8 word list"})],
                                          let'
                                            (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                             ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(1,1)),
                                                 call
                                                   ("immediate8",
                                                    @{typ "64 word \<times> 8 word list"},
                                                    llc([],
                                                        var("v#15",
                                                            @{typ "8 word \<times> 8 word list"})),
                                                    @{theory}),
                                                 call
                                                   ("immediate32",
                                                    @{typ "64 word \<times> 8 word list"},
                                                    llc([],
                                                        var("v#15",
                                                            @{typ "8 word \<times> 8 word list"})),
                                                    @{theory})),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zpush",@{typ instruction},
                                                      call
                                                        ("Zimm_rm.Zimm",@{typ Zimm_rm},
                                                         var_w("imm",64),@{theory}),@{theory}),
                                                   var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[tp[var_w("v#79",8),var("v#80",@{typ "8 word list"})],lt,
                                          lt,lf,lt,lf,lf,var_b"b'0",var_b"v'0"],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#79",8)],
                                                    var("v#80",@{typ "8 word list"}))],@{theory}),
                                          ite(eq(var_w("opcode",3),lw(6,3)),
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"Unsupported opcode: Shift Group 2",@{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zbinop",@{typ instruction},
                                                       tp[mop(Cast @{typ Zbinop_name},
                                                              bop(Add,
                                                                  mop(Cast HOLogic.natT,
                                                                      var_w("opcode",3)),ln 8)),
                                                          call
                                                            ("OpSize",@{typ Zsize},
                                                             tp[var_b"have_rex",
                                                                call
                                                                  ("REX.W",HOLogic.boolT,
                                                                   var("REX",@{typ REX}),@{theory}),
                                                                mop(Cast w1,ll[var_b"v'0"]),
                                                                var_b"op_size_override"],@{theory}),
                                                          ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(0,1)),
                                                              call
                                                                ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                                 tp[var("rm",@{typ Zrm}),lw(1,64)],
                                                                 @{theory}),
                                                              call
                                                                ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                                 tp[var("rm",@{typ Zrm}),
                                                                    lc("RCX","Zreg",@{theory})],
                                                                 @{theory}))],@{theory}),
                                                    var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[tp[var_w("v#63",8),var("v#64",@{typ "8 word list"})],lt,
                                          lf,lf,lf,lt,lt,lt,lt],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#63",8)],
                                                    var("v#64",@{typ "8 word list"}))],@{theory}),
                                          ite(eq(var_w("opcode",3),lw(0,3)),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zpop",@{typ instruction},
                                                       var("rm",@{typ Zrm}),@{theory}),
                                                    var("strm3",@{typ "8 word list"})],@{theory}),
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"Unsupported opcode: Group 1a",@{theory})))),
                                      (tp[tp[var_w("v",8),
                                             llc([var_w("opc",8)],var("v0",@{typ "8 word list"}))],
                                          lf,lf,lf,lf,lt,lt,lt,lt],
                                       itb([(eq(var_w("v",8),lw(56,8)),
                                             call
                                               ("Zinst.Zdec_fail",@{typ Zinst},
                                                cc[ls"Unsupported opcode: 0F 38 ",
                                                   mop(Cast(@{typ string}),var_w("opc",8))],
                                                @{theory})),
                                            (eq(var_w("v",8),lw(58,8)),
                                             call
                                               ("Zinst.Zdec_fail",@{typ Zinst},
                                                cc[ls"Unsupported opcode: 0F 3A ",
                                                   mop(Cast(@{typ string}),var_w("opc",8))],
                                                @{theory}))],
                                           let'
                                             (tp[var_b"b'7",var_b"b'6",var_b"b'5",var_b"b'4",
                                                 var_b"b'3",var_b"b'2",var_b"b'1",var_b"b'0"],
                                              call
                                                ("boolify'8",
                                                 @{typ
                                                 "bool \<times>
                                                  bool \<times>
                                                  bool \<times>
                                                  bool \<times>
                                                  bool \<times> bool \<times> bool \<times> bool"},
                                                 var_w("v",8),@{theory}),
                                              itb([(bop(And,mop(Not,var_b"b'7"),
                                                        bop(And,var_b"b'6",
                                                            bop(And,mop(Not,var_b"b'5"),
                                                                mop(Not,var_b"b'4")))),
                                                    let'
                                                      (tp[var("reg",@{typ Zreg}),
                                                          var("rm",@{typ Zrm}),
                                                          var("strm3",@{typ "8 word list"})],
                                                       call
                                                         ("readModRM",
                                                          @{typ
                                                          "Zreg \<times> Zrm \<times> 8 word list"},
                                                          tp[var("REX",@{typ REX}),
                                                             llc([var_w("opc",8)],
                                                                 var("v0",@{typ "8 word list"}))],
                                                          @{theory}),
                                                       call
                                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                                          tp[var("p",@{typ "8 word list"}),
                                                             call
                                                               ("instruction.Zmov",
                                                                @{typ instruction},
                                                                tp[mop(Cast @{typ Zcond},
                                                                       mop(Cast w4,
                                                                           ll[var_b"b'3",var_b"b'2",
                                                                              var_b"b'1",var_b"b'0"])),
                                                                   call
                                                                     ("OpSize",@{typ Zsize},
                                                                      tp[lt,
                                                                         call
                                                                           ("REX.W",HOLogic.boolT,
                                                                            var("REX",@{typ REX}),
                                                                            @{theory}),lw(1,1),
                                                                         var_b"op_size_override"],
                                                                      @{theory}),
                                                                   call
                                                                     ("Zdest_src.Zr_rm",
                                                                      @{typ Zdest_src},
                                                                      tp[var("reg",@{typ Zreg}),
                                                                         var("rm",@{typ Zrm})],
                                                                      @{theory})],@{theory}),
                                                             var("strm3",@{typ "8 word list"})],
                                                          @{theory}))),
                                                   (bop(And,var_b"b'7",
                                                        bop(And,mop(Not,var_b"b'6"),
                                                            bop(And,mop(Not,var_b"b'5"),
                                                                mop(Not,var_b"b'4")))),
                                                    let'
                                                      (tp[var_w("imm",64),
                                                          var("strm3",@{typ "8 word list"})],
                                                       call
                                                         ("immediate32",
                                                          @{typ "64 word \<times> 8 word list"},
                                                          llc([var_w("opc",8)],
                                                              var("v0",@{typ "8 word list"})),
                                                          @{theory}),
                                                       call
                                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                                          tp[var("p",@{typ "8 word list"}),
                                                             call
                                                               ("instruction.Zjcc",
                                                                @{typ instruction},
                                                                tp[mop(Cast @{typ Zcond},
                                                                       mop(Cast w4,
                                                                           ll[var_b"b'3",var_b"b'2",
                                                                              var_b"b'1",var_b"b'0"])),
                                                                   var_w("imm",64)],@{theory}),
                                                             var("strm3",@{typ "8 word list"})],
                                                          @{theory}))),
                                                   (bop(And,var_b"b'7",
                                                        bop(And,mop(Not,var_b"b'6"),
                                                            bop(And,var_b"b'5",
                                                                bop(And,var_b"b'4",
                                                                    bop(And,mop(Not,var_b"b'3"),
                                                                        bop(And,mop(Not,var_b"b'2"),
                                                                            mop(Not,var_b"b'1"))))))),
                                                    let'
                                                      (tp[var("reg",@{typ Zreg}),
                                                          var("rm",@{typ Zrm}),
                                                          var("strm3",@{typ "8 word list"})],
                                                       call
                                                         ("readModRM",
                                                          @{typ
                                                          "Zreg \<times> Zrm \<times> 8 word list"},
                                                          tp[var("REX",@{typ REX}),
                                                             llc([var_w("opc",8)],
                                                                 var("v0",@{typ "8 word list"}))],
                                                          @{theory}),
                                                       call
                                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                                          tp[var("p",@{typ "8 word list"}),
                                                             call
                                                               ("instruction.Zcmpxchg",
                                                                @{typ instruction},
                                                                tp[call
                                                                     ("OpSize",@{typ Zsize},
                                                                      tp[var_b"have_rex",
                                                                         call
                                                                           ("REX.W",HOLogic.boolT,
                                                                            var("REX",@{typ REX}),
                                                                            @{theory}),
                                                                         mop(Cast w1,ll[var_b"b'0"]),
                                                                         var_b"op_size_override"],
                                                                      @{theory}),
                                                                   var("rm",@{typ Zrm}),
                                                                   var("reg",@{typ Zreg})],@{theory}),
                                                             var("strm3",@{typ "8 word list"})],
                                                          @{theory}))),
                                                   (bop(And,var_b"b'7",
                                                        bop(And,var_b"b'6",
                                                            bop(And,mop(Not,var_b"b'5"),
                                                                bop(And,mop(Not,var_b"b'4"),
                                                                    bop(And,mop(Not,var_b"b'3"),
                                                                        bop(And,mop(Not,var_b"b'2"),
                                                                            mop(Not,var_b"b'1"))))))),
                                                    let'
                                                      (tp[var("reg",@{typ Zreg}),
                                                          var("rm",@{typ Zrm}),
                                                          var("strm3",@{typ "8 word list"})],
                                                       call
                                                         ("readModRM",
                                                          @{typ
                                                          "Zreg \<times> Zrm \<times> 8 word list"},
                                                          tp[var("REX",@{typ REX}),
                                                             llc([var_w("opc",8)],
                                                                 var("v0",@{typ "8 word list"}))],
                                                          @{theory}),
                                                       call
                                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                                          tp[var("p",@{typ "8 word list"}),
                                                             call
                                                               ("instruction.Zxadd",
                                                                @{typ instruction},
                                                                tp[call
                                                                     ("OpSize",@{typ Zsize},
                                                                      tp[var_b"have_rex",
                                                                         call
                                                                           ("REX.W",HOLogic.boolT,
                                                                            var("REX",@{typ REX}),
                                                                            @{theory}),
                                                                         mop(Cast w1,ll[var_b"b'0"]),
                                                                         var_b"op_size_override"],
                                                                      @{theory}),
                                                                   var("rm",@{typ Zrm}),
                                                                   var("reg",@{typ Zreg})],@{theory}),
                                                             var("strm3",@{typ "8 word list"})],
                                                          @{theory}))),
                                                   (bop(And,var_b"b'7",
                                                        bop(And,mop(Not,var_b"b'6"),
                                                            bop(And,var_b"b'5",
                                                                bop(And,var_b"b'4",
                                                                    bop(And,var_b"b'2",var_b"b'1"))))),
                                                    let'
                                                      (tp[var("reg",@{typ Zreg}),
                                                          var("rm",@{typ Zrm}),
                                                          var("strm3",@{typ "8 word list"})],
                                                       call
                                                         ("readModRM",
                                                          @{typ
                                                          "Zreg \<times> Zrm \<times> 8 word list"},
                                                          tp[var("REX",@{typ REX}),
                                                             llc([var_w("opc",8)],
                                                                 var("v0",@{typ "8 word list"}))],
                                                          @{theory}),
                                                       let'
                                                         (var("arg",
                                                              @{typ
                                                              "Zsize \<times>
                                                               Zdest_src \<times> Zsize"}),
                                                          tp[ite(eq(mop(Cast w1,ll[var_b"b'0"]),
                                                                    lw(1,1)),
                                                                 Term.Const
                                                                   (@{const_name "Z16"},@{typ Zsize}),
                                                                 call
                                                                   ("Zsize.Z8",@{typ Zsize},
                                                                    var_b"have_rex",@{theory})),
                                                             call
                                                               ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                                tp[var("reg",@{typ Zreg}),
                                                                   var("rm",@{typ Zrm})],@{theory}),
                                                             call
                                                               ("OpSize",@{typ Zsize},
                                                                tp[var_b"have_rex",
                                                                   call
                                                                     ("REX.W",HOLogic.boolT,
                                                                      var("REX",@{typ REX}),
                                                                      @{theory}),lw(1,1),
                                                                   var_b"op_size_override"],
                                                                @{theory})],
                                                          call
                                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                                             tp[var("p",@{typ "8 word list"}),
                                                                ite(eq(mop(Cast w1,ll[var_b"b'3"]),
                                                                       lw(1,1)),
                                                                    call
                                                                      ("instruction.Zmovsx",
                                                                       @{typ instruction},
                                                                       var("arg",
                                                                           @{typ
                                                                           "Zsize \<times>
                                                                            Zdest_src \<times> Zsize"}),
                                                                       @{theory}),
                                                                    call
                                                                      ("instruction.Zmovzx",
                                                                       @{typ instruction},
                                                                       var("arg",
                                                                           @{typ
                                                                           "Zsize \<times>
                                                                            Zdest_src \<times> Zsize"}),
                                                                       @{theory})),
                                                                var("strm3",@{typ "8 word list"})],
                                                             @{theory}))))],
                                                  call
                                                    ("Zinst.Zdec_fail",@{typ Zinst},
                                                     cc[ls"Unsupported opcode: 0F ",
                                                        mop(Cast(@{typ string}),var_w("v",8))],
                                                     @{theory}))))),
                                      (tp[tp[var_w("v#43",8),var("v#44",@{typ "8 word list"})],lf,
                                          lt,lf,lt,var_b"b'0",var_b"r'2",var_b"r'1",var_b"r'0"],
                                       let'
                                         (var("reg",@{typ Zrm}),
                                          call
                                            ("Zrm.Zr",@{typ Zrm},
                                             mop(Cast @{typ Zreg},
                                                 cc[mop(Cast w1,
                                                        call
                                                          ("REX.B",HOLogic.boolT,
                                                           var("REX",@{typ REX}),@{theory})),
                                                    mop(Cast (Word_Lib.mk_wordT 3),
                                                        ll[var_b"r'2",var_b"r'1",var_b"r'0"])]),
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(0,1)),
                                                    call
                                                      ("instruction.Zpush",@{typ instruction},
                                                       call
                                                         ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                          var("reg",@{typ Zrm}),@{theory}),@{theory}),
                                                    call
                                                      ("instruction.Zpop",@{typ instruction},
                                                       var("reg",@{typ Zrm}),@{theory})),
                                                llc([var_w("v#43",8)],
                                                    var("v#44",@{typ "8 word list"}))],@{theory}))),
                                      (tp[tp[var_w("v#75",8),var("v#76",@{typ "8 word list"})],lt,
                                          lt,lf,lf,lf,lt,lt,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                                var("strm3",@{typ "8 word list"})],
                                             call
                                               ("readOpcodeModRM",
                                                @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                                tp[var("REX",@{typ REX}),
                                                   llc([var_w("v#75",8)],
                                                       var("v#76",@{typ "8 word list"}))],@{theory}),
                                             let'
                                               (tp[var_w("imm",64),var("strm4",@{typ "8 word list"})],
                                                call
                                                  ("immediate",
                                                   @{typ "64 word \<times> 8 word list"},
                                                   tp[var("size",@{typ Zsize}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}),
                                                ite(eq(var_w("opcode",3),lw(0,3)),
                                                    call
                                                      ("Zinst.Zfull_inst",@{typ Zinst},
                                                       tp[var("p",@{typ "8 word list"}),
                                                          call
                                                            ("instruction.Zmov",@{typ instruction},
                                                             tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                                var("size",@{typ Zsize}),
                                                                call
                                                                  ("Zdest_src.Zrm_i",
                                                                   @{typ Zdest_src},
                                                                   tp[var("rm",@{typ Zrm}),
                                                                      var_w("imm",64)],@{theory})],
                                                             @{theory}),
                                                          var("strm4",@{typ "8 word list"})],
                                                       @{theory}),
                                                    call
                                                      ("Zinst.Zdec_fail",@{typ Zinst},
                                                       ls"Unsupported opcode: Group 11",@{theory})))))),
                                      (tp[tp[var_w("v#59",8),var("v#60",@{typ "8 word list"})],lt,
                                          lf,lf,lf,lt,lf,var_b"x'0",var_b"v'0"],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#59",8)],
                                                    var("v#60",@{typ "8 word list"}))],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zmov",@{typ instruction},
                                                   tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",HOLogic.boolT,
                                                               var("REX",@{typ REX}),@{theory}),
                                                            mop(Cast w1,ll[var_b"v'0"]),
                                                            var_b"op_size_override"],@{theory}),
                                                      ite(eq(mop(Cast w1,ll[var_b"x'0"]),lw(0,1)),
                                                          call
                                                            ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                             tp[var("rm",@{typ Zrm}),
                                                                var("reg",@{typ Zreg})],@{theory}),
                                                          call
                                                            ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                             tp[var("reg",@{typ Zreg}),
                                                                var("rm",@{typ Zrm})],@{theory}))],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[tp[var_w("v#91",8),var("v#92",@{typ "8 word list"})],lt,
                                          lt,lt,lt,lt,lt,lt,lf],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),
                                                llc([var_w("v#91",8)],
                                                    var("v#92",@{typ "8 word list"}))],@{theory}),
                                          itb([(eq(var_w("opcode",3),lw(0,3)),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zmonop",@{typ instruction},
                                                         tp[lc("Zinc","Zmonop_name",@{theory}),
                                                            call
                                                              ("Zsize.Z8",@{typ Zsize},
                                                               var_b"have_rex",@{theory}),
                                                            var("rm",@{typ Zrm})],@{theory}),
                                                      var("strm3",@{typ "8 word list"})],@{theory})),
                                               (eq(var_w("opcode",3),lw(1,3)),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zmonop",@{typ instruction},
                                                         tp[lc("Zdec","Zmonop_name",@{theory}),
                                                            call
                                                              ("Zsize.Z8",@{typ Zsize},
                                                               var_b"have_rex",@{theory}),
                                                            var("rm",@{typ Zrm})],@{theory}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}))],
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"Unsupported opcode: INC/DEC Group 4",@{theory})))),
                                      (tp[tp[var_w("v#51",8),var("v#52",@{typ "8 word list"})],lt,
                                          lf,lf,lf,lf,lf,lf,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                                var("strm3",@{typ "8 word list"})],
                                             call
                                               ("readOpcodeModRM",
                                                @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                                tp[var("REX",@{typ REX}),
                                                   llc([var_w("v#51",8)],
                                                       var("v#52",@{typ "8 word list"}))],@{theory}),
                                             let'
                                               (tp[var_w("imm",64),var("strm4",@{typ "8 word list"})],
                                                call
                                                  ("immediate",
                                                   @{typ "64 word \<times> 8 word list"},
                                                   tp[var("size",@{typ Zsize}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zbinop",@{typ instruction},
                                                         tp[mop(Cast @{typ Zbinop_name},
                                                                var_w("opcode",3)),
                                                            var("size",@{typ Zsize}),
                                                            call
                                                              ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                               tp[var("rm",@{typ Zrm}),
                                                                  var_w("imm",64)],@{theory})],
                                                         @{theory}),
                                                      var("strm4",@{typ "8 word list"})],@{theory}))))),
                                      (tp[tp[var_w("v#83",8),var("v#84",@{typ "8 word list"})],lt,
                                          lt,lt,lf,lf,lf,lt,lf],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             llc([var_w("v#83",8)],var("v#84",@{typ "8 word list"})),
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zloop",@{typ instruction},
                                                   tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                      var_w("imm",64)],@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory}))),
                                      (tp[tp[var_w("v#67",8),var("v#68",@{typ "8 word list"})],lt,
                                          lf,lt,lf,lt,lf,lf,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[lt,
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                             call
                                               ("immediate",@{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),
                                                   llc([var_w("v#67",8)],
                                                       var("v#68",@{typ "8 word list"}))],@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zbinop",@{typ instruction},
                                                      tp[lc("Ztest","Zbinop_name",@{theory}),
                                                         var("size",@{typ Zsize}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[call
                                                                 ("Zrm.Zr",@{typ Zrm},
                                                                  lc("RAX","Zreg",@{theory}),
                                                                  @{theory}),var_w("imm",64)],
                                                            @{theory})],@{theory}),
                                                   var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[tp[var_w("v",8),var("v0",@{typ "8 word list"})],
                                          var_b"opc'7",var_b"opc'6",var_b"opc'5",var_b"opc'4",
                                          var_b"opc'3",var_b"opc'2",var_b"opc'1",var_b"opc'0"],
                                       call
                                         ("Zinst.Zdec_fail",@{typ Zinst},
                                          cc[ls"Unsupported opcode: ",
                                             mop(Cast(@{typ string}),
                                                 mop(Cast w8,
                                                     ll[var_b"opc'7",var_b"opc'6",var_b"opc'5",
                                                        var_b"opc'4",var_b"opc'3",var_b"opc'2",
                                                        var_b"opc'1",var_b"opc'0"]))],@{theory}))],
                                     @{context})),
                                 (lnl w8,
                                  cs(tp[var_b"v#0",var_b"v#1",var_b"v#2",var_b"v#3",var_b"v#4",
                                        var_b"v#5",var_b"v#6",var_b"v#7"],
                                     [(tp[lf,lf,var_b"opc'2",var_b"opc'1",var_b"opc'0",lf,
                                          var_b"x'0",var_b"v'0"],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[mop(Cast @{typ Zbinop_name},
                                                          mop(Cast (Word_Lib.mk_wordT 3),
                                                              ll[var_b"opc'2",var_b"opc'1",
                                                                 var_b"opc'0"])),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",HOLogic.boolT,
                                                               var("REX",@{typ REX}),@{theory}),
                                                            mop(Cast w1,ll[var_b"v'0"]),
                                                            var_b"op_size_override"],@{theory}),
                                                      ite(eq(mop(Cast w1,ll[var_b"x'0"]),lw(0,1)),
                                                          call
                                                            ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                             tp[var("rm",@{typ Zrm}),
                                                                var("reg",@{typ Zreg})],@{theory}),
                                                          call
                                                            ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                             tp[var("reg",@{typ Zreg}),
                                                                var("rm",@{typ Zrm})],@{theory}))],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[lf,lf,var_b"opc'2",var_b"opc'1",var_b"opc'0",lt,lf,
                                          var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                             call
                                               ("immediate",@{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),lnl w8],@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zbinop",@{typ instruction},
                                                      tp[mop(Cast @{typ Zbinop_name},
                                                             mop(Cast (Word_Lib.mk_wordT 3),
                                                                 ll[var_b"opc'2",var_b"opc'1",
                                                                    var_b"opc'0"])),
                                                         var("size",@{typ Zsize}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[call
                                                                 ("Zrm.Zr",@{typ Zrm},
                                                                  lc("RAX","Zreg",@{theory}),
                                                                  @{theory}),var_w("imm",64)],
                                                            @{theory})],@{theory}),
                                                   var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[lf,lt,lf,lt,var_b"b'0",var_b"r'2",var_b"r'1",var_b"r'0"],
                                       let'
                                         (var("reg",@{typ Zrm}),
                                          call
                                            ("Zrm.Zr",@{typ Zrm},
                                             mop(Cast @{typ Zreg},
                                                 cc[mop(Cast w1,
                                                        call
                                                          ("REX.B",HOLogic.boolT,
                                                           var("REX",@{typ REX}),@{theory})),
                                                    mop(Cast (Word_Lib.mk_wordT 3),
                                                        ll[var_b"r'2",var_b"r'1",var_b"r'0"])]),
                                             @{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(0,1)),
                                                    call
                                                      ("instruction.Zpush",@{typ instruction},
                                                       call
                                                         ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                          var("reg",@{typ Zrm}),@{theory}),@{theory}),
                                                    call
                                                      ("instruction.Zpop",@{typ instruction},
                                                       var("reg",@{typ Zrm}),@{theory})),lnl w8],
                                             @{theory}))),
                                      (tp[lf,lt,lt,lf,lf,lf,lt,lt],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zmovsx",@{typ instruction},
                                                   tp[Term.Const(@{const_name "Z32"},@{typ Zsize}),
                                                      call
                                                        ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                         tp[var("reg",@{typ Zreg}),
                                                            var("rm",@{typ Zrm})],@{theory}),
                                                      Term.Const(@{const_name "Z64"},@{typ Zsize})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[lf,lt,lt,lf,lt,lf,var_b"b'0",lf],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(1,1)),
                                              call
                                                ("immediate8",@{typ "64 word \<times> 8 word list"},
                                                 lnl w8,@{theory}),
                                              call
                                                ("immediate32",
                                                 @{typ "64 word \<times> 8 word list"},lnl w8,
                                                 @{theory})),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zpush",@{typ instruction},
                                                   call
                                                     ("Zimm_rm.Zimm",@{typ Zimm_rm},var_w("imm",64),
                                                      @{theory}),@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory}))),
                                      (tp[lf,lt,lt,lt,var_b"c'3",var_b"c'2",var_b"c'1",var_b"c'0"],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             lnl w8,@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zjcc",@{typ instruction},
                                                   tp[mop(Cast @{typ Zcond},
                                                          mop(Cast w4,
                                                              ll[var_b"c'3",var_b"c'2",var_b"c'1",
                                                                 var_b"c'0"])),var_w("imm",64)],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[lt,lf,lf,lf,lf,lf,lf,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                                var("strm3",@{typ "8 word list"})],
                                             call
                                               ("readOpcodeModRM",
                                                @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                                tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                             let'
                                               (tp[var_w("imm",64),var("strm4",@{typ "8 word list"})],
                                                call
                                                  ("immediate",
                                                   @{typ "64 word \<times> 8 word list"},
                                                   tp[var("size",@{typ Zsize}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zbinop",@{typ instruction},
                                                         tp[mop(Cast @{typ Zbinop_name},
                                                                var_w("opcode",3)),
                                                            var("size",@{typ Zsize}),
                                                            call
                                                              ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                               tp[var("rm",@{typ Zrm}),
                                                                  var_w("imm",64)],@{theory})],
                                                         @{theory}),
                                                      var("strm4",@{typ "8 word list"})],@{theory}))))),
                                      (tp[lt,lf,lf,lf,lf,lf,lt,lt],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm4",@{typ "8 word list"})],
                                             call
                                               ("immediate8",@{typ "64 word \<times> 8 word list"},
                                                var("strm3",@{typ "8 word list"}),@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zbinop",@{typ instruction},
                                                      tp[mop(Cast @{typ Zbinop_name},
                                                             var_w("opcode",3)),
                                                         call
                                                           ("OpSize",@{typ Zsize},
                                                            tp[lf,
                                                               call
                                                                 ("REX.W",HOLogic.boolT,
                                                                  var("REX",@{typ REX}),@{theory}),
                                                               lw(1,1),var_b"op_size_override"],
                                                            @{theory}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[var("rm",@{typ Zrm}),var_w("imm",64)],
                                                            @{theory})],@{theory}),
                                                   var("strm4",@{typ "8 word list"})],@{theory})))),
                                      (tp[lt,lf,lf,lf,lf,lt,lf,var_b"v'0"],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zbinop",@{typ instruction},
                                                   tp[lc("Ztest","Zbinop_name",@{theory}),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",HOLogic.boolT,
                                                               var("REX",@{typ REX}),@{theory}),
                                                            mop(Cast w1,ll[var_b"v'0"]),
                                                            var_b"op_size_override"],@{theory}),
                                                      call
                                                        ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                         tp[var("rm",@{typ Zrm}),
                                                            var("reg",@{typ Zreg})],@{theory})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[lt,lf,lf,lf,lf,lt,lt,var_b"v'0"],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zxchg",@{typ instruction},
                                                   tp[call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",HOLogic.boolT,
                                                               var("REX",@{typ REX}),@{theory}),
                                                            mop(Cast w1,ll[var_b"v'0"]),
                                                            var_b"op_size_override"],@{theory}),
                                                      var("rm",@{typ Zrm}),var("reg",@{typ Zreg})],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[lt,lf,lf,lf,lt,lf,var_b"x'0",var_b"v'0"],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zmov",@{typ instruction},
                                                   tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                      call
                                                        ("OpSize",@{typ Zsize},
                                                         tp[var_b"have_rex",
                                                            call
                                                              ("REX.W",HOLogic.boolT,
                                                               var("REX",@{typ REX}),@{theory}),
                                                            mop(Cast w1,ll[var_b"v'0"]),
                                                            var_b"op_size_override"],@{theory}),
                                                      ite(eq(mop(Cast w1,ll[var_b"x'0"]),lw(0,1)),
                                                          call
                                                            ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                             tp[var("rm",@{typ Zrm}),
                                                                var("reg",@{typ Zreg})],@{theory}),
                                                          call
                                                            ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                             tp[var("reg",@{typ Zreg}),
                                                                var("rm",@{typ Zrm})],@{theory}))],
                                                   @{theory}),var("strm3",@{typ "8 word list"})],
                                             @{theory}))),
                                      (tp[lt,lf,lf,lf,lt,lt,lf,lt],
                                       let'
                                         (tp[var("reg",@{typ Zreg}),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readModRM",
                                             @{typ "Zreg \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          ite(call
                                                ("isZm",HOLogic.boolT,var("rm",@{typ Zrm}),@{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zlea",@{typ instruction},
                                                       tp[call
                                                            ("OpSize",@{typ Zsize},
                                                             tp[lt,
                                                                call
                                                                  ("REX.W",HOLogic.boolT,
                                                                   var("REX",@{typ REX}),@{theory}),
                                                                lw(1,1),var_b"op_size_override"],
                                                             @{theory}),
                                                          call
                                                            ("Zdest_src.Zr_rm",@{typ Zdest_src},
                                                             tp[var("reg",@{typ Zreg}),
                                                                var("rm",@{typ Zrm})],@{theory})],
                                                       @{theory}),var("strm3",@{typ "8 word list"})],
                                                 @{theory}),
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"LEA with register argument",@{theory})))),
                                      (tp[lt,lf,lf,lf,lt,lt,lt,lt],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          ite(eq(var_w("opcode",3),lw(0,3)),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zpop",@{typ instruction},
                                                       var("rm",@{typ Zrm}),@{theory}),
                                                    var("strm3",@{typ "8 word list"})],@{theory}),
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"Unsupported opcode: Group 1a",@{theory})))),
                                      (tp[lt,lf,lf,lt,lf,var_b"r'2",var_b"r'1",var_b"r'0"],
                                       let'
                                         (var("reg",@{typ Zreg}),
                                          call
                                            ("RexReg",@{typ Zreg},
                                             tp[call
                                                  ("REX.B",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),
                                                mop(Cast (Word_Lib.mk_wordT 3),
                                                    ll[var_b"r'2",var_b"r'1",var_b"r'0"])],@{theory}),
                                          ite(eq(var("reg",@{typ Zreg}),lc("RAX","Zreg",@{theory})),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    Term.Const
                                                      (@{const_name "Znop"},@{typ instruction}),
                                                    lnl w8],@{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zxchg",@{typ instruction},
                                                       tp[call
                                                            ("OpSize",@{typ Zsize},
                                                             tp[lt,
                                                                call
                                                                  ("REX.W",HOLogic.boolT,
                                                                   var("REX",@{typ REX}),@{theory}),
                                                                lw(1,1),var_b"op_size_override"],
                                                             @{theory}),
                                                          call
                                                            ("Zrm.Zr",@{typ Zrm},
                                                             lc("RAX","Zreg",@{theory}),@{theory}),
                                                          var("reg",@{typ Zreg})],@{theory}),lnl w8],
                                                 @{theory})))),
                                      (tp[lt,lf,lt,lf,lt,lf,lf,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[lt,
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                             call
                                               ("immediate",@{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),lnl w8],@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zbinop",@{typ instruction},
                                                      tp[lc("Ztest","Zbinop_name",@{theory}),
                                                         var("size",@{typ Zsize}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[call
                                                                 ("Zrm.Zr",@{typ Zrm},
                                                                  lc("RAX","Zreg",@{theory}),
                                                                  @{theory}),var_w("imm",64)],
                                                            @{theory})],@{theory}),
                                                   var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[lt,lf,lt,lt,var_b"v'0",var_b"r'2",var_b"r'1",var_b"r'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                             call
                                               ("full_immediate",
                                                @{typ "64 word \<times> 8 word list"},
                                                tp[var("size",@{typ Zsize}),lnl w8],@{theory}),
                                             call
                                               ("Zinst.Zfull_inst",@{typ Zinst},
                                                tp[var("p",@{typ "8 word list"}),
                                                   call
                                                     ("instruction.Zmov",@{typ instruction},
                                                      tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                         var("size",@{typ Zsize}),
                                                         call
                                                           ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                            tp[call
                                                                 ("Zrm.Zr",@{typ Zrm},
                                                                  mop(Cast @{typ Zreg},
                                                                      cc[mop(Cast w1,
                                                                             call
                                                                               ("REX.B",
                                                                                HOLogic.boolT,
                                                                                var("REX",@{typ REX}),
                                                                                @{theory})),
                                                                         mop(Cast
                                                                               (Word_Lib.mk_wordT 3),
                                                                             ll[var_b"r'2",
                                                                                var_b"r'1",
                                                                                var_b"r'0"])]),
                                                                  @{theory}),var_w("imm",64)],
                                                            @{theory})],@{theory}),
                                                   var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[lt,lt,lf,lf,lf,lf,lf,var_b"v'0"],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          let'
                                            (tp[var_w("imm",64),var("strm4",@{typ "8 word list"})],
                                             call
                                               ("immediate8",@{typ "64 word \<times> 8 word list"},
                                                var("strm3",@{typ "8 word list"}),@{theory}),
                                             ite(eq(var_w("opcode",3),lw(6,3)),
                                                 call
                                                   ("Zinst.Zdec_fail",@{typ Zinst},
                                                    ls"Unsupported opcode: Shift Group 2",@{theory}),
                                                 call
                                                   ("Zinst.Zfull_inst",@{typ Zinst},
                                                    tp[var("p",@{typ "8 word list"}),
                                                       call
                                                         ("instruction.Zbinop",@{typ instruction},
                                                          tp[mop(Cast @{typ Zbinop_name},
                                                                 bop(Add,
                                                                     mop(Cast HOLogic.natT,
                                                                         var_w("opcode",3)),ln 8)),
                                                             call
                                                               ("OpSize",@{typ Zsize},
                                                                tp[var_b"have_rex",
                                                                   call
                                                                     ("REX.W",HOLogic.boolT,
                                                                      var("REX",@{typ REX}),
                                                                      @{theory}),
                                                                   mop(Cast w1,ll[var_b"v'0"]),
                                                                   var_b"op_size_override"],
                                                                @{theory}),
                                                             call
                                                               ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                                tp[var("rm",@{typ Zrm}),
                                                                   var_w("imm",64)],@{theory})],
                                                          @{theory}),
                                                       var("strm4",@{typ "8 word list"})],@{theory}))))),
                                      (tp[lt,lt,lf,lf,lf,lf,lt,var_b"v'0"],
                                       ite(eq(mop(Cast w1,ll[var_b"v'0"]),lw(0,1)),
                                           let'
                                             (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                              call
                                                ("immediate16",
                                                 @{typ "64 word \<times> 8 word list"},lnl w8,
                                                 @{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zret",@{typ instruction},
                                                       var_w("imm",64),@{theory}),
                                                    var("strm3",@{typ "8 word list"})],@{theory})),
                                           call
                                             ("Zinst.Zfull_inst",@{typ Zinst},
                                              tp[var("p",@{typ "8 word list"}),
                                                 call
                                                   ("instruction.Zret",@{typ instruction},lw(0,64),
                                                    @{theory}),lnl w8],@{theory}))),
                                      (tp[lt,lt,lf,lf,lf,lt,lt,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                                var("strm3",@{typ "8 word list"})],
                                             call
                                               ("readOpcodeModRM",
                                                @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                                tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                             let'
                                               (tp[var_w("imm",64),var("strm4",@{typ "8 word list"})],
                                                call
                                                  ("immediate",
                                                   @{typ "64 word \<times> 8 word list"},
                                                   tp[var("size",@{typ Zsize}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}),
                                                ite(eq(var_w("opcode",3),lw(0,3)),
                                                    call
                                                      ("Zinst.Zfull_inst",@{typ Zinst},
                                                       tp[var("p",@{typ "8 word list"}),
                                                          call
                                                            ("instruction.Zmov",@{typ instruction},
                                                             tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                                var("size",@{typ Zsize}),
                                                                call
                                                                  ("Zdest_src.Zrm_i",
                                                                   @{typ Zdest_src},
                                                                   tp[var("rm",@{typ Zrm}),
                                                                      var_w("imm",64)],@{theory})],
                                                             @{theory}),
                                                          var("strm4",@{typ "8 word list"})],
                                                       @{theory}),
                                                    call
                                                      ("Zinst.Zdec_fail",@{typ Zinst},
                                                       ls"Unsupported opcode: Group 11",@{theory})))))),
                                      (tp[lt,lt,lf,lf,lt,lf,lf,lt],
                                       call
                                         ("Zinst.Zfull_inst",@{typ Zinst},
                                          tp[var("p",@{typ "8 word list"}),
                                             Term.Const(@{const_name "Zleave"},@{typ instruction}),
                                             lnl w8],@{theory})),
                                      (tp[lt,lt,lf,lt,lf,lf,var_b"b'0",var_b"v'0"],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          ite(eq(var_w("opcode",3),lw(6,3)),
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"Unsupported opcode: Shift Group 2",@{theory}),
                                              call
                                                ("Zinst.Zfull_inst",@{typ Zinst},
                                                 tp[var("p",@{typ "8 word list"}),
                                                    call
                                                      ("instruction.Zbinop",@{typ instruction},
                                                       tp[mop(Cast @{typ Zbinop_name},
                                                              bop(Add,
                                                                  mop(Cast HOLogic.natT,
                                                                      var_w("opcode",3)),ln 8)),
                                                          call
                                                            ("OpSize",@{typ Zsize},
                                                             tp[var_b"have_rex",
                                                                call
                                                                  ("REX.W",HOLogic.boolT,
                                                                   var("REX",@{typ REX}),@{theory}),
                                                                mop(Cast w1,ll[var_b"v'0"]),
                                                                var_b"op_size_override"],@{theory}),
                                                          ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(0,1)),
                                                              call
                                                                ("Zdest_src.Zrm_i",@{typ Zdest_src},
                                                                 tp[var("rm",@{typ Zrm}),lw(1,64)],
                                                                 @{theory}),
                                                              call
                                                                ("Zdest_src.Zrm_r",@{typ Zdest_src},
                                                                 tp[var("rm",@{typ Zrm}),
                                                                    lc("RCX","Zreg",@{theory})],
                                                                 @{theory}))],@{theory}),
                                                    var("strm3",@{typ "8 word list"})],@{theory})))),
                                      (tp[lt,lt,lt,lf,lf,lf,lf,var_b"b'0"],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             lnl w8,@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zloop",@{typ instruction},
                                                   tp[ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(0,1)),
                                                          lc("Z_NE","Zcond",@{theory}),
                                                          lc("Z_E","Zcond",@{theory})),
                                                      var_w("imm",64)],@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory}))),
                                      (tp[lt,lt,lt,lf,lf,lf,lt,lf],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate8",@{typ "64 word \<times> 8 word list"},
                                             lnl w8,@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zloop",@{typ instruction},
                                                   tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                      var_w("imm",64)],@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory}))),
                                      (tp[lt,lt,lt,lf,lt,lf,lf,lf],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          call
                                            ("immediate32",@{typ "64 word \<times> 8 word list"},
                                             lnl w8,@{theory}),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zcall",@{typ instruction},
                                                   call
                                                     ("Zimm_rm.Zimm",@{typ Zimm_rm},var_w("imm",64),
                                                      @{theory}),@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory}))),
                                      (tp[lt,lt,lt,lf,lt,lf,var_b"b'0",lt],
                                       let'
                                         (tp[var_w("imm",64),var("strm3",@{typ "8 word list"})],
                                          ite(eq(mop(Cast w1,ll[var_b"b'0"]),lw(0,1)),
                                              call
                                                ("immediate32",
                                                 @{typ "64 word \<times> 8 word list"},lnl w8,
                                                 @{theory}),
                                              call
                                                ("immediate8",@{typ "64 word \<times> 8 word list"},
                                                 lnl w8,@{theory})),
                                          call
                                            ("Zinst.Zfull_inst",@{typ Zinst},
                                             tp[var("p",@{typ "8 word list"}),
                                                call
                                                  ("instruction.Zjcc",@{typ instruction},
                                                   tp[lc("Z_ALWAYS","Zcond",@{theory}),
                                                      var_w("imm",64)],@{theory}),
                                                var("strm3",@{typ "8 word list"})],@{theory}))),
                                      (tp[lt,lt,lt,lt,lf,lt,lt,var_b"v'0"],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),mop(Cast w1,ll[var_b"v'0"]),
                                                var_b"op_size_override"],@{theory}),
                                          let'
                                            (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                                var("strm3",@{typ "8 word list"})],
                                             call
                                               ("readOpcodeModRM",
                                                @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                                tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                             itb([(eq(var_w("opcode",3),lw(0,3)),
                                                   let'
                                                     (tp[var_w("imm",64),
                                                         var("strm4",@{typ "8 word list"})],
                                                      call
                                                        ("immediate",
                                                         @{typ "64 word \<times> 8 word list"},
                                                         tp[var("size",@{typ Zsize}),
                                                            var("strm3",@{typ "8 word list"})],
                                                         @{theory}),
                                                      call
                                                        ("Zinst.Zfull_inst",@{typ Zinst},
                                                         tp[var("p",@{typ "8 word list"}),
                                                            call
                                                              ("instruction.Zbinop",
                                                               @{typ instruction},
                                                               tp[lc("Ztest","Zbinop_name",@{theory}),
                                                                  var("size",@{typ Zsize}),
                                                                  call
                                                                    ("Zdest_src.Zrm_i",
                                                                     @{typ Zdest_src},
                                                                     tp[var("rm",@{typ Zrm}),
                                                                        var_w("imm",64)],@{theory})],
                                                               @{theory}),
                                                            var("strm4",@{typ "8 word list"})],
                                                         @{theory}))),
                                                  (eq(var_w("opcode",3),lw(2,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmonop",@{typ instruction},
                                                            tp[lc("Znot","Zmonop_name",@{theory}),
                                                               var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(3,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmonop",@{typ instruction},
                                                            tp[lc("Zneg","Zmonop_name",@{theory}),
                                                               var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(4,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmul",@{typ instruction},
                                                            tp[var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(6,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zdiv",@{typ instruction},
                                                            tp[var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory}))],
                                                 call
                                                   ("Zinst.Zdec_fail",@{typ Zinst},
                                                    ls"Unsupported opcode: Unary Group 3",@{theory}))))),
                                      (tp[lt,lt,lt,lt,lt,lt,lt,lf],
                                       let'
                                         (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                             var("strm3",@{typ "8 word list"})],
                                          call
                                            ("readOpcodeModRM",
                                             @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                             tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                          itb([(eq(var_w("opcode",3),lw(0,3)),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zmonop",@{typ instruction},
                                                         tp[lc("Zinc","Zmonop_name",@{theory}),
                                                            call
                                                              ("Zsize.Z8",@{typ Zsize},
                                                               var_b"have_rex",@{theory}),
                                                            var("rm",@{typ Zrm})],@{theory}),
                                                      var("strm3",@{typ "8 word list"})],@{theory})),
                                               (eq(var_w("opcode",3),lw(1,3)),
                                                call
                                                  ("Zinst.Zfull_inst",@{typ Zinst},
                                                   tp[var("p",@{typ "8 word list"}),
                                                      call
                                                        ("instruction.Zmonop",@{typ instruction},
                                                         tp[lc("Zdec","Zmonop_name",@{theory}),
                                                            call
                                                              ("Zsize.Z8",@{typ Zsize},
                                                               var_b"have_rex",@{theory}),
                                                            var("rm",@{typ Zrm})],@{theory}),
                                                      var("strm3",@{typ "8 word list"})],@{theory}))],
                                              call
                                                ("Zinst.Zdec_fail",@{typ Zinst},
                                                 ls"Unsupported opcode: INC/DEC Group 4",@{theory})))),
                                      (tp[lt,lt,lt,lt,lt,lt,lt,lt],
                                       let'
                                         (var("size",@{typ Zsize}),
                                          call
                                            ("OpSize",@{typ Zsize},
                                             tp[var_b"have_rex",
                                                call
                                                  ("REX.W",HOLogic.boolT,var("REX",@{typ REX}),
                                                   @{theory}),lw(1,1),var_b"op_size_override"],
                                             @{theory}),
                                          let'
                                            (tp[var_w("opcode",3),var("rm",@{typ Zrm}),
                                                var("strm3",@{typ "8 word list"})],
                                             call
                                               ("readOpcodeModRM",
                                                @{typ "3 word \<times> Zrm \<times> 8 word list"},
                                                tp[var("REX",@{typ REX}),lnl w8],@{theory}),
                                             itb([(eq(var_w("opcode",3),lw(0,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmonop",@{typ instruction},
                                                            tp[lc("Zinc","Zmonop_name",@{theory}),
                                                               var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(1,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zmonop",@{typ instruction},
                                                            tp[lc("Zdec","Zmonop_name",@{theory}),
                                                               var("size",@{typ Zsize}),
                                                               var("rm",@{typ Zrm})],@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(2,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zcall",@{typ instruction},
                                                            call
                                                              ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                               var("rm",@{typ Zrm}),@{theory}),
                                                            @{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(4,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zjmp",@{typ instruction},
                                                            var("rm",@{typ Zrm}),@{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory})),
                                                  (eq(var_w("opcode",3),lw(6,3)),
                                                   call
                                                     ("Zinst.Zfull_inst",@{typ Zinst},
                                                      tp[var("p",@{typ "8 word list"}),
                                                         call
                                                           ("instruction.Zpush",@{typ instruction},
                                                            call
                                                              ("Zimm_rm.Zrm",@{typ Zimm_rm},
                                                               var("rm",@{typ Zrm}),@{theory}),
                                                            @{theory}),
                                                         var("strm3",@{typ "8 word list"})],
                                                      @{theory}))],
                                                 call
                                                   ("Zinst.Zdec_fail",@{typ Zinst},
                                                    ls"Unsupported opcode: INC/DEC Group 5",
                                                    @{theory}))))),
                                      (tp[var_b"opc'7",var_b"opc'6",var_b"opc'5",var_b"opc'4",
                                          var_b"opc'3",var_b"opc'2",var_b"opc'1",var_b"opc'0"],
                                       call
                                         ("Zinst.Zdec_fail",@{typ Zinst},
                                          cc[ls"Unsupported opcode: ",
                                             mop(Cast(@{typ string}),
                                                 mop(Cast w8,
                                                     ll[var_b"opc'7",var_b"opc'6",var_b"opc'5",
                                                        var_b"opc'4",var_b"opc'3",var_b"opc'2",
                                                        var_b"opc'1",var_b"opc'0"]))],@{theory}))],
                                     @{context}))],@{context}))),
                         (lnl w8,call("Zinst.Zdec_fail",@{typ Zinst},ls"No opcode",@{theory}))],
                        @{context})))))],@{context})))
end
\<close>

ML \<open>
local 
open L3 
in
val () = def
  ("x64_fetch",
   mn(lnl w8,
      mb(forloop
           (tp[ln 19,ln 0,
               close
                 (var_n"i",
                  mb(mr(close
                          (var("s",@{typ "(8 word list) \<times> Labelled_X64_state"}),
                           call
                             ("Labelled_X64_state.MEM",@{typ "64 word \<Rightarrow> 8 word"},
                              mop(Snd,var("s",@{typ "(8 word list) \<times> Labelled_X64_state"})),
                              @{theory}))),
                     close
                       (var("v",@{typ "64 word \<Rightarrow> 8 word"}),
                        mb(mb(mb(mb(mr(close
                                         (var("s",@{typ "(8 word list) \<times> Labelled_X64_state"}),
                                          call
                                            ("Labelled_X64_state.RIP",w64,
                                             mop(Snd,
                                                 var("s",
                                                     @{typ
                                                     "(8 word list) \<times> Labelled_X64_state"})),
                                             @{theory}))),
                                    close
                                      (var_w("v0",64),
                                       mb(mu(bop(Add,var_w("v0",64),mop(Cast w64,var_n"i")),
                                             @{typ "(8 word list) \<times> Labelled_X64_state"}),
                                          close
                                            (var_w("v0",64),
                                             mu(apply
                                                  (var("v",@{typ "64 word \<Rightarrow> 8 word"}),
                                                   var_w("v0",64)),
                                                @{typ "(8 word list) \<times> Labelled_X64_state"}))))),
                                 close
                                   (var_w("v",8),
                                    mb(mr(close
                                            (var("s",
                                                 @{typ "(8 word list) \<times> Labelled_X64_state"}),
                                             mop(Fst,
                                                 var("s",
                                                     @{typ
                                                     "(8 word list) \<times> Labelled_X64_state"})))),
                                       close
                                         (var("v0",@{typ "8 word list"}),
                                          mu(tp[var_w("v",8),var("v0",@{typ "8 word list"})],
                                             @{typ "(8 word list) \<times> Labelled_X64_state"}))))),
                              close
                                (var("v",@{typ "8 word \<times> 8 word list"}),
                                 mu(llc([],var("v",@{typ "8 word \<times> 8 word list"})),
                                    @{typ "(8 word list) \<times> Labelled_X64_state"}))),
                           close
                             (var("v",@{typ "8 word list"}),
                              mw(close
                                   (var("s",@{typ "(8 word list) \<times> Labelled_X64_state"}),
                                    tp[var("v",@{typ "8 word list"}),
                                       mop(Snd,
                                           var("s",
                                               @{typ "(8 word list) \<times> Labelled_X64_state"}))])))))))]),
         close
           (var_a HOLogic.unitT,
            mr(close
                 (var("s",@{typ "(8 word list) \<times> Labelled_X64_state"}),
                  mop(Fst,var("s",@{typ "(8 word list) \<times> Labelled_X64_state"}))))))))
end
\<close>

ML \<open>
local 
open L3 
val qTy = @{typ Labelled_X64_state} 
in
val () = def
  ("x64_next",
   mb(const
        ("x64_fetch",
         @{typ "Labelled_X64_state \<Rightarrow> ((8 word list) \<times> Labelled_X64_state)"},
         @{theory}),
      close
        (var("v",@{typ "8 word list"}),
         mb(mu(call("x64_decode",@{typ Zinst},var("v",@{typ "8 word list"}),@{theory}),qTy),
            close
              (var("x",@{typ Zinst}),
               cs(var("x",@{typ Zinst}),
                  [(call
                      ("Zinst.Zfull_inst",@{typ Zinst},
                       tp[var_a(@{typ "8 word list"}),var("i",@{typ instruction}),
                          var("strm1",@{typ "8 word list"})],@{theory}),
                    mb(mr(close
                            (var("s",qTy),call("Labelled_X64_state.RIP",w64,var("s",qTy),@{theory}))),
                       close
                         (var_w("v",64),
                          mb(mb(mu(bop(Add,var_w("v",64),
                                       mop(Cast w64,
                                           bop(Sub,ln 20,
                                               mop(Length,var("strm1",@{typ "8 word list"}))))),qTy),
                                close
                                  (var_w("v",64),
                                   mw(close
                                        (var("s",qTy),
                                         rupd
                                           ("Labelled_X64_state.RIP",tp[var("s",qTy),var_w("v",64)],
                                            @{theory}))))),
                             close
                               (var_a HOLogic.unitT,
                                call
                                  ("Run",
                                   @{typ
                                   "Labelled_X64_state \<Rightarrow>
                                    (unit \<times> Labelled_X64_state)"},
                                   var("i",@{typ instruction}),@{theory})))))),
                   (call("Zinst.Zdec_fail",@{typ Zinst},var_s"s",@{theory}),
                    call
                      ("raise'exception",
                       @{typ "Labelled_X64_state \<Rightarrow> (unit \<times> Labelled_X64_state)"},
                       call("exception.FAILURE",@{typ exception},var_s"s",@{theory}),@{theory}))],
                  @{context}))))))
end
\<close>
termination readPrefix by lexicographic_order
end