/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */
 

#ifndef __LW_PARSER_H
#define __LW_PARSER_H

class LWVariable;
class LWPiece;
class LWBoard;
class LWCommandSegment;
class LWCommand;
class LWValue;
class LWProgram;

class LWProgramData {
GNode *tree_piece;
GSList *list_vars;

public:
~LWProgramData ();
void registerVariable (LWVariable *variable);
void setTree (GNode *a_tree);
GNode *getTree ();
void debugTree ();
};

class LWParser {
static guint ref_data;
static LWPiece *begin_piece;

static void matchWith (LWCommandSegment*pcmd, LWCommand *cmd, LWPiece *piece);
static void compareParity (gboolean **r, 
						LWCommand *cmd_a, LWPiece *piece_a,
						LWCommand *cmd_b, LWPiece *piece_b);
static gboolean comparePriority (LWPiece *a, LWPiece *b); 
static void toggleToSymbol (LWPiece *piece, const gchar *symbolname);
static void lexScan (LWPiece *prev, LWPiece *piece);
static GNode *parseIteration (GNode *prev, LWPiece *piece);
static LWValue *computeValue (LWProgramData *pd, GNode *node);
static void setArguments (LWProgramData *pd, LWCommand *cmd, GNode *node);
static void checkNode (LWProgramData *pd, GNode *node);
static gboolean parseIterCmd (GNode **nodeptr, GNode **nodeptr2, LWPiece *piece);

LWProgram *program;
gboolean enable_debug;
	
public:
static void unrefData ();
static LWCommand *getNodeCommand (GNode *node);
		
LWParser (LWProgram *a_program);
~LWParser ();
LWProgramData *parse (LWBoard *program_board);
void enableDebug (gboolean enable);
};

#endif
