; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=powerpc-ibm-aix-xcoff -verify-machineinstrs \
; RUN:          -mcpu=pwr8 -vec-extabi | FileCheck %s

; The build[csilf] functions simply test the scalar_to_vector handling with
; direct moves. This corresponds to the "insertelement" instruction. Subsequent
; to this, there will be a splat corresponding to the shufflevector.

@d = common global double 0.000000e+00, align 8

; Function Attrs: norecurse nounwind readnone
define <16 x i8> @buildc(i8 zeroext %a) {
; CHECK-LABEL: buildc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtvsrwz 34, 3
; CHECK-NEXT:    vspltb 2, 2, 7
; CHECK-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <16 x i8> undef, i8 %a, i32 0
  %splat.splat = shufflevector <16 x i8> %splat.splatinsert, <16 x i8> undef, <16 x i32> zeroinitializer
  ret <16 x i8> %splat.splat
}

; Function Attrs: norecurse nounwind readnone
define <8 x i16> @builds(i16 zeroext %a) {
; CHECK-LABEL: builds:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    sth 3, -16(1)
; CHECK-NEXT:    lxvw4x 34, 0, 4
; CHECK-NEXT:    vsplth 2, 2, 0
; CHECK-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <8 x i16> undef, i16 %a, i32 0
  %splat.splat = shufflevector <8 x i16> %splat.splatinsert, <8 x i16> undef, <8 x i32> zeroinitializer
  ret <8 x i16> %splat.splat
}

; Function Attrs: norecurse nounwind readnone
define <4 x i32> @buildi(i32 zeroext %a) {
; CHECK-LABEL: buildi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    stw 3, -16(1)
; CHECK-NEXT:    lxvw4x 0, 0, 4
; CHECK-NEXT:    xxspltw 34, 0, 0
; CHECK-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <4 x i32> undef, i32 %a, i32 0
  %splat.splat = shufflevector <4 x i32> %splat.splatinsert, <4 x i32> undef, <4 x i32> zeroinitializer
  ret <4 x i32> %splat.splat
}

; Function Attrs: norecurse nounwind readnone
define <2 x i64> @buildl(i64 %a) {
; CHECK-LABEL: buildl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stw 4, -16(1)
; CHECK-NEXT:    stw 3, -32(1)
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    addi 4, 1, -32
; CHECK-NEXT:    lxvw4x 34, 0, 3
; CHECK-NEXT:    lxvw4x 35, 0, 4
; CHECK-NEXT:    vmrghw 2, 3, 2
; CHECK-NEXT:    xxswapd 0, 34
; CHECK-NEXT:    xxsldwi 34, 0, 34, 2
; CHECK-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <2 x i64> undef, i64 %a, i32 0
  %splat.splat = shufflevector <2 x i64> %splat.splatinsert, <2 x i64> undef, <2 x i32> zeroinitializer
  ret <2 x i64> %splat.splat
}

; Function Attrs: norecurse nounwind readnone
define <4 x float> @buildf(float %a) {
; CHECK-LABEL: buildf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpspn 0, 1
; CHECK-NEXT:    xxspltw 34, 0, 1
; CHECK-NEXT:    blr
entry:
  %splat.splatinsert = insertelement <4 x float> undef, float %a, i32 0
  %splat.splat = shufflevector <4 x float> %splat.splatinsert, <4 x float> undef, <4 x i32> zeroinitializer
  ret <4 x float> %splat.splat
}

; The optimization to remove stack operations from PPCDAGToDAGISel::Select
; should still trigger for v2f64, producing an lxvdsx.
; Function Attrs: norecurse nounwind readonly
define <2 x double> @buildd() {
; CHECK-LABEL: buildd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz 3, L..C0(2)
; CHECK-NEXT:    lxvdsx 34, 0, 3
; CHECK-NEXT:    blr
entry:
  %0 = load double, double* @d, align 8
  %splat.splatinsert = insertelement <2 x double> undef, double %0, i32 0
  %splat.splat = shufflevector <2 x double> %splat.splatinsert, <2 x double> undef, <2 x i32> zeroinitializer
  ret <2 x double> %splat.splat
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc0(<16 x i8> %vsc) {
; CHECK-LABEL: getsc0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -16(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 0
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc1(<16 x i8> %vsc) {
; CHECK-LABEL: getsc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -15(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 1
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc2(<16 x i8> %vsc) {
; CHECK-LABEL: getsc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -14(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 2
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc3(<16 x i8> %vsc) {
; CHECK-LABEL: getsc3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -13(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 3
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc4(<16 x i8> %vsc) {
; CHECK-LABEL: getsc4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -12(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 4
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc5(<16 x i8> %vsc) {
; CHECK-LABEL: getsc5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -11(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 5
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc6(<16 x i8> %vsc) {
; CHECK-LABEL: getsc6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -10(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 6
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc7(<16 x i8> %vsc) {
; CHECK-LABEL: getsc7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -9(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 7
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc8(<16 x i8> %vsc) {
; CHECK-LABEL: getsc8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -8(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 8
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc9(<16 x i8> %vsc) {
; CHECK-LABEL: getsc9:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -7(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 9
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc10(<16 x i8> %vsc) {
; CHECK-LABEL: getsc10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -6(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 10
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc11(<16 x i8> %vsc) {
; CHECK-LABEL: getsc11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -5(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 11
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc12(<16 x i8> %vsc) {
; CHECK-LABEL: getsc12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -4(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 12
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc13(<16 x i8> %vsc) {
; CHECK-LABEL: getsc13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -3(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 13
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc14(<16 x i8> %vsc) {
; CHECK-LABEL: getsc14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -2(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 14
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getsc15(<16 x i8> %vsc) {
; CHECK-LABEL: getsc15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -1(1)
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 15
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc0(<16 x i8> %vuc) {
; CHECK-LABEL: getuc0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -16(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 0
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc1(<16 x i8> %vuc) {
; CHECK-LABEL: getuc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -15(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 1
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc2(<16 x i8> %vuc) {
; CHECK-LABEL: getuc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -14(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 2
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc3(<16 x i8> %vuc) {
; CHECK-LABEL: getuc3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -13(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 3
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc4(<16 x i8> %vuc) {
; CHECK-LABEL: getuc4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -12(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 4
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc5(<16 x i8> %vuc) {
; CHECK-LABEL: getuc5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -11(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 5
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc6(<16 x i8> %vuc) {
; CHECK-LABEL: getuc6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -10(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 6
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc7(<16 x i8> %vuc) {
; CHECK-LABEL: getuc7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -9(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 7
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc8(<16 x i8> %vuc) {
; CHECK-LABEL: getuc8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -8(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 8
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc9(<16 x i8> %vuc) {
; CHECK-LABEL: getuc9:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -7(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 9
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc10(<16 x i8> %vuc) {
; CHECK-LABEL: getuc10:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -6(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 10
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc11(<16 x i8> %vuc) {
; CHECK-LABEL: getuc11:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -5(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 11
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc12(<16 x i8> %vuc) {
;
; CHECK-LABEL: getuc12:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -4(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 12
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc13(<16 x i8> %vuc) {
; CHECK-LABEL: getuc13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -3(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 13
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc14(<16 x i8> %vuc) {
; CHECK-LABEL: getuc14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -2(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 14
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getuc15(<16 x i8> %vuc) {
; CHECK-LABEL: getuc15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lbz 3, -1(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 15
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i8 @getvelsc(<16 x i8> %vsc, i32 signext %i) {
; CHECK-LABEL: getvelsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    clrlwi 3, 3, 28
; CHECK-NEXT:    stxvw4x 34, 0, 4
; CHECK-NEXT:    lbzx 3, 4, 3
; CHECK-NEXT:    extsb 3, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vsc, i32 %i
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i8 @getveluc(<16 x i8> %vuc, i32 signext %i) {
; CHECK-LABEL: getveluc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    clrlwi 3, 3, 28
; CHECK-NEXT:    stxvw4x 34, 0, 4
; CHECK-NEXT:    lbzx 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %vuc, i32 %i
  ret i8 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss0(<8 x i16> %vss) {
; CHECK-LABEL: getss0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lha 3, -16(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 0
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss1(<8 x i16> %vss) {
; CHECK-LABEL: getss1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lha 3, -14(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 1
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss2(<8 x i16> %vss) {
; CHECK-LABEL: getss2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lha 3, -12(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 2
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss3(<8 x i16> %vss) {
; CHECK-LABEL: getss3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lha 3, -10(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 3
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss4(<8 x i16> %vss) {
; CHECK-LABEL: getss4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lha 3, -8(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 4
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss5(<8 x i16> %vss) {
; CHECK-LABEL: getss5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lha 3, -6(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 5
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss6(<8 x i16> %vss) {
; CHECK-LABEL: getss6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lha 3, -4(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 6
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getss7(<8 x i16> %vss) {
; CHECK-LABEL: getss7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lha 3, -2(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 7
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus0(<8 x i16> %vus) {
; CHECK-LABEL: getus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lhz 3, -16(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 0
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus1(<8 x i16> %vus) {
; CHECK-LABEL: getus1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lhz 3, -14(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 1
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus2(<8 x i16> %vus) {
; CHECK-LABEL: getus2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lhz 3, -12(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 2
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus3(<8 x i16> %vus) {
; CHECK-LABEL: getus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lhz 3, -10(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 3
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus4(<8 x i16> %vus) {
; CHECK-LABEL: getus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lhz 3, -8(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 4
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus5(<8 x i16> %vus) {
; CHECK-LABEL: getus5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lhz 3, -6(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 5
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus6(<8 x i16> %vus) {
; CHECK-LABEL: getus6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lhz 3, -4(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 6
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getus7(<8 x i16> %vus) {
; CHECK-LABEL: getus7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lhz 3, -2(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 7
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i16 @getvelss(<8 x i16> %vss, i32 signext %i) {
; CHECK-LABEL: getvelss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-NEXT:    stxvw4x 34, 0, 4
; CHECK-NEXT:    lhax 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vss, i32 %i
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i16 @getvelus(<8 x i16> %vus, i32 signext %i) {
; CHECK-LABEL: getvelus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-NEXT:    stxvw4x 34, 0, 4
; CHECK-NEXT:    lhzx 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %vus, i32 %i
  ret i16 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getsi0(<4 x i32> %vsi) {
; CHECK-LABEL: getsi0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -16(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 0
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getsi1(<4 x i32> %vsi) {
; CHECK-LABEL: getsi1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -12(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 1
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getsi2(<4 x i32> %vsi) {
; CHECK-LABEL: getsi2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -8(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 2
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getsi3(<4 x i32> %vsi) {
; CHECK-LABEL: getsi3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -4(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 3
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getui0(<4 x i32> %vui) {
; CHECK-LABEL: getui0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -16(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 0
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getui1(<4 x i32> %vui) {
; CHECK-LABEL: getui1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -12(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 1
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getui2(<4 x i32> %vui) {
; CHECK-LABEL: getui2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -8(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 2
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getui3(<4 x i32> %vui) {
; CHECK-LABEL: getui3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -4(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 3
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @getvelsi(<4 x i32> %vsi, i32 signext %i) {
; CHECK-LABEL: getvelsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-NEXT:    stxvw4x 34, 0, 4
; CHECK-NEXT:    lwzx 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vsi, i32 %i
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define zeroext i32 @getvelui(<4 x i32> %vui, i32 signext %i) {
; CHECK-LABEL: getvelui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-NEXT:    stxvw4x 34, 0, 4
; CHECK-NEXT:    lwzx 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %vui, i32 %i
  ret i32 %vecext
}

; Function Attrs: norecurse nounwind readnone
define i64 @getsl0(<2 x i64> %vsl) {
; CHECK-LABEL: getsl0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -16(1)
; CHECK-NEXT:    lwz 4, -12(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vsl, i32 0
  ret i64 %vecext
}

; Function Attrs: norecurse nounwind readnone
define i64 @getsl1(<2 x i64> %vsl) {
; CHECK-LABEL: getsl1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -8(1)
; CHECK-NEXT:    lwz 4, -4(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vsl, i32 1
  ret i64 %vecext
}

; Function Attrs: norecurse nounwind readnone
define i64 @getul0(<2 x i64> %vul) {
; CHECK-LABEL: getul0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -16(1)
; CHECK-NEXT:    lwz 4, -12(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vul, i32 0
  ret i64 %vecext
}

; Function Attrs: norecurse nounwind readnone
define i64 @getul1(<2 x i64> %vul) {
; CHECK-LABEL: getul1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    stxvw4x 34, 0, 3
; CHECK-NEXT:    lwz 3, -8(1)
; CHECK-NEXT:    lwz 4, -4(1)
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vul, i32 1
  ret i64 %vecext
}

; Function Attrs: norecurse nounwind readnone
define i64 @getvelsl(<2 x i64> %vsl, i32 signext %i) {
; CHECK-LABEL: getvelsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add 3, 3, 3
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    addi 5, 3, 1
; CHECK-NEXT:    stxvw4x 34, 0, 4
; CHECK-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-NEXT:    rlwinm 5, 5, 2, 28, 29
; CHECK-NEXT:    lwzx 3, 4, 3
; CHECK-NEXT:    lwzx 4, 4, 5
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vsl, i32 %i
  ret i64 %vecext
}

; Function Attrs: norecurse nounwind readnone
define i64 @getvelul(<2 x i64> %vul, i32 signext %i) {
; CHECK-LABEL: getvelul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add 3, 3, 3
; CHECK-NEXT:    addi 4, 1, -16
; CHECK-NEXT:    addi 5, 3, 1
; CHECK-NEXT:    stxvw4x 34, 0, 4
; CHECK-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-NEXT:    rlwinm 5, 5, 2, 28, 29
; CHECK-NEXT:    lwzx 3, 4, 3
; CHECK-NEXT:    lwzx 4, 4, 5
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x i64> %vul, i32 %i
  ret i64 %vecext
}

; Function Attrs: norecurse nounwind readnone
define float @getf0(<4 x float> %vf) {
; CHECK-LABEL: getf0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvspdpn 1, 34
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 0
  ret float %vecext
}

; Function Attrs: norecurse nounwind readnone
define float @getf1(<4 x float> %vf) {
; CHECK-LABEL: getf1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsldwi 0, 34, 34, 1
; CHECK-NEXT:    xscvspdpn 1, 0
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 1
  ret float %vecext
}

; Function Attrs: norecurse nounwind readnone
define float @getf2(<4 x float> %vf) {
; CHECK-LABEL: getf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd 0, 34
; CHECK-NEXT:    xscvspdpn 1, 0
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 2
  ret float %vecext
}

; Function Attrs: norecurse nounwind readnone
define float @getf3(<4 x float> %vf) {
; CHECK-LABEL: getf3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxsldwi 0, 34, 34, 3
; CHECK-NEXT:    xscvspdpn 1, 0
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <4 x float> %vf, i32 3
  ret float %vecext
}

; Function Attrs: norecurse nounwind readnone
define float @getvelf(<4 x float> %vf, i32 signext %i) {
; CHECK-LABEL: getvelf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slwi 3, 3, 2
; CHECK-NEXT:    lvsl 3, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    xscvspdpn 1, 34
; CHECK-NEXT:    blr
entry:
   %vecext = extractelement <4 x float> %vf, i32 %i
   ret float %vecext
}

; Function Attrs: norecurse nounwind readnone
define double @getd0(<2 x double> %vd) {
; CHECK-LABEL: getd0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlor 1, 34, 34
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x double> %vd, i32 0
  ret double %vecext
}

; Function Attrs: norecurse nounwind readnone
define double @getd1(<2 x double> %vd) {
; CHECK-LABEL: getd1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd 1, 34
; CHECK-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x double> %vd, i32 1
  ret double %vecext
}

; Function Attrs: norecurse nounwind readnone
define double @getveld(<2 x double> %vd, i32 signext %i) {
; CHECK-LABEL: getveld:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. 3, 3, 1
; CHECK-NEXT:    slwi 3, 3, 3
; CHECK-NEXT:    lvsl 3, 0, 3
; CHECK-NEXT:    vperm 2, 2, 2, 3
; CHECK-NEXT:    xxlor 1, 34, 34
; CHECK-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-NEXT:    blr
entry:
  %vecext = extractelement <2 x double> %vd, i32 %i
  ret double %vecext
}
