; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
;
; Verify that strchr calls with a string consisting of one or two sequences
; of all the same characters are folded and those with mixed strings are not.

@s1 = constant [2 x i8] c"\01\00"
@s11 = constant [3 x i8] c"\01\01\00"
@s111 = constant [4 x i8] c"\01\01\01\00"
@s000 = constant [4 x i8] c"\00\00\00\00"
@s11102 = constant [6 x i8] c"\01\01\01\00\02\00"
@s21111 = constant [6 x i8] c"\02\01\01\01\01\00"

declare i8* @strchr(i8*, i32)


; Fold strchr(S = "\01", C) to C == '\01' ? S : C == '\0' ? S + 1 : null.

define i8* @fold_strchr_s1_C(i32 %C) {
; CHECK-LABEL: @fold_strchr_s1_C(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[C:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    [[MEMCHR_SEL1:%.*]] = select i1 [[TMP2]], i8* getelementptr inbounds ([2 x i8], [2 x i8]* @s1, i64 0, i64 1), i8* null
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i8 [[TMP1]], 1
; CHECK-NEXT:    [[MEMCHR_SEL2:%.*]] = select i1 [[TMP3]], i8* getelementptr inbounds ([2 x i8], [2 x i8]* @s1, i64 0, i64 0), i8* [[MEMCHR_SEL1]]
; CHECK-NEXT:    ret i8* [[MEMCHR_SEL2]]
;
  %ptr = getelementptr inbounds [2 x i8], [2 x i8]* @s1, i64 0, i64 0
  %ret = call i8* @strchr(i8* %ptr, i32 %C)
  ret i8* %ret
}


; Fold strchr(S = "\01\01", C) to C == '\01' ? S : C == '\0' ? S + 2 : null.

define i8* @fold_strchr_s11_C(i32 %C) {
; CHECK-LABEL: @fold_strchr_s11_C(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[C:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    [[MEMCHR_SEL1:%.*]] = select i1 [[TMP2]], i8* getelementptr inbounds ([3 x i8], [3 x i8]* @s11, i64 0, i64 2), i8* null
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i8 [[TMP1]], 1
; CHECK-NEXT:    [[MEMCHR_SEL2:%.*]] = select i1 [[TMP3]], i8* getelementptr inbounds ([3 x i8], [3 x i8]* @s11, i64 0, i64 0), i8* [[MEMCHR_SEL1]]
; CHECK-NEXT:    ret i8* [[MEMCHR_SEL2]]
;
  %ptr = getelementptr inbounds [3 x i8], [3 x i8]* @s11, i64 0, i64 0
  %ret = call i8* @strchr(i8* %ptr, i32 %C)
  ret i8* %ret
}


; Fold strchr(S = "\01\01\01", C) to C == '\01' ? S : C == '\0' ? S + 3 : null.

define i8* @fold_strchr_s111_C(i32 %C) {
; CHECK-LABEL: @fold_strchr_s111_C(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[C:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    [[MEMCHR_SEL1:%.*]] = select i1 [[TMP2]], i8* getelementptr inbounds ([4 x i8], [4 x i8]* @s111, i64 0, i64 3), i8* null
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i8 [[TMP1]], 1
; CHECK-NEXT:    [[MEMCHR_SEL2:%.*]] = select i1 [[TMP3]], i8* getelementptr inbounds ([4 x i8], [4 x i8]* @s111, i64 0, i64 0), i8* [[MEMCHR_SEL1]]
; CHECK-NEXT:    ret i8* [[MEMCHR_SEL2]]
;
  %ptr = getelementptr inbounds [4 x i8], [4 x i8]* @s111, i64 0, i64 0
  %ret = call i8* @strchr(i8* %ptr, i32 %C)
  ret i8* %ret
}


; Fold strchr(S = "\00\00\00", C) to C == '\0' ? S : null.

define i8* @fold_strchr_s000_C(i32 %C) {
; CHECK-LABEL: @fold_strchr_s000_C(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[C:%.*]] to i8
; CHECK-NEXT:    [[MEMCHR_CHAR0CMP:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    [[MEMCHR_SEL:%.*]] = select i1 [[MEMCHR_CHAR0CMP]], i8* getelementptr inbounds ([4 x i8], [4 x i8]* @s000, i64 0, i64 0), i8* null
; CHECK-NEXT:    ret i8* [[MEMCHR_SEL]]
;
  %ptr = getelementptr inbounds [4 x i8], [4 x i8]* @s000, i64 0, i64 0
  %ret = call i8* @strchr(i8* %ptr, i32 %C)
  ret i8* %ret
}


; Do not fold strchr(S = "\02\01\01\01\01", C).  It's transformed to
; memchr(S, C, 6).

define i8* @xform_strchr_s21111_C(i32 %C) {
; CHECK-LABEL: @xform_strchr_s21111_C(
; CHECK-NEXT:    [[MEMCHR:%.*]] = call i8* @memchr(i8* noundef nonnull dereferenceable(1) getelementptr inbounds ([6 x i8], [6 x i8]* @s21111, i64 0, i64 0), i32 [[C:%.*]], i64 6)
; CHECK-NEXT:    ret i8* [[MEMCHR]]
;
  %ptr = getelementptr inbounds [6 x i8], [6 x i8]* @s21111, i64 0, i64 0
  %ret = call i8* @strchr(i8* %ptr, i32 %C)
  ret i8* %ret
}


; Fold strchr(S = "\02\01\01\01\01" + 1, C) to
;   C == '\01' ? S + 1 : C == '\0' ? S + 5 : null.

define i8* @fold_strchr_s21111p1_C(i32 %C) {
; CHECK-LABEL: @fold_strchr_s21111p1_C(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[C:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    [[MEMCHR_SEL1:%.*]] = select i1 [[TMP2]], i8* getelementptr inbounds ([6 x i8], [6 x i8]* @s21111, i64 0, i64 5), i8* null
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i8 [[TMP1]], 1
; CHECK-NEXT:    [[MEMCHR_SEL2:%.*]] = select i1 [[TMP3]], i8* getelementptr inbounds ([6 x i8], [6 x i8]* @s21111, i64 0, i64 1), i8* [[MEMCHR_SEL1]]
; CHECK-NEXT:    ret i8* [[MEMCHR_SEL2]]
;
  %ptr = getelementptr inbounds [6 x i8], [6 x i8]* @s21111, i64 0, i64 1
  %ret = call i8* @strchr(i8* %ptr, i32 %C)
  ret i8* %ret
}

; Fold strchr(S = "\01\01\01\00\02", C) to
;   C == '\01' ? S : C == '\0' ? S + 3 : null.

define i8* @fold_strchr_s11102_C(i32 %C) {
; CHECK-LABEL: @fold_strchr_s11102_C(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[C:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[TMP1]], 0
; CHECK-NEXT:    [[MEMCHR_SEL1:%.*]] = select i1 [[TMP2]], i8* getelementptr inbounds ([6 x i8], [6 x i8]* @s11102, i64 0, i64 3), i8* null
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i8 [[TMP1]], 1
; CHECK-NEXT:    [[MEMCHR_SEL2:%.*]] = select i1 [[TMP3]], i8* getelementptr inbounds ([6 x i8], [6 x i8]* @s11102, i64 0, i64 0), i8* [[MEMCHR_SEL1]]
; CHECK-NEXT:    ret i8* [[MEMCHR_SEL2]]
;
  %ptr = getelementptr inbounds [6 x i8], [6 x i8]* @s11102, i64 0, i64 0
  %ret = call i8* @strchr(i8* %ptr, i32 %C)
  ret i8* %ret
}
