%
%
%   Copyright (C) 2014, The University of Texas at Austin
%
%   This file is part of libflame and is available under the 3-Clause
%   BSD license, which can be found in the LICENSE file at the top-level
%   directory, or at http://opensource.org/licenses/BSD-3-Clause
%
%

function [C_out ] = FLA_Syrk_ln_unb_var3( A, C )

  [ AT, ...
    AB ] = FLA_Part_2x1( A, ...
                         0, 'FLA_BOTTOM' );

  [ CTL, CTR, ...
    CBL, CBR ] = FLA_Part_2x2( C, ...
                               0, 0, 'FLA_BR' );

  while ( size( AB, 1 ) < size( A, 1 ) )

    [ A0, ...
      a1t, ...
      A2 ] = FLA_Repart_2x1_to_3x1( AT, ...
                                    AB, ...
                                    1, 'FLA_TOP' );

    [ C00,  c01,     C02,  ...
      c10t, gamma11, c12t, ...
      C20,  c21,     C22 ] = FLA_Repart_2x2_to_3x3( CTL, CTR, ...
                                                    CBL, CBR, ...
                                                    1, 1, 'FLA_TL' );

    %------------------------------------------------------------%

    c21     = c21     + A2 * a1t';
    gamma11 = gamma11 + a1t * a1t';

    %------------------------------------------------------------%

    [ AT, ...
      AB ] = FLA_Cont_with_3x1_to_2x1( A0, ...
                                       a1t, ...
                                       A2, ...
                                       'FLA_BOTTOM' );

    [ CTL, CTR, ...
      CBL, CBR ] = FLA_Cont_with_3x3_to_2x2( C00,  c01,     C02,  ...
                                             c10t, gamma11, c12t, ...
                                             C20,  c21,     C22, ...
                                             'FLA_BR' );

  end

  C_out = [ CTL, CTR
            CBL, CBR ];

return


