#!/bin/bash

main() 
{
    script_name=${0##*/}
    echo " "
    echo " "
    echo " "${script_name}
    echo " "
    echo " Objective:"
    echo "   The script removes comma expressions, which are automatically generated by max and min macros."
    echo " "

    files="$(find . -maxdepth 1 -name "*.c")"
    for file in ${files}; do
        echo -ne "   Removing comma expressions from ... ${file}                  "\\r

        # This will convert too much. 
        # | sed  's/\(.* =.*\), \(.* =.*\);/\1; \2; \/\/ , expr subst  /g' 
        
        tmp_file=$(echo "${file}.back")
        ( mv -f ${file} ${tmp_file} ;
            cat ${tmp_file} \
                | sed  's/\([][a-z0-9_.]* =.*\), \([][a-z0-9_.]* =.*\);/\1; \2; \/\/ , expr subst  /g' \
                | sed  's/\([][a-z0-9_.]* =.*\), \([][a-z0-9_.]* =.*\), /\1; \2; /g' \
                | sed  '/\/\* Writing concatenation \*\//,/s_cat/d' \
                | sed  's/int s_cat(.*);//g' \
                > ${file} ;
            rm -f ${tmp_file} )
    done

    return 0
}

main "$@"
