# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.interactor_observer import InteractorObserver


class InteractorStyle(InteractorObserver):
    r"""
    InteractorStyle - provide event-driven interface to the rendering
    window (defines trackball mode)
    
    Superclass: InteractorObserver
    
    InteractorStyle is a base class implementing the majority of
    motion control routines and defines an event driven interface to
    support RenderWindowInteractor. RenderWindowInteractor
    implements platform dependent key/mouse routing and timer control,
    which forwards events in a neutral form to InteractorStyle.
    
    InteractorStyle implements the "joystick" style of interaction.
    That is, holding down the mouse keys generates a stream of events
    that cause continuous actions (e.g., rotate, translate, pan, zoom).
    (The class InteractorStyleTrackball implements a grab and move
    style.) The event bindings for this class include the following:
    - Keypress j / Keypress t: toggle between joystick (position
      sensitive) and trackball (motion sensitive) styles. In joystick
      style, motion occurs continuously as long as a mouse button is
      pressed. In trackball style, motion occurs when the mouse button is
    pressed and the mouse pointer moves.
    - Keypress c / Keypress a: toggle between camera and actor modes. In
      camera mode, mouse events affect the camera position and focal
      point. In actor mode, mouse events affect the actor that is under
      the mouse pointer.
    - Button 1: rotate the camera around its focal point (if camera mode)
    or rotate the actor around its origin (if actor mode). The rotation
      is in the direction defined from the center of the renderer's
      viewport towards the mouse position. In joystick mode, the
      magnitude of the rotation is determined by the distance the mouse
      is from the center of the render window.
    - Button 2: pan the camera (if camera mode) or translate the actor
      (if actor mode). In joystick mode, the direction of pan or
      translation is from the center of the viewport towards the mouse
      position. In trackball mode, the direction of motion is the
      direction the mouse moves. (Note: with 2-button mice, pan is
      defined as <Shift>-Button 1.)
    - Button 3: zoom the camera (if camera mode) or scale the actor (if
      actor mode). Zoom in/increase scale if the mouse position is in the
    top half of the viewport; zoom out/decrease scale if the mouse
      position is in the bottom half. In joystick mode, the amount of
      zoom is controlled by the distance of the mouse pointer from the
      horizontal centerline of the window.
    - Keypress 3: toggle the render window into and out of stereo mode.
      By default, red-blue stereo pairs are created. Some systems support
    Crystal Eyes LCD stereo glasses; you have to invoke
      set_stereo_type_to_crystal_eyes() on the rendering window.
    - Keypress e: exit the application.
    - Keypress f: fly to the picked point
    - Keypress p: perform a pick operation. The render window interactor
      has an internal instance of CellPicker that it uses to pick.
    - Keypress r: reset the camera view along the current view direction.
    Centers the actors and moves the camera so that all actors are
      visible.
    - Keypress s: modify the representation of all actors so that they
      are surfaces.
    - Keypress u: invoke the user-defined function. Typically, this
      keypress will bring up an interactor that you can type commands in.
      Typing u calls user_call_back() on the RenderWindowInteractor,
      which invokes a Command::UserEvent. In other words, to define a
      user-defined callback, just add an observer to the
      Command::UserEvent on the RenderWindowInteractor object.
    - Keypress w: modify the representation of all actors so that they
      are wireframe.
    
    InteractorStyle can be subclassed to provide new interaction
    styles and a facility to override any of the default mouse/key
    operations which currently handle trackball or joystick styles is
    provided. Note that this class will fire a variety of events that can
    be watched using an observer, such as left_button_press_event,
    left_button_release_event, middle_button_press_event,
    middle_button_release_event, right_button_press_event,
    right_button_release_event, enter_event, leave_event, key_press_event,
    key_release_event, char_event, expose_event, configure_event, timer_event,
    mouse_move_event,
    
    @sa
    InteractorStyleTrackball
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkInteractorStyle, obj, update, **traits)
    
    auto_adjust_camera_clipping_range = tvtk_base.true_bool_trait(desc=\
        r"""
        If auto_adjust_camera_clipping_range is on, then before each render
        the camera clipping range will be adjusted to "fit" the whole
        scene. Clipping will still occur if objects in the scene are
        behind the camera or come very close. If
        auto_adjust_camera_clipping_range is off, no adjustment will be made
        per render, but the camera clipping range will still be reset
        when the camera is reset.
        """
    )

    def _auto_adjust_camera_clipping_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutoAdjustCameraClippingRange,
                        self.auto_adjust_camera_clipping_range_)

    handle_observers = tvtk_base.true_bool_trait(desc=\
        r"""
        Does process_events handle observers on this class or not
        """
    )

    def _handle_observers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHandleObservers,
                        self.handle_observers_)

    use_timers = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _use_timers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseTimers,
                        self.use_timers_)

    def _get_interactor(self):
        return wrap_vtk(self._vtk_obj.GetInteractor())
    def _set_interactor(self, arg):
        old_val = self._get_interactor()
        self._wrap_call(self._vtk_obj.SetInteractor,
                        deref_vtk(arg))
        self.trait_property_changed('interactor', old_val, arg)
    interactor = traits.Property(_get_interactor, _set_interactor, desc=\
        r"""
        
        """
    )

    mouse_wheel_motion_factor = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the mouse wheel motion factor. Default to 1.0. Set it to
        a different value to emphasize or de-emphasize the action
        triggered by mouse wheel motion.
        """
    )

    def _mouse_wheel_motion_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMouseWheelMotionFactor,
                        self.mouse_wheel_motion_factor)

    pick_color = tvtk_base.vtk_color_trait((1.0, 0.0, 0.0), desc=\
        r"""
        Set/Get the pick color (used by default to color Actor2D's).
        The color is expressed as red/green/blue values between
        (0.0,1.0).
        """
    )

    def _pick_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPickColor,
                        self.pick_color, False)

    def _get_t_dx_style(self):
        return wrap_vtk(self._vtk_obj.GetTDxStyle())
    def _set_t_dx_style(self, arg):
        old_val = self._get_t_dx_style()
        self._wrap_call(self._vtk_obj.SetTDxStyle,
                        deref_vtk(arg))
        self.trait_property_changed('t_dx_style', old_val, arg)
    t_dx_style = traits.Property(_get_t_dx_style, _set_t_dx_style, desc=\
        r"""
        3Dconnexion device interactor style. Initial value is a pointer
        to an object of class TdxInteractorStyleCamera.
        """
    )

    timer_duration = traits.Trait(10, traits.Range(1, 100000, enter_set=True, auto_set=False), desc=\
        r"""
        If using timers, specify the default timer interval (in
        milliseconds). Care must be taken when adjusting the timer
        interval from the default value of 10 milliseconds--it may
        adversely affect the interactors.
        """
    )

    def _timer_duration_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimerDuration,
                        self.timer_duration)

    def _get_auto_adjust_camera_clipping_range_max_value(self):
        return self._vtk_obj.GetAutoAdjustCameraClippingRangeMaxValue()
    auto_adjust_camera_clipping_range_max_value = traits.Property(_get_auto_adjust_camera_clipping_range_max_value, desc=\
        r"""
        
        """
    )

    def _get_auto_adjust_camera_clipping_range_min_value(self):
        return self._vtk_obj.GetAutoAdjustCameraClippingRangeMinValue()
    auto_adjust_camera_clipping_range_min_value = traits.Property(_get_auto_adjust_camera_clipping_range_min_value, desc=\
        r"""
        
        """
    )

    def _get_state(self):
        return self._vtk_obj.GetState()
    state = traits.Property(_get_state, desc=\
        r"""
        Some useful information for interaction
        """
    )

    def delegate_t_dx_event(self, *args):
        """
        delegate_t_dx_event(self, event:int, calldata:Pointer) -> None
        C++: void delegate_t_dx_event(unsigned long event, void *calldata)
        Called by the callback to process 3DConnexion device events.
        """
        ret = self._wrap_call(self._vtk_obj.DelegateTDxEvent, *args)
        return ret

    def dolly(self):
        """
        dolly(self) -> None
        C++: virtual void dolly()"""
        ret = self._vtk_obj.Dolly()
        return ret
        

    def end_dolly(self):
        """
        end_dolly(self) -> None
        C++: virtual void end_dolly()"""
        ret = self._vtk_obj.EndDolly()
        return ret
        

    def end_env_rotate(self):
        """
        end_env_rotate(self) -> None
        C++: virtual void end_env_rotate()"""
        ret = self._vtk_obj.EndEnvRotate()
        return ret
        

    def end_gesture(self):
        """
        end_gesture(self) -> None
        C++: virtual void end_gesture()"""
        ret = self._vtk_obj.EndGesture()
        return ret
        

    def end_pan(self):
        """
        end_pan(self) -> None
        C++: virtual void end_pan()"""
        ret = self._vtk_obj.EndPan()
        return ret
        

    def end_rotate(self):
        """
        end_rotate(self) -> None
        C++: virtual void end_rotate()"""
        ret = self._vtk_obj.EndRotate()
        return ret
        

    def end_spin(self):
        """
        end_spin(self) -> None
        C++: virtual void end_spin()"""
        ret = self._vtk_obj.EndSpin()
        return ret
        

    def end_timer(self):
        """
        end_timer(self) -> None
        C++: virtual void end_timer()"""
        ret = self._vtk_obj.EndTimer()
        return ret
        

    def end_two_pointer(self):
        """
        end_two_pointer(self) -> None
        C++: virtual void end_two_pointer()"""
        ret = self._vtk_obj.EndTwoPointer()
        return ret
        

    def end_uniform_scale(self):
        """
        end_uniform_scale(self) -> None
        C++: virtual void end_uniform_scale()"""
        ret = self._vtk_obj.EndUniformScale()
        return ret
        

    def end_zoom(self):
        """
        end_zoom(self) -> None
        C++: virtual void end_zoom()"""
        ret = self._vtk_obj.EndZoom()
        return ret
        

    def environment_rotate(self):
        """
        environment_rotate(self) -> None
        C++: virtual void environment_rotate()"""
        ret = self._vtk_obj.EnvironmentRotate()
        return ret
        

    def find_poked_renderer(self, *args):
        """
        find_poked_renderer(self, __a:int, __b:int) -> None
        C++: void find_poked_renderer(int, int)
        When an event occurs, we must determine which Renderer the event
        occurred within, since one render_window may contain multiple
        renderers.
        """
        ret = self._wrap_call(self._vtk_obj.FindPokedRenderer, *args)
        return ret

    def highlight_actor2d(self, *args):
        """
        highlight_actor2d(self, actor2D:Actor2D) -> None
        C++: virtual void highlight_actor2d(Actor2D *actor2D)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HighlightActor2D, *my_args)
        return ret

    def highlight_prop(self, *args):
        """
        highlight_prop(self, prop:Prop) -> None
        C++: virtual void highlight_prop(Prop *prop)
        When picking successfully selects an actor, this method
        highlights the picked prop appropriately. Currently this is done
        by placing a bounding box around a picked Prop3D, and using
        the pick_color to highlight a Prop2D.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HighlightProp, *my_args)
        return ret

    def highlight_prop3d(self, *args):
        """
        highlight_prop3d(self, prop3D:Prop3D) -> None
        C++: virtual void highlight_prop3d(Prop3D *prop3D)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HighlightProp3D, *my_args)
        return ret

    def on_button3d(self, *args):
        """
        on_button3d(self, __a:EventData) -> None
        C++: virtual void on_button3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnButton3D, *my_args)
        return ret

    def on_clip3d(self, *args):
        """
        on_clip3d(self, __a:EventData) -> None
        C++: virtual void on_clip3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnClip3D, *my_args)
        return ret

    def on_configure(self):
        """
        on_configure(self) -> None
        C++: virtual void on_configure()"""
        ret = self._vtk_obj.OnConfigure()
        return ret
        

    def on_drop_files(self, *args):
        """
        on_drop_files(self, filePaths:StringArray) -> None
        C++: virtual void on_drop_files(StringArray *filePaths)
        When files are dropped on the render window. The argument
        contains the list of file paths dropped. It is called after
        on_drop_location.
        """
        my_args = deref_array(args, [['vtkStringArray']])
        ret = self._wrap_call(self._vtk_obj.OnDropFiles, *my_args)
        return ret

    def on_drop_location(self, *args):
        """
        on_drop_location(self, position:[float, ...]) -> None
        C++: virtual void on_drop_location(double *position)
        When the mouse location is updated while dragging files. The
        argument contains the position relative to the window of the
        mouse where the files are dropped. It is called before
        on_drop_files.
        """
        ret = self._wrap_call(self._vtk_obj.OnDropLocation, *args)
        return ret

    def on_end_pan(self):
        """
        on_end_pan(self) -> None
        C++: virtual void on_end_pan()"""
        ret = self._vtk_obj.OnEndPan()
        return ret
        

    def on_end_pinch(self):
        """
        on_end_pinch(self) -> None
        C++: virtual void on_end_pinch()"""
        ret = self._vtk_obj.OnEndPinch()
        return ret
        

    def on_end_rotate(self):
        """
        on_end_rotate(self) -> None
        C++: virtual void on_end_rotate()"""
        ret = self._vtk_obj.OnEndRotate()
        return ret
        

    def on_end_swipe(self):
        """
        on_end_swipe(self) -> None
        C++: virtual void on_end_swipe()"""
        ret = self._vtk_obj.OnEndSwipe()
        return ret
        

    def on_enter(self):
        """
        on_enter(self) -> None
        C++: virtual void on_enter()"""
        ret = self._vtk_obj.OnEnter()
        return ret
        

    def on_expose(self):
        """
        on_expose(self) -> None
        C++: virtual void on_expose()
        These are more esoteric events, but are useful in some cases.
        """
        ret = self._vtk_obj.OnExpose()
        return ret
        

    def on_fifth_button_down(self):
        """
        on_fifth_button_down(self) -> None
        C++: virtual void on_fifth_button_down()"""
        ret = self._vtk_obj.OnFifthButtonDown()
        return ret
        

    def on_fifth_button_up(self):
        """
        on_fifth_button_up(self) -> None
        C++: virtual void on_fifth_button_up()"""
        ret = self._vtk_obj.OnFifthButtonUp()
        return ret
        

    def on_fourth_button_down(self):
        """
        on_fourth_button_down(self) -> None
        C++: virtual void on_fourth_button_down()"""
        ret = self._vtk_obj.OnFourthButtonDown()
        return ret
        

    def on_fourth_button_up(self):
        """
        on_fourth_button_up(self) -> None
        C++: virtual void on_fourth_button_up()"""
        ret = self._vtk_obj.OnFourthButtonUp()
        return ret
        

    def on_key_down(self):
        """
        on_key_down(self) -> None
        C++: virtual void on_key_down()"""
        ret = self._vtk_obj.OnKeyDown()
        return ret
        

    def on_key_press(self):
        """
        on_key_press(self) -> None
        C++: virtual void on_key_press()"""
        ret = self._vtk_obj.OnKeyPress()
        return ret
        

    def on_key_release(self):
        """
        on_key_release(self) -> None
        C++: virtual void on_key_release()"""
        ret = self._vtk_obj.OnKeyRelease()
        return ret
        

    def on_key_up(self):
        """
        on_key_up(self) -> None
        C++: virtual void on_key_up()"""
        ret = self._vtk_obj.OnKeyUp()
        return ret
        

    def on_leave(self):
        """
        on_leave(self) -> None
        C++: virtual void on_leave()"""
        ret = self._vtk_obj.OnLeave()
        return ret
        

    def on_left_button_double_click(self):
        """
        on_left_button_double_click(self) -> None
        C++: virtual void on_left_button_double_click()"""
        ret = self._vtk_obj.OnLeftButtonDoubleClick()
        return ret
        

    def on_left_button_down(self):
        """
        on_left_button_down(self) -> None
        C++: virtual void on_left_button_down()"""
        ret = self._vtk_obj.OnLeftButtonDown()
        return ret
        

    def on_left_button_up(self):
        """
        on_left_button_up(self) -> None
        C++: virtual void on_left_button_up()"""
        ret = self._vtk_obj.OnLeftButtonUp()
        return ret
        

    def on_long_tap(self):
        """
        on_long_tap(self) -> None
        C++: virtual void on_long_tap()"""
        ret = self._vtk_obj.OnLongTap()
        return ret
        

    def on_menu3d(self, *args):
        """
        on_menu3d(self, __a:EventData) -> None
        C++: virtual void on_menu3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnMenu3D, *my_args)
        return ret

    def on_middle_button_double_click(self):
        """
        on_middle_button_double_click(self) -> None
        C++: virtual void on_middle_button_double_click()"""
        ret = self._vtk_obj.OnMiddleButtonDoubleClick()
        return ret
        

    def on_middle_button_down(self):
        """
        on_middle_button_down(self) -> None
        C++: virtual void on_middle_button_down()"""
        ret = self._vtk_obj.OnMiddleButtonDown()
        return ret
        

    def on_middle_button_up(self):
        """
        on_middle_button_up(self) -> None
        C++: virtual void on_middle_button_up()"""
        ret = self._vtk_obj.OnMiddleButtonUp()
        return ret
        

    def on_mouse_move(self):
        """
        on_mouse_move(self) -> None
        C++: virtual void on_mouse_move()
        Generic event bindings can be overridden in subclasses
        """
        ret = self._vtk_obj.OnMouseMove()
        return ret
        

    def on_mouse_wheel_backward(self):
        """
        on_mouse_wheel_backward(self) -> None
        C++: virtual void on_mouse_wheel_backward()"""
        ret = self._vtk_obj.OnMouseWheelBackward()
        return ret
        

    def on_mouse_wheel_forward(self):
        """
        on_mouse_wheel_forward(self) -> None
        C++: virtual void on_mouse_wheel_forward()"""
        ret = self._vtk_obj.OnMouseWheelForward()
        return ret
        

    def on_mouse_wheel_left(self):
        """
        on_mouse_wheel_left(self) -> None
        C++: virtual void on_mouse_wheel_left()"""
        ret = self._vtk_obj.OnMouseWheelLeft()
        return ret
        

    def on_mouse_wheel_right(self):
        """
        on_mouse_wheel_right(self) -> None
        C++: virtual void on_mouse_wheel_right()"""
        ret = self._vtk_obj.OnMouseWheelRight()
        return ret
        

    def on_move3d(self, *args):
        """
        on_move3d(self, __a:EventData) -> None
        C++: virtual void on_move3d(EventData *)
        Generic 3D event bindings can be overridden in subclasses
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnMove3D, *my_args)
        return ret

    def on_next_pose3d(self, *args):
        """
        on_next_pose3d(self, __a:EventData) -> None
        C++: virtual void on_next_pose3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnNextPose3D, *my_args)
        return ret

    def on_pan(self):
        """
        on_pan(self) -> None
        C++: virtual void on_pan()"""
        ret = self._vtk_obj.OnPan()
        return ret
        

    def on_pick3d(self, *args):
        """
        on_pick3d(self, __a:EventData) -> None
        C++: virtual void on_pick3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnPick3D, *my_args)
        return ret

    def on_pinch(self):
        """
        on_pinch(self) -> None
        C++: virtual void on_pinch()"""
        ret = self._vtk_obj.OnPinch()
        return ret
        

    def on_position_prop3d(self, *args):
        """
        on_position_prop3d(self, __a:EventData) -> None
        C++: virtual void on_position_prop3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnPositionProp3D, *my_args)
        return ret

    def on_right_button_double_click(self):
        """
        on_right_button_double_click(self) -> None
        C++: virtual void on_right_button_double_click()"""
        ret = self._vtk_obj.OnRightButtonDoubleClick()
        return ret
        

    def on_right_button_down(self):
        """
        on_right_button_down(self) -> None
        C++: virtual void on_right_button_down()"""
        ret = self._vtk_obj.OnRightButtonDown()
        return ret
        

    def on_right_button_up(self):
        """
        on_right_button_up(self) -> None
        C++: virtual void on_right_button_up()"""
        ret = self._vtk_obj.OnRightButtonUp()
        return ret
        

    def on_rotate(self):
        """
        on_rotate(self) -> None
        C++: virtual void on_rotate()"""
        ret = self._vtk_obj.OnRotate()
        return ret
        

    def on_select3d(self, *args):
        """
        on_select3d(self, __a:EventData) -> None
        C++: virtual void on_select3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnSelect3D, *my_args)
        return ret

    def on_start_pan(self):
        """
        on_start_pan(self) -> None
        C++: virtual void on_start_pan()"""
        ret = self._vtk_obj.OnStartPan()
        return ret
        

    def on_start_pinch(self):
        """
        on_start_pinch(self) -> None
        C++: virtual void on_start_pinch()"""
        ret = self._vtk_obj.OnStartPinch()
        return ret
        

    def on_start_rotate(self):
        """
        on_start_rotate(self) -> None
        C++: virtual void on_start_rotate()"""
        ret = self._vtk_obj.OnStartRotate()
        return ret
        

    def on_start_swipe(self):
        """
        on_start_swipe(self) -> None
        C++: virtual void on_start_swipe()
        gesture based events
        """
        ret = self._vtk_obj.OnStartSwipe()
        return ret
        

    def on_swipe(self):
        """
        on_swipe(self) -> None
        C++: virtual void on_swipe()"""
        ret = self._vtk_obj.OnSwipe()
        return ret
        

    def on_tap(self):
        """
        on_tap(self) -> None
        C++: virtual void on_tap()"""
        ret = self._vtk_obj.OnTap()
        return ret
        

    def on_timer(self):
        """
        on_timer(self) -> None
        C++: virtual void on_timer()
        on_timer calls Rotate, Rotate etc which should be overridden by
        style subclasses.
        """
        ret = self._vtk_obj.OnTimer()
        return ret
        

    def on_viewer_movement3d(self, *args):
        """
        on_viewer_movement3d(self, __a:EventData) -> None
        C++: virtual void on_viewer_movement3d(EventData *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.OnViewerMovement3D, *my_args)
        return ret

    def pan(self):
        """
        pan(self) -> None
        C++: virtual void pan()"""
        ret = self._vtk_obj.Pan()
        return ret
        

    def rotate(self):
        """
        rotate(self) -> None
        C++: virtual void rotate()
        These methods for the different interactions in different modes
        are overridden in subclasses to perform the correct motion. Since
        they might be called from on_timer, they do not have mouse coord
        parameters (use interactor's get_event_position and
        get_last_event_position)
        """
        ret = self._vtk_obj.Rotate()
        return ret
        

    def spin(self):
        """
        spin(self) -> None
        C++: virtual void spin()"""
        ret = self._vtk_obj.Spin()
        return ret
        

    def start_animate(self):
        """
        start_animate(self) -> None
        C++: virtual void start_animate()
        Interaction mode entry points used internally.
        """
        ret = self._vtk_obj.StartAnimate()
        return ret
        

    def start_dolly(self):
        """
        start_dolly(self) -> None
        C++: virtual void start_dolly()"""
        ret = self._vtk_obj.StartDolly()
        return ret
        

    def start_env_rotate(self):
        """
        start_env_rotate(self) -> None
        C++: virtual void start_env_rotate()"""
        ret = self._vtk_obj.StartEnvRotate()
        return ret
        

    def start_gesture(self):
        """
        start_gesture(self) -> None
        C++: virtual void start_gesture()"""
        ret = self._vtk_obj.StartGesture()
        return ret
        

    def start_pan(self):
        """
        start_pan(self) -> None
        C++: virtual void start_pan()"""
        ret = self._vtk_obj.StartPan()
        return ret
        

    def start_rotate(self):
        """
        start_rotate(self) -> None
        C++: virtual void start_rotate()"""
        ret = self._vtk_obj.StartRotate()
        return ret
        

    def start_spin(self):
        """
        start_spin(self) -> None
        C++: virtual void start_spin()"""
        ret = self._vtk_obj.StartSpin()
        return ret
        

    def start_state(self, *args):
        """
        start_state(self, newstate:int) -> None
        C++: virtual void start_state(int newstate)
        utility routines used by state changes
        """
        ret = self._wrap_call(self._vtk_obj.StartState, *args)
        return ret

    def start_timer(self):
        """
        start_timer(self) -> None
        C++: virtual void start_timer()"""
        ret = self._vtk_obj.StartTimer()
        return ret
        

    def start_two_pointer(self):
        """
        start_two_pointer(self) -> None
        C++: virtual void start_two_pointer()"""
        ret = self._vtk_obj.StartTwoPointer()
        return ret
        

    def start_uniform_scale(self):
        """
        start_uniform_scale(self) -> None
        C++: virtual void start_uniform_scale()"""
        ret = self._vtk_obj.StartUniformScale()
        return ret
        

    def start_zoom(self):
        """
        start_zoom(self) -> None
        C++: virtual void start_zoom()"""
        ret = self._vtk_obj.StartZoom()
        return ret
        

    def stop_animate(self):
        """
        stop_animate(self) -> None
        C++: virtual void stop_animate()"""
        ret = self._vtk_obj.StopAnimate()
        return ret
        

    def stop_state(self):
        """
        stop_state(self) -> None
        C++: virtual void stop_state()"""
        ret = self._vtk_obj.StopState()
        return ret
        

    def uniform_scale(self):
        """
        uniform_scale(self) -> None
        C++: virtual void uniform_scale()"""
        ret = self._vtk_obj.UniformScale()
        return ret
        

    def zoom(self):
        """
        zoom(self) -> None
        C++: virtual void zoom()"""
        ret = self._vtk_obj.Zoom()
        return ret
        

    _updateable_traits_ = \
    (('auto_adjust_camera_clipping_range',
    'GetAutoAdjustCameraClippingRange'), ('handle_observers',
    'GetHandleObservers'), ('use_timers', 'GetUseTimers'), ('enabled',
    'GetEnabled'), ('key_press_activation', 'GetKeyPressActivation'),
    ('picking_managed', 'GetPickingManaged'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('mouse_wheel_motion_factor', 'GetMouseWheelMotionFactor'),
    ('pick_color', 'GetPickColor'), ('timer_duration',
    'GetTimerDuration'), ('key_press_activation_value',
    'GetKeyPressActivationValue'), ('priority', 'GetPriority'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['auto_adjust_camera_clipping_range', 'debug', 'enabled',
    'global_warning_display', 'handle_observers', 'key_press_activation',
    'picking_managed', 'use_timers', 'key_press_activation_value',
    'mouse_wheel_motion_factor', 'pick_color', 'priority',
    'timer_duration'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(InteractorStyle, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit InteractorStyle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['auto_adjust_camera_clipping_range', 'enabled',
            'handle_observers', 'key_press_activation', 'picking_managed',
            'use_timers'], [], ['key_press_activation_value',
            'mouse_wheel_motion_factor', 'pick_color', 'priority',
            'timer_duration']),
            title='Edit InteractorStyle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit InteractorStyle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

