# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.algorithm import Algorithm


class XMLWriterBase(Algorithm):
    r"""
    XMLWriterBase - Abstract base class for VTK-XML writers.
    
    Superclass: Algorithm
    
    XMLWriterBase class was created to help refactor XML writers
    (XMLWriter and subclasses). Get/Set API on XMLWriter is moved
    here while all the gory implementation details are left in
    XMLWriter. This enables use to create a sibling hierarchy to
    XMLWriter that uses a cleaner design to implement the IO
    capabilities. Eventually, we XMLWriter and its children will be
    substituted by a parallel hierarchy at which point this class may
    merge with it's new subclass.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLWriterBase, obj, update, **traits)
    
    encode_appended_data = tvtk_base.true_bool_trait(desc=\
        r"""
        Get/Set whether the appended data section is base64 encoded.  If
        encoded, reading and writing will be slower, but the file will be
        fully valid XML and text-only.  If not encoded, the XML
        specification will be violated, but reading and writing will be
        fast.  The default is to do the encoding.
        """
    )

    def _encode_appended_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEncodeAppendedData,
                        self.encode_appended_data_)

    write_to_output_string = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable writing to an output_string instead of the default, a file.
        """
    )

    def _write_to_output_string_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteToOutputString,
                        self.write_to_output_string_)

    byte_order = tvtk_base.RevPrefixMap({'little_endian': 1, 'big_endian': 0}, default_value='little_endian', desc=\
        r"""
        Get/Set the byte order of data written to the file.  The default
        is the machine's hardware byte order.
        """
    )

    def _byte_order_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetByteOrder,
                        self.byte_order_)

    data_mode = tvtk_base.RevPrefixMap({'appended': 2, 'ascii': 0, 'binary': 1}, default_value='appended', desc=\
        r"""
        Get/Set the data mode used for the file's data.  The options are
        XMLWriter::Ascii, XMLWriter::Binary, and
        XMLWriter::Appended.
        """
    )

    def _data_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDataMode,
                        self.data_mode_)

    header_type = tvtk_base.RevPrefixMap({'u_int32': 32, 'u_int64': 64}, default_value='u_int32', desc=\
        r"""
        Get/Set the binary data header word type.  The default is UInt32.
        Set to UInt64 when storing arrays requiring 64-bit indexing.
        """
    )

    def _header_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHeaderType,
                        self.header_type_)

    id_type = tvtk_base.RevPrefixMap({'int64': 64, 'int32': 32}, default_value='int64', desc=\
        r"""
        Get/Set the size of the IdType values stored in the file.  The
        default is the real size of IdType.
        """
    )

    def _id_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIdType,
                        self.id_type_)

    block_size = traits.Int(32768, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the block size used in compression.  When reading, this
        controls the granularity of how much extra information must be
        read when only part of the data are requested.  The value should
        be a multiple of the largest scalar data type.
        """
    )

    def _block_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBlockSize,
                        self.block_size)

    compression_level = traits.Int(5, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set compression level. 1 (worst compression, fastest) ... 9
        (best compression, slowest).
        """
    )

    def _compression_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompressionLevel,
                        self.compression_level)

    def _get_compressor(self):
        return wrap_vtk(self._vtk_obj.GetCompressor())
    def _set_compressor(self, arg):
        old_val = self._get_compressor()
        self._wrap_call(self._vtk_obj.SetCompressor,
                        deref_vtk(arg))
        self.trait_property_changed('compressor', old_val, arg)
    compressor = traits.Property(_get_compressor, _set_compressor, desc=\
        r"""
        
        """
    )

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Get/Set the name of the output file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def _get_default_file_extension(self):
        return self._vtk_obj.GetDefaultFileExtension()
    default_file_extension = traits.Property(_get_default_file_extension, desc=\
        r"""
        Get the default file extension for files written by this writer.
        """
    )

    def _get_output_string(self):
        return self._vtk_obj.GetOutputString()
    output_string = traits.Property(_get_output_string, desc=\
        r"""
        
        """
    )

    def set_compressor_type(self, *args):
        """
        set_compressor_type(self, compressorType:int) -> None
        C++: void set_compressor_type(int compressorType)
        Convenience functions to set the compressor to certain known
        types.
        """
        ret = self._wrap_call(self._vtk_obj.SetCompressorType, *args)
        return ret

    def set_compressor_type_to_lz4(self):
        """
        set_compressor_type_to_lz4(self) -> None
        C++: void set_compressor_type_to_lz4()"""
        ret = self._vtk_obj.SetCompressorTypeToLZ4()
        return ret
        

    def set_compressor_type_to_lzma(self):
        """
        set_compressor_type_to_lzma(self) -> None
        C++: void set_compressor_type_to_lzma()"""
        ret = self._vtk_obj.SetCompressorTypeToLZMA()
        return ret
        

    def set_compressor_type_to_none(self):
        """
        set_compressor_type_to_none(self) -> None
        C++: void set_compressor_type_to_none()"""
        ret = self._vtk_obj.SetCompressorTypeToNone()
        return ret
        

    def set_compressor_type_to_z_lib(self):
        """
        set_compressor_type_to_z_lib(self) -> None
        C++: void set_compressor_type_to_z_lib()"""
        ret = self._vtk_obj.SetCompressorTypeToZLib()
        return ret
        

    def write(self):
        """
        write(self) -> int
        C++: int write()
        Invoke the writer.  Returns 1 for success, 0 for failure.
        """
        ret = self._vtk_obj.Write()
        return ret
        

    _updateable_traits_ = \
    (('encode_appended_data', 'GetEncodeAppendedData'),
    ('write_to_output_string', 'GetWriteToOutputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('byte_order',
    'GetByteOrder'), ('data_mode', 'GetDataMode'), ('header_type',
    'GetHeaderType'), ('id_type', 'GetIdType'), ('block_size',
    'GetBlockSize'), ('compression_level', 'GetCompressionLevel'),
    ('file_name', 'GetFileName'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'encode_appended_data',
    'global_warning_display', 'release_data_flag',
    'write_to_output_string', 'byte_order', 'data_mode', 'header_type',
    'id_type', 'block_size', 'compression_level', 'file_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLWriterBase, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLWriterBase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['encode_appended_data', 'write_to_output_string'],
            ['byte_order', 'data_mode', 'header_type', 'id_type'], ['block_size',
            'compression_level', 'file_name']),
            title='Edit XMLWriterBase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLWriterBase properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

