/**
 * Le but de ce programme est de donner un outil simple permettant d'obtenir 
 * rapidement le code d'une couleur donnée.
 *
 * Le code source suivant ne constitue pas un tutoriel.
 * De surcroit, il n'utilise aucune nouvelle fonctionnalité de la librairie MLV.
 * Vous pouvez donc passer à l'exemple suivant qui sera plus instructif.
 */

#include <MLV/MLV_all.h>
#include <math.h>
#include <stdio.h>


//
// Attention ! 
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main( int argc, char *argv[] ){

	#define NB_COULEUR 752
	const char* couleur_string[NB_COULEUR] = {
		"MLV_COLOR_SNOW",
		"MLV_COLOR_GHOST_WHITE",
		"MLV_COLOR_GHOSTWHITE",
		"MLV_COLOR_WHITE_SMOKE",
		"MLV_COLOR_WHITESMOKE",
		"MLV_COLOR_GAINSBORO",
		"MLV_COLOR_FLORAL_WHITE",
		"MLV_COLOR_FLORALWHITE",
		"MLV_COLOR_OLD_LACE",
		"MLV_COLOR_OLDLACE",
		"MLV_COLOR_LINEN",
		"MLV_COLOR_ANTIQUE_WHITE",
		"MLV_COLOR_ANTIQUEWHITE",
		"MLV_COLOR_PAPAYA_WHIP",
		"MLV_COLOR_PAPAYAWHIP",
		"MLV_COLOR_BLANCHED_ALMOND",
		"MLV_COLOR_BLANCHEDALMOND",
		"MLV_COLOR_BISQUE",
		"MLV_COLOR_PEACH_PUFF",
		"MLV_COLOR_PEACHPUFF",
		"MLV_COLOR_NAVAJO_WHITE",
		"MLV_COLOR_NAVAJOWHITE",
		"MLV_COLOR_MOCCASIN",
		"MLV_COLOR_CORNSILK",
		"MLV_COLOR_IVORY",
		"MLV_COLOR_LEMON_CHIFFON",
		"MLV_COLOR_LEMONCHIFFON",
		"MLV_COLOR_SEASHELL",
		"MLV_COLOR_HONEYDEW",
		"MLV_COLOR_MINT_CREAM",
		"MLV_COLOR_MINTCREAM",
		"MLV_COLOR_AZURE",
		"MLV_COLOR_ALICE_BLUE",
		"MLV_COLOR_ALICEBLUE",
		"MLV_COLOR_LAVENDER",
		"MLV_COLOR_LAVENDER_BLUSH",
		"MLV_COLOR_LAVENDERBLUSH",
		"MLV_COLOR_MISTY_ROSE",
		"MLV_COLOR_MISTYROSE",
		"MLV_COLOR_WHITE",
		"MLV_COLOR_BLACK",
		"MLV_COLOR_DARK_SLATE_GRAY",
		"MLV_COLOR_DARKSLATEGRAY",
		"MLV_COLOR_DARK_SLATE_GREY",
		"MLV_COLOR_DARKSLATEGREY",
		"MLV_COLOR_DIM_GRAY",
		"MLV_COLOR_DIMGRAY",
		"MLV_COLOR_DIM_GREY",
		"MLV_COLOR_DIMGREY",
		"MLV_COLOR_SLATE_GRAY",
		"MLV_COLOR_SLATEGRAY",
		"MLV_COLOR_SLATE_GREY",
		"MLV_COLOR_SLATEGREY",
		"MLV_COLOR_LIGHT_SLATE_GRAY",
		"MLV_COLOR_LIGHTSLATEGRAY",
		"MLV_COLOR_LIGHT_SLATE_GREY",
		"MLV_COLOR_LIGHTSLATEGREY",
		"MLV_COLOR_GRAY",
		"MLV_COLOR_GREY",
		"MLV_COLOR_LIGHT_GREY",
		"MLV_COLOR_LIGHTGREY",
		"MLV_COLOR_LIGHT_GRAY",
		"MLV_COLOR_LIGHTGRAY",
		"MLV_COLOR_MIDNIGHT_BLUE",
		"MLV_COLOR_MIDNIGHTBLUE",
		"MLV_COLOR_NAVY",
		"MLV_COLOR_NAVY_BLUE",
		"MLV_COLOR_NAVYBLUE",
		"MLV_COLOR_CORNFLOWER_BLUE",
		"MLV_COLOR_CORNFLOWERBLUE",
		"MLV_COLOR_DARK_SLATE_BLUE",
		"MLV_COLOR_DARKSLATEBLUE",
		"MLV_COLOR_SLATE_BLUE",
		"MLV_COLOR_SLATEBLUE",
		"MLV_COLOR_MEDIUM_SLATE_BLUE",
		"MLV_COLOR_MEDIUMSLATEBLUE",
		"MLV_COLOR_LIGHT_SLATE_BLUE",
		"MLV_COLOR_LIGHTSLATEBLUE",
		"MLV_COLOR_MEDIUM_BLUE",
		"MLV_COLOR_MEDIUMBLUE",
		"MLV_COLOR_ROYAL_BLUE",
		"MLV_COLOR_ROYALBLUE",
		"MLV_COLOR_BLUE",
		"MLV_COLOR_DODGER_BLUE",
		"MLV_COLOR_DODGERBLUE",
		"MLV_COLOR_DEEP_SKY_BLUE",
		"MLV_COLOR_DEEPSKYBLUE",
		"MLV_COLOR_SKY_BLUE",
		"MLV_COLOR_SKYBLUE",
		"MLV_COLOR_LIGHT_SKY_BLUE",
		"MLV_COLOR_LIGHTSKYBLUE",
		"MLV_COLOR_STEEL_BLUE",
		"MLV_COLOR_STEELBLUE",
		"MLV_COLOR_LIGHT_STEEL_BLUE",
		"MLV_COLOR_LIGHTSTEELBLUE",
		"MLV_COLOR_LIGHT_BLUE",
		"MLV_COLOR_LIGHTBLUE",
		"MLV_COLOR_POWDER_BLUE",
		"MLV_COLOR_POWDERBLUE",
		"MLV_COLOR_PALE_TURQUOISE",
		"MLV_COLOR_PALETURQUOISE",
		"MLV_COLOR_DARK_TURQUOISE",
		"MLV_COLOR_DARKTURQUOISE",
		"MLV_COLOR_MEDIUM_TURQUOISE",
		"MLV_COLOR_MEDIUMTURQUOISE",
		"MLV_COLOR_TURQUOISE",
		"MLV_COLOR_CYAN",
		"MLV_COLOR_LIGHT_CYAN",
		"MLV_COLOR_LIGHTCYAN",
		"MLV_COLOR_CADET_BLUE",
		"MLV_COLOR_CADETBLUE",
		"MLV_COLOR_MEDIUM_AQUAMARINE",
		"MLV_COLOR_MEDIUMAQUAMARINE",
		"MLV_COLOR_AQUAMARINE",
		"MLV_COLOR_DARK_GREEN",
		"MLV_COLOR_DARKGREEN",
		"MLV_COLOR_DARK_OLIVE_GREEN",
		"MLV_COLOR_DARKOLIVEGREEN",
		"MLV_COLOR_DARK_SEA_GREEN",
		"MLV_COLOR_DARKSEAGREEN",
		"MLV_COLOR_SEA_GREEN",
		"MLV_COLOR_SEAGREEN",
		"MLV_COLOR_MEDIUM_SEA_GREEN",
		"MLV_COLOR_MEDIUMSEAGREEN",
		"MLV_COLOR_LIGHT_SEA_GREEN",
		"MLV_COLOR_LIGHTSEAGREEN",
		"MLV_COLOR_PALE_GREEN",
		"MLV_COLOR_PALEGREEN",
		"MLV_COLOR_SPRING_GREEN",
		"MLV_COLOR_SPRINGGREEN",
		"MLV_COLOR_LAWN_GREEN",
		"MLV_COLOR_LAWNGREEN",
		"MLV_COLOR_GREEN",
		"MLV_COLOR_CHARTREUSE",
		"MLV_COLOR_MEDIUM_SPRING_GREEN",
		"MLV_COLOR_MEDIUMSPRINGGREEN",
		"MLV_COLOR_GREEN_YELLOW",
		"MLV_COLOR_GREENYELLOW",
		"MLV_COLOR_LIME_GREEN",
		"MLV_COLOR_LIMEGREEN",
		"MLV_COLOR_YELLOW_GREEN",
		"MLV_COLOR_YELLOWGREEN",
		"MLV_COLOR_FOREST_GREEN",
		"MLV_COLOR_FORESTGREEN",
		"MLV_COLOR_OLIVE_DRAB",
		"MLV_COLOR_OLIVEDRAB",
		"MLV_COLOR_DARK_KHAKI",
		"MLV_COLOR_DARKKHAKI",
		"MLV_COLOR_KHAKI",
		"MLV_COLOR_PALE_GOLDENROD",
		"MLV_COLOR_PALEGOLDENROD",
		"MLV_COLOR_LIGHT_GOLDENROD_YELLOW",
		"MLV_COLOR_LIGHTGOLDENRODYELLOW",
		"MLV_COLOR_LIGHT_YELLOW",
		"MLV_COLOR_LIGHTYELLOW",
		"MLV_COLOR_YELLOW",
		"MLV_COLOR_GOLD",
		"MLV_COLOR_LIGHT_GOLDENROD",
		"MLV_COLOR_LIGHTGOLDENROD",
		"MLV_COLOR_GOLDENROD",
		"MLV_COLOR_DARK_GOLDENROD",
		"MLV_COLOR_DARKGOLDENROD",
		"MLV_COLOR_ROSY_BROWN",
		"MLV_COLOR_ROSYBROWN",
		"MLV_COLOR_INDIAN_RED",
		"MLV_COLOR_INDIANRED",
		"MLV_COLOR_SADDLE_BROWN",
		"MLV_COLOR_SADDLEBROWN",
		"MLV_COLOR_SIENNA",
		"MLV_COLOR_PERU",
		"MLV_COLOR_BURLYWOOD",
		"MLV_COLOR_BEIGE",
		"MLV_COLOR_WHEAT",
		"MLV_COLOR_SANDY_BROWN",
		"MLV_COLOR_SANDYBROWN",
		"MLV_COLOR_TAN",
		"MLV_COLOR_CHOCOLATE",
		"MLV_COLOR_FIREBRICK",
		"MLV_COLOR_BROWN",
		"MLV_COLOR_DARK_SALMON",
		"MLV_COLOR_DARKSALMON",
		"MLV_COLOR_SALMON",
		"MLV_COLOR_LIGHT_SALMON",
		"MLV_COLOR_LIGHTSALMON",
		"MLV_COLOR_ORANGE",
		"MLV_COLOR_DARK_ORANGE",
		"MLV_COLOR_DARKORANGE",
		"MLV_COLOR_CORAL",
		"MLV_COLOR_LIGHT_CORAL",
		"MLV_COLOR_LIGHTCORAL",
		"MLV_COLOR_TOMATO",
		"MLV_COLOR_ORANGE_RED",
		"MLV_COLOR_ORANGERED",
		"MLV_COLOR_RED",
		"MLV_COLOR_HOT_PINK",
		"MLV_COLOR_HOTPINK",
		"MLV_COLOR_DEEP_PINK",
		"MLV_COLOR_DEEPPINK",
		"MLV_COLOR_PINK",
		"MLV_COLOR_LIGHT_PINK",
		"MLV_COLOR_LIGHTPINK",
		"MLV_COLOR_PALE_VIOLET_RED",
		"MLV_COLOR_PALEVIOLETRED",
		"MLV_COLOR_MAROON",
		"MLV_COLOR_MEDIUM_VIOLET_RED",
		"MLV_COLOR_MEDIUMVIOLETRED",
		"MLV_COLOR_VIOLET_RED",
		"MLV_COLOR_VIOLETRED",
		"MLV_COLOR_MAGENTA",
		"MLV_COLOR_VIOLET",
		"MLV_COLOR_PLUM",
		"MLV_COLOR_ORCHID",
		"MLV_COLOR_MEDIUM_ORCHID",
		"MLV_COLOR_MEDIUMORCHID",
		"MLV_COLOR_DARK_ORCHID",
		"MLV_COLOR_DARKORCHID",
		"MLV_COLOR_DARK_VIOLET",
		"MLV_COLOR_DARKVIOLET",
		"MLV_COLOR_BLUE_VIOLET",
		"MLV_COLOR_BLUEVIOLET",
		"MLV_COLOR_PURPLE",
		"MLV_COLOR_MEDIUM_PURPLE",
		"MLV_COLOR_MEDIUMPURPLE",
		"MLV_COLOR_THISTLE",
		"MLV_COLOR_SNOW1",
		"MLV_COLOR_SNOW2",
		"MLV_COLOR_SNOW3",
		"MLV_COLOR_SNOW4",
		"MLV_COLOR_SEASHELL1",
		"MLV_COLOR_SEASHELL2",
		"MLV_COLOR_SEASHELL3",
		"MLV_COLOR_SEASHELL4",
		"MLV_COLOR_ANTIQUEWHITE1",
		"MLV_COLOR_ANTIQUEWHITE2",
		"MLV_COLOR_ANTIQUEWHITE3",
		"MLV_COLOR_ANTIQUEWHITE4",
		"MLV_COLOR_BISQUE1",
		"MLV_COLOR_BISQUE2",
		"MLV_COLOR_BISQUE3",
		"MLV_COLOR_BISQUE4",
		"MLV_COLOR_PEACHPUFF1",
		"MLV_COLOR_PEACHPUFF2",
		"MLV_COLOR_PEACHPUFF3",
		"MLV_COLOR_PEACHPUFF4",
		"MLV_COLOR_NAVAJOWHITE1",
		"MLV_COLOR_NAVAJOWHITE2",
		"MLV_COLOR_NAVAJOWHITE3",
		"MLV_COLOR_NAVAJOWHITE4",
		"MLV_COLOR_LEMONCHIFFON1",
		"MLV_COLOR_LEMONCHIFFON2",
		"MLV_COLOR_LEMONCHIFFON3",
		"MLV_COLOR_LEMONCHIFFON4",
		"MLV_COLOR_CORNSILK1",
		"MLV_COLOR_CORNSILK2",
		"MLV_COLOR_CORNSILK3",
		"MLV_COLOR_CORNSILK4",
		"MLV_COLOR_IVORY1",
		"MLV_COLOR_IVORY2",
		"MLV_COLOR_IVORY3",
		"MLV_COLOR_IVORY4",
		"MLV_COLOR_HONEYDEW1",
		"MLV_COLOR_HONEYDEW2",
		"MLV_COLOR_HONEYDEW3",
		"MLV_COLOR_HONEYDEW4",
		"MLV_COLOR_LAVENDERBLUSH1",
		"MLV_COLOR_LAVENDERBLUSH2",
		"MLV_COLOR_LAVENDERBLUSH3",
		"MLV_COLOR_LAVENDERBLUSH4",
		"MLV_COLOR_MISTYROSE1",
		"MLV_COLOR_MISTYROSE2",
		"MLV_COLOR_MISTYROSE3",
		"MLV_COLOR_MISTYROSE4",
		"MLV_COLOR_AZURE1",
		"MLV_COLOR_AZURE2",
		"MLV_COLOR_AZURE3",
		"MLV_COLOR_AZURE4",
		"MLV_COLOR_SLATEBLUE1",
		"MLV_COLOR_SLATEBLUE2",
		"MLV_COLOR_SLATEBLUE3",
		"MLV_COLOR_SLATEBLUE4",
		"MLV_COLOR_ROYALBLUE1",
		"MLV_COLOR_ROYALBLUE2",
		"MLV_COLOR_ROYALBLUE3",
		"MLV_COLOR_ROYALBLUE4",
		"MLV_COLOR_BLUE1",
		"MLV_COLOR_BLUE2",
		"MLV_COLOR_BLUE3",
		"MLV_COLOR_BLUE4",
		"MLV_COLOR_DODGERBLUE1",
		"MLV_COLOR_DODGERBLUE2",
		"MLV_COLOR_DODGERBLUE3",
		"MLV_COLOR_DODGERBLUE4",
		"MLV_COLOR_STEELBLUE1",
		"MLV_COLOR_STEELBLUE2",
		"MLV_COLOR_STEELBLUE3",
		"MLV_COLOR_STEELBLUE4",
		"MLV_COLOR_DEEPSKYBLUE1",
		"MLV_COLOR_DEEPSKYBLUE2",
		"MLV_COLOR_DEEPSKYBLUE3",
		"MLV_COLOR_DEEPSKYBLUE4",
		"MLV_COLOR_SKYBLUE1",
		"MLV_COLOR_SKYBLUE2",
		"MLV_COLOR_SKYBLUE3",
		"MLV_COLOR_SKYBLUE4",
		"MLV_COLOR_LIGHTSKYBLUE1",
		"MLV_COLOR_LIGHTSKYBLUE2",
		"MLV_COLOR_LIGHTSKYBLUE3",
		"MLV_COLOR_LIGHTSKYBLUE4",
		"MLV_COLOR_SLATEGRAY1",
		"MLV_COLOR_SLATEGRAY2",
		"MLV_COLOR_SLATEGRAY3",
		"MLV_COLOR_SLATEGRAY4",
		"MLV_COLOR_LIGHTSTEELBLUE1",
		"MLV_COLOR_LIGHTSTEELBLUE2",
		"MLV_COLOR_LIGHTSTEELBLUE3",
		"MLV_COLOR_LIGHTSTEELBLUE4",
		"MLV_COLOR_LIGHTBLUE1",
		"MLV_COLOR_LIGHTBLUE2",
		"MLV_COLOR_LIGHTBLUE3",
		"MLV_COLOR_LIGHTBLUE4",
		"MLV_COLOR_LIGHTCYAN1",
		"MLV_COLOR_LIGHTCYAN2",
		"MLV_COLOR_LIGHTCYAN3",
		"MLV_COLOR_LIGHTCYAN4",
		"MLV_COLOR_PALETURQUOISE1",
		"MLV_COLOR_PALETURQUOISE2",
		"MLV_COLOR_PALETURQUOISE3",
		"MLV_COLOR_PALETURQUOISE4",
		"MLV_COLOR_CADETBLUE1",
		"MLV_COLOR_CADETBLUE2",
		"MLV_COLOR_CADETBLUE3",
		"MLV_COLOR_CADETBLUE4",
		"MLV_COLOR_TURQUOISE1",
		"MLV_COLOR_TURQUOISE2",
		"MLV_COLOR_TURQUOISE3",
		"MLV_COLOR_TURQUOISE4",
		"MLV_COLOR_CYAN1",
		"MLV_COLOR_CYAN2",
		"MLV_COLOR_CYAN3",
		"MLV_COLOR_CYAN4",
		"MLV_COLOR_DARKSLATEGRAY1",
		"MLV_COLOR_DARKSLATEGRAY2",
		"MLV_COLOR_DARKSLATEGRAY3",
		"MLV_COLOR_DARKSLATEGRAY4",
		"MLV_COLOR_AQUAMARINE1",
		"MLV_COLOR_AQUAMARINE2",
		"MLV_COLOR_AQUAMARINE3",
		"MLV_COLOR_AQUAMARINE4",
		"MLV_COLOR_DARKSEAGREEN1",
		"MLV_COLOR_DARKSEAGREEN2",
		"MLV_COLOR_DARKSEAGREEN3",
		"MLV_COLOR_DARKSEAGREEN4",
		"MLV_COLOR_SEAGREEN1",
		"MLV_COLOR_SEAGREEN2",
		"MLV_COLOR_SEAGREEN3",
		"MLV_COLOR_SEAGREEN4",
		"MLV_COLOR_PALEGREEN1",
		"MLV_COLOR_PALEGREEN2",
		"MLV_COLOR_PALEGREEN3",
		"MLV_COLOR_PALEGREEN4",
		"MLV_COLOR_SPRINGGREEN1",
		"MLV_COLOR_SPRINGGREEN2",
		"MLV_COLOR_SPRINGGREEN3",
		"MLV_COLOR_SPRINGGREEN4",
		"MLV_COLOR_GREEN1",
		"MLV_COLOR_GREEN2",
		"MLV_COLOR_GREEN3",
		"MLV_COLOR_GREEN4",
		"MLV_COLOR_CHARTREUSE1",
		"MLV_COLOR_CHARTREUSE2",
		"MLV_COLOR_CHARTREUSE3",
		"MLV_COLOR_CHARTREUSE4",
		"MLV_COLOR_OLIVEDRAB1",
		"MLV_COLOR_OLIVEDRAB2",
		"MLV_COLOR_OLIVEDRAB3",
		"MLV_COLOR_OLIVEDRAB4",
		"MLV_COLOR_DARKOLIVEGREEN1",
		"MLV_COLOR_DARKOLIVEGREEN2",
		"MLV_COLOR_DARKOLIVEGREEN3",
		"MLV_COLOR_DARKOLIVEGREEN4",
		"MLV_COLOR_KHAKI1",
		"MLV_COLOR_KHAKI2",
		"MLV_COLOR_KHAKI3",
		"MLV_COLOR_KHAKI4",
		"MLV_COLOR_LIGHTGOLDENROD1",
		"MLV_COLOR_LIGHTGOLDENROD2",
		"MLV_COLOR_LIGHTGOLDENROD3",
		"MLV_COLOR_LIGHTGOLDENROD4",
		"MLV_COLOR_LIGHTYELLOW1",
		"MLV_COLOR_LIGHTYELLOW2",
		"MLV_COLOR_LIGHTYELLOW3",
		"MLV_COLOR_LIGHTYELLOW4",
		"MLV_COLOR_YELLOW1",
		"MLV_COLOR_YELLOW2",
		"MLV_COLOR_YELLOW3",
		"MLV_COLOR_YELLOW4",
		"MLV_COLOR_GOLD1",
		"MLV_COLOR_GOLD2",
		"MLV_COLOR_GOLD3",
		"MLV_COLOR_GOLD4",
		"MLV_COLOR_GOLDENROD1",
		"MLV_COLOR_GOLDENROD2",
		"MLV_COLOR_GOLDENROD3",
		"MLV_COLOR_GOLDENROD4",
		"MLV_COLOR_DARKGOLDENROD1",
		"MLV_COLOR_DARKGOLDENROD2",
		"MLV_COLOR_DARKGOLDENROD3",
		"MLV_COLOR_DARKGOLDENROD4",
		"MLV_COLOR_ROSYBROWN1",
		"MLV_COLOR_ROSYBROWN2",
		"MLV_COLOR_ROSYBROWN3",
		"MLV_COLOR_ROSYBROWN4",
		"MLV_COLOR_INDIANRED1",
		"MLV_COLOR_INDIANRED2",
		"MLV_COLOR_INDIANRED3",
		"MLV_COLOR_INDIANRED4",
		"MLV_COLOR_SIENNA1",
		"MLV_COLOR_SIENNA2",
		"MLV_COLOR_SIENNA3",
		"MLV_COLOR_SIENNA4",
		"MLV_COLOR_BURLYWOOD1",
		"MLV_COLOR_BURLYWOOD2",
		"MLV_COLOR_BURLYWOOD3",
		"MLV_COLOR_BURLYWOOD4",
		"MLV_COLOR_WHEAT1",
		"MLV_COLOR_WHEAT2",
		"MLV_COLOR_WHEAT3",
		"MLV_COLOR_WHEAT4",
		"MLV_COLOR_TAN1",
		"MLV_COLOR_TAN2",
		"MLV_COLOR_TAN3",
		"MLV_COLOR_TAN4",
		"MLV_COLOR_CHOCOLATE1",
		"MLV_COLOR_CHOCOLATE2",
		"MLV_COLOR_CHOCOLATE3",
		"MLV_COLOR_CHOCOLATE4",
		"MLV_COLOR_FIREBRICK1",
		"MLV_COLOR_FIREBRICK2",
		"MLV_COLOR_FIREBRICK3",
		"MLV_COLOR_FIREBRICK4",
		"MLV_COLOR_BROWN1",
		"MLV_COLOR_BROWN2",
		"MLV_COLOR_BROWN3",
		"MLV_COLOR_BROWN4",
		"MLV_COLOR_SALMON1",
		"MLV_COLOR_SALMON2",
		"MLV_COLOR_SALMON3",
		"MLV_COLOR_SALMON4",
		"MLV_COLOR_LIGHTSALMON1",
		"MLV_COLOR_LIGHTSALMON2",
		"MLV_COLOR_LIGHTSALMON3",
		"MLV_COLOR_LIGHTSALMON4",
		"MLV_COLOR_ORANGE1",
		"MLV_COLOR_ORANGE2",
		"MLV_COLOR_ORANGE3",
		"MLV_COLOR_ORANGE4",
		"MLV_COLOR_DARKORANGE1",
		"MLV_COLOR_DARKORANGE2",
		"MLV_COLOR_DARKORANGE3",
		"MLV_COLOR_DARKORANGE4",
		"MLV_COLOR_CORAL1",
		"MLV_COLOR_CORAL2",
		"MLV_COLOR_CORAL3",
		"MLV_COLOR_CORAL4",
		"MLV_COLOR_TOMATO1",
		"MLV_COLOR_TOMATO2",
		"MLV_COLOR_TOMATO3",
		"MLV_COLOR_TOMATO4",
		"MLV_COLOR_ORANGERED1",
		"MLV_COLOR_ORANGERED2",
		"MLV_COLOR_ORANGERED3",
		"MLV_COLOR_ORANGERED4",
		"MLV_COLOR_RED1",
		"MLV_COLOR_RED2",
		"MLV_COLOR_RED3",
		"MLV_COLOR_RED4",
		"MLV_COLOR_DEEPPINK1",
		"MLV_COLOR_DEEPPINK2",
		"MLV_COLOR_DEEPPINK3",
		"MLV_COLOR_DEEPPINK4",
		"MLV_COLOR_HOTPINK1",
		"MLV_COLOR_HOTPINK2",
		"MLV_COLOR_HOTPINK3",
		"MLV_COLOR_HOTPINK4",
		"MLV_COLOR_PINK1",
		"MLV_COLOR_PINK2",
		"MLV_COLOR_PINK3",
		"MLV_COLOR_PINK4",
		"MLV_COLOR_LIGHTPINK1",
		"MLV_COLOR_LIGHTPINK2",
		"MLV_COLOR_LIGHTPINK3",
		"MLV_COLOR_LIGHTPINK4",
		"MLV_COLOR_PALEVIOLETRED1",
		"MLV_COLOR_PALEVIOLETRED2",
		"MLV_COLOR_PALEVIOLETRED3",
		"MLV_COLOR_PALEVIOLETRED4",
		"MLV_COLOR_MAROON1",
		"MLV_COLOR_MAROON2",
		"MLV_COLOR_MAROON3",
		"MLV_COLOR_MAROON4",
		"MLV_COLOR_VIOLETRED1",
		"MLV_COLOR_VIOLETRED2",
		"MLV_COLOR_VIOLETRED3",
		"MLV_COLOR_VIOLETRED4",
		"MLV_COLOR_MAGENTA1",
		"MLV_COLOR_MAGENTA2",
		"MLV_COLOR_MAGENTA3",
		"MLV_COLOR_MAGENTA4",
		"MLV_COLOR_ORCHID1",
		"MLV_COLOR_ORCHID2",
		"MLV_COLOR_ORCHID3",
		"MLV_COLOR_ORCHID4",
		"MLV_COLOR_PLUM1",
		"MLV_COLOR_PLUM2",
		"MLV_COLOR_PLUM3",
		"MLV_COLOR_PLUM4",
		"MLV_COLOR_MEDIUMORCHID1",
		"MLV_COLOR_MEDIUMORCHID2",
		"MLV_COLOR_MEDIUMORCHID3",
		"MLV_COLOR_MEDIUMORCHID4",
		"MLV_COLOR_DARKORCHID1",
		"MLV_COLOR_DARKORCHID2",
		"MLV_COLOR_DARKORCHID3",
		"MLV_COLOR_DARKORCHID4",
		"MLV_COLOR_PURPLE1",
		"MLV_COLOR_PURPLE2",
		"MLV_COLOR_PURPLE3",
		"MLV_COLOR_PURPLE4",
		"MLV_COLOR_MEDIUMPURPLE1",
		"MLV_COLOR_MEDIUMPURPLE2",
		"MLV_COLOR_MEDIUMPURPLE3",
		"MLV_COLOR_MEDIUMPURPLE4",
		"MLV_COLOR_THISTLE1",
		"MLV_COLOR_THISTLE2",
		"MLV_COLOR_THISTLE3",
		"MLV_COLOR_THISTLE4",
		"MLV_COLOR_GRAY0",
		"MLV_COLOR_GREY0",
		"MLV_COLOR_GRAY1",
		"MLV_COLOR_GREY1",
		"MLV_COLOR_GRAY2",
		"MLV_COLOR_GREY2",
		"MLV_COLOR_GRAY3",
		"MLV_COLOR_GREY3",
		"MLV_COLOR_GRAY4",
		"MLV_COLOR_GREY4",
		"MLV_COLOR_GRAY5",
		"MLV_COLOR_GREY5",
		"MLV_COLOR_GRAY6",
		"MLV_COLOR_GREY6",
		"MLV_COLOR_GRAY7",
		"MLV_COLOR_GREY7",
		"MLV_COLOR_GRAY8",
		"MLV_COLOR_GREY8",
		"MLV_COLOR_GRAY9",
		"MLV_COLOR_GREY9",
		"MLV_COLOR_GRAY10",
		"MLV_COLOR_GREY10",
		"MLV_COLOR_GRAY11",
		"MLV_COLOR_GREY11",
		"MLV_COLOR_GRAY12",
		"MLV_COLOR_GREY12",
		"MLV_COLOR_GRAY13",
		"MLV_COLOR_GREY13",
		"MLV_COLOR_GRAY14",
		"MLV_COLOR_GREY14",
		"MLV_COLOR_GRAY15",
		"MLV_COLOR_GREY15",
		"MLV_COLOR_GRAY16",
		"MLV_COLOR_GREY16",
		"MLV_COLOR_GRAY17",
		"MLV_COLOR_GREY17",
		"MLV_COLOR_GRAY18",
		"MLV_COLOR_GREY18",
		"MLV_COLOR_GRAY19",
		"MLV_COLOR_GREY19",
		"MLV_COLOR_GRAY20",
		"MLV_COLOR_GREY20",
		"MLV_COLOR_GRAY21",
		"MLV_COLOR_GREY21",
		"MLV_COLOR_GRAY22",
		"MLV_COLOR_GREY22",
		"MLV_COLOR_GRAY23",
		"MLV_COLOR_GREY23",
		"MLV_COLOR_GRAY24",
		"MLV_COLOR_GREY24",
		"MLV_COLOR_GRAY25",
		"MLV_COLOR_GREY25",
		"MLV_COLOR_GRAY26",
		"MLV_COLOR_GREY26",
		"MLV_COLOR_GRAY27",
		"MLV_COLOR_GREY27",
		"MLV_COLOR_GRAY28",
		"MLV_COLOR_GREY28",
		"MLV_COLOR_GRAY29",
		"MLV_COLOR_GREY29",
		"MLV_COLOR_GRAY30",
		"MLV_COLOR_GREY30",
		"MLV_COLOR_GRAY31",
		"MLV_COLOR_GREY31",
		"MLV_COLOR_GRAY32",
		"MLV_COLOR_GREY32",
		"MLV_COLOR_GRAY33",
		"MLV_COLOR_GREY33",
		"MLV_COLOR_GRAY34",
		"MLV_COLOR_GREY34",
		"MLV_COLOR_GRAY35",
		"MLV_COLOR_GREY35",
		"MLV_COLOR_GRAY36",
		"MLV_COLOR_GREY36",
		"MLV_COLOR_GRAY37",
		"MLV_COLOR_GREY37",
		"MLV_COLOR_GRAY38",
		"MLV_COLOR_GREY38",
		"MLV_COLOR_GRAY39",
		"MLV_COLOR_GREY39",
		"MLV_COLOR_GRAY40",
		"MLV_COLOR_GREY40",
		"MLV_COLOR_GRAY41",
		"MLV_COLOR_GREY41",
		"MLV_COLOR_GRAY42",
		"MLV_COLOR_GREY42",
		"MLV_COLOR_GRAY43",
		"MLV_COLOR_GREY43",
		"MLV_COLOR_GRAY44",
		"MLV_COLOR_GREY44",
		"MLV_COLOR_GRAY45",
		"MLV_COLOR_GREY45",
		"MLV_COLOR_GRAY46",
		"MLV_COLOR_GREY46",
		"MLV_COLOR_GRAY47",
		"MLV_COLOR_GREY47",
		"MLV_COLOR_GRAY48",
		"MLV_COLOR_GREY48",
		"MLV_COLOR_GRAY49",
		"MLV_COLOR_GREY49",
		"MLV_COLOR_GRAY50",
		"MLV_COLOR_GREY50",
		"MLV_COLOR_GRAY51",
		"MLV_COLOR_GREY51",
		"MLV_COLOR_GRAY52",
		"MLV_COLOR_GREY52",
		"MLV_COLOR_GRAY53",
		"MLV_COLOR_GREY53",
		"MLV_COLOR_GRAY54",
		"MLV_COLOR_GREY54",
		"MLV_COLOR_GRAY55",
		"MLV_COLOR_GREY55",
		"MLV_COLOR_GRAY56",
		"MLV_COLOR_GREY56",
		"MLV_COLOR_GRAY57",
		"MLV_COLOR_GREY57",
		"MLV_COLOR_GRAY58",
		"MLV_COLOR_GREY58",
		"MLV_COLOR_GRAY59",
		"MLV_COLOR_GREY59",
		"MLV_COLOR_GRAY60",
		"MLV_COLOR_GREY60",
		"MLV_COLOR_GRAY61",
		"MLV_COLOR_GREY61",
		"MLV_COLOR_GRAY62",
		"MLV_COLOR_GREY62",
		"MLV_COLOR_GRAY63",
		"MLV_COLOR_GREY63",
		"MLV_COLOR_GRAY64",
		"MLV_COLOR_GREY64",
		"MLV_COLOR_GRAY65",
		"MLV_COLOR_GREY65",
		"MLV_COLOR_GRAY66",
		"MLV_COLOR_GREY66",
		"MLV_COLOR_GRAY67",
		"MLV_COLOR_GREY67",
		"MLV_COLOR_GRAY68",
		"MLV_COLOR_GREY68",
		"MLV_COLOR_GRAY69",
		"MLV_COLOR_GREY69",
		"MLV_COLOR_GRAY70",
		"MLV_COLOR_GREY70",
		"MLV_COLOR_GRAY71",
		"MLV_COLOR_GREY71",
		"MLV_COLOR_GRAY72",
		"MLV_COLOR_GREY72",
		"MLV_COLOR_GRAY73",
		"MLV_COLOR_GREY73",
		"MLV_COLOR_GRAY74",
		"MLV_COLOR_GREY74",
		"MLV_COLOR_GRAY75",
		"MLV_COLOR_GREY75",
		"MLV_COLOR_GRAY76",
		"MLV_COLOR_GREY76",
		"MLV_COLOR_GRAY77",
		"MLV_COLOR_GREY77",
		"MLV_COLOR_GRAY78",
		"MLV_COLOR_GREY78",
		"MLV_COLOR_GRAY79",
		"MLV_COLOR_GREY79",
		"MLV_COLOR_GRAY80",
		"MLV_COLOR_GREY80",
		"MLV_COLOR_GRAY81",
		"MLV_COLOR_GREY81",
		"MLV_COLOR_GRAY82",
		"MLV_COLOR_GREY82",
		"MLV_COLOR_GRAY83",
		"MLV_COLOR_GREY83",
		"MLV_COLOR_GRAY84",
		"MLV_COLOR_GREY84",
		"MLV_COLOR_GRAY85",
		"MLV_COLOR_GREY85",
		"MLV_COLOR_GRAY86",
		"MLV_COLOR_GREY86",
		"MLV_COLOR_GRAY87",
		"MLV_COLOR_GREY87",
		"MLV_COLOR_GRAY88",
		"MLV_COLOR_GREY88",
		"MLV_COLOR_GRAY89",
		"MLV_COLOR_GREY89",
		"MLV_COLOR_GRAY90",
		"MLV_COLOR_GREY90",
		"MLV_COLOR_GRAY91",
		"MLV_COLOR_GREY91",
		"MLV_COLOR_GRAY92",
		"MLV_COLOR_GREY92",
		"MLV_COLOR_GRAY93",
		"MLV_COLOR_GREY93",
		"MLV_COLOR_GRAY94",
		"MLV_COLOR_GREY94",
		"MLV_COLOR_GRAY95",
		"MLV_COLOR_GREY95",
		"MLV_COLOR_GRAY96",
		"MLV_COLOR_GREY96",
		"MLV_COLOR_GRAY97",
		"MLV_COLOR_GREY97",
		"MLV_COLOR_GRAY98",
		"MLV_COLOR_GREY98",
		"MLV_COLOR_GRAY99",
		"MLV_COLOR_GREY99",
		"MLV_COLOR_GRAY100",
		"MLV_COLOR_GREY100",
		"MLV_COLOR_DARK_GREY",
		"MLV_COLOR_DARKGREY",
		"MLV_COLOR_DARK_GRAY",
		"MLV_COLOR_DARKGRAY",
		"MLV_COLOR_DARK_BLUE",
		"MLV_COLOR_DARKBLUE",
		"MLV_COLOR_DARK_CYAN",
		"MLV_COLOR_DARKCYAN",
		"MLV_COLOR_DARK_MAGENTA",
		"MLV_COLOR_DARKMAGENTA",
		"MLV_COLOR_DARK_RED",
		"MLV_COLOR_DARKRED",
		"MLV_COLOR_LIGHT_GREEN",
		"MLV_COLOR_LIGHTGREEN"
	};
	MLV_Color couleur[NB_COULEUR] ={
		MLV_COLOR_SNOW,
		MLV_COLOR_GHOST_WHITE,
		MLV_COLOR_GHOSTWHITE,
		MLV_COLOR_WHITE_SMOKE,
		MLV_COLOR_WHITESMOKE,
		MLV_COLOR_GAINSBORO,
		MLV_COLOR_FLORAL_WHITE,
		MLV_COLOR_FLORALWHITE,
		MLV_COLOR_OLD_LACE,
		MLV_COLOR_OLDLACE,
		MLV_COLOR_LINEN,
		MLV_COLOR_ANTIQUE_WHITE,
		MLV_COLOR_ANTIQUEWHITE,
		MLV_COLOR_PAPAYA_WHIP,
		MLV_COLOR_PAPAYAWHIP,
		MLV_COLOR_BLANCHED_ALMOND,
		MLV_COLOR_BLANCHEDALMOND,
		MLV_COLOR_BISQUE,
		MLV_COLOR_PEACH_PUFF,
		MLV_COLOR_PEACHPUFF,
		MLV_COLOR_NAVAJO_WHITE,
		MLV_COLOR_NAVAJOWHITE,
		MLV_COLOR_MOCCASIN,
		MLV_COLOR_CORNSILK,
		MLV_COLOR_IVORY,
		MLV_COLOR_LEMON_CHIFFON,
		MLV_COLOR_LEMONCHIFFON,
		MLV_COLOR_SEASHELL,
		MLV_COLOR_HONEYDEW,
		MLV_COLOR_MINT_CREAM,
		MLV_COLOR_MINTCREAM,
		MLV_COLOR_AZURE,
		MLV_COLOR_ALICE_BLUE,
		MLV_COLOR_ALICEBLUE,
		MLV_COLOR_LAVENDER,
		MLV_COLOR_LAVENDER_BLUSH,
		MLV_COLOR_LAVENDERBLUSH,
		MLV_COLOR_MISTY_ROSE,
		MLV_COLOR_MISTYROSE,
		MLV_COLOR_WHITE,
		MLV_COLOR_BLACK,
		MLV_COLOR_DARK_SLATE_GRAY,
		MLV_COLOR_DARKSLATEGRAY,
		MLV_COLOR_DARK_SLATE_GREY,
		MLV_COLOR_DARKSLATEGREY,
		MLV_COLOR_DIM_GRAY,
		MLV_COLOR_DIMGRAY,
		MLV_COLOR_DIM_GREY,
		MLV_COLOR_DIMGREY,
		MLV_COLOR_SLATE_GRAY,
		MLV_COLOR_SLATEGRAY,
		MLV_COLOR_SLATE_GREY,
		MLV_COLOR_SLATEGREY,
		MLV_COLOR_LIGHT_SLATE_GRAY,
		MLV_COLOR_LIGHTSLATEGRAY,
		MLV_COLOR_LIGHT_SLATE_GREY,
		MLV_COLOR_LIGHTSLATEGREY,
		MLV_COLOR_GRAY,
		MLV_COLOR_GREY,
		MLV_COLOR_LIGHT_GREY,
		MLV_COLOR_LIGHTGREY,
		MLV_COLOR_LIGHT_GRAY,
		MLV_COLOR_LIGHTGRAY,
		MLV_COLOR_MIDNIGHT_BLUE,
		MLV_COLOR_MIDNIGHTBLUE,
		MLV_COLOR_NAVY,
		MLV_COLOR_NAVY_BLUE,
		MLV_COLOR_NAVYBLUE,
		MLV_COLOR_CORNFLOWER_BLUE,
		MLV_COLOR_CORNFLOWERBLUE,
		MLV_COLOR_DARK_SLATE_BLUE,
		MLV_COLOR_DARKSLATEBLUE,
		MLV_COLOR_SLATE_BLUE,
		MLV_COLOR_SLATEBLUE,
		MLV_COLOR_MEDIUM_SLATE_BLUE,
		MLV_COLOR_MEDIUMSLATEBLUE,
		MLV_COLOR_LIGHT_SLATE_BLUE,
		MLV_COLOR_LIGHTSLATEBLUE,
		MLV_COLOR_MEDIUM_BLUE,
		MLV_COLOR_MEDIUMBLUE,
		MLV_COLOR_ROYAL_BLUE,
		MLV_COLOR_ROYALBLUE,
		MLV_COLOR_BLUE,
		MLV_COLOR_DODGER_BLUE,
		MLV_COLOR_DODGERBLUE,
		MLV_COLOR_DEEP_SKY_BLUE,
		MLV_COLOR_DEEPSKYBLUE,
		MLV_COLOR_SKY_BLUE,
		MLV_COLOR_SKYBLUE,
		MLV_COLOR_LIGHT_SKY_BLUE,
		MLV_COLOR_LIGHTSKYBLUE,
		MLV_COLOR_STEEL_BLUE,
		MLV_COLOR_STEELBLUE,
		MLV_COLOR_LIGHT_STEEL_BLUE,
		MLV_COLOR_LIGHTSTEELBLUE,
		MLV_COLOR_LIGHT_BLUE,
		MLV_COLOR_LIGHTBLUE,
		MLV_COLOR_POWDER_BLUE,
		MLV_COLOR_POWDERBLUE,
		MLV_COLOR_PALE_TURQUOISE,
		MLV_COLOR_PALETURQUOISE,
		MLV_COLOR_DARK_TURQUOISE,
		MLV_COLOR_DARKTURQUOISE,
		MLV_COLOR_MEDIUM_TURQUOISE,
		MLV_COLOR_MEDIUMTURQUOISE,
		MLV_COLOR_TURQUOISE,
		MLV_COLOR_CYAN,
		MLV_COLOR_LIGHT_CYAN,
		MLV_COLOR_LIGHTCYAN,
		MLV_COLOR_CADET_BLUE,
		MLV_COLOR_CADETBLUE,
		MLV_COLOR_MEDIUM_AQUAMARINE,
		MLV_COLOR_MEDIUMAQUAMARINE,
		MLV_COLOR_AQUAMARINE,
		MLV_COLOR_DARK_GREEN,
		MLV_COLOR_DARKGREEN,
		MLV_COLOR_DARK_OLIVE_GREEN,
		MLV_COLOR_DARKOLIVEGREEN,
		MLV_COLOR_DARK_SEA_GREEN,
		MLV_COLOR_DARKSEAGREEN,
		MLV_COLOR_SEA_GREEN,
		MLV_COLOR_SEAGREEN,
		MLV_COLOR_MEDIUM_SEA_GREEN,
		MLV_COLOR_MEDIUMSEAGREEN,
		MLV_COLOR_LIGHT_SEA_GREEN,
		MLV_COLOR_LIGHTSEAGREEN,
		MLV_COLOR_PALE_GREEN,
		MLV_COLOR_PALEGREEN,
		MLV_COLOR_SPRING_GREEN,
		MLV_COLOR_SPRINGGREEN,
		MLV_COLOR_LAWN_GREEN,
		MLV_COLOR_LAWNGREEN,
		MLV_COLOR_GREEN,
		MLV_COLOR_CHARTREUSE,
		MLV_COLOR_MEDIUM_SPRING_GREEN,
		MLV_COLOR_MEDIUMSPRINGGREEN,
		MLV_COLOR_GREEN_YELLOW,
		MLV_COLOR_GREENYELLOW,
		MLV_COLOR_LIME_GREEN,
		MLV_COLOR_LIMEGREEN,
		MLV_COLOR_YELLOW_GREEN,
		MLV_COLOR_YELLOWGREEN,
		MLV_COLOR_FOREST_GREEN,
		MLV_COLOR_FORESTGREEN,
		MLV_COLOR_OLIVE_DRAB,
		MLV_COLOR_OLIVEDRAB,
		MLV_COLOR_DARK_KHAKI,
		MLV_COLOR_DARKKHAKI,
		MLV_COLOR_KHAKI,
		MLV_COLOR_PALE_GOLDENROD,
		MLV_COLOR_PALEGOLDENROD,
		MLV_COLOR_LIGHT_GOLDENROD_YELLOW,
		MLV_COLOR_LIGHTGOLDENRODYELLOW,
		MLV_COLOR_LIGHT_YELLOW,
		MLV_COLOR_LIGHTYELLOW,
		MLV_COLOR_YELLOW,
		MLV_COLOR_GOLD,
		MLV_COLOR_LIGHT_GOLDENROD,
		MLV_COLOR_LIGHTGOLDENROD,
		MLV_COLOR_GOLDENROD,
		MLV_COLOR_DARK_GOLDENROD,
		MLV_COLOR_DARKGOLDENROD,
		MLV_COLOR_ROSY_BROWN,
		MLV_COLOR_ROSYBROWN,
		MLV_COLOR_INDIAN_RED,
		MLV_COLOR_INDIANRED,
		MLV_COLOR_SADDLE_BROWN,
		MLV_COLOR_SADDLEBROWN,
		MLV_COLOR_SIENNA,
		MLV_COLOR_PERU,
		MLV_COLOR_BURLYWOOD,
		MLV_COLOR_BEIGE,
		MLV_COLOR_WHEAT,
		MLV_COLOR_SANDY_BROWN,
		MLV_COLOR_SANDYBROWN,
		MLV_COLOR_TAN,
		MLV_COLOR_CHOCOLATE,
		MLV_COLOR_FIREBRICK,
		MLV_COLOR_BROWN,
		MLV_COLOR_DARK_SALMON,
		MLV_COLOR_DARKSALMON,
		MLV_COLOR_SALMON,
		MLV_COLOR_LIGHT_SALMON,
		MLV_COLOR_LIGHTSALMON,
		MLV_COLOR_ORANGE,
		MLV_COLOR_DARK_ORANGE,
		MLV_COLOR_DARKORANGE,
		MLV_COLOR_CORAL,
		MLV_COLOR_LIGHT_CORAL,
		MLV_COLOR_LIGHTCORAL,
		MLV_COLOR_TOMATO,
		MLV_COLOR_ORANGE_RED,
		MLV_COLOR_ORANGERED,
		MLV_COLOR_RED,
		MLV_COLOR_HOT_PINK,
		MLV_COLOR_HOTPINK,
		MLV_COLOR_DEEP_PINK,
		MLV_COLOR_DEEPPINK,
		MLV_COLOR_PINK,
		MLV_COLOR_LIGHT_PINK,
		MLV_COLOR_LIGHTPINK,
		MLV_COLOR_PALE_VIOLET_RED,
		MLV_COLOR_PALEVIOLETRED,
		MLV_COLOR_MAROON,
		MLV_COLOR_MEDIUM_VIOLET_RED,
		MLV_COLOR_MEDIUMVIOLETRED,
		MLV_COLOR_VIOLET_RED,
		MLV_COLOR_VIOLETRED,
		MLV_COLOR_MAGENTA,
		MLV_COLOR_VIOLET,
		MLV_COLOR_PLUM,
		MLV_COLOR_ORCHID,
		MLV_COLOR_MEDIUM_ORCHID,
		MLV_COLOR_MEDIUMORCHID,
		MLV_COLOR_DARK_ORCHID,
		MLV_COLOR_DARKORCHID,
		MLV_COLOR_DARK_VIOLET,
		MLV_COLOR_DARKVIOLET,
		MLV_COLOR_BLUE_VIOLET,
		MLV_COLOR_BLUEVIOLET,
		MLV_COLOR_PURPLE,
		MLV_COLOR_MEDIUM_PURPLE,
		MLV_COLOR_MEDIUMPURPLE,
		MLV_COLOR_THISTLE,
		MLV_COLOR_SNOW1,
		MLV_COLOR_SNOW2,
		MLV_COLOR_SNOW3,
		MLV_COLOR_SNOW4,
		MLV_COLOR_SEASHELL1,
		MLV_COLOR_SEASHELL2,
		MLV_COLOR_SEASHELL3,
		MLV_COLOR_SEASHELL4,
		MLV_COLOR_ANTIQUEWHITE1,
		MLV_COLOR_ANTIQUEWHITE2,
		MLV_COLOR_ANTIQUEWHITE3,
		MLV_COLOR_ANTIQUEWHITE4,
		MLV_COLOR_BISQUE1,
		MLV_COLOR_BISQUE2,
		MLV_COLOR_BISQUE3,
		MLV_COLOR_BISQUE4,
		MLV_COLOR_PEACHPUFF1,
		MLV_COLOR_PEACHPUFF2,
		MLV_COLOR_PEACHPUFF3,
		MLV_COLOR_PEACHPUFF4,
		MLV_COLOR_NAVAJOWHITE1,
		MLV_COLOR_NAVAJOWHITE2,
		MLV_COLOR_NAVAJOWHITE3,
		MLV_COLOR_NAVAJOWHITE4,
		MLV_COLOR_LEMONCHIFFON1,
		MLV_COLOR_LEMONCHIFFON2,
		MLV_COLOR_LEMONCHIFFON3,
		MLV_COLOR_LEMONCHIFFON4,
		MLV_COLOR_CORNSILK1,
		MLV_COLOR_CORNSILK2,
		MLV_COLOR_CORNSILK3,
		MLV_COLOR_CORNSILK4,
		MLV_COLOR_IVORY1,
		MLV_COLOR_IVORY2,
		MLV_COLOR_IVORY3,
		MLV_COLOR_IVORY4,
		MLV_COLOR_HONEYDEW1,
		MLV_COLOR_HONEYDEW2,
		MLV_COLOR_HONEYDEW3,
		MLV_COLOR_HONEYDEW4,
		MLV_COLOR_LAVENDERBLUSH1,
		MLV_COLOR_LAVENDERBLUSH2,
		MLV_COLOR_LAVENDERBLUSH3,
		MLV_COLOR_LAVENDERBLUSH4,
		MLV_COLOR_MISTYROSE1,
		MLV_COLOR_MISTYROSE2,
		MLV_COLOR_MISTYROSE3,
		MLV_COLOR_MISTYROSE4,
		MLV_COLOR_AZURE1,
		MLV_COLOR_AZURE2,
		MLV_COLOR_AZURE3,
		MLV_COLOR_AZURE4,
		MLV_COLOR_SLATEBLUE1,
		MLV_COLOR_SLATEBLUE2,
		MLV_COLOR_SLATEBLUE3,
		MLV_COLOR_SLATEBLUE4,
		MLV_COLOR_ROYALBLUE1,
		MLV_COLOR_ROYALBLUE2,
		MLV_COLOR_ROYALBLUE3,
		MLV_COLOR_ROYALBLUE4,
		MLV_COLOR_BLUE1,
		MLV_COLOR_BLUE2,
		MLV_COLOR_BLUE3,
		MLV_COLOR_BLUE4,
		MLV_COLOR_DODGERBLUE1,
		MLV_COLOR_DODGERBLUE2,
		MLV_COLOR_DODGERBLUE3,
		MLV_COLOR_DODGERBLUE4,
		MLV_COLOR_STEELBLUE1,
		MLV_COLOR_STEELBLUE2,
		MLV_COLOR_STEELBLUE3,
		MLV_COLOR_STEELBLUE4,
		MLV_COLOR_DEEPSKYBLUE1,
		MLV_COLOR_DEEPSKYBLUE2,
		MLV_COLOR_DEEPSKYBLUE3,
		MLV_COLOR_DEEPSKYBLUE4,
		MLV_COLOR_SKYBLUE1,
		MLV_COLOR_SKYBLUE2,
		MLV_COLOR_SKYBLUE3,
		MLV_COLOR_SKYBLUE4,
		MLV_COLOR_LIGHTSKYBLUE1,
		MLV_COLOR_LIGHTSKYBLUE2,
		MLV_COLOR_LIGHTSKYBLUE3,
		MLV_COLOR_LIGHTSKYBLUE4,
		MLV_COLOR_SLATEGRAY1,
		MLV_COLOR_SLATEGRAY2,
		MLV_COLOR_SLATEGRAY3,
		MLV_COLOR_SLATEGRAY4,
		MLV_COLOR_LIGHTSTEELBLUE1,
		MLV_COLOR_LIGHTSTEELBLUE2,
		MLV_COLOR_LIGHTSTEELBLUE3,
		MLV_COLOR_LIGHTSTEELBLUE4,
		MLV_COLOR_LIGHTBLUE1,
		MLV_COLOR_LIGHTBLUE2,
		MLV_COLOR_LIGHTBLUE3,
		MLV_COLOR_LIGHTBLUE4,
		MLV_COLOR_LIGHTCYAN1,
		MLV_COLOR_LIGHTCYAN2,
		MLV_COLOR_LIGHTCYAN3,
		MLV_COLOR_LIGHTCYAN4,
		MLV_COLOR_PALETURQUOISE1,
		MLV_COLOR_PALETURQUOISE2,
		MLV_COLOR_PALETURQUOISE3,
		MLV_COLOR_PALETURQUOISE4,
		MLV_COLOR_CADETBLUE1,
		MLV_COLOR_CADETBLUE2,
		MLV_COLOR_CADETBLUE3,
		MLV_COLOR_CADETBLUE4,
		MLV_COLOR_TURQUOISE1,
		MLV_COLOR_TURQUOISE2,
		MLV_COLOR_TURQUOISE3,
		MLV_COLOR_TURQUOISE4,
		MLV_COLOR_CYAN1,
		MLV_COLOR_CYAN2,
		MLV_COLOR_CYAN3,
		MLV_COLOR_CYAN4,
		MLV_COLOR_DARKSLATEGRAY1,
		MLV_COLOR_DARKSLATEGRAY2,
		MLV_COLOR_DARKSLATEGRAY3,
		MLV_COLOR_DARKSLATEGRAY4,
		MLV_COLOR_AQUAMARINE1,
		MLV_COLOR_AQUAMARINE2,
		MLV_COLOR_AQUAMARINE3,
		MLV_COLOR_AQUAMARINE4,
		MLV_COLOR_DARKSEAGREEN1,
		MLV_COLOR_DARKSEAGREEN2,
		MLV_COLOR_DARKSEAGREEN3,
		MLV_COLOR_DARKSEAGREEN4,
		MLV_COLOR_SEAGREEN1,
		MLV_COLOR_SEAGREEN2,
		MLV_COLOR_SEAGREEN3,
		MLV_COLOR_SEAGREEN4,
		MLV_COLOR_PALEGREEN1,
		MLV_COLOR_PALEGREEN2,
		MLV_COLOR_PALEGREEN3,
		MLV_COLOR_PALEGREEN4,
		MLV_COLOR_SPRINGGREEN1,
		MLV_COLOR_SPRINGGREEN2,
		MLV_COLOR_SPRINGGREEN3,
		MLV_COLOR_SPRINGGREEN4,
		MLV_COLOR_GREEN1,
		MLV_COLOR_GREEN2,
		MLV_COLOR_GREEN3,
		MLV_COLOR_GREEN4,
		MLV_COLOR_CHARTREUSE1,
		MLV_COLOR_CHARTREUSE2,
		MLV_COLOR_CHARTREUSE3,
		MLV_COLOR_CHARTREUSE4,
		MLV_COLOR_OLIVEDRAB1,
		MLV_COLOR_OLIVEDRAB2,
		MLV_COLOR_OLIVEDRAB3,
		MLV_COLOR_OLIVEDRAB4,
		MLV_COLOR_DARKOLIVEGREEN1,
		MLV_COLOR_DARKOLIVEGREEN2,
		MLV_COLOR_DARKOLIVEGREEN3,
		MLV_COLOR_DARKOLIVEGREEN4,
		MLV_COLOR_KHAKI1,
		MLV_COLOR_KHAKI2,
		MLV_COLOR_KHAKI3,
		MLV_COLOR_KHAKI4,
		MLV_COLOR_LIGHTGOLDENROD1,
		MLV_COLOR_LIGHTGOLDENROD2,
		MLV_COLOR_LIGHTGOLDENROD3,
		MLV_COLOR_LIGHTGOLDENROD4,
		MLV_COLOR_LIGHTYELLOW1,
		MLV_COLOR_LIGHTYELLOW2,
		MLV_COLOR_LIGHTYELLOW3,
		MLV_COLOR_LIGHTYELLOW4,
		MLV_COLOR_YELLOW1,
		MLV_COLOR_YELLOW2,
		MLV_COLOR_YELLOW3,
		MLV_COLOR_YELLOW4,
		MLV_COLOR_GOLD1,
		MLV_COLOR_GOLD2,
		MLV_COLOR_GOLD3,
		MLV_COLOR_GOLD4,
		MLV_COLOR_GOLDENROD1,
		MLV_COLOR_GOLDENROD2,
		MLV_COLOR_GOLDENROD3,
		MLV_COLOR_GOLDENROD4,
		MLV_COLOR_DARKGOLDENROD1,
		MLV_COLOR_DARKGOLDENROD2,
		MLV_COLOR_DARKGOLDENROD3,
		MLV_COLOR_DARKGOLDENROD4,
		MLV_COLOR_ROSYBROWN1,
		MLV_COLOR_ROSYBROWN2,
		MLV_COLOR_ROSYBROWN3,
		MLV_COLOR_ROSYBROWN4,
		MLV_COLOR_INDIANRED1,
		MLV_COLOR_INDIANRED2,
		MLV_COLOR_INDIANRED3,
		MLV_COLOR_INDIANRED4,
		MLV_COLOR_SIENNA1,
		MLV_COLOR_SIENNA2,
		MLV_COLOR_SIENNA3,
		MLV_COLOR_SIENNA4,
		MLV_COLOR_BURLYWOOD1,
		MLV_COLOR_BURLYWOOD2,
		MLV_COLOR_BURLYWOOD3,
		MLV_COLOR_BURLYWOOD4,
		MLV_COLOR_WHEAT1,
		MLV_COLOR_WHEAT2,
		MLV_COLOR_WHEAT3,
		MLV_COLOR_WHEAT4,
		MLV_COLOR_TAN1,
		MLV_COLOR_TAN2,
		MLV_COLOR_TAN3,
		MLV_COLOR_TAN4,
		MLV_COLOR_CHOCOLATE1,
		MLV_COLOR_CHOCOLATE2,
		MLV_COLOR_CHOCOLATE3,
		MLV_COLOR_CHOCOLATE4,
		MLV_COLOR_FIREBRICK1,
		MLV_COLOR_FIREBRICK2,
		MLV_COLOR_FIREBRICK3,
		MLV_COLOR_FIREBRICK4,
		MLV_COLOR_BROWN1,
		MLV_COLOR_BROWN2,
		MLV_COLOR_BROWN3,
		MLV_COLOR_BROWN4,
		MLV_COLOR_SALMON1,
		MLV_COLOR_SALMON2,
		MLV_COLOR_SALMON3,
		MLV_COLOR_SALMON4,
		MLV_COLOR_LIGHTSALMON1,
		MLV_COLOR_LIGHTSALMON2,
		MLV_COLOR_LIGHTSALMON3,
		MLV_COLOR_LIGHTSALMON4,
		MLV_COLOR_ORANGE1,
		MLV_COLOR_ORANGE2,
		MLV_COLOR_ORANGE3,
		MLV_COLOR_ORANGE4,
		MLV_COLOR_DARKORANGE1,
		MLV_COLOR_DARKORANGE2,
		MLV_COLOR_DARKORANGE3,
		MLV_COLOR_DARKORANGE4,
		MLV_COLOR_CORAL1,
		MLV_COLOR_CORAL2,
		MLV_COLOR_CORAL3,
		MLV_COLOR_CORAL4,
		MLV_COLOR_TOMATO1,
		MLV_COLOR_TOMATO2,
		MLV_COLOR_TOMATO3,
		MLV_COLOR_TOMATO4,
		MLV_COLOR_ORANGERED1,
		MLV_COLOR_ORANGERED2,
		MLV_COLOR_ORANGERED3,
		MLV_COLOR_ORANGERED4,
		MLV_COLOR_RED1,
		MLV_COLOR_RED2,
		MLV_COLOR_RED3,
		MLV_COLOR_RED4,
		MLV_COLOR_DEEPPINK1,
		MLV_COLOR_DEEPPINK2,
		MLV_COLOR_DEEPPINK3,
		MLV_COLOR_DEEPPINK4,
		MLV_COLOR_HOTPINK1,
		MLV_COLOR_HOTPINK2,
		MLV_COLOR_HOTPINK3,
		MLV_COLOR_HOTPINK4,
		MLV_COLOR_PINK1,
		MLV_COLOR_PINK2,
		MLV_COLOR_PINK3,
		MLV_COLOR_PINK4,
		MLV_COLOR_LIGHTPINK1,
		MLV_COLOR_LIGHTPINK2,
		MLV_COLOR_LIGHTPINK3,
		MLV_COLOR_LIGHTPINK4,
		MLV_COLOR_PALEVIOLETRED1,
		MLV_COLOR_PALEVIOLETRED2,
		MLV_COLOR_PALEVIOLETRED3,
		MLV_COLOR_PALEVIOLETRED4,
		MLV_COLOR_MAROON1,
		MLV_COLOR_MAROON2,
		MLV_COLOR_MAROON3,
		MLV_COLOR_MAROON4,
		MLV_COLOR_VIOLETRED1,
		MLV_COLOR_VIOLETRED2,
		MLV_COLOR_VIOLETRED3,
		MLV_COLOR_VIOLETRED4,
		MLV_COLOR_MAGENTA1,
		MLV_COLOR_MAGENTA2,
		MLV_COLOR_MAGENTA3,
		MLV_COLOR_MAGENTA4,
		MLV_COLOR_ORCHID1,
		MLV_COLOR_ORCHID2,
		MLV_COLOR_ORCHID3,
		MLV_COLOR_ORCHID4,
		MLV_COLOR_PLUM1,
		MLV_COLOR_PLUM2,
		MLV_COLOR_PLUM3,
		MLV_COLOR_PLUM4,
		MLV_COLOR_MEDIUMORCHID1,
		MLV_COLOR_MEDIUMORCHID2,
		MLV_COLOR_MEDIUMORCHID3,
		MLV_COLOR_MEDIUMORCHID4,
		MLV_COLOR_DARKORCHID1,
		MLV_COLOR_DARKORCHID2,
		MLV_COLOR_DARKORCHID3,
		MLV_COLOR_DARKORCHID4,
		MLV_COLOR_PURPLE1,
		MLV_COLOR_PURPLE2,
		MLV_COLOR_PURPLE3,
		MLV_COLOR_PURPLE4,
		MLV_COLOR_MEDIUMPURPLE1,
		MLV_COLOR_MEDIUMPURPLE2,
		MLV_COLOR_MEDIUMPURPLE3,
		MLV_COLOR_MEDIUMPURPLE4,
		MLV_COLOR_THISTLE1,
		MLV_COLOR_THISTLE2,
		MLV_COLOR_THISTLE3,
		MLV_COLOR_THISTLE4,
		MLV_COLOR_GRAY0,
		MLV_COLOR_GREY0,
		MLV_COLOR_GRAY1,
		MLV_COLOR_GREY1,
		MLV_COLOR_GRAY2,
		MLV_COLOR_GREY2,
		MLV_COLOR_GRAY3,
		MLV_COLOR_GREY3,
		MLV_COLOR_GRAY4,
		MLV_COLOR_GREY4,
		MLV_COLOR_GRAY5,
		MLV_COLOR_GREY5,
		MLV_COLOR_GRAY6,
		MLV_COLOR_GREY6,
		MLV_COLOR_GRAY7,
		MLV_COLOR_GREY7,
		MLV_COLOR_GRAY8,
		MLV_COLOR_GREY8,
		MLV_COLOR_GRAY9,
		MLV_COLOR_GREY9,
		MLV_COLOR_GRAY10,
		MLV_COLOR_GREY10,
		MLV_COLOR_GRAY11,
		MLV_COLOR_GREY11,
		MLV_COLOR_GRAY12,
		MLV_COLOR_GREY12,
		MLV_COLOR_GRAY13,
		MLV_COLOR_GREY13,
		MLV_COLOR_GRAY14,
		MLV_COLOR_GREY14,
		MLV_COLOR_GRAY15,
		MLV_COLOR_GREY15,
		MLV_COLOR_GRAY16,
		MLV_COLOR_GREY16,
		MLV_COLOR_GRAY17,
		MLV_COLOR_GREY17,
		MLV_COLOR_GRAY18,
		MLV_COLOR_GREY18,
		MLV_COLOR_GRAY19,
		MLV_COLOR_GREY19,
		MLV_COLOR_GRAY20,
		MLV_COLOR_GREY20,
		MLV_COLOR_GRAY21,
		MLV_COLOR_GREY21,
		MLV_COLOR_GRAY22,
		MLV_COLOR_GREY22,
		MLV_COLOR_GRAY23,
		MLV_COLOR_GREY23,
		MLV_COLOR_GRAY24,
		MLV_COLOR_GREY24,
		MLV_COLOR_GRAY25,
		MLV_COLOR_GREY25,
		MLV_COLOR_GRAY26,
		MLV_COLOR_GREY26,
		MLV_COLOR_GRAY27,
		MLV_COLOR_GREY27,
		MLV_COLOR_GRAY28,
		MLV_COLOR_GREY28,
		MLV_COLOR_GRAY29,
		MLV_COLOR_GREY29,
		MLV_COLOR_GRAY30,
		MLV_COLOR_GREY30,
		MLV_COLOR_GRAY31,
		MLV_COLOR_GREY31,
		MLV_COLOR_GRAY32,
		MLV_COLOR_GREY32,
		MLV_COLOR_GRAY33,
		MLV_COLOR_GREY33,
		MLV_COLOR_GRAY34,
		MLV_COLOR_GREY34,
		MLV_COLOR_GRAY35,
		MLV_COLOR_GREY35,
		MLV_COLOR_GRAY36,
		MLV_COLOR_GREY36,
		MLV_COLOR_GRAY37,
		MLV_COLOR_GREY37,
		MLV_COLOR_GRAY38,
		MLV_COLOR_GREY38,
		MLV_COLOR_GRAY39,
		MLV_COLOR_GREY39,
		MLV_COLOR_GRAY40,
		MLV_COLOR_GREY40,
		MLV_COLOR_GRAY41,
		MLV_COLOR_GREY41,
		MLV_COLOR_GRAY42,
		MLV_COLOR_GREY42,
		MLV_COLOR_GRAY43,
		MLV_COLOR_GREY43,
		MLV_COLOR_GRAY44,
		MLV_COLOR_GREY44,
		MLV_COLOR_GRAY45,
		MLV_COLOR_GREY45,
		MLV_COLOR_GRAY46,
		MLV_COLOR_GREY46,
		MLV_COLOR_GRAY47,
		MLV_COLOR_GREY47,
		MLV_COLOR_GRAY48,
		MLV_COLOR_GREY48,
		MLV_COLOR_GRAY49,
		MLV_COLOR_GREY49,
		MLV_COLOR_GRAY50,
		MLV_COLOR_GREY50,
		MLV_COLOR_GRAY51,
		MLV_COLOR_GREY51,
		MLV_COLOR_GRAY52,
		MLV_COLOR_GREY52,
		MLV_COLOR_GRAY53,
		MLV_COLOR_GREY53,
		MLV_COLOR_GRAY54,
		MLV_COLOR_GREY54,
		MLV_COLOR_GRAY55,
		MLV_COLOR_GREY55,
		MLV_COLOR_GRAY56,
		MLV_COLOR_GREY56,
		MLV_COLOR_GRAY57,
		MLV_COLOR_GREY57,
		MLV_COLOR_GRAY58,
		MLV_COLOR_GREY58,
		MLV_COLOR_GRAY59,
		MLV_COLOR_GREY59,
		MLV_COLOR_GRAY60,
		MLV_COLOR_GREY60,
		MLV_COLOR_GRAY61,
		MLV_COLOR_GREY61,
		MLV_COLOR_GRAY62,
		MLV_COLOR_GREY62,
		MLV_COLOR_GRAY63,
		MLV_COLOR_GREY63,
		MLV_COLOR_GRAY64,
		MLV_COLOR_GREY64,
		MLV_COLOR_GRAY65,
		MLV_COLOR_GREY65,
		MLV_COLOR_GRAY66,
		MLV_COLOR_GREY66,
		MLV_COLOR_GRAY67,
		MLV_COLOR_GREY67,
		MLV_COLOR_GRAY68,
		MLV_COLOR_GREY68,
		MLV_COLOR_GRAY69,
		MLV_COLOR_GREY69,
		MLV_COLOR_GRAY70,
		MLV_COLOR_GREY70,
		MLV_COLOR_GRAY71,
		MLV_COLOR_GREY71,
		MLV_COLOR_GRAY72,
		MLV_COLOR_GREY72,
		MLV_COLOR_GRAY73,
		MLV_COLOR_GREY73,
		MLV_COLOR_GRAY74,
		MLV_COLOR_GREY74,
		MLV_COLOR_GRAY75,
		MLV_COLOR_GREY75,
		MLV_COLOR_GRAY76,
		MLV_COLOR_GREY76,
		MLV_COLOR_GRAY77,
		MLV_COLOR_GREY77,
		MLV_COLOR_GRAY78,
		MLV_COLOR_GREY78,
		MLV_COLOR_GRAY79,
		MLV_COLOR_GREY79,
		MLV_COLOR_GRAY80,
		MLV_COLOR_GREY80,
		MLV_COLOR_GRAY81,
		MLV_COLOR_GREY81,
		MLV_COLOR_GRAY82,
		MLV_COLOR_GREY82,
		MLV_COLOR_GRAY83,
		MLV_COLOR_GREY83,
		MLV_COLOR_GRAY84,
		MLV_COLOR_GREY84,
		MLV_COLOR_GRAY85,
		MLV_COLOR_GREY85,
		MLV_COLOR_GRAY86,
		MLV_COLOR_GREY86,
		MLV_COLOR_GRAY87,
		MLV_COLOR_GREY87,
		MLV_COLOR_GRAY88,
		MLV_COLOR_GREY88,
		MLV_COLOR_GRAY89,
		MLV_COLOR_GREY89,
		MLV_COLOR_GRAY90,
		MLV_COLOR_GREY90,
		MLV_COLOR_GRAY91,
		MLV_COLOR_GREY91,
		MLV_COLOR_GRAY92,
		MLV_COLOR_GREY92,
		MLV_COLOR_GRAY93,
		MLV_COLOR_GREY93,
		MLV_COLOR_GRAY94,
		MLV_COLOR_GREY94,
		MLV_COLOR_GRAY95,
		MLV_COLOR_GREY95,
		MLV_COLOR_GRAY96,
		MLV_COLOR_GREY96,
		MLV_COLOR_GRAY97,
		MLV_COLOR_GREY97,
		MLV_COLOR_GRAY98,
		MLV_COLOR_GREY98,
		MLV_COLOR_GRAY99,
		MLV_COLOR_GREY99,
		MLV_COLOR_GRAY100,
		MLV_COLOR_GREY100,
		MLV_COLOR_DARK_GREY,
		MLV_COLOR_DARKGREY,
		MLV_COLOR_DARK_GRAY,
		MLV_COLOR_DARKGRAY,
		MLV_COLOR_DARK_BLUE,
		MLV_COLOR_DARKBLUE,
		MLV_COLOR_DARK_CYAN,
		MLV_COLOR_DARKCYAN,
		MLV_COLOR_DARK_MAGENTA,
		MLV_COLOR_DARKMAGENTA,
		MLV_COLOR_DARK_RED,
		MLV_COLOR_DARKRED,
		MLV_COLOR_LIGHT_GREEN,
		MLV_COLOR_LIGHTGREEN
	};

	int largeur = 640;
	int hauteur = 480;
	int nb_case_largeur = sqrt(NB_COULEUR);
	int largeur_case = largeur/nb_case_largeur;
	int hauteur_case = hauteur/nb_case_largeur;
	int x, y, integerX, integerY, couleur_obtenu, posX, posY;

	//
	// Créé et affiche la fenêtre
	//
	MLV_create_window( "beginner - 9 - colors", "colors", 640, 480 );

	while( 1 ){
		int i;
		//
		// Nettoie l'écran pour un nouvel affichage
		//
		MLV_clear_window( MLV_COLOR_BLACK );

		//
		// Affiche le rectangle de ième couleur
		//
		for( i=0; i<NB_COULEUR; i++){
			posX = i%nb_case_largeur;
			posY = i/nb_case_largeur;
			MLV_draw_filled_rectangle(
				posX*largeur_case,
				posY*hauteur_case,
				largeur_case,
				hauteur_case,
				couleur[i]
			);
		}
		//
		// Met a jour l'affichage.
		//
		MLV_update_window();

		//
		// Attends que l'utilisateur clique sur le bouton gauche de la souris
		//
		MLV_wait_mouse(&x, &y);

		integerX = x/( largeur_case);
		integerY = y/( hauteur_case);
		couleur_obtenu= integerX+integerY*nb_case_largeur;

		if( couleur_obtenu<NB_COULEUR ){
			printf( "Couleur : %s \n",couleur_string[couleur_obtenu] );
			MLV_draw_adapted_text_box (
				0, 0, 
				couleur_string[ couleur_obtenu ],
				9,
				MLV_COLOR_RED,
				MLV_COLOR_GREEN,
				MLV_COLOR_BLACK,
				MLV_TEXT_CENTER
			);
		}
		
		//
		// Met à jour l'affichage.
		//
		MLV_update_window();

		MLV_wait_mouse(&x, &y);
	}

	//
	// Ferme la fenêtre
	//
	MLV_free_window();

	return 0;
}

/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010,2011,2012,2013 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */
