How to Contribute
=================
We welcome contributions from the community to make MobilityDB better!

If you want to connect with us, you may always join the gitter chat, or contact us via mailing list. We want you working on things you're excited about. Drop a message and if some one can assist you, will contact you back ASAP.

Here are many ways you can contact us:
*   Gitter chat at [![Gitter](https://badges.gitter.im/MobilityDBProject/MobilityDB.svg)](https://gitter.im/MobilityDBProject/MobilityDB?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
*   [User mailing list](http://lists.osgeo.org/mailman/listinfo/mobilitydb-users)
*   [Developer mailing list](http://lists.osgeo.org/mailman/listinfo/mobilitydb-dev)

If you haven't yet, Chapter 1 of the [manual](https://docs.mobilitydb.com/MobilityDB/master/) describes how to download and build the sources.

Reporting Issues and Suggesting Features
----------------------------------------
When contributing to this repository, please first search the issues to see if your problem/wish has already been reported. If so, add any extra context you might have found, or at least indicate that you too are having the problem/wish. This will help us prioritize common issues.

If your problem is unreported, create a new [issue](https://github.com/MobilityDB/MobilityDB/issues) for it. This will allow the community to discuss it. When creating an issue, you will be able to choose between multiple templates that we provide to assist in making a clear description of the issue. If you further want to contribute a solution, please go forward and create a pull request.

Pull Request Process
--------------------
You can fork this repository, make your own contribution, and submit a pull request. Please put as the pull request title the issue number that it closes (for example, `[Closes issue #xxx]`). Write a clear log message for your commits. One-line messages are fine for small changes, but bigger changes should have more information.

Contribution Agreement
----------------------
MobilityDB source code is provided under the [PostgreSQL license](https://github.com/MobilityDB/MobilityDB/blob/master/LICENSE.txt). The documentation is provided under the [Creative Commons Attribution-Share Alike 3.0 License](https://creativecommons.org/licenses/by-sa/3.0/). Any contribution will automatically fall to the same license respectively.

Code of Conduct
---------------
We have a [code of conduct](https://github.com/MobilityDB/MobilityDB/blob/master/code-of-conduct.md), so please follow it in all your interactions with the project.
