// 
// MusicTrackOptions.cs
//  
// Author:
//       Yavor Georgiev <fealebenpae@gmail.com>
// 
// Copyright (c) 2010 Yavor Georgiev
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

using System;
using System.Collections.Generic;

namespace Mono.Upnp.Dcp.MediaServer1.ContentDirectory1.AV
{
    public class MusicTrackOptions : AudioItemOptions
    {
        IEnumerable<PersonWithRole> artists;
        IEnumerable<string> albums;
        IEnumerable<string> playlists;
        IEnumerable<string> contributors;

        public IEnumerable<PersonWithRole> Artists {
            get { return GetEnumerable (artists); }
            set { artists = value; }
        }

        public IEnumerable<string> Albums {
            get { return GetEnumerable (albums); }
            set { albums = value; }
        }

        public IEnumerable<string> Playlists {
            get { return GetEnumerable (playlists); }
            set { playlists = value; }
        }

        public IEnumerable<string> Contributors {
            get { return GetEnumerable (contributors); }
            set { contributors = value; }
        }

        public virtual Uri AlbumArtUri { get; set; }

        public virtual int? OriginalTrackNumber { get;  set; }

        public virtual string StorageMedium { get; set; }

        public virtual string Date { get; set; }
    }
}

