import { createConversionChecker } from '../helpers/helpers';

import hypot from 'core-js-pure/es/math/hypot';

QUnit.test('Math.hypot', assert => {
  const { sqrt } = Math;
  assert.isFunction(hypot);
  assert.same(hypot(), 0);
  assert.same(hypot(1), 1);
  assert.same(hypot('', 0), 0);
  assert.same(hypot(0, ''), 0);
  assert.same(hypot(Infinity, 0), Infinity, 'Infinity, 0');
  assert.same(hypot(-Infinity, 0), Infinity, '-Infinity, 0');
  assert.same(hypot(0, Infinity), Infinity, '0, Infinity');
  assert.same(hypot(0, -Infinity), Infinity, '0, -Infinity');
  assert.same(hypot(Infinity, NaN), Infinity, 'Infinity, NaN');
  assert.same(hypot(NaN, -Infinity), Infinity, 'NaN, -Infinity');
  assert.same(hypot(NaN, 0), NaN, 'NaN, 0');
  assert.same(hypot(0, NaN), NaN, '0, NaN');
  assert.same(hypot(0, -0), 0);
  assert.same(hypot(0, 0), 0);
  assert.same(hypot(-0, -0), 0);
  assert.same(hypot(-0, 0), 0);
  assert.same(hypot(0, 1), 1);
  assert.same(hypot(0, -1), 1);
  assert.same(hypot(-0, 1), 1);
  assert.same(hypot(-0, -1), 1);
  assert.same(hypot(0), 0);
  assert.same(hypot(1), 1);
  assert.same(hypot(2), 2);
  assert.same(hypot(0, 0, 1), 1);
  assert.same(hypot(0, 1, 0), 1);
  assert.same(hypot(1, 0, 0), 1);
  assert.same(hypot(2, 3, 4), sqrt(2 * 2 + 3 * 3 + 4 * 4));
  assert.same(hypot(2, 3, 4, 5), sqrt(2 * 2 + 3 * 3 + 4 * 4 + 5 * 5));
  assert.epsilon(hypot(66, 66), 93.33809511662427);
  assert.epsilon(hypot(0.1, 100), 100.0000499999875);
  assert.same(hypot(1e+300, 1e+300), 1.4142135623730952e+300);
  assert.same(Math.floor(hypot(1e-300, 1e-300) * 1e308), 141421356);
  assert.same(hypot(1e+300, 1e+300, 2, 3), 1.4142135623730952e+300);
  assert.same(hypot(-3, 4), 5);
  assert.same(hypot(3, -4), 5);

  const checker1 = createConversionChecker(2);
  const checker2 = createConversionChecker(3);
  const checker3 = createConversionChecker(4);
  const checker4 = createConversionChecker(5);
  assert.same(hypot(checker1, checker2, checker3, checker4), sqrt(2 * 2 + 3 * 3 + 4 * 4 + 5 * 5), 'object wrapper');
  assert.same(checker1.$valueOf, 1, 'checker1 valueOf calls');
  assert.same(checker1.$toString, 0, 'checker1 toString calls');
  assert.same(checker2.$valueOf, 1, 'checker2 valueOf calls');
  assert.same(checker2.$toString, 0, 'checker2 toString calls');
  assert.same(checker3.$valueOf, 1, 'checker3 valueOf calls');
  assert.same(checker3.$toString, 0, 'checker3 toString calls');
  assert.same(checker4.$valueOf, 1, 'checker4 valueOf calls');
  assert.same(checker4.$toString, 0, 'checker4 toString calls');
});
