var assert = require('assert')
var parse = require('../').parse

function addTest(arg, row, col, errRegExp) {
	var fn = function() {
		try {
			parse(arg)
		} catch(err) {
			if (row !== undefined) assert.equal(err.row, row, 'wrong row: ' + err.row)
			if (col !== undefined) assert.equal(err.column, col, 'wrong column: ' + err.column)
			if (errRegExp) assert(errRegExp.exec(err.message))
			return
		}
		throw new Error("no error")
	}

	if (typeof(describe) === 'function') {
		it('test_errors: ' + JSON.stringify(arg), fn)
	} else {
		fn()
	}
}

// semicolon will be unexpected, so it indicates an error position
addTest(';', 1, 1)
addTest('\n\n\n;', 4, 1)
addTest('\r\n;', 2, 1)
addTest('\n\r;', 3, 1)
addTest('\n\u2028;', 3, 1)
addTest('\n\u2029;', 3, 1)
addTest('[\n1\n,\n;', 4, 1)
addTest('{\n;', 2, 1)
addTest('{\n1\n:\n;', 4, 1)
addTest('.e3', 1, 3, /"\.e3"/)

// line continuations
addTest('["\\\n",\n;', 3, 1)
addTest('["\\\r\n",\n;', 3, 1)
addTest('["\\\u2028",\n;', 3, 1)
addTest('["\\\u2029",\n;', 3, 1)

// bareword rewind
addTest('nulz', 1, 1)

// no data
addTest('  ', 1, 3, /No data.*whitespace/)
addTest('blah', 1, 1, /Unexpected token 'b'/)
addTest('', 1, 1, /No data.*empty input/)

try {
	parse('{{{{{{{{{')
} catch(err) {
	var x = err.stack.match(/parseObject/g)
	assert(!x || x.length < 2, "shouldn't blow up the stack with internal calls")
}

