/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Compile a module for evaluating a rational function.
*
* @module @stdlib/math/base/tools/evalrational-compile
*
* @example
* var compile = require( '@stdlib/math/base/tools/evalrational-compile' );
*
* var P = [ -6.0, -5.0 ];
* var Q = [ 3.0, 0.5 ];
*
* var str = compile( P, Q ); // ( -6*6^0 - 5*6^1 ) / ( 3*6^0 + 0.5*6^1 )
* // returns <string>
*/

// MODULES //

var compile = require( './main.js' );


// EXPORTS //

module.exports = compile;
