# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

## [11.4.0](https://github.com/itgalaxy/webfont/compare/v11.2.37...v11.4.0) (2021-09-07)


### Features

* adding config option to prevent ligature unicode generation ([642deb9](https://github.com/itgalaxy/webfont/commit/642deb9235ca88c164e7faa9424aa8d895ecb862)), closes [#457](https://github.com/itgalaxy/webfont/issues/457)

## [11.3.0](https://github.com/itgalaxy/webfont/compare/v11.2.37...v11.3.0) (2021-09-07)


### Features

* adding config option to prevent ligature unicode generation ([642deb9](https://github.com/itgalaxy/webfont/commit/642deb9235ca88c164e7faa9424aa8d895ecb862)), closes [#457](https://github.com/itgalaxy/webfont/issues/457)

### [11.2.37](https://github.com/itgalaxy/webfont/compare/v11.2.36...v11.2.37) (2021-09-06)

### [11.2.36](https://github.com/itgalaxy/webfont/compare/v11.2.35...v11.2.36) (2021-09-04)

### [11.2.35](https://github.com/itgalaxy/webfont/compare/v11.2.34...v11.2.35) (2021-09-04)

### [11.2.34](https://github.com/itgalaxy/webfont/compare/v11.2.33...v11.2.34) (2021-09-04)

### [11.2.33](https://github.com/itgalaxy/webfont/compare/v11.2.32...v11.2.33) (2021-08-28)

### [11.2.32](https://github.com/itgalaxy/webfont/compare/v11.2.31...v11.2.32) (2021-08-27)

### [11.2.31](https://github.com/itgalaxy/webfont/compare/v11.2.30...v11.2.31) (2021-08-24)

### [11.2.30](https://github.com/itgalaxy/webfont/compare/v11.2.29...v11.2.30) (2021-08-24)

### [11.2.29](https://github.com/itgalaxy/webfont/compare/v11.2.28...v11.2.29) (2021-08-17)

### [11.2.28](https://github.com/itgalaxy/webfont/compare/v11.2.27...v11.2.28) (2021-08-17)

### [11.2.27](https://github.com/itgalaxy/webfont/compare/v11.2.26...v11.2.27) (2021-08-10)

### [11.2.26](https://github.com/itgalaxy/webfont/compare/v11.2.25...v11.2.26) (2021-08-07)

### [11.2.25](https://github.com/itgalaxy/webfont/compare/v11.2.24...v11.2.25) (2021-08-03)

### [11.2.24](https://github.com/itgalaxy/webfont/compare/v11.2.23...v11.2.24) (2021-08-01)

### [11.2.23](https://github.com/itgalaxy/webfont/compare/v11.2.22...v11.2.23) (2021-07-31)

### [11.2.21](https://github.com/itgalaxy/webfont/compare/v11.2.20...v11.2.21) (2021-07-31)

### 11.2.20 (2021-07-31)

### [11.2.22](https://github.com/itgalaxy/webfont/compare/v11.2.21...v11.2.22) (2021-07-31)

### 11.2.20 (2021-07-31)

### [11.2.21](https://github.com/itgalaxy/webfont/compare/v11.2.20...v11.2.21) (2021-07-31)

### [11.2.20](https://github.com/itgalaxy/webfont/compare/v11.2.19...v11.2.20) (2021-07-31)

### [11.2.19](https://github.com/itgalaxy/webfont/compare/v11.2.18...v11.2.19) (2021-07-27)

### [11.2.18](https://github.com/itgalaxy/webfont/compare/v11.2.17...v11.2.18) (2021-07-27)

### [11.2.17](https://github.com/itgalaxy/webfont/compare/v11.2.16...v11.2.17) (2021-07-27)


### Bug Fixes

* **deps:** switch out from latest versions in dependencies ([67efe05](https://github.com/itgalaxy/webfont/commit/67efe057f109b6f02efd62dd84f091e1ed138a9f)), closes [#464](https://github.com/itgalaxy/webfont/issues/464)

### [11.2.16](https://github.com/itgalaxy/webfont/compare/v11.2.15...v11.2.16) (2021-07-27)

### [11.2.15](https://github.com/itgalaxy/webfont/compare/v11.2.14...v11.2.15) (2021-07-26)

### [11.2.14](https://github.com/itgalaxy/webfont/compare/v11.2.13...v11.2.14) (2021-07-26)

### [11.2.13](https://github.com/itgalaxy/webfont/compare/v11.2.12...v11.2.13) (2021-07-24)

### [11.2.12](https://github.com/itgalaxy/webfont/compare/v11.2.11...v11.2.12) (2021-07-23)

### [11.2.11](https://github.com/itgalaxy/webfont/compare/v11.2.10...v11.2.11) (2021-07-23)

### [11.2.10](https://github.com/itgalaxy/webfont/compare/v11.2.8...v11.2.10) (2021-07-20)

### [11.2.8](https://github.com/itgalaxy/webfont/compare/v11.2.7...v11.2.8) (2021-07-06)

### [11.2.7](https://github.com/itgalaxy/webfont/compare/v11.2.6...v11.2.7) (2021-07-01)

### [11.2.6](https://github.com/itgalaxy/webfont/compare/v11.2.5...v11.2.6) (2021-06-29)

### [11.2.5](https://github.com/itgalaxy/webfont/compare/v11.2.4...v11.2.5) (2021-06-29)

### [11.2.4](https://github.com/itgalaxy/webfont/compare/v11.2.3...v11.2.4) (2021-06-23)

### [11.2.3](https://github.com/itgalaxy/webfont/compare/v11.2.2...v11.2.3) (2021-06-23)

### [11.2.2](https://github.com/itgalaxy/webfont/compare/v11.2.1...v11.2.2) (2021-06-22)

### [11.2.1](https://github.com/itgalaxy/webfont/compare/v11.2.0...v11.2.1) (2021-06-22)

## [11.2.0](https://github.com/itgalaxy/webfont/compare/v11.1.1...v11.2.0) (2021-06-22)


### Features

* add new transformation function ([6a0c60c](https://github.com/itgalaxy/webfont/commit/6a0c60c794616abd041aa7da6f9fdc4bd5a4ad6a)), closes [#183](https://github.com/itgalaxy/webfont/issues/183)
* add standalone glyphs data getter ([0cfe581](https://github.com/itgalaxy/webfont/commit/0cfe5819d5e3b8efdc7f35e4437d9bcb88c6e8ee))
* **types:** add `unicode` key to `GlyphMetadata` ([33fa7cb](https://github.com/itgalaxy/webfont/commit/33fa7cbf618463970f5c38ee23c4f3603678aff8))
* **types:** allow `unicode` key and Promise as `GlyphTransformFn` output ([a3bde0c](https://github.com/itgalaxy/webfont/commit/a3bde0ccc86e4ca25f5e76cbae9e8e5f202abb56))
* add standalone options getter ([13b8596](https://github.com/itgalaxy/webfont/commit/13b8596587279f57af2adff2428ca9ac05261714))


### Bug Fixes

* **deps:** fix security issue ([3abc00a](https://github.com/itgalaxy/webfont/commit/3abc00a50d6c1d107046301d77dcc9f92cc33e16))
* **deps:** fixed 1 package vulnerability ([feda633](https://github.com/itgalaxy/webfont/commit/feda633a7c20731ce5514891adb3c14c4d9a8323))
* **deps:** pin `svgicons2svgfont` to `10.0.1` ([87789d3](https://github.com/itgalaxy/webfont/commit/87789d35b02db36537d26cac3ab9e0e0924d7c81))

### [11.1.1](https://github.com/itgalaxy/webfont/compare/v11.1.0...v11.1.1) (2021-05-13)


### Bug Fixes

* **deps:** upgrade `wawoff2` dependency ([69a8dfb](https://github.com/itgalaxy/webfont/commit/69a8dfb3a70456aaa3777a8734ccccc41397a26c))

## [11.1.0](https://github.com/itgalaxy/webfont/compare/v11.0.0...v11.1.0) (2021-05-12)


### Features

* add support to base64 font strings on templates ([2a56338](https://github.com/itgalaxy/webfont/commit/2a56338c0eb74ec7c680ef80e99e5472d69919ab)), closes [#328](https://github.com/itgalaxy/webfont/issues/328) [#329](https://github.com/itgalaxy/webfont/issues/329)

## [11.0.0](https://github.com/itgalaxy/webfont/compare/v10.1.0...v11.0.0) (2021-05-12)


### ⚠ BREAKING CHANGES

* We removed support for Node.js 11 and Node.js 10 at this version. Please upgrade your environment to Node.js 12 or higher.

### ci

* remove Node.js 10 and 11 support ([0f0dbf6](https://github.com/itgalaxy/webfont/commit/0f0dbf64a2b7ce15519bb9ada86fdb2941251a08))

## [10.1.0](https://github.com/itgalaxy/webfont/compare/v10.0.1...v10.1.0) (2021-05-12)


### Features

* **cli:** create output folder if it's not present. ([#280](https://github.com/itgalaxy/webfont/issues/280)) ([d66a0d4](https://github.com/itgalaxy/webfont/commit/d66a0d457068b97a1bb747fb0f8ccc473721ff4a)), closes [#307](https://github.com/itgalaxy/webfont/issues/307)


### Bug Fixes

* **deps:** upgrade dependencies ([d623b06](https://github.com/itgalaxy/webfont/commit/d623b06dc8bd9afa5c83b27c5df57404c4b1a3f6))

### [10.0.1](https://github.com/itgalaxy/webfont/compare/v10.0.0...v10.0.1) (2021-05-12)

## [10.0.0](https://github.com/itgalaxy/webfont/compare/v10.0.0-alpha.3...v10.0.0) (2021-04-08)

### ⚠ BREAKING CHANGES

- starting from version 10 stable, you should use webfont via named import, like this: `import { webfont } from "webfont"`.

- adopt named import/export system ([31adbc7](https://github.com/itgalaxy/webfont/commit/31adbc7faa974c3d5a1ba9ffd4a5944bcab4fae8))

- drop support for Node.js 8;

### Features

- migrate all codebase to TypeScript ([0b71779](https://github.com/itgalaxy/webfont/commit/0b71779a2a3b97eb27af65f64e936d6730dc5eb9))
- add support to ligatures and JSON template ([f622c44](https://github.com/itgalaxy/webfont/commit/f622c44561534f1d997d2ebd82a08e00ca2af86c))
- **cli:** add support to `template-cache-string` argument ([ae8b050](https://github.com/itgalaxy/webfont/commit/ae8b0503506be2544cd5b5a5b0f2c420fec588b5))
- **demo:** add styl file example ([3aa5180](https://github.com/itgalaxy/webfont/commit/3aa5180a63fffc8d1067803e63ba9f35097009b9))
- **demo:** update fonts with ligatures support ([64b10d6](https://github.com/itgalaxy/webfont/commit/64b10d645f43c49f0ffe92ca2978739a3abb115c))
- **json template and template cache string:** add json built-in template, and templateCacheString which defaults to unix timestamp. ([1e43bba](https://github.com/itgalaxy/webfont/commit/1e43bba3e7aab537b2ff601c5205bd9b4b136734))
- **ligatures:** add ligature support ([9106a13](https://github.com/itgalaxy/webfont/commit/9106a139067141f9d57fe2726ff4f295af35e4b7))
- **standalone:** add support to JSON template and cacheString ([ad64421](https://github.com/itgalaxy/webfont/commit/ad64421a9da9cadbaba96e423cc00c1c6be76572))
- **templates:** add cacheString support ([f39d2c1](https://github.com/itgalaxy/webfont/commit/f39d2c1753f19474d1fc0defd7de37b5f9706ca5))
- **templates:** add template for JSON ([3b704b3](https://github.com/itgalaxy/webfont/commit/3b704b391682a99262c8ffd1a6c2c1bb22b5df58))
- add stylus template ([588a753](https://github.com/itgalaxy/webfont/commit/588a75320daead1e3340da18efd716d75db4d00d))
- allow adding a hash in generated font file name ([@brunoroux](https://github.com/brunoroux)) ([1913c9a](https://github.com/itgalaxy/webfont/commit/1913c9a87ea868810d7ceac9d6f203f13d90a6ea))
- allow to add a hash in generated font file name ([6ca0d9e](https://github.com/itgalaxy/webfont/commit/6ca0d9ea7cb190d677b03db8c591183cd93c9b19))
- respect `formats` option when using external config ([29769b0](https://github.com/itgalaxy/webfont/commit/29769b0b7f9b10a1ae77e49b813e3be494e9b699))

### Bug Fixes

- **cli:** use `fs` instead of `fs-extra` for writing files ([e7bf9f5](https://github.com/itgalaxy/webfont/commit/e7bf9f567be4aa370193d32f0a167841aa7b1567))
- **demo:** adopt `font-display: block` for a little better icon font loading ([0f9dbc0](https://github.com/itgalaxy/webfont/commit/0f9dbc012a65e0f05bec916986e27fa7322d6306))
- **deps:** [Snyk] Fix for 1 vulnerabilities ([6e08d33](https://github.com/itgalaxy/webfont/commit/6e08d332797128dbcfba70a2c11a2d1db6f72649)), closes [#197](https://github.com/itgalaxy/webfont/issues/197)
- **deps:** [Snyk] Fix for 1 vulnerable dependencies ([6e9e243](https://github.com/itgalaxy/webfont/commit/6e9e24369a7908c494c4fbf91eee5ccce212bd73)), closes [#188](https://github.com/itgalaxy/webfont/issues/188)
- **deps:** [Snyk] Security upgrade meow from 5.0.0 to 6.1.0 ([b5f9021](https://github.com/itgalaxy/webfont/commit/b5f9021d9327eaad8aeaf86ea95f80e70f47f9da)), closes [#195](https://github.com/itgalaxy/webfont/issues/195)
- **deps:** fix insecure dependency ([59a9604](https://github.com/itgalaxy/webfont/commit/59a96045b3ec2fd296ddc0c49d6ff856105617cb))
- **deps:** fix/sort deps and scripts after `npm audit fix` ([cf5cfc4](https://github.com/itgalaxy/webfont/commit/cf5cfc467ca4b4d62071b3bcc5b937878f655777)), closes [#209](https://github.com/itgalaxy/webfont/issues/209)
- **deps:** fix/sort deps and scripts after `npm audit fix` ([4118fcf](https://github.com/itgalaxy/webfont/commit/4118fcf5e816c2545bf149791c06457c5c27728f))
- **deps:** pin/upgrade eslint dependencies, fix some errors ([9206e72](https://github.com/itgalaxy/webfont/commit/9206e72ec9294373532968253fe4376a718986f6)), closes [#225](https://github.com/itgalaxy/webfont/issues/225)
- **deps:** sort/upgrade dependencies after npm audit fix ([0f976a9](https://github.com/itgalaxy/webfont/commit/0f976a930bb345af4401d4812bb37b7044c6a07d)), closes [#220](https://github.com/itgalaxy/webfont/issues/220)
- **deps:** sort/upgrade dependencies after npm audit fix ([a1ba509](https://github.com/itgalaxy/webfont/commit/a1ba50959b36763543787478b22e836852e8ab10))
- **deps:** upgrade `eslint` dependencies and plugins ([1e5a5ca](https://github.com/itgalaxy/webfont/commit/1e5a5cae0d4f488a45d076d9af6317135ab0ae7e))
- **templates:** adopt `font-display: block` for better icon font loading ([4669891](https://github.com/itgalaxy/webfont/commit/4669891dc9e10ce836c13c4e99f5c8357ab7ae51))
- .snyk, package.json & package-lock.json to reduce vulnerabilities ([2e387cc](https://github.com/itgalaxy/webfont/commit/2e387ccf780b79ae3efda07030f238e45eb43977))
- package.json & package-lock.json to reduce vulnerabilities ([b02f52f](https://github.com/itgalaxy/webfont/commit/b02f52fa77b495ef5e19f14e849d4f886a2f584b))
- package.json, package-lock.json & .snyk to reduce vulnerabilities ([c805812](https://github.com/itgalaxy/webfont/commit/c8058125bc1f7410c43c8d057f485c425aa739c9))
- package.json, package-lock.json & .snyk to reduce vulnerabilities ([791e5f4](https://github.com/itgalaxy/webfont/commit/791e5f4c56466853e97c5874d74ca52dfee1fd9a))
- package.json, package-lock.json & .snyk to reduce vulnerabilities ([8f037d5](https://github.com/itgalaxy/webfont/commit/8f037d50711d633d406a127ef76384662d40ff09))

## 9.0.0 - 2019-04-19

- Changed: drops support for Node.js 6.
- Feat: improve basic templates (see [templates](templates)).
- Feat: use wasm package for generate woff2

## 8.2.1 - 2018-12-28

- Chore: update dependencies.

## 8.2.0 - 2018-11-13

- Added: `sort` option (and `--no-sort` flag for CLI).
- Chore: update dependencies.

## 8.1.4 - 2018-06-05

- Chore: minimum require `svgicons2svgfont` version is now `^9.0.3` (this fix compatibility with `nodejs@10`).

## 8.1.3 - 2018-04-25

- Chore: minimum require `meow` version is now `^5.0.0`.
- Chore: minimum require `cosmiconfig` version is now `^5.0.3`.
- Chore: minimum require `fs-extra` version is now `^6.0.1`.
- Chore: drop `merge-deep` in favor `lodash.merge`.

## 8.1.2 - 2018-04-23

- Fixed: deterministic output (i.e. each glyph in font have same unicode in font).

## 8.1.1 - 2018-03-22

- Fixed: always configure `nunjucks` for template path.

## 8.1.0 - 2018-03-22

- Feat: export `config` path when he is using (in `result.config.filePath`).

## 8.0.0 - 2018-03-21

- Added: `demo` directory (thanks for [@shogo](https://github.com/ShogoFunaguchi)).
- Changed: export `glyphsData` instead `foundFiles` (`glyphsData` contain all information about any glyph).
- Changed: `result.styles` rename to `result.template` (for API).
- Changed: `dest` by default `process.cwd()`.
- Changed: rename `dest-styles` CLI option to `dest-template`.
- Changed: rename `cssTemplateClassName` to `templateClassName`.
- Changed: rename `cssTemplateFontPath` to `templateFontPath`.
- Changed: rename `cssTemplateFontName` to `templateFontName`.
- Changed: `glyphTransformFn` should always return glyph metadata.
- Changed: minimum required `nodejs` version is now `6.9.5` (see [svgicons2svgfont](https://github.com/nfroidure/svgicons2svgfont/blob/master/package.json#L41).
- Changed: use `globby@8` (based on `fast-glob`, it is better perf).
- Chore: minimum used `svgicons2svgfont` package is now `^9.0.2`
- Chore: minimum used `cosmiconfig` package is now `^4.0.0`
- Fixed: don't use `globby` for getting build-in tempalte (better perf).
- Fixed: always add trailing slash to `templateFontPath`.

## 7.1.4 - 2017-05-24

- Fixed: use `copyright`, `ts` and `version` with null value by default, it is avoid problems when your use long term caching.
- Fixed: options for `ttf` font generation now correctly handles.

## 7.1.3 - 2017-04-13

- Fixed: search config if not present in CLI arguments.

## 7.1.2 - 2017-04-12

- Fixed: `template` option now respected from config.

## 7.1.1 - 2017-03-29

- Fixed: potential crash with memory allocation when using `fs` for read files.

## 7.1.0 - 2017-01-24

- Added: `glyphTransformFn` option for transform glyph metadata before transferred in style template.

## 7.0.2 - 2016-12-22

- Fixed: exit code can be not number.

## 7.0.1 - 2016-12-20

- Fixed: arguments for svgicons2svgfont (missing font prefix).
- Chore: improved output of help in `CLI`.

## 7.0.0 - 2016-11-09

- Added: `template` option instead `css`, `cssFormat`, `srcCssTemplate`.
- Added: `destStyles` options instead `destCssTemplate`.
- Added: `styles` property to result.
- Fixed: throw error on empty `svg` files.
- Removed: `css` option.
- Removed: `cssFormat` option.
- Removed: `srcCssTemplate` option.
- Removed: `css` property from result.
- Removed: `destCssTemplate` argument from `cli`.
- Tests: improved tests (relative and absolute path to template).

## 6.0.4 - 2016-11-08

- Fixed: regression bug with passed arguments to template.

## 6.0.3 - 2016-11-08

- Fixed: validate `xml` of glyphs.
- Chore: minimum required `eslint-plugin-ava` version is now `^2.2.0`.
- Chore: minimum required `eslint-plugin-itgalaxy` version is now `^26.0.0`.
- Chore: minimum required `eslint-plugin-jsx-a11y` version is now `^3.0.0`.
- Chore: minimum required `eslint-plugin-react` version is now `^6.6.0`.
- Chore: refactoring code.

## 6.0.2 - 2016-11-07

- Fixed: use `reject` instead `Promise.reject` in glyphs `error` callback.
- Fixed: use callback `finish` instead `end` for `svgicons2svgfont` stream.
- Tests: improve tests on bad examples.

## 6.0.1 - 2016-11-07

- Fixed: add `error` event to `glyph` stream.
- Fixed: don't create `new Error` where this is not necessary.
- Chore: minimum required `nunjucks` version is now `^3.0.0`.
- Chore: minimum required `eslint` version is now `^3.9.1`.
- Chore: minimum required `eslint-plugin-ava` version is now `^4.0.0`.
- Chore: minimum required `eslint-plugin-itgalaxy` version is now `^25.0.0`.
- Chore: minimum required `eslint-plugin-node` version is now `^3.0.0`.
- Chore: minimum required `eslint-plugin-promise` version is now `^3.3.0`.
- Chore: minimum required `eslint-plugin-react` version is now `^6.5.0`.
- Tests: improve tests on bad examples.

## 6.0.0 - 2016-10-26

- Added: support `nodejs` `7`.
- Added: `verbose` argument for verbose output.
- Remove: `quite` argument.
- Chore: improve `README.md`.
- Chore: improve `description` in `package.json`.

## 5.0.0 - 2016-10-24

- Fixed: wrong `CSS` syntax when not all format are selected.
- Chore(SEMVER-MAJOR): rename extension for all templates from `nunjucks` to `njk`.

## 4.0.1 - 2016-10-19

- Fixed: CLI `fontName` and `formats` arguments bug.
- Chore: minimum required `ajv-cli` version is now `^1.1.0`.
- Chore: minimum required `remark-preset-lint-itgalaxy` version is now `^2.0.0`.
- Chore: minimum required `nunjucks` from `2.0.0` to `2.5.0`.
- Chore: minimum required `eslint-plugin-import` version is now `^2.0.0`.
- Chore: minimum required `eslint-plugin-promise` version is now `^3.0.0`.
- Chore: minimum required `eslint-plugin-lodash` version is now `^2.1.0`.
- Chore: rename `eslint-plugin-xo` to `eslint-plugin-unicorn`.
- Chore: minimum required `eslint-plugin-unicorn` version is now `^1.0.0`.
- Chore: minimum required `eslint-plugin-itgalaxy` version is now `^23.0.0`.
- Chore: minimum required `cosmiconfig` version is now `^2.0.0`.

## 4.0.0

- Changed: all style templates for font now have `nunjucks` extension.
- Chore(package): remove extra `files` from `package.json`.
- Chore(package): install all `peerDependencies` for `eslint-plugin-itgalaxy`.
- Chore(package): update a minimal version `ava` from `0.15.0` to `0.16.0`.
- Chore(package): update a minimal version `eslint-plugin-ava` from `2.5.0` to `3.0.0`.
- Chore(package): update a minimal version `npm-run-all` from `2.3.0` to `3.0.0`.
- Chore(package): update a minimal version `eslint-plugin-itgalaxy` from `8.0.0` to `11.0.0`.
- Chore(package): update a minimal version `nyc` from `7.0.0` to `8.0.0`.
- Chore(package): remove `nyc` settings, now fine works without their.
- Chore(package): use `^` instead `~` from `babel-preset-stage-0`.
- Chore(package): use `remark-preset-lint-itgalaxy` instead `remark-lint-config-itgalaxy`.
- Chore(package): use right version for `eslint-plugin-*` and `eslint`.
- Chore: improved `README.md`.
- Chore: fix glob pattern for `lint:remark` script command.

## 3.0.1

- Fixed: `--css-template-font-path` now get also from `cosmiconfig`.

## 3.0.0

- Added: support `cosmiconfig`.
- Changed: change function arguments in `standalone`.
- Chore: refactoring.
- Chore: sorting alphabetically `dependencies` and `devDependencies`.
- Chore: remove unused `eslint-*` plugins from `devDependencies`.
- Chore: update minimal version `eslint-plugin-itgalaxy` to `8.0.0`.
- Chore: check is valid fonts in tests.
- Chore: add more tests.
- Chore: sharable config for `remark-lint`.
- Chore: add `nodejs` v5 to `.travis.yml`.

## 2.0.3

- Chore: improved `description` and `keywords` in `package.json`.

## 2.0.2

- Fixed: `svg2ttf` now correctly generates `ttf` font.
- Fixed: `ttf2eot` now correctly generates `eot` font.
- Fixed: `ttf2woff` now correctly generates `woff` font.
- Fixed: `svg2ttf` now correctly accepts option.
- Chore: more readable name tests.
- Chore: rename extension `templates`.

## 2.0.1

- Chore: update `globby` to `6.0.0`.
- Chore: update minimal version `babel-cli` to `6.11.0`.
- Chore: update minimal version `babel-core` to `6.11.0`.
- Chore: update `eslint-plugin-itgalaxy` to `6.0.0`.

## 2.0.0

- Added: `--src-css-template` agument.
- Added: `--css-template-class-name` argument.
- Added: `--css-template-font-path` argument.
- Added: `--css-template-font-name` argument.
- Changed: remove `--css-template-format` argument, now format is taken from `--dest-css-template`.
- Changed: remove `--css` argument, css now generated if you use `--dest-css-template` argument.
- Changed: rename `--css-template-dest` argument to `--dest-css-template`.
- Remove: `--css-template` argument.

## 1.0.1

- Fixed: get `fontId` from `fontName`, if `fontId` is `null` or `undefined`.

## 1.0.0

- Initial release.
