# -*- python -*-
#                           Package   : omniidl
# template.py               Created on: 2000/01/20
#			    Author1   : David Scott (djs)
#                           Author2   : Duncan Grisby (dgrisby)
#
#  Copyright (C) 2004-2011 Apasphere Ltd.
#  Copyright (C) 1999 AT&T Laboratories Cambridge
#
#  This file is part of omniidl.
#
#  omniidl is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see http://www.gnu.org/licenses/

"""C++ templates for the DynSK.cc file"""

header_comment = """\
// This file is generated by @program@ - @library@. Do not edit.
"""

header = """\
#include "@basename@@hh@"

OMNI_USING_NAMESPACE(omni)

static const char* @prefix@_dyn_library_version = @library@_dyn;

static ::CORBA::TypeCode::_Tracker @prefix@_tcTrack(__FILE__);
"""

fragment_header = """\
static ::CORBA::TypeCode::_Tracker @prefix@_tcTrack(__FILE__);
"""


interface = """\
static void @private_prefix@_@guard_name@_marshal_fn(cdrStream& _s, void* _v)
{
  omniObjRef* _o = (omniObjRef*)_v;
  omniObjRef::_marshal(_o, _s);
}
static void @private_prefix@_@guard_name@_unmarshal_fn(cdrStream& _s, void*& _v)
{
  omniObjRef* _o = omniObjRef::_unMarshal(@fqname@::_PD_repoId, _s);
  _v = _o;
}
static void @private_prefix@_@guard_name@_destructor_fn(void* _v)
{
  omniObjRef* _o = (omniObjRef*)_v;
  if (_o)
    omni::releaseObjRef(_o);
}

void operator<<=(::CORBA::Any& _a, @fqname@_ptr _o)
{
  @fqname@_ptr _no = @fqname@::_duplicate(_o);
  _a.PR_insert(@tc_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               _no->_PR_getobj());
}
void operator<<=(::CORBA::Any& _a, @fqname@_ptr* _op)
{
  _a.PR_insert(@tc_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               (*_op)->_PR_getobj());
  *_op = @fqname@::_nil();
}

::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, @fqname@_ptr& _o)
{
  void* _v;
  if (_a.PR_extract(@tc_name@,
                    @private_prefix@_@guard_name@_unmarshal_fn,
                    @private_prefix@_@guard_name@_marshal_fn,
                    @private_prefix@_@guard_name@_destructor_fn,
                    _v)) {
    omniObjRef* _r = (omniObjRef*)_v;
    if (_r)
      _o = (@fqname@_ptr)_r->_ptrToObjRef(@fqname@::_PD_repoId);
    else
      _o = @fqname@::_nil();
    return 1;
  }
  return 0;
}
"""

abstract_interface = """\
static void @private_prefix@_@guard_name@_marshal_fn(cdrStream& _s, void* _v)
{
  ::CORBA::AbstractBase* _a = (::CORBA::AbstractBase*)_v;
  if (_v) {
    ::CORBA::ValueBase* _b = _a->_NP_to_value();
    if (_b) {
      _s.marshalBoolean(0);
      ::CORBA::ValueBase::_NP_marshal(_b,_s);
      return;
    }
    ::CORBA::Object_ptr _o = _a->_NP_to_object();
    if (_o) {
      _s.marshalBoolean(1);
      omniObjRef::_marshal(_o->_PR_getobj(),_s);
      return;
    }
  }
  _s.marshalBoolean(0);
  ::CORBA::ValueBase::_NP_marshal(0,_s);
}
static void @private_prefix@_@guard_name@_unmarshal_fn(cdrStream& _s, void*& _v)
{
  ::CORBA::AbstractBase* _a;
  ::CORBA::Boolean _c = _s.unmarshalBoolean();
  if (_c) {
    omniObjRef* _o = omniObjRef::_unMarshal(@fqname@::_PD_repoId,_s);
    if (_o)
      _a = (@fqname@_ptr)_o->_ptrToObjRef(@fqname@::_PD_repoId);
    else
      _a = @fqname@::_nil();
  }
  else {
    ::CORBA::ValueBase* _b = ::CORBA::ValueBase::_NP_unmarshal(_s);
    if (_b)
      _a = (@fqname@_ptr)_b->_ptrToValue(@fqname@::_PD_repoId);
    else
      _a = 0;
  }
  _v = _a;
}
static void @private_prefix@_@guard_name@_destructor_fn(void* _v)
{
  ::CORBA::AbstractBase* _a = (::CORBA::AbstractBase*)_v;
  ::CORBA::release(_a);
}

void operator<<=(::CORBA::Any& _a, @fqname@_ptr _o)
{
  @fqname@_ptr _no = @fqname@::_duplicate(_o);
  _a.PR_insert(@tc_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               (::CORBA::AbstractBase*)_no);
}
void operator<<=(::CORBA::Any& _a, @fqname@_ptr* _op)
{
  _a.PR_insert(@tc_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               (::CORBA::AbstractBase*)*_op);
  *_op = @fqname@::_nil();
}

::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, @fqname@_ptr& _o)
{
  void* _v;
  if (_a.PR_extract(@tc_name@,
                    @private_prefix@_@guard_name@_unmarshal_fn,
                    @private_prefix@_@guard_name@_marshal_fn,
                    @private_prefix@_@guard_name@_destructor_fn,
                    _v)) {
    ::CORBA::AbstractBase* _a = (::CORBA::AbstractBase*)_v;
    if (_a) {
      ::CORBA::ValueBase* _b = _a->_NP_to_value();
      if (_b) {
        _o = (@fqname@_ptr)_b->_ptrToValue(@fqname@::_PD_repoId);
        return 1;
      }
      ::CORBA::Object_ptr _p = _a->_NP_to_object();
      if (_p) {
        _o = (@fqname@_ptr)_p->_ptrToObjRef(@fqname@::_PD_repoId);
        return 1;
      }
    }
    _o = 0;
    return 1;
  }
  return 0;
}
"""


enum = """\
static void @private_prefix@_@guard_name@_marshal_fn(cdrStream& _s, void* _v)
{
  @fqname@* _p = (@fqname@*)_v;
  *_p >>= _s;
}
static void @private_prefix@_@guard_name@_unmarshal_fn(cdrStream& _s, void*& _v)
{
  @fqname@* _p = (@fqname@*)_v;
  *_p <<= _s;
}

void operator<<=(::CORBA::Any& _a, @fqname@ _s)
{
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               &_s);
}

::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, @fqname@& _s)
{
  return _a.PR_extract(@private_prefix@_tc_@guard_name@,
                       @private_prefix@_@guard_name@_unmarshal_fn,
                       &_s);
}
"""

struct = """\
static void @private_prefix@_@guard_name@_marshal_fn(cdrStream& _s, void* _v)
{
  @fqname@* _p = (@fqname@*)_v;
  *_p >>= _s;
}
static void @private_prefix@_@guard_name@_unmarshal_fn(cdrStream& _s, void*& _v)
{
  @fqname@* _p = new @fqname@;
  *_p <<= _s;
  _v = _p;
}
static void @private_prefix@_@guard_name@_destructor_fn(void* _v)
{
  @fqname@* _p = (@fqname@*)_v;
  delete _p;
}

void operator<<=(::CORBA::Any& _a, const @fqname@& _s)
{
  @fqname@* _p = new @fqname@(_s);
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               _p);
}
void operator<<=(::CORBA::Any& _a, @fqname@* _sp)
{
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               _sp);
}

::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, @fqname@*& _sp)
{
  return _a >>= (const @fqname@*&) _sp;
}
::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, const @fqname@*& _sp)
{
  void* _v;
  if (_a.PR_extract(@private_prefix@_tc_@guard_name@,
                    @private_prefix@_@guard_name@_unmarshal_fn,
                    @private_prefix@_@guard_name@_marshal_fn,
                    @private_prefix@_@guard_name@_destructor_fn,
                    _v)) {
    _sp = (const @fqname@*)_v;
    return 1;
  }
  return 0;
}
"""

union = struct

exception = """
static void @private_prefix@_@guard_name@_marshal_fn(cdrStream& _s, void* _v)
{
  const @fqname@* _p = (const @fqname@*)_v;
  ::CORBA::Any::PR_marshalExceptionRepoId(_s, _p->_rep_id());
  *_p >>= _s;
}
static void @private_prefix@_@guard_name@_unmarshal_fn(cdrStream& _s, void*& _v)
{
  ::CORBA::Any::PR_unmarshalExceptionRepoId(_s);
  @fqname@* _p = new @fqname@;
  *_p <<= _s;
  _v = _p;
}
static void @private_prefix@_@guard_name@_destructor_fn(void* _v)
{
  @fqname@* _p = (@fqname@*)_v;
  delete _p;
}

void operator<<=(::CORBA::Any& _a, const @fqname@& _s)
{
  @fqname@* _p = new @fqname@(_s);
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               _p);
}
void operator<<=(::CORBA::Any& _a, const @fqname@* _sp)
{
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               (@fqname@*)_sp);
}

::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, const @fqname@*& _sp)
{
  void* _v;
  if (_a.PR_extract(@private_prefix@_tc_@guard_name@,
                    @private_prefix@_@guard_name@_unmarshal_fn,
                    @private_prefix@_@guard_name@_marshal_fn,
                    @private_prefix@_@guard_name@_destructor_fn,
                    _v)) {
    _sp = (const @fqname@*)_v;
    return 1;
  }
  return 0;
}

static void @private_prefix@_insertToAny__c@guard_name@(::CORBA::Any& _a, const ::CORBA::Exception& _e) {
  const @fqname@ & _ex = (const @fqname@ &) _e;
  operator<<=(_a,_ex);
}

static void @private_prefix@_insertToAnyNCP__c@guard_name@ (::CORBA::Any& _a, const ::CORBA::Exception* _e) {
  const @fqname@* _ex = (const @fqname@*) _e;
  operator<<=(_a,_ex);
}

class @private_prefix@_insertToAny_Singleton__c@guard_name@ {
public:
  @private_prefix@_insertToAny_Singleton__c@guard_name@() {
    @fqname@::insertToAnyFn = @private_prefix@_insertToAny__c@guard_name@;
    @fqname@::insertToAnyFnNCP = @private_prefix@_insertToAnyNCP__c@guard_name@;
  }
};
static @private_prefix@_insertToAny_Singleton__c@guard_name@ @private_prefix@_insertToAny_Singleton__c@guard_name@_;
"""


value = """\
static void @private_prefix@_@guard_name@_marshal_fn(cdrStream& _s, void* _v)
{
  @fqname@* _p = (@fqname@*)_v;
  @fqname@::_NP_marshal(_p, _s);
}
static void @private_prefix@_@guard_name@_unmarshal_fn(cdrStream& _s, void*& _v)
{
  @fqname@* _p = @fqname@::_NP_unmarshal(_s);
  _v = _p;
}
static void @private_prefix@_@guard_name@_destructor_fn(void* _v)
{
  @fqname@* _p = (@fqname@*)_v;
  ::CORBA::remove_ref(_p);
}

void operator<<=(::CORBA::Any& _a, @fqname@* _v)
{
  ::CORBA::add_ref(_v);
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               _v);
}
void operator<<=(::CORBA::Any& _a, @fqname@** _vp)
{
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               *_vp);
  *_vp = 0;
}

::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, @fqname@*& _sp)
{
  void* _v;
  if (_a.PR_extract(@private_prefix@_tc_@guard_name@,
                    @private_prefix@_@guard_name@_unmarshal_fn,
                    @private_prefix@_@guard_name@_marshal_fn,
                    @private_prefix@_@guard_name@_destructor_fn,
                    _v)) {
    _sp = (@fqname@*)_v;
    return 1;
  }
  return 0;
}
"""

valuebox = value



array = """\
static void @private_prefix@_@guard_name@_marshal_fn(cdrStream& _s, void* _v)
{
  @fqname@_slice* _a = (@fqname@_slice*)_v;
  @marshal@
}
static void @private_prefix@_@guard_name@_unmarshal_fn(cdrStream& _s, void*& _v)
{
  @fqname@_slice* _a = @fqname@_alloc();
  @unmarshal@
  _v = _a;
}
static void @private_prefix@_@guard_name@_destructor_fn(void* _v)
{
  @fqname@_slice* _a = (@fqname@_slice*)_v;
  @fqname@_free(_a);
}

void operator<<=(::CORBA::Any& _a, const @fqname@_forany& _s)
{
  @fqname@_slice* _v;
  if (!_s.NP_nocopy())
    _v = @fqname@_dup(_s);
  else
    _v = _s.NP_getSlice();

  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               _v);
}
::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, @fqname@_forany& _s)
{
  void* _v;
  if (_a.PR_extract(@private_prefix@_tc_@guard_name@,
                    @private_prefix@_@guard_name@_unmarshal_fn,
                    @private_prefix@_@guard_name@_marshal_fn,
                    @private_prefix@_@guard_name@_destructor_fn,
                    _v)) {
    _s = (@fqname@_slice*)_v;
    return 1;
  }
  return 0;
}
"""

sequence = """\
static void @private_prefix@_@guard_name@_marshal_fn(cdrStream& _s, void* _v)
{
  @fqname@* _p = (@fqname@*)_v;
  *_p >>= _s;
}
static void @private_prefix@_@guard_name@_unmarshal_fn(cdrStream& _s, void*& _v)
{
  @fqname@* _p = new @fqname@;
  *_p <<= _s;
  _v = _p;
}
static void @private_prefix@_@guard_name@_destructor_fn(void* _v)
{
  @fqname@* _p = (@fqname@*)_v;
  delete _p;
}

void operator<<=(::CORBA::Any& _a, const @fqname@& _s)
{
  @fqname@* _p = new @fqname@(_s);
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               _p);
}
void operator<<=(::CORBA::Any& _a, @fqname@* _sp)
{
  _a.PR_insert(@private_prefix@_tc_@guard_name@,
               @private_prefix@_@guard_name@_marshal_fn,
               @private_prefix@_@guard_name@_destructor_fn,
               _sp);
}

::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, @fqname@*& _sp)
{
  return _a >>= (const @fqname@*&) _sp;
}
::CORBA::Boolean operator>>=(const ::CORBA::Any& _a, const @fqname@*& _sp)
{
  void* _v;
  if (_a.PR_extract(@private_prefix@_tc_@guard_name@,
                    @private_prefix@_@guard_name@_unmarshal_fn,
                    @private_prefix@_@guard_name@_marshal_fn,
                    @private_prefix@_@guard_name@_destructor_fn,
                    _v)) {
    _sp = (const @fqname@*)_v;
    return 1;
  }
  return 0;
}
"""


external_linkage = """\
#if defined(OMNI_HAS_Cplusplus_Namespace) && defined(_MSC_VER)
// MSVC++ does not give the constant external linkage otherwise.
@open_namespace@
  const ::CORBA::TypeCode_ptr @tc_unscoped_name@ = @mangled_name@;
@close_namespace@
#else
const ::CORBA::TypeCode_ptr @tc_name@ = @mangled_name@;
#endif
"""
