<?php
/**
 * See horde/config/prefs.php for documentation on the structure of this file.
 *
 * IMPORTANT: DO NOT EDIT THIS FILE! DO NOT COPY prefs.php TO prefs.local.php!
 * Local overrides ONLY MUST be placed in prefs.local.php or prefs.d/.
 * If the 'vhosts' setting has been enabled in Horde's configuration, you can
 * use prefs-servername.php.
 */
$prefGroups['display'] = array(
    'column' => _("General Preferences"),
    'label' => _("Display Preferences"),
    'desc' => _("Change display preferences such as which view to display by default, how many photos to display on a page, and the default gallery style to use."),
    'members' => array(
        'grouptitle', 'defaultview', 'tilesperrow', 'tilesperpage',
        'facesperpage', 'groupby', 'groupsperpage',
        'default_gallerystyle_select',
        'force_old_uploader'
    )
);

$prefGroups['metadata'] = array(
    'column' => _("General Preferences"),
    'label' => _("Tags and Metadata Preferences"),
    'desc' => _("Change preferences dealing with tags and image metadata."),
    'members' => array('showexif', 'exif_tags', 'exif_title')
);

$prefGroups['perms'] = array(
    'column' => _("General Preferences"),
    'label' => _("Permission Preferences"),
    'desc' => _("Change your user permission preferences such as who can download original photos, and what permissions newly created galleries should have by default."),
    'members' => array(
        'default_download', 'default_permissions', 'group_permissions',
        'guest_permissions'
    )
);

$prefGroups['watermark'] = array(
    'column' => _("General Preferences"),
    'label' => _("Watermark Preferences"),
    'desc' => _("Change your watermark preferences."),
    'members' => array(
        'watermark_text', 'watermark_vertical', 'watermark_horizontal',
        'watermark_font', 'watermark_auto'
    )
);

/* Note that for the following to work, your pref backend must support
   retrieving prefs for other users (such as the SQL backend) */
$_prefs['grouptitle'] = array(
    'value' => '',
    'type' => 'text',
    'desc' => _("Custom text to display describing your galleries. This will be displayed in place of your username when grouping galleries by username.")
);

$_prefs['defaultview'] = array(
    'value' => 'galleries',
    'type' => 'enum',
    'enum' => array(
        'browse' => _("Browse"),
        'galleries' => _("Galleries"),
        'mygalleries' => _("My Galleries")
    ),
    'desc' => _("View to display by default")
);

$_prefs['groupby'] = array(
    'value' => 'none',
    'type' => 'enum',
    'enum' => array(
        'owner' => _("Owner"),
        'none' => _("None")
    ),
    'desc' => _("Group galleries by")
);

// number of photos on each row in the gallery view
$_prefs['tilesperrow'] = array(
    'value' => 3,
    'type' => 'number',
    'desc' => _("Number of tiles per row")
);

$_prefs['tilesperpage'] = array(
    'value' => 9,
    'type' => 'number',
    'desc' => _("Number of tiles per page")
);

$_prefs['facesperpage'] = array(
    'value' => '20',
    'locked' => empty($GLOBALS['conf']['faces']['driver']),
    'type' => 'number',
    'desc' => _("Number of faces per page")
);

$_prefs['groupsperpage'] = array(
    'value' => 9,
    'type' => 'number',
    'desc' => _("Number of groups per page")
);

$_prefs['showexif'] = array(
    'value' => false,
    'type' => 'checkbox',
    'desc' => _("Show EXIF data")
);

$_prefs['myansel_layout'] = array(
 'value' => 'a:1:{i:0;a:3:{i:0;a:4:{s:3:"app";s:5:"ansel";s:6:"height";i:1;s:5:"width";i:1;s:6:"params";a:2:{s:5:"type2";s:17:"ansel_Block_Cloud";s:6:"params";a:1:{s:5:"count";s:2:"20";}}}i:1;a:4:{s:3:"app";s:5:"ansel";s:6:"height";i:1;s:5:"width";i:1;s:6:"params";a:2:{s:5:"type2";s:23:"ansel_Block_MyGalleries";s:6:"params";a:1:{s:5:"limit";s:1:"0";}}}i:2;a:4:{s:3:"app";s:5:"ansel";s:6:"height";i:1;s:5:"width";i:1;s:6:"params";a:2:{s:5:"type2";s:25:"ansel_Block_RecentlyAdded";s:6:"params";a:2:{s:7:"gallery";s:3:"all";s:5:"limit";s:2:"10";}}}}}'
);

$_prefs['default_gallerystyle'] = array(
    'value' => 'ansel_default'
);
$_prefs['default_gallerystyle_select'] = array(
    'type' => 'special',
    'handler' => 'Ansel_Prefs_Special_GalleryStyle'
);

$_prefs['show_actions'] = array(
    'value' => 0
);

$_prefs['show_othergalleries'] = array(
    'value' => 0
);
$_prefs['current_maplayer'] = array(
    'value' => ''
);
$_prefs['watermark_text'] = array(
    'value' => '',
    'type' => 'text',
    'desc' => _("Custom watermark to use for photos")
);

$_prefs['watermark_horizontal'] = array(
    'value' => 'left',
    'type' => 'enum',
    'enum' => array(
        'left' => _("Left"),
        'center' => _("Center"),
        'right' => _("Right")
    ),
    'desc' => _("Horizontal Alignment")
);

$_prefs['watermark_vertical'] = array(
    'value' => 'bottom',
    'type' => 'enum',
    'enum' => array(
        'top' => _("Top"),
        'center' => _("Center"),
        'bottom' => _("Bottom")
    ),
    'desc' => _("Vertical Alignment")
);

$_prefs['watermark_font'] = array(
    'value' => 'medium',
    'type' => 'enum',
    'enum' => array(
        'tiny' => _("Tiny"),
        'small' => _("Small"),
        'medium' => _("Medium"),
        'large' => _("Large"),
        'giant' => _("Giant")
    ),
    'desc' => _("Font Size")
);

$_prefs['watermark_auto'] = array(
    'value' => 0,
    'type' => 'checkbox',
    'desc' => _("Automatically watermark photos?")
);

$_prefs['default_download'] = array(
    'value' => 'edit',
    'type' => 'enum',
    'enum' => array(
        'all' => _("Anyone"),
        'edit' => _("Users with edit permissions"),
        'authenticated' =>  _("Authenticated users")
    ),
    'desc' => _("Who should be allowed to download original photos")
);

$_prefs['default_permissions'] = array(
    'value' => 'read',
    'type' => 'enum',
    'enum' => array(
        'none' => _("None"),
        'read' => _("Read-only"),
        'edit' => _("Read and write")
    ),
    'desc' => _("When a new gallery is created, what permissions should be given to authenticated users by default?")
);

$_prefs['guest_permissions'] = array(
    'value' => 'read',
    'type' => 'enum',
    'enum' => array(
        'none' => _("None (Owner only)"),
        'read' => _("Read-only")
    ),
    'desc' => _("When a new gallery is created, what permissions should be given to guests by default?")
);

$_prefs['group_permissions'] = array(
    'value' => 'none',
    'type' => 'enum',
    'enum' => array(
        'none' => _("None"),
        'read' => _("Read-only"),
        'edit' => _("Read and write"),
        'delete' => _("Read, write, and delete")
    ),
    'desc' => _("When a new gallery is created, what default permissions should be given to groups that the user is a member of?")
);

$_prefs['exif_tags'] = array(
    'value' => 'a:0:{}',
    'type' => 'multienum',
    'enum' => Horde_Image_Exif::getFields(array($GLOBALS['conf']['exif']['driver'], !empty($GLOBALS['conf']['exif']['params']) ? $GLOBALS['conf']['exif']['params'] : array()), true),
    'desc' => _("Which metadata fields should we automatically add as image tags during upload?"),
);

$_prefs['exif_title'] = array(
    'value' => '',
    'type' => 'enum',
    'enum' => array_merge(array(
        'none' => _("None"),
    ), Horde_Image_Exif::getFields(array($GLOBALS['conf']['exif']['driver'], !empty($GLOBALS['conf']['exif']['params']) ? $GLOBALS['conf']['exif']['params'] : array()), true)),
    'desc' => _("Should we automatically set the image title on upload if able? If so, choose the field to obtain the title from.")
);

$_prefs['force_old_uploader'] = array(
    'value' => false,
    'type' => 'checkbox',
    'desc' => _("Do not use the ajax-enabled uploader? Select this if your browser is having trouble uploading images with the ajax uploader.")
);
