/*
 * Decompiled with CFR 0.152.
 */
package com.megginson.sax;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl {
    private final Attributes EMPTY_ATTS = new AttributesImpl();
    private Hashtable prefixTable;
    private Hashtable forcedDeclTable;
    private Hashtable doneDeclTable;
    private int elementLevel = 0;
    private Writer output;
    private NamespaceSupport nsSupport;
    private int prefixCounter = 0;

    public XMLWriter() {
        this.init(null);
    }

    public XMLWriter(Writer writer) {
        this.init(writer);
    }

    public XMLWriter(XMLReader xMLReader) {
        super(xMLReader);
        this.init(null);
    }

    public XMLWriter(XMLReader xMLReader, Writer writer) {
        super(xMLReader);
        this.init(writer);
    }

    private void init(Writer writer) {
        this.setOutput(writer);
        this.nsSupport = new NamespaceSupport();
        this.prefixTable = new Hashtable();
        this.forcedDeclTable = new Hashtable();
        this.doneDeclTable = new Hashtable();
    }

    public void reset() {
        this.elementLevel = 0;
        this.prefixCounter = 0;
        this.nsSupport.reset();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void setOutput(Writer writer) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public void setPrefix(String string, String string2) {
        this.prefixTable.put(string, string2);
    }

    public String getPrefix(String string) {
        return (String)this.prefixTable.get(string);
    }

    public void forceNSDecl(String string) {
        this.forcedDeclTable.put(string, Boolean.TRUE);
    }

    public void forceNSDecl(String string, String string2) {
        this.setPrefix(string, string2);
        this.forceNSDecl(string);
    }

    public void startDocument() throws SAXException {
        this.reset();
        this.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n\n");
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.write('\n');
        super.endDocument();
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.elementLevel;
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        super.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.write("</");
        this.writeName(string, string2, string3, true);
        this.write('>');
        if (this.elementLevel == 1) {
            this.write('\n');
        }
        super.endElement(string, string2, string3);
        this.nsSupport.popContext();
        --this.elementLevel;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.writeEsc(cArray, n, n2, false);
        super.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.writeEsc(cArray, n, n2, false);
        super.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.write("<?");
        this.write(string);
        this.write(' ');
        this.write(string2);
        this.write("?>");
        if (this.elementLevel < 1) {
            this.write('\n');
        }
        super.processingInstruction(string, string2);
    }

    public void emptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write("/>");
        super.startElement(string, string2, string3, attributes);
        super.endElement(string, string2, string3);
    }

    public void startElement(String string, String string2) throws SAXException {
        this.startElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void startElement(String string) throws SAXException {
        this.startElement("", string, "", this.EMPTY_ATTS);
    }

    public void endElement(String string, String string2) throws SAXException {
        this.endElement(string, string2, "");
    }

    public void endElement(String string) throws SAXException {
        this.endElement("", string, "");
    }

    public void emptyElement(String string, String string2) throws SAXException {
        this.emptyElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void emptyElement(String string) throws SAXException {
        this.emptyElement("", string, "", this.EMPTY_ATTS);
    }

    public void dataElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.startElement(string, string2, string3, attributes);
        this.characters(string4);
        this.endElement(string, string2, string3);
    }

    public void dataElement(String string, String string2, String string3) throws SAXException {
        this.dataElement(string, string2, "", this.EMPTY_ATTS, string3);
    }

    public void dataElement(String string, String string2) throws SAXException {
        this.dataElement("", string, "", this.EMPTY_ATTS, string2);
    }

    public void characters(String string) throws SAXException {
        char[] cArray = string.toCharArray();
        this.characters(cArray, 0, cArray.length);
    }

    private void forceNSDecls() {
        Enumeration enumeration = this.forcedDeclTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.doPrefix(string, null, true);
        }
    }

    private String doPrefix(String string, String string2, boolean bl) {
        String string3 = this.nsSupport.getURI("");
        if ("".equals(string)) {
            if (bl && string3 != null) {
                this.nsSupport.declarePrefix("", "");
            }
            return null;
        }
        String string4 = bl && string3 != null && string.equals(string3) ? "" : this.nsSupport.getPrefix(string);
        if (string4 != null) {
            return string4;
        }
        string4 = (String)this.doneDeclTable.get(string);
        if (string4 != null && ((!bl || string3 != null) && "".equals(string4) || this.nsSupport.getURI(string4) != null)) {
            string4 = null;
        }
        if (string4 == null && (string4 = (String)this.prefixTable.get(string)) != null && ((!bl || string3 != null) && "".equals(string4) || this.nsSupport.getURI(string4) != null)) {
            string4 = null;
        }
        if (string4 == null && string2 != null && !"".equals(string2)) {
            int n = string2.indexOf(58);
            if (n == -1) {
                if (bl && string3 == null) {
                    string4 = "";
                }
            } else {
                string4 = string2.substring(0, n);
            }
        }
        while (string4 == null || this.nsSupport.getURI(string4) != null) {
            string4 = "__NS" + ++this.prefixCounter;
        }
        this.nsSupport.declarePrefix(string4, string);
        this.doneDeclTable.put(string, string4);
        return string4;
    }

    private void write(char c) throws SAXException {
        try {
            this.output.write(c);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void write(String string) throws SAXException {
        try {
            this.output.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void writeAttributes(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            char[] cArray = attributes.getValue(n2).toCharArray();
            this.write(' ');
            this.writeName(attributes.getURI(n2), attributes.getLocalName(n2), attributes.getQName(n2), false);
            this.write("=\"");
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
            ++n2;
        }
    }

    private void writeEsc(char[] cArray, int n, int n2, boolean bl) throws SAXException {
        int n3 = n;
        while (n3 < n + n2) {
            switch (cArray[n3]) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        break;
                    }
                    this.write('\"');
                    break;
                }
                default: {
                    if (cArray[n3] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(cArray[n3]));
                        this.write(';');
                        break;
                    }
                    this.write(cArray[n3]);
                }
            }
            ++n3;
        }
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> enumeration = this.nsSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = this.nsSupport.getURI(string);
            if (string2 == null) {
                string2 = "";
            }
            char[] cArray = string2.toCharArray();
            this.write(' ');
            if ("".equals(string)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(string);
                this.write("=\"");
            }
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeName(String string, String string2, String string3, boolean bl) throws SAXException {
        String string4 = this.doPrefix(string, string3, bl);
        if (string4 != null && !"".equals(string4)) {
            this.write(string4);
            this.write(':');
        }
        this.write(string2);
    }
}

