/**********************************************************************
 *
 * PostGIS - Spatial Types for PostgreSQL
 * http://postgis.net
 * Copyright 2008 Paul Ramsey
 *
 * This is free software; you can redistribute and/or modify it under
 * the terms of the GNU General Public Licence. See the COPYING file.
 *
 **********************************************************************/

#include <stdio.h>
#include <string.h>
#include "CUnit/Basic.h"
#include "cu_tester.h"
#include "../postgis_config.h"

/*
** The main() function for setting up and running the tests.
** Returns a CUE_SUCCESS on successful running, another
** CUnit error code on failure.
*/
int main()
{

	/* initialize the CUnit test registry */
	if (CUE_SUCCESS != CU_initialize_registry())
		return CU_get_error();

	/* Add the shp2pgsql test suite */
	if (NULL == register_shp2pgsql_suite())
	{
		CU_cleanup_registry();
		return CU_get_error();
	}

#ifdef POSTGIS_PGSQL_VERSION
	/* Add the pgsql2shp test suite */
	if (NULL == register_pgsql2shp_suite())
	{
		CU_cleanup_registry();
		return CU_get_error();
	}
#endif

	/* Run all tests using the CUnit Basic interface */
	CU_basic_set_mode(CU_BRM_VERBOSE);
	CU_basic_run_tests();
	CU_cleanup_registry();

	return CU_get_error();

}
