cmake_minimum_required(VERSION 3.1.0)
if(POLICY CMP0077)
    if(${CMAKE_VERSION} VERSION_LESS "3.13.0")
        cmake_policy(SET CMP0077 OLD)
        message(STATUS "CMP0077 policy set to OLD")
    else()
        cmake_policy(SET CMP0077 NEW)
        message(STATUS "CMP0077 policy set to NEW")
    endif()
endif()

if(PSI_PLUS)
    set(MACOSX_BUNDLE_GUI_IDENTIFIER "com.psi-plus")
    set(MACOSX_BUNDLE_COPYRIGHT "Copyright 2001-2020 Psi IM and Psi+ developers")
    set(MACOSX_ICON_FILE "application-plus.icns")
else()
    set(MACOSX_BUNDLE_GUI_IDENTIFIER "org.psi-im")
    set(MACOSX_BUNDLE_COPYRIGHT "Copyright 2001-2020 Psi IM developers")
    set(MACOSX_ICON_FILE "application.icns")
endif()

set(MACOSX_ICON "${PROJECT_SOURCE_DIR}/mac/${MACOSX_ICON_FILE}")
set(MACOSX_BUNDLE_LONG_VERSION_STRING ${CLIENT_NAME} ${APP_VERSION})
set(MACOSX_BUNDLE_BUNDLE_NAME ${CLIENT_NAME})
set(MACOSX_BUNDLE_SHORT_VERSION_STRING ${APP_VERSION})
set(MACOSX_BUNDLE_BUNDLE_VERSION ${APP_VERSION})

if(${_qt5Core_install_prefix} STREQUAL "")
    message(WARNING "Warning! \"_qt5Core_install_prefix\" is not set, macdeployqt found in PATH will be used")
    set (MACDEPLOYQT "macdeployqt")
else(${_qt5Core_install_prefix} STREQUAL "")
    set (MACDEPLOYQT "${_qt5Core_install_prefix}/bin/macdeployqt")
endif(${_qt5Core_install_prefix} STREQUAL "")

if(CMAKE_OSX_DEPLOYMENT_TARGET)
    set(CPACK_PACKAGE_FILE_NAME "${CLIENT_NAME}-${APP_VERSION}${VERBOSE_SUFFIX}-macOS${CMAKE_OSX_DEPLOYMENT_TARGET}-${CMAKE_SYSTEM_PROCESSOR}")
else(CMAKE_OSX_DEPLOYMENT_TARGET)
    set(CPACK_PACKAGE_FILE_NAME "${CLIENT_NAME}-${APP_VERSION}${VERBOSE_SUFFIX}-${CMAKE_SYSTEM_PROCESSOR}")
endif(CMAKE_OSX_DEPLOYMENT_TARGET)

set(CPACK_PACKAGE_ICON ${MACOSX_ICON})
set(CPACK_BUNDLE_ICON ${MACOSX_ICON})
set(CPACK_BUNDLE_NAME ${CLIENT_NAME})
if(${CMAKE_VERSION} VERSION_LESS "3.13.0")
    set(CPACK_BINARY_DRAGNDROP ON)
else()
    option(CPACK_BINARY_DRAGNDROP ON)
endif()

include(CPack)
