require 'spec_helper'

describe 'collectd::plugin::battery', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end

      options = os_specific_options(facts)
      context 'default' do
        it 'defaults' do
          content = <<EOS
# Generated by Puppet
<LoadPlugin battery>
  Globals false
</LoadPlugin>

<Plugin "battery">
  ValuesPercentage false
  ReportDegraded false
  QueryStateFS false
</Plugin>

EOS

          is_expected.to compile.with_all_deps
          is_expected.to contain_file('battery.load').with(
            content: content,
            path: "#{options[:plugin_conf_dir]}/10-battery.conf"
          )
        end
      end

      options = os_specific_options(facts)
      context 'multiple instances' do
        let :params do
          {
            'values_percentage' => true,
            'report_degraded'   => true,
            'query_state_fs'    => true
          }
        end

        it 'overrides defaults' do
          content = <<EOS
# Generated by Puppet
<LoadPlugin battery>
  Globals false
</LoadPlugin>

<Plugin "battery">
  ValuesPercentage true
  ReportDegraded true
  QueryStateFS true
</Plugin>

EOS

          is_expected.to compile.with_all_deps
          is_expected.to contain_class('collectd')
          is_expected.to contain_file('battery.load').with(
            content: content,
            path: "#{options[:plugin_conf_dir]}/10-battery.conf"
          )
        end
      end
    end
  end
end
