# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.databox import DataBoxManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataBoxManagementJobsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoxManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_list(self, resource_group):
        response = self.client.jobs.list(
            api_version="2025-02-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_mark_devices_shipped(self, resource_group):
        response = self.client.jobs.mark_devices_shipped(
            job_name="str",
            resource_group_name=resource_group.name,
            mark_devices_shipped_request={"deliverToDcPackageDetails": {"carrierName": "str", "trackingId": "str"}},
            api_version="2025-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_list_by_resource_group(self, resource_group):
        response = self.client.jobs.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-02-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_get(self, resource_group):
        response = self.client.jobs.get(
            resource_group_name=resource_group.name,
            job_name="str",
            api_version="2025-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_begin_create(self, resource_group):
        response = self.client.jobs.begin_create(
            resource_group_name=resource_group.name,
            job_name="str",
            job_resource={
                "location": "str",
                "sku": {"name": "str", "displayName": "str", "family": "str", "model": "str"},
                "transferType": "str",
                "allDevicesLost": bool,
                "cancellationReason": "str",
                "delayedStage": "str",
                "deliveryInfo": {"scheduledDateTime": "2020-02-20 00:00:00"},
                "deliveryType": "NonScheduled",
                "details": "job_details",
                "error": {
                    "additionalInfo": [{"info": {}, "type": "str"}],
                    "code": "str",
                    "details": [...],
                    "message": "str",
                    "target": "str",
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "None",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "isCancellable": bool,
                "isCancellableWithoutFee": bool,
                "isDeletable": bool,
                "isPrepareToShipEnabled": bool,
                "isShippingAddressEditable": bool,
                "name": "str",
                "reverseShippingDetailsUpdate": "str",
                "reverseTransportPreferenceUpdate": "str",
                "startTime": "2020-02-20 00:00:00",
                "status": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-02-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_begin_delete(self, resource_group):
        response = self.client.jobs.begin_delete(
            resource_group_name=resource_group.name,
            job_name="str",
            api_version="2025-02-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_begin_update(self, resource_group):
        response = self.client.jobs.begin_update(
            resource_group_name=resource_group.name,
            job_name="str",
            job_resource_update_parameter={
                "details": {
                    "contactDetails": {
                        "contactName": "str",
                        "emailList": ["str"],
                        "phone": "str",
                        "mobile": "str",
                        "notificationPreference": [{"sendNotification": True, "stageName": "str"}],
                        "phoneExtension": "str",
                    },
                    "keyEncryptionKey": {
                        "kekType": "MicrosoftManaged",
                        "identityProperties": {"type": "str", "userAssigned": {"resourceId": "str"}},
                        "kekUrl": "str",
                        "kekVaultResourceID": "str",
                    },
                    "preferences": {
                        "encryptionPreferences": {"doubleEncryption": "Disabled", "hardwareEncryption": "str"},
                        "preferredDataCenterRegion": ["str"],
                        "reverseTransportPreferences": {"preferredShipmentType": "str", "isUpdated": bool},
                        "storageAccountAccessTierPreferences": ["Archive"],
                        "transportPreferences": {"preferredShipmentType": "str", "isUpdated": bool},
                    },
                    "returnToCustomerPackageDetails": {
                        "carrierAccountNumber": "str",
                        "carrierName": "str",
                        "trackingId": "str",
                    },
                    "reverseShippingDetails": {
                        "contactDetails": {
                            "contactName": "str",
                            "phone": "str",
                            "mobile": "str",
                            "phoneExtension": "str",
                        },
                        "isUpdated": bool,
                        "shippingAddress": {
                            "country": "str",
                            "streetAddress1": "str",
                            "addressType": "None",
                            "city": "str",
                            "companyName": "str",
                            "postalCode": "str",
                            "skipAddressValidation": bool,
                            "stateOrProvince": "str",
                            "streetAddress2": "str",
                            "streetAddress3": "str",
                            "taxIdentificationNumber": "str",
                            "zipExtendedCode": "str",
                        },
                    },
                    "shippingAddress": {
                        "country": "str",
                        "streetAddress1": "str",
                        "addressType": "None",
                        "city": "str",
                        "companyName": "str",
                        "postalCode": "str",
                        "skipAddressValidation": bool,
                        "stateOrProvince": "str",
                        "streetAddress2": "str",
                        "streetAddress3": "str",
                        "taxIdentificationNumber": "str",
                        "zipExtendedCode": "str",
                    },
                },
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "None",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "tags": {"str": "str"},
            },
            api_version="2025-02-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_book_shipment_pick_up(self, resource_group):
        response = self.client.jobs.book_shipment_pick_up(
            resource_group_name=resource_group.name,
            job_name="str",
            shipment_pick_up_request={
                "endTime": "2020-02-20 00:00:00",
                "shipmentLocation": "str",
                "startTime": "2020-02-20 00:00:00",
            },
            api_version="2025-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_cancel(self, resource_group):
        response = self.client.jobs.cancel(
            resource_group_name=resource_group.name,
            job_name="str",
            cancellation_reason={"reason": "str"},
            api_version="2025-02-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_jobs_list_credentials(self, resource_group):
        response = self.client.jobs.list_credentials(
            resource_group_name=resource_group.name,
            job_name="str",
            api_version="2025-02-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
