
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Geom_BezierSurface.hxx>
#include <Geom_BSplineSurface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Geom_BezierSurface.hxx>
#include <Geom_BSplineSurface.hxx>

// module includes
#include <GeomAdaptor.hxx>
#include <GeomAdaptor_Curve.hxx>
#include <GeomAdaptor_Surface.hxx>
#include <GeomAdaptor_SurfaceOfLinearExtrusion.hxx>
#include <GeomAdaptor_SurfaceOfRevolution.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <Geom_BezierCurve.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Geom_OffsetCurve.hxx>


// Module definiiton
void register_GeomAdaptor(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("GeomAdaptor"));
py::object klass;

//Python trampoline classes

// classes

    // Class GeomAdaptor from ./opencascade/GeomAdaptor.hxx
    klass = m.attr("GeomAdaptor");

    // default constructor
    register_default_constructor<GeomAdaptor , shared_ptr<GeomAdaptor>>(m,"GeomAdaptor");

    // nested enums

    static_cast<py::class_<GeomAdaptor , shared_ptr<GeomAdaptor>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("MakeCurve_s",
                    (opencascade::handle<Geom_Curve> (*)( const Adaptor3d_Curve &  ) ) static_cast<opencascade::handle<Geom_Curve> (*)( const Adaptor3d_Curve &  ) >(&GeomAdaptor::MakeCurve),
                    R"#(Inherited from GHCurve. Provides a curve handled by reference. Build a Geom_Curve using the information from the Curve from Adaptor3d)#"  , py::arg("C")
          )
        .def_static("MakeSurface_s",
                    (opencascade::handle<Geom_Surface> (*)( const Adaptor3d_Surface & ,  const Standard_Boolean  ) ) static_cast<opencascade::handle<Geom_Surface> (*)( const Adaptor3d_Surface & ,  const Standard_Boolean  ) >(&GeomAdaptor::MakeSurface),
                    R"#(Build a Geom_Surface using the information from the Surface from Adaptor3d)#"  , py::arg("theS"),  py::arg("theTrimFlag")=static_cast<const Standard_Boolean>(Standard_True)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomAdaptor_Curve from ./opencascade/GeomAdaptor_Curve.hxx
    klass = m.attr("GeomAdaptor_Curve");


    // nested enums

    static_cast<py::class_<GeomAdaptor_Curve ,opencascade::handle<GeomAdaptor_Curve>  , Adaptor3d_Curve >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Geom_Curve> & >()  , py::arg("theCurve") )
        .def(py::init< const opencascade::handle<Geom_Curve> &,const Standard_Real,const Standard_Real >()  , py::arg("theCurve"),  py::arg("theUFirst"),  py::arg("theULast") )
    // custom constructors
    // methods
        .def("ShallowCopy",
             (opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_Curve::*)() const) static_cast<opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("Reset",
             (void (GeomAdaptor_Curve::*)() ) static_cast<void (GeomAdaptor_Curve::*)() >(&GeomAdaptor_Curve::Reset),
             R"#(Reset currently loaded curve (undone Load()).)#" 
          )
        .def("Load",
             (void (GeomAdaptor_Curve::*)( const opencascade::handle<Geom_Curve> &  ) ) static_cast<void (GeomAdaptor_Curve::*)( const opencascade::handle<Geom_Curve> &  ) >(&GeomAdaptor_Curve::Load),
             R"#(None)#"  , py::arg("theCurve")
          )
        .def("Load",
             (void (GeomAdaptor_Curve::*)( const opencascade::handle<Geom_Curve> & ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<void (GeomAdaptor_Curve::*)( const opencascade::handle<Geom_Curve> & ,  const Standard_Real ,  const Standard_Real  ) >(&GeomAdaptor_Curve::Load),
             R"#(Standard_ConstructionError is raised if theUFirst>theULast)#"  , py::arg("theCurve"),  py::arg("theUFirst"),  py::arg("theULast")
          )
        .def("FirstParameter",
             (Standard_Real (GeomAdaptor_Curve::*)() const) static_cast<Standard_Real (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::FirstParameter),
             R"#(None)#" 
          )
        .def("LastParameter",
             (Standard_Real (GeomAdaptor_Curve::*)() const) static_cast<Standard_Real (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::LastParameter),
             R"#(None)#" 
          )
        .def("Continuity",
             (GeomAbs_Shape (GeomAdaptor_Curve::*)() const) static_cast<GeomAbs_Shape (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Continuity),
             R"#(None)#" 
          )
        .def("NbIntervals",
             (Standard_Integer (GeomAdaptor_Curve::*)( const GeomAbs_Shape  ) const) static_cast<Standard_Integer (GeomAdaptor_Curve::*)( const GeomAbs_Shape  ) const>(&GeomAdaptor_Curve::NbIntervals),
             R"#(Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("Intervals",
             (void (GeomAdaptor_Curve::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const) static_cast<void (GeomAdaptor_Curve::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const>(&GeomAdaptor_Curve::Intervals),
             R"#(Stores in <T> the parameters bounding the intervals of continuity <S>.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("Trim",
             (opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_Curve::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const) static_cast<opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_Curve::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const>(&GeomAdaptor_Curve::Trim),
             R"#(Returns a curve equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsClosed",
             (Standard_Boolean (GeomAdaptor_Curve::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::IsClosed),
             R"#(None)#" 
          )
        .def("IsPeriodic",
             (Standard_Boolean (GeomAdaptor_Curve::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::IsPeriodic),
             R"#(None)#" 
          )
        .def("Period",
             (Standard_Real (GeomAdaptor_Curve::*)() const) static_cast<Standard_Real (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Period),
             R"#(None)#" 
          )
        .def("Value",
             (gp_Pnt (GeomAdaptor_Curve::*)( const Standard_Real  ) const) static_cast<gp_Pnt (GeomAdaptor_Curve::*)( const Standard_Real  ) const>(&GeomAdaptor_Curve::Value),
             R"#(Computes the point of parameter U on the curve)#"  , py::arg("U")
          )
        .def("D0",
             (void (GeomAdaptor_Curve::*)( const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (GeomAdaptor_Curve::*)( const Standard_Real ,  gp_Pnt &  ) const>(&GeomAdaptor_Curve::D0),
             R"#(Computes the point of parameter U.)#"  , py::arg("U"),  py::arg("P")
          )
        .def("D1",
             (void (GeomAdaptor_Curve::*)( const Standard_Real ,  gp_Pnt & ,  gp_Vec &  ) const) static_cast<void (GeomAdaptor_Curve::*)( const Standard_Real ,  gp_Pnt & ,  gp_Vec &  ) const>(&GeomAdaptor_Curve::D1),
             R"#(Computes the point of parameter U on the curve with its first derivative.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V")
          )
        .def("D2",
             (void (GeomAdaptor_Curve::*)( const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (GeomAdaptor_Curve::*)( const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const>(&GeomAdaptor_Curve::D2),
             R"#(Returns the point P of parameter U, the first and second derivatives V1 and V2.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2")
          )
        .def("D3",
             (void (GeomAdaptor_Curve::*)( const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (GeomAdaptor_Curve::*)( const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&GeomAdaptor_Curve::D3),
             R"#(Returns the point P of parameter U, the first, the second and the third derivative.)#"  , py::arg("U"),  py::arg("P"),  py::arg("V1"),  py::arg("V2"),  py::arg("V3")
          )
        .def("DN",
             (gp_Vec (GeomAdaptor_Curve::*)( const Standard_Real ,  const Standard_Integer  ) const) static_cast<gp_Vec (GeomAdaptor_Curve::*)( const Standard_Real ,  const Standard_Integer  ) const>(&GeomAdaptor_Curve::DN),
             R"#(The returned vector gives the value of the derivative for the order of derivation N. Warning : On the specific case of BSplineCurve: if the curve is cut in interval of continuity CN, the derivatives are computed on the current interval. else the derivatives are computed on the basis curve. Raised if N < 1.)#"  , py::arg("U"),  py::arg("N")
          )
        .def("Resolution",
             (Standard_Real (GeomAdaptor_Curve::*)( const Standard_Real  ) const) static_cast<Standard_Real (GeomAdaptor_Curve::*)( const Standard_Real  ) const>(&GeomAdaptor_Curve::Resolution),
             R"#(returns the parametric resolution)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_CurveType (GeomAdaptor_Curve::*)() const) static_cast<GeomAbs_CurveType (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::GetType),
             R"#(None)#" 
          )
        .def("Line",
             (gp_Lin (GeomAdaptor_Curve::*)() const) static_cast<gp_Lin (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Line),
             R"#(None)#" 
          )
        .def("Circle",
             (gp_Circ (GeomAdaptor_Curve::*)() const) static_cast<gp_Circ (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Circle),
             R"#(None)#" 
          )
        .def("Ellipse",
             (gp_Elips (GeomAdaptor_Curve::*)() const) static_cast<gp_Elips (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Ellipse),
             R"#(None)#" 
          )
        .def("Hyperbola",
             (gp_Hypr (GeomAdaptor_Curve::*)() const) static_cast<gp_Hypr (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Hyperbola),
             R"#(None)#" 
          )
        .def("Parabola",
             (gp_Parab (GeomAdaptor_Curve::*)() const) static_cast<gp_Parab (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Parabola),
             R"#(None)#" 
          )
        .def("Degree",
             (Standard_Integer (GeomAdaptor_Curve::*)() const) static_cast<Standard_Integer (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Degree),
             R"#(this should NEVER make a copy of the underlying curve to read the relevant information)#" 
          )
        .def("IsRational",
             (Standard_Boolean (GeomAdaptor_Curve::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::IsRational),
             R"#(this should NEVER make a copy of the underlying curve to read the relevant information)#" 
          )
        .def("NbPoles",
             (Standard_Integer (GeomAdaptor_Curve::*)() const) static_cast<Standard_Integer (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::NbPoles),
             R"#(this should NEVER make a copy of the underlying curve to read the relevant information)#" 
          )
        .def("NbKnots",
             (Standard_Integer (GeomAdaptor_Curve::*)() const) static_cast<Standard_Integer (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::NbKnots),
             R"#(this should NEVER make a copy of the underlying curve to read the relevant information)#" 
          )
        .def("Bezier",
             (opencascade::handle<Geom_BezierCurve> (GeomAdaptor_Curve::*)() const) static_cast<opencascade::handle<Geom_BezierCurve> (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Bezier),
             R"#(this will NOT make a copy of the Bezier Curve : If you want to modify the Curve please make a copy yourself Also it will NOT trim the surface to myFirst/Last.)#" 
          )
        .def("BSpline",
             (opencascade::handle<Geom_BSplineCurve> (GeomAdaptor_Curve::*)() const) static_cast<opencascade::handle<Geom_BSplineCurve> (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::BSpline),
             R"#(this will NOT make a copy of the BSpline Curve : If you want to modify the Curve please make a copy yourself Also it will NOT trim the surface to myFirst/Last.)#" 
          )
        .def("OffsetCurve",
             (opencascade::handle<Geom_OffsetCurve> (GeomAdaptor_Curve::*)() const) static_cast<opencascade::handle<Geom_OffsetCurve> (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::OffsetCurve),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&GeomAdaptor_Curve::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&GeomAdaptor_Curve::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (GeomAdaptor_Curve::*)() const) static_cast<const opencascade::handle<Standard_Type> & (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::DynamicType),
             R"#(None)#"
             
         )
       .def("Curve",
             (const opencascade::handle<Geom_Curve> & (GeomAdaptor_Curve::*)() const) static_cast<const opencascade::handle<Geom_Curve> & (GeomAdaptor_Curve::*)() const>(&GeomAdaptor_Curve::Curve),
             R"#(Provides a curve inherited from Hcurve from Adaptor. This is inherited to provide easy to use constructors.)#"
             
         )
;

    // Class GeomAdaptor_Surface from ./opencascade/GeomAdaptor_Surface.hxx
    klass = m.attr("GeomAdaptor_Surface");


    // nested enums

    static_cast<py::class_<GeomAdaptor_Surface ,opencascade::handle<GeomAdaptor_Surface>  , Adaptor3d_Surface >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Geom_Surface> & >()  , py::arg("theSurf") )
        .def(py::init< const opencascade::handle<Geom_Surface> &,const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Real >()  , py::arg("theSurf"),  py::arg("theUFirst"),  py::arg("theULast"),  py::arg("theVFirst"),  py::arg("theVLast"),  py::arg("theTolU")=static_cast<const Standard_Real>(0.0),  py::arg("theTolV")=static_cast<const Standard_Real>(0.0) )
    // custom constructors
    // methods
        .def("ShallowCopy",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_Surface::*)() const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("Load",
             (void (GeomAdaptor_Surface::*)( const opencascade::handle<Geom_Surface> &  ) ) static_cast<void (GeomAdaptor_Surface::*)( const opencascade::handle<Geom_Surface> &  ) >(&GeomAdaptor_Surface::Load),
             R"#(None)#"  , py::arg("theSurf")
          )
        .def("Load",
             (void (GeomAdaptor_Surface::*)( const opencascade::handle<Geom_Surface> & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<void (GeomAdaptor_Surface::*)( const opencascade::handle<Geom_Surface> & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) >(&GeomAdaptor_Surface::Load),
             R"#(Standard_ConstructionError is raised if theUFirst>theULast or theVFirst>theVLast)#"  , py::arg("theSurf"),  py::arg("theUFirst"),  py::arg("theULast"),  py::arg("theVFirst"),  py::arg("theVLast"),  py::arg("theTolU")=static_cast<const Standard_Real>(0.0),  py::arg("theTolV")=static_cast<const Standard_Real>(0.0)
          )
        .def("FirstUParameter",
             (Standard_Real (GeomAdaptor_Surface::*)() const) static_cast<Standard_Real (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::FirstUParameter),
             R"#(None)#" 
          )
        .def("LastUParameter",
             (Standard_Real (GeomAdaptor_Surface::*)() const) static_cast<Standard_Real (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::LastUParameter),
             R"#(None)#" 
          )
        .def("FirstVParameter",
             (Standard_Real (GeomAdaptor_Surface::*)() const) static_cast<Standard_Real (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::FirstVParameter),
             R"#(None)#" 
          )
        .def("LastVParameter",
             (Standard_Real (GeomAdaptor_Surface::*)() const) static_cast<Standard_Real (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::LastVParameter),
             R"#(None)#" 
          )
        .def("UContinuity",
             (GeomAbs_Shape (GeomAdaptor_Surface::*)() const) static_cast<GeomAbs_Shape (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::UContinuity),
             R"#(None)#" 
          )
        .def("VContinuity",
             (GeomAbs_Shape (GeomAdaptor_Surface::*)() const) static_cast<GeomAbs_Shape (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::VContinuity),
             R"#(None)#" 
          )
        .def("NbUIntervals",
             (Standard_Integer (GeomAdaptor_Surface::*)( const GeomAbs_Shape  ) const) static_cast<Standard_Integer (GeomAdaptor_Surface::*)( const GeomAbs_Shape  ) const>(&GeomAdaptor_Surface::NbUIntervals),
             R"#(Returns the number of U intervals for continuity <S>. May be one if UContinuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("NbVIntervals",
             (Standard_Integer (GeomAdaptor_Surface::*)( const GeomAbs_Shape  ) const) static_cast<Standard_Integer (GeomAdaptor_Surface::*)( const GeomAbs_Shape  ) const>(&GeomAdaptor_Surface::NbVIntervals),
             R"#(Returns the number of V intervals for continuity <S>. May be one if VContinuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("UIntervals",
             (void (GeomAdaptor_Surface::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const) static_cast<void (GeomAdaptor_Surface::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const>(&GeomAdaptor_Surface::UIntervals),
             R"#(Returns the intervals with the requested continuity in the U direction.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("VIntervals",
             (void (GeomAdaptor_Surface::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const) static_cast<void (GeomAdaptor_Surface::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const>(&GeomAdaptor_Surface::VIntervals),
             R"#(Returns the intervals with the requested continuity in the V direction.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("UTrim",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const>(&GeomAdaptor_Surface::UTrim),
             R"#(Returns a surface trimmed in the U direction equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("VTrim",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const>(&GeomAdaptor_Surface::VTrim),
             R"#(Returns a surface trimmed in the V direction between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsUClosed",
             (Standard_Boolean (GeomAdaptor_Surface::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::IsUClosed),
             R"#(None)#" 
          )
        .def("IsVClosed",
             (Standard_Boolean (GeomAdaptor_Surface::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::IsVClosed),
             R"#(None)#" 
          )
        .def("IsUPeriodic",
             (Standard_Boolean (GeomAdaptor_Surface::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::IsUPeriodic),
             R"#(None)#" 
          )
        .def("UPeriod",
             (Standard_Real (GeomAdaptor_Surface::*)() const) static_cast<Standard_Real (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::UPeriod),
             R"#(None)#" 
          )
        .def("IsVPeriodic",
             (Standard_Boolean (GeomAdaptor_Surface::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::IsVPeriodic),
             R"#(None)#" 
          )
        .def("VPeriod",
             (Standard_Real (GeomAdaptor_Surface::*)() const) static_cast<Standard_Real (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::VPeriod),
             R"#(None)#" 
          )
        .def("Value",
             (gp_Pnt (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real  ) const) static_cast<gp_Pnt (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real  ) const>(&GeomAdaptor_Surface::Value),
             R"#(Computes the point of parameters U,V on the surface.)#"  , py::arg("U"),  py::arg("V")
          )
        .def("D0",
             (void (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  gp_Pnt &  ) const) static_cast<void (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  gp_Pnt &  ) const>(&GeomAdaptor_Surface::D0),
             R"#(Computes the point of parameters U,V on the surface.)#"  , py::arg("U"),  py::arg("V"),  py::arg("P")
          )
        .def("D1",
             (void (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec &  ) const>(&GeomAdaptor_Surface::D1),
             R"#(Computes the point and the first derivatives on the surface.)#"  , py::arg("U"),  py::arg("V"),  py::arg("P"),  py::arg("D1U"),  py::arg("D1V")
          )
        .def("D2",
             (void (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&GeomAdaptor_Surface::D2),
             R"#(Computes the point, the first and second derivatives on the surface.)#"  , py::arg("U"),  py::arg("V"),  py::arg("P"),  py::arg("D1U"),  py::arg("D1V"),  py::arg("D2U"),  py::arg("D2V"),  py::arg("D2UV")
          )
        .def("D3",
             (void (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const) static_cast<void (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  gp_Pnt & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec & ,  gp_Vec &  ) const>(&GeomAdaptor_Surface::D3),
             R"#(Computes the point, the first, second and third derivatives on the surface.)#"  , py::arg("U"),  py::arg("V"),  py::arg("P"),  py::arg("D1U"),  py::arg("D1V"),  py::arg("D2U"),  py::arg("D2V"),  py::arg("D2UV"),  py::arg("D3U"),  py::arg("D3V"),  py::arg("D3UUV"),  py::arg("D3UVV")
          )
        .def("DN",
             (gp_Vec (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer  ) const) static_cast<gp_Vec (GeomAdaptor_Surface::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer  ) const>(&GeomAdaptor_Surface::DN),
             R"#(Computes the derivative of order Nu in the direction U and Nv in the direction V at the point P(U, V).)#"  , py::arg("U"),  py::arg("V"),  py::arg("Nu"),  py::arg("Nv")
          )
        .def("UResolution",
             (Standard_Real (GeomAdaptor_Surface::*)( const Standard_Real  ) const) static_cast<Standard_Real (GeomAdaptor_Surface::*)( const Standard_Real  ) const>(&GeomAdaptor_Surface::UResolution),
             R"#(Returns the parametric U resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("VResolution",
             (Standard_Real (GeomAdaptor_Surface::*)( const Standard_Real  ) const) static_cast<Standard_Real (GeomAdaptor_Surface::*)( const Standard_Real  ) const>(&GeomAdaptor_Surface::VResolution),
             R"#(Returns the parametric V resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_SurfaceType (GeomAdaptor_Surface::*)() const) static_cast<GeomAbs_SurfaceType (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::GetType),
             R"#(Returns the type of the surface : Plane, Cylinder, Cone, Sphere, Torus, BezierSurface, BSplineSurface, SurfaceOfRevolution, SurfaceOfExtrusion, OtherSurface)#" 
          )
        .def("Plane",
             (gp_Pln (GeomAdaptor_Surface::*)() const) static_cast<gp_Pln (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::Plane),
             R"#(None)#" 
          )
        .def("Cylinder",
             (gp_Cylinder (GeomAdaptor_Surface::*)() const) static_cast<gp_Cylinder (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::Cylinder),
             R"#(None)#" 
          )
        .def("Cone",
             (gp_Cone (GeomAdaptor_Surface::*)() const) static_cast<gp_Cone (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::Cone),
             R"#(None)#" 
          )
        .def("Sphere",
             (gp_Sphere (GeomAdaptor_Surface::*)() const) static_cast<gp_Sphere (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::Sphere),
             R"#(None)#" 
          )
        .def("Torus",
             (gp_Torus (GeomAdaptor_Surface::*)() const) static_cast<gp_Torus (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::Torus),
             R"#(None)#" 
          )
        .def("UDegree",
             (Standard_Integer (GeomAdaptor_Surface::*)() const) static_cast<Standard_Integer (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::UDegree),
             R"#(None)#" 
          )
        .def("NbUPoles",
             (Standard_Integer (GeomAdaptor_Surface::*)() const) static_cast<Standard_Integer (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::NbUPoles),
             R"#(None)#" 
          )
        .def("VDegree",
             (Standard_Integer (GeomAdaptor_Surface::*)() const) static_cast<Standard_Integer (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::VDegree),
             R"#(None)#" 
          )
        .def("NbVPoles",
             (Standard_Integer (GeomAdaptor_Surface::*)() const) static_cast<Standard_Integer (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::NbVPoles),
             R"#(None)#" 
          )
        .def("NbUKnots",
             (Standard_Integer (GeomAdaptor_Surface::*)() const) static_cast<Standard_Integer (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::NbUKnots),
             R"#(None)#" 
          )
        .def("NbVKnots",
             (Standard_Integer (GeomAdaptor_Surface::*)() const) static_cast<Standard_Integer (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::NbVKnots),
             R"#(None)#" 
          )
        .def("IsURational",
             (Standard_Boolean (GeomAdaptor_Surface::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::IsURational),
             R"#(None)#" 
          )
        .def("IsVRational",
             (Standard_Boolean (GeomAdaptor_Surface::*)() const) static_cast<Standard_Boolean (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::IsVRational),
             R"#(None)#" 
          )
        .def("Bezier",
             (opencascade::handle<Geom_BezierSurface> (GeomAdaptor_Surface::*)() const) static_cast<opencascade::handle<Geom_BezierSurface> (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::Bezier),
             R"#(This will NOT make a copy of the Bezier Surface : If you want to modify the Surface please make a copy yourself Also it will NOT trim the surface to myU/VFirst/Last.)#" 
          )
        .def("BSpline",
             (opencascade::handle<Geom_BSplineSurface> (GeomAdaptor_Surface::*)() const) static_cast<opencascade::handle<Geom_BSplineSurface> (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::BSpline),
             R"#(This will NOT make a copy of the BSpline Surface : If you want to modify the Surface please make a copy yourself Also it will NOT trim the surface to myU/VFirst/Last.)#" 
          )
        .def("AxeOfRevolution",
             (gp_Ax1 (GeomAdaptor_Surface::*)() const) static_cast<gp_Ax1 (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::AxeOfRevolution),
             R"#(None)#" 
          )
        .def("Direction",
             (gp_Dir (GeomAdaptor_Surface::*)() const) static_cast<gp_Dir (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::Direction),
             R"#(None)#" 
          )
        .def("BasisCurve",
             (opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_Surface::*)() const) static_cast<opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::BasisCurve),
             R"#(None)#" 
          )
        .def("BasisSurface",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_Surface::*)() const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::BasisSurface),
             R"#(None)#" 
          )
        .def("OffsetValue",
             (Standard_Real (GeomAdaptor_Surface::*)() const) static_cast<Standard_Real (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::OffsetValue),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&GeomAdaptor_Surface::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&GeomAdaptor_Surface::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (GeomAdaptor_Surface::*)() const) static_cast<const opencascade::handle<Standard_Type> & (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::DynamicType),
             R"#(None)#"
             
         )
       .def("Surface",
             (const opencascade::handle<Geom_Surface> & (GeomAdaptor_Surface::*)() const) static_cast<const opencascade::handle<Geom_Surface> & (GeomAdaptor_Surface::*)() const>(&GeomAdaptor_Surface::Surface),
             R"#(None)#"
             
         )
;

    // Class GeomAdaptor_SurfaceOfLinearExtrusion from ./opencascade/GeomAdaptor_SurfaceOfLinearExtrusion.hxx
    klass = m.attr("GeomAdaptor_SurfaceOfLinearExtrusion");


    // nested enums

    static_cast<py::class_<GeomAdaptor_SurfaceOfLinearExtrusion ,opencascade::handle<GeomAdaptor_SurfaceOfLinearExtrusion>  , GeomAdaptor_Surface >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Adaptor3d_Curve> & >()  , py::arg("C") )
        .def(py::init< const opencascade::handle<Adaptor3d_Curve> &,const gp_Dir & >()  , py::arg("C"),  py::arg("V") )
    // custom constructors
    // methods
        .def("ShallowCopy",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("Load",
             (void (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const opencascade::handle<Adaptor3d_Curve> &  ) ) static_cast<void (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const opencascade::handle<Adaptor3d_Curve> &  ) >(&GeomAdaptor_SurfaceOfLinearExtrusion::Load),
             R"#(Changes the Curve)#"  , py::arg("C")
          )
        .def("Load",
             (void (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const gp_Dir &  ) ) static_cast<void (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const gp_Dir &  ) >(&GeomAdaptor_SurfaceOfLinearExtrusion::Load),
             R"#(Changes the Direction)#"  , py::arg("V")
          )
        .def("FirstUParameter",
             (Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::FirstUParameter),
             R"#(None)#" 
          )
        .def("LastUParameter",
             (Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::LastUParameter),
             R"#(None)#" 
          )
        .def("FirstVParameter",
             (Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::FirstVParameter),
             R"#(None)#" 
          )
        .def("LastVParameter",
             (Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::LastVParameter),
             R"#(None)#" 
          )
        .def("UContinuity",
             (GeomAbs_Shape (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<GeomAbs_Shape (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::UContinuity),
             R"#(None)#" 
          )
        .def("VContinuity",
             (GeomAbs_Shape (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<GeomAbs_Shape (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::VContinuity),
             R"#(Return CN.)#" 
          )
        .def("NbUIntervals",
             (Standard_Integer (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const GeomAbs_Shape  ) const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const GeomAbs_Shape  ) const>(&GeomAdaptor_SurfaceOfLinearExtrusion::NbUIntervals),
             R"#(Returns the number of U intervals for continuity <S>. May be one if UContinuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("NbVIntervals",
             (Standard_Integer (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const GeomAbs_Shape  ) const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const GeomAbs_Shape  ) const>(&GeomAdaptor_SurfaceOfLinearExtrusion::NbVIntervals),
             R"#(Returns the number of V intervals for continuity <S>. May be one if VContinuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("UIntervals",
             (void (GeomAdaptor_SurfaceOfLinearExtrusion::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const) static_cast<void (GeomAdaptor_SurfaceOfLinearExtrusion::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const>(&GeomAdaptor_SurfaceOfLinearExtrusion::UIntervals),
             R"#(Returns the intervals with the requested continuity in the U direction.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("VIntervals",
             (void (GeomAdaptor_SurfaceOfLinearExtrusion::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const) static_cast<void (GeomAdaptor_SurfaceOfLinearExtrusion::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const>(&GeomAdaptor_SurfaceOfLinearExtrusion::VIntervals),
             R"#(Returns the intervals with the requested continuity in the V direction.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("UTrim",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const>(&GeomAdaptor_SurfaceOfLinearExtrusion::UTrim),
             R"#(Returns a surface trimmed in the U direction equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("VTrim",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const>(&GeomAdaptor_SurfaceOfLinearExtrusion::VTrim),
             R"#(Returns a surface trimmed in the V direction between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsUClosed",
             (Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::IsUClosed),
             R"#(None)#" 
          )
        .def("IsVClosed",
             (Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::IsVClosed),
             R"#(None)#" 
          )
        .def("IsUPeriodic",
             (Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::IsUPeriodic),
             R"#(None)#" 
          )
        .def("UPeriod",
             (Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::UPeriod),
             R"#(None)#" 
          )
        .def("IsVPeriodic",
             (Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::IsVPeriodic),
             R"#(None)#" 
          )
        .def("VPeriod",
             (Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::VPeriod),
             R"#(None)#" 
          )
        .def("UResolution",
             (Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const Standard_Real  ) const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const Standard_Real  ) const>(&GeomAdaptor_SurfaceOfLinearExtrusion::UResolution),
             R"#(Returns the parametric U resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("VResolution",
             (Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const Standard_Real  ) const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfLinearExtrusion::*)( const Standard_Real  ) const>(&GeomAdaptor_SurfaceOfLinearExtrusion::VResolution),
             R"#(Returns the parametric V resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_SurfaceType (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<GeomAbs_SurfaceType (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::GetType),
             R"#(Returns the type of the surface : Plane, Cylinder, Cone, Sphere, Torus, BezierSurface, BSplineSurface, SurfaceOfRevolution, SurfaceOfExtrusion, OtherSurface)#" 
          )
        .def("Plane",
             (gp_Pln (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<gp_Pln (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::Plane),
             R"#(None)#" 
          )
        .def("Cylinder",
             (gp_Cylinder (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<gp_Cylinder (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::Cylinder),
             R"#(None)#" 
          )
        .def("Cone",
             (gp_Cone (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<gp_Cone (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::Cone),
             R"#(None)#" 
          )
        .def("Sphere",
             (gp_Sphere (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<gp_Sphere (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::Sphere),
             R"#(None)#" 
          )
        .def("Torus",
             (gp_Torus (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<gp_Torus (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::Torus),
             R"#(None)#" 
          )
        .def("UDegree",
             (Standard_Integer (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::UDegree),
             R"#(None)#" 
          )
        .def("NbUPoles",
             (Standard_Integer (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::NbUPoles),
             R"#(None)#" 
          )
        .def("IsURational",
             (Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::IsURational),
             R"#(None)#" 
          )
        .def("IsVRational",
             (Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::IsVRational),
             R"#(None)#" 
          )
        .def("Bezier",
             (opencascade::handle<Geom_BezierSurface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<opencascade::handle<Geom_BezierSurface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::Bezier),
             R"#(None)#" 
          )
        .def("BSpline",
             (opencascade::handle<Geom_BSplineSurface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<opencascade::handle<Geom_BSplineSurface> (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::BSpline),
             R"#(None)#" 
          )
        .def("AxeOfRevolution",
             (gp_Ax1 (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<gp_Ax1 (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::AxeOfRevolution),
             R"#(None)#" 
          )
        .def("Direction",
             (gp_Dir (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<gp_Dir (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::Direction),
             R"#(None)#" 
          )
        .def("BasisCurve",
             (opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::BasisCurve),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&GeomAdaptor_SurfaceOfLinearExtrusion::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&GeomAdaptor_SurfaceOfLinearExtrusion::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const) static_cast<const opencascade::handle<Standard_Type> & (GeomAdaptor_SurfaceOfLinearExtrusion::*)() const>(&GeomAdaptor_SurfaceOfLinearExtrusion::DynamicType),
             R"#(None)#"
             
         )
;

    // Class GeomAdaptor_SurfaceOfRevolution from ./opencascade/GeomAdaptor_SurfaceOfRevolution.hxx
    klass = m.attr("GeomAdaptor_SurfaceOfRevolution");


    // nested enums

    static_cast<py::class_<GeomAdaptor_SurfaceOfRevolution ,opencascade::handle<GeomAdaptor_SurfaceOfRevolution>  , GeomAdaptor_Surface >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Adaptor3d_Curve> & >()  , py::arg("C") )
        .def(py::init< const opencascade::handle<Adaptor3d_Curve> &,const gp_Ax1 & >()  , py::arg("C"),  py::arg("V") )
    // custom constructors
    // methods
        .def("ShallowCopy",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::ShallowCopy),
             R"#(Shallow copy of adaptor)#" 
          )
        .def("Load",
             (void (GeomAdaptor_SurfaceOfRevolution::*)( const opencascade::handle<Adaptor3d_Curve> &  ) ) static_cast<void (GeomAdaptor_SurfaceOfRevolution::*)( const opencascade::handle<Adaptor3d_Curve> &  ) >(&GeomAdaptor_SurfaceOfRevolution::Load),
             R"#(Changes the Curve)#"  , py::arg("C")
          )
        .def("Load",
             (void (GeomAdaptor_SurfaceOfRevolution::*)( const gp_Ax1 &  ) ) static_cast<void (GeomAdaptor_SurfaceOfRevolution::*)( const gp_Ax1 &  ) >(&GeomAdaptor_SurfaceOfRevolution::Load),
             R"#(Changes the Direction)#"  , py::arg("V")
          )
        .def("AxeOfRevolution",
             (gp_Ax1 (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<gp_Ax1 (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::AxeOfRevolution),
             R"#(None)#" 
          )
        .def("FirstUParameter",
             (Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::FirstUParameter),
             R"#(None)#" 
          )
        .def("LastUParameter",
             (Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::LastUParameter),
             R"#(None)#" 
          )
        .def("FirstVParameter",
             (Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::FirstVParameter),
             R"#(None)#" 
          )
        .def("LastVParameter",
             (Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::LastVParameter),
             R"#(None)#" 
          )
        .def("UContinuity",
             (GeomAbs_Shape (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<GeomAbs_Shape (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::UContinuity),
             R"#(None)#" 
          )
        .def("VContinuity",
             (GeomAbs_Shape (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<GeomAbs_Shape (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::VContinuity),
             R"#(Return CN.)#" 
          )
        .def("NbUIntervals",
             (Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)( const GeomAbs_Shape  ) const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)( const GeomAbs_Shape  ) const>(&GeomAdaptor_SurfaceOfRevolution::NbUIntervals),
             R"#(Returns the number of U intervals for continuity <S>. May be one if UContinuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("NbVIntervals",
             (Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)( const GeomAbs_Shape  ) const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)( const GeomAbs_Shape  ) const>(&GeomAdaptor_SurfaceOfRevolution::NbVIntervals),
             R"#(Returns the number of V intervals for continuity <S>. May be one if VContinuity(me) >= <S>)#"  , py::arg("S")
          )
        .def("UIntervals",
             (void (GeomAdaptor_SurfaceOfRevolution::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const) static_cast<void (GeomAdaptor_SurfaceOfRevolution::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const>(&GeomAdaptor_SurfaceOfRevolution::UIntervals),
             R"#(Returns the intervals with the requested continuity in the U direction.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("VIntervals",
             (void (GeomAdaptor_SurfaceOfRevolution::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const) static_cast<void (GeomAdaptor_SurfaceOfRevolution::*)( NCollection_Array1<Standard_Real> & ,  const GeomAbs_Shape  ) const>(&GeomAdaptor_SurfaceOfRevolution::VIntervals),
             R"#(Returns the intervals with the requested continuity in the V direction.)#"  , py::arg("T"),  py::arg("S")
          )
        .def("UTrim",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfRevolution::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfRevolution::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const>(&GeomAdaptor_SurfaceOfRevolution::UTrim),
             R"#(Returns a surface trimmed in the U direction equivalent of <me> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("VTrim",
             (opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfRevolution::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const) static_cast<opencascade::handle<Adaptor3d_Surface> (GeomAdaptor_SurfaceOfRevolution::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) const>(&GeomAdaptor_SurfaceOfRevolution::VTrim),
             R"#(Returns a surface trimmed in the V direction between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>)#"  , py::arg("First"),  py::arg("Last"),  py::arg("Tol")
          )
        .def("IsUClosed",
             (Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::IsUClosed),
             R"#(None)#" 
          )
        .def("IsVClosed",
             (Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::IsVClosed),
             R"#(None)#" 
          )
        .def("IsUPeriodic",
             (Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::IsUPeriodic),
             R"#(None)#" 
          )
        .def("UPeriod",
             (Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::UPeriod),
             R"#(None)#" 
          )
        .def("IsVPeriodic",
             (Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::IsVPeriodic),
             R"#(None)#" 
          )
        .def("VPeriod",
             (Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::VPeriod),
             R"#(None)#" 
          )
        .def("UResolution",
             (Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)( const Standard_Real  ) const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)( const Standard_Real  ) const>(&GeomAdaptor_SurfaceOfRevolution::UResolution),
             R"#(Returns the parametric U resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("VResolution",
             (Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)( const Standard_Real  ) const) static_cast<Standard_Real (GeomAdaptor_SurfaceOfRevolution::*)( const Standard_Real  ) const>(&GeomAdaptor_SurfaceOfRevolution::VResolution),
             R"#(Returns the parametric V resolution corresponding to the real space resolution <R3d>.)#"  , py::arg("R3d")
          )
        .def("GetType",
             (GeomAbs_SurfaceType (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<GeomAbs_SurfaceType (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::GetType),
             R"#(Returns the type of the surface : Plane, Cylinder, Cone, Sphere, Torus, BezierSurface, BSplineSurface, SurfaceOfRevolution, SurfaceOfExtrusion, OtherSurface)#" 
          )
        .def("Plane",
             (gp_Pln (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<gp_Pln (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::Plane),
             R"#(None)#" 
          )
        .def("Cylinder",
             (gp_Cylinder (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<gp_Cylinder (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::Cylinder),
             R"#(None)#" 
          )
        .def("Cone",
             (gp_Cone (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<gp_Cone (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::Cone),
             R"#(Apex of the Cone = Cone.Position().Location() ==> ReferenceRadius = 0.)#" 
          )
        .def("Sphere",
             (gp_Sphere (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<gp_Sphere (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::Sphere),
             R"#(None)#" 
          )
        .def("Torus",
             (gp_Torus (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<gp_Torus (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::Torus),
             R"#(None)#" 
          )
        .def("VDegree",
             (Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::VDegree),
             R"#(None)#" 
          )
        .def("NbVPoles",
             (Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::NbVPoles),
             R"#(None)#" 
          )
        .def("NbVKnots",
             (Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Integer (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::NbVKnots),
             R"#(None)#" 
          )
        .def("IsURational",
             (Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::IsURational),
             R"#(None)#" 
          )
        .def("IsVRational",
             (Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<Standard_Boolean (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::IsVRational),
             R"#(None)#" 
          )
        .def("Bezier",
             (opencascade::handle<Geom_BezierSurface> (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<opencascade::handle<Geom_BezierSurface> (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::Bezier),
             R"#(None)#" 
          )
        .def("BSpline",
             (opencascade::handle<Geom_BSplineSurface> (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<opencascade::handle<Geom_BSplineSurface> (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::BSpline),
             R"#(None)#" 
          )
        .def("BasisCurve",
             (opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<opencascade::handle<Adaptor3d_Curve> (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::BasisCurve),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&GeomAdaptor_SurfaceOfRevolution::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&GeomAdaptor_SurfaceOfRevolution::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<const opencascade::handle<Standard_Type> & (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::DynamicType),
             R"#(None)#"
             
         )
       .def("Axis",
             (const gp_Ax3 & (GeomAdaptor_SurfaceOfRevolution::*)() const) static_cast<const gp_Ax3 & (GeomAdaptor_SurfaceOfRevolution::*)() const>(&GeomAdaptor_SurfaceOfRevolution::Axis),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/GeomAdaptor.hxx
// ./opencascade/GeomAdaptor_Curve.hxx
// ./opencascade/GeomAdaptor_Surface.hxx
// ./opencascade/GeomAdaptor_SurfaceOfLinearExtrusion.hxx
// ./opencascade/GeomAdaptor_SurfaceOfRevolution.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
