
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_ReadData.hxx>
#include <StdObjMgt_WriteData.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_Persistent.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_Persistent.hxx>
#include <Standard_GUID.hxx>

// module includes
#include <StdObjMgt_Attribute.hxx>
#include <StdObjMgt_MapOfInstantiators.hxx>
#include <StdObjMgt_Persistent.hxx>
#include <StdObjMgt_ReadData.hxx>
#include <StdObjMgt_SharedObject.hxx>
#include <StdObjMgt_TransientPersistentMap.hxx>
#include <StdObjMgt_WriteData.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_StdObjMgt(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("StdObjMgt"));
py::object klass;

//Python trampoline classes
    class Py_StdObjMgt_Persistent : public StdObjMgt_Persistent{
    public:
        using StdObjMgt_Persistent::StdObjMgt_Persistent;


        // public pure virtual
        void Read(StdObjMgt_ReadData & theReadData) override { PYBIND11_OVERLOAD_PURE(void,StdObjMgt_Persistent,Read,theReadData) };
        void Write(StdObjMgt_WriteData & theWriteData) const  override { PYBIND11_OVERLOAD_PURE(void,StdObjMgt_Persistent,Write,theWriteData) };
        void PChildren(NCollection_Sequence<opencascade::handle<StdObjMgt_Persistent>> & ) const  override { PYBIND11_OVERLOAD_PURE(void,StdObjMgt_Persistent,PChildren,) };
        Standard_CString PName() const  override { PYBIND11_OVERLOAD_PURE(Standard_CString,StdObjMgt_Persistent,PName,) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class StdObjMgt_MapOfInstantiators from ./opencascade/StdObjMgt_MapOfInstantiators.hxx
    klass = m.attr("StdObjMgt_MapOfInstantiators");

    // default constructor
    register_default_constructor<StdObjMgt_MapOfInstantiators , shared_ptr<StdObjMgt_MapOfInstantiators>>(m,"StdObjMgt_MapOfInstantiators");

    // nested enums

    static_cast<py::class_<StdObjMgt_MapOfInstantiators , shared_ptr<StdObjMgt_MapOfInstantiators>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdObjMgt_Persistent from ./opencascade/StdObjMgt_Persistent.hxx
    klass = m.attr("StdObjMgt_Persistent");


    // nested enums

    static_cast<py::class_<StdObjMgt_Persistent ,opencascade::handle<StdObjMgt_Persistent> ,Py_StdObjMgt_Persistent , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Read",
             (void (StdObjMgt_Persistent::*)( StdObjMgt_ReadData &  ) ) static_cast<void (StdObjMgt_Persistent::*)( StdObjMgt_ReadData &  ) >(&StdObjMgt_Persistent::Read),
             R"#(Read persistent data from a file.)#"  , py::arg("theReadData")
          )
        .def("Write",
             (void (StdObjMgt_Persistent::*)( StdObjMgt_WriteData &  ) const) static_cast<void (StdObjMgt_Persistent::*)( StdObjMgt_WriteData &  ) const>(&StdObjMgt_Persistent::Write),
             R"#(Write persistent data to a file.)#"  , py::arg("theWriteData")
          )
        .def("PChildren",
             (void (StdObjMgt_Persistent::*)( NCollection_Sequence<opencascade::handle<StdObjMgt_Persistent>> &  ) const) static_cast<void (StdObjMgt_Persistent::*)( NCollection_Sequence<opencascade::handle<StdObjMgt_Persistent>> &  ) const>(&StdObjMgt_Persistent::PChildren),
             R"#(Gets persistent child objects)#"  , py::arg("arg")
          )
        .def("PName",
             (Standard_CString (StdObjMgt_Persistent::*)() const) static_cast<Standard_CString (StdObjMgt_Persistent::*)() const>(&StdObjMgt_Persistent::PName),
             R"#(Returns persistent type name)#" 
          )
        .def("ImportDocument",
             (void (StdObjMgt_Persistent::*)( const opencascade::handle<TDocStd_Document> &  ) const) static_cast<void (StdObjMgt_Persistent::*)( const opencascade::handle<TDocStd_Document> &  ) const>(&StdObjMgt_Persistent::ImportDocument),
             R"#(Import transient document from the persistent data (to be overridden by document class; does nothing by default for other classes).)#"  , py::arg("theDocument")
          )
        .def("CreateAttribute",
             (opencascade::handle<TDF_Attribute> (StdObjMgt_Persistent::*)() ) static_cast<opencascade::handle<TDF_Attribute> (StdObjMgt_Persistent::*)() >(&StdObjMgt_Persistent::CreateAttribute),
             R"#(Create an empty transient attribute (to be overridden by attribute classes; does nothing and returns a null handle by default for other classes).)#" 
          )
        .def("GetAttribute",
             (opencascade::handle<TDF_Attribute> (StdObjMgt_Persistent::*)() const) static_cast<opencascade::handle<TDF_Attribute> (StdObjMgt_Persistent::*)() const>(&StdObjMgt_Persistent::GetAttribute),
             R"#(Get transient attribute for the persistent data (to be overridden by attribute classes; returns a null handle by default for non-attribute classes).)#" 
          )
        .def("ImportAttribute",
             (void (StdObjMgt_Persistent::*)() ) static_cast<void (StdObjMgt_Persistent::*)() >(&StdObjMgt_Persistent::ImportAttribute),
             R"#(Import transient attribute from the persistent data (to be overridden by attribute classes; does nothing by default for non-attribute classes).)#" 
          )
        .def("AsciiString",
             (opencascade::handle<TCollection_HAsciiString> (StdObjMgt_Persistent::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (StdObjMgt_Persistent::*)() const>(&StdObjMgt_Persistent::AsciiString),
             R"#(Get referenced ASCII string (to be overridden by ASCII string class; returns a null handle by default for other classes).)#" 
          )
        .def("ExtString",
             (opencascade::handle<TCollection_HExtendedString> (StdObjMgt_Persistent::*)() const) static_cast<opencascade::handle<TCollection_HExtendedString> (StdObjMgt_Persistent::*)() const>(&StdObjMgt_Persistent::ExtString),
             R"#(Get referenced extended string (to be overridden by extended string class; returns a null handle by default for other classes).)#" 
          )
        .def("Label",
             (TDF_Label (StdObjMgt_Persistent::*)( const opencascade::handle<TDF_Data> &  ) const) static_cast<TDF_Label (StdObjMgt_Persistent::*)( const opencascade::handle<TDF_Data> &  ) const>(&StdObjMgt_Persistent::Label),
             R"#(Get a label expressed by referenced extended string (to be overridden by extended string class; returns a null label by default for other classes).)#"  , py::arg("theDF")
          )
        .def("TypeNum",
             (Standard_Integer (StdObjMgt_Persistent::*)() const) static_cast<Standard_Integer (StdObjMgt_Persistent::*)() const>(&StdObjMgt_Persistent::TypeNum),
             R"#(Returns the assigned persistent type number)#" 
          )
        .def("TypeNum",
             (void (StdObjMgt_Persistent::*)( Standard_Integer  ) ) static_cast<void (StdObjMgt_Persistent::*)( Standard_Integer  ) >(&StdObjMgt_Persistent::TypeNum),
             R"#(Assigns a persistent type number to the object)#"  , py::arg("theTypeNum")
          )
        .def("RefNum",
             (Standard_Integer (StdObjMgt_Persistent::*)() const) static_cast<Standard_Integer (StdObjMgt_Persistent::*)() const>(&StdObjMgt_Persistent::RefNum),
             R"#(Returns the object reference number)#" 
          )
        .def("RefNum",
             (void (StdObjMgt_Persistent::*)( Standard_Integer  ) ) static_cast<void (StdObjMgt_Persistent::*)( Standard_Integer  ) >(&StdObjMgt_Persistent::RefNum),
             R"#(Sets an object reference number)#"  , py::arg("theRefNum")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdObjMgt_ReadData from ./opencascade/StdObjMgt_ReadData.hxx
    klass = m.attr("StdObjMgt_ReadData");


    // nested enums

    static_cast<py::class_<StdObjMgt_ReadData , shared_ptr<StdObjMgt_ReadData>  >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Storage_BaseDriver> &,const Standard_Integer >()  , py::arg("theDriver"),  py::arg("theNumberOfObjects") )
    // custom constructors
    // methods
        .def("ReadPersistentObject",
             (void (StdObjMgt_ReadData::*)( const Standard_Integer  ) ) static_cast<void (StdObjMgt_ReadData::*)( const Standard_Integer  ) >(&StdObjMgt_ReadData::ReadPersistentObject),
             R"#(None)#"  , py::arg("theRef")
          )
        .def("PersistentObject",
             (opencascade::handle<StdObjMgt_Persistent> (StdObjMgt_ReadData::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<StdObjMgt_Persistent> (StdObjMgt_ReadData::*)( const Standard_Integer  ) const>(&StdObjMgt_ReadData::PersistentObject),
             R"#(None)#"  , py::arg("theRef")
          )
        .def("ReadReference",
             (opencascade::handle<StdObjMgt_Persistent> (StdObjMgt_ReadData::*)() ) static_cast<opencascade::handle<StdObjMgt_Persistent> (StdObjMgt_ReadData::*)() >(&StdObjMgt_ReadData::ReadReference),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdObjMgt_SharedObject from ./opencascade/StdObjMgt_SharedObject.hxx
    klass = m.attr("StdObjMgt_SharedObject");

    // default constructor
    register_default_constructor<StdObjMgt_SharedObject , shared_ptr<StdObjMgt_SharedObject>>(m,"StdObjMgt_SharedObject");

    // nested enums

    static_cast<py::class_<StdObjMgt_SharedObject , shared_ptr<StdObjMgt_SharedObject>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdObjMgt_WriteData from ./opencascade/StdObjMgt_WriteData.hxx
    klass = m.attr("StdObjMgt_WriteData");


    // nested enums

    static_cast<py::class_<StdObjMgt_WriteData , shared_ptr<StdObjMgt_WriteData>  >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Storage_BaseDriver> & >()  , py::arg("theDriver") )
    // custom constructors
    // methods
        .def("WritePersistentObject",
             (void (StdObjMgt_WriteData::*)( const opencascade::handle<StdObjMgt_Persistent> &  ) ) static_cast<void (StdObjMgt_WriteData::*)( const opencascade::handle<StdObjMgt_Persistent> &  ) >(&StdObjMgt_WriteData::WritePersistentObject),
             R"#(None)#"  , py::arg("thePersistent")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/StdObjMgt_Attribute.hxx
// ./opencascade/StdObjMgt_MapOfInstantiators.hxx
// ./opencascade/StdObjMgt_Persistent.hxx
// ./opencascade/StdObjMgt_ReadData.hxx
// ./opencascade/StdObjMgt_SharedObject.hxx
// ./opencascade/StdObjMgt_TransientPersistentMap.hxx
// ./opencascade/StdObjMgt_WriteData.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
