# Copyright (c) 2006-2024 Broadcom. All Rights Reserved.
# Broadcom Confidential. The term "Broadcom" refers to Broadcom Inc.
# and/or its subsidiaries.

# ******* WARNING - AUTO GENERATED CODE - DO NOT EDIT *******

from typing import NoReturn
from typing import Optional

from pyVmomi.VmomiSupport import long

from pyVmomi.vim import Datacenter
from pyVmomi.vim import Datastore
from pyVmomi.vim import KeyValue
from pyVmomi.vim import Task
from pyVmomi.vim import VirtualMachine

from pyVmomi.vim.encryption import CryptoSpec

from pyVmomi.vim.vm import ProfileSpec

from pyVmomi.vim.vslm import CloneSpec
from pyVmomi.vim.vslm import CreateSpec
from pyVmomi.vim.vslm import DiskCryptoSpec
from pyVmomi.vim.vslm import ID
from pyVmomi.vim.vslm import InfrastructureObjectPolicy
from pyVmomi.vim.vslm import InfrastructureObjectPolicySpec
from pyVmomi.vim.vslm import RelocateSpec
from pyVmomi.vim.vslm import StateInfo
from pyVmomi.vim.vslm import TagEntry
from pyVmomi.vim.vslm import VStorageObject
from pyVmomi.vim.vslm import VStorageObjectManagerBase
from pyVmomi.vim.vslm import VStorageObjectSnapshotDetails
from pyVmomi.vim.vslm import VStorageObjectSnapshotInfo

from pyVmomi.vim.vslm.vcenter import RetrieveVStorageObjSpec
from pyVmomi.vim.vslm.vcenter import VStorageObjectAssociations

class VStorageObjectManager(VStorageObjectManagerBase):
   def CreateDisk(self, spec: CreateSpec) -> Task: ...
   def RegisterDisk(self, path: str, name: Optional[str]) -> VStorageObject: ...
   def ExtendDisk(self, id: ID, datastore: Datastore, newCapacityInMB: long) -> Task: ...
   def InflateDisk(self, id: ID, datastore: Datastore) -> Task: ...
   def RenameVStorageObject(self, id: ID, datastore: Datastore, name: str) -> NoReturn: ...
   def UpdateVStorageObjectPolicy(self, id: ID, datastore: Datastore, profile: list[ProfileSpec]) -> Task: ...
   def UpdateVStorageObjectCrypto(self, id: ID, datastore: Datastore, profile: list[ProfileSpec], disksCrypto: Optional[DiskCryptoSpec]) -> Task: ...
   def UpdateVStorageInfrastructureObjectPolicy(self, spec: InfrastructureObjectPolicySpec) -> Task: ...
   def RetrieveVStorageInfrastructureObjectPolicy(self, datastore: Datastore) -> list[InfrastructureObjectPolicy]: ...
   def DeleteVStorageObject(self, id: ID, datastore: Datastore) -> Task: ...
   def RetrieveVStorageObject(self, id: ID, datastore: Datastore, diskInfoFlags: list[str]) -> VStorageObject: ...
   def RetrieveVStorageObjectState(self, id: ID, datastore: Datastore) -> StateInfo: ...
   def RetrieveVStorageObjectAssociations(self, ids: list[RetrieveVStorageObjSpec]) -> list[VStorageObjectAssociations]: ...
   def ListVStorageObject(self, datastore: Datastore) -> list[ID]: ...
   def CloneVStorageObject(self, id: ID, datastore: Datastore, spec: CloneSpec) -> Task: ...
   def RelocateVStorageObject(self, id: ID, datastore: Datastore, spec: RelocateSpec) -> Task: ...
   def SetVStorageObjectControlFlags(self, id: ID, datastore: Datastore, controlFlags: list[str]) -> NoReturn: ...
   def ClearVStorageObjectControlFlags(self, id: ID, datastore: Datastore, controlFlags: list[str]) -> NoReturn: ...
   def AttachTagToVStorageObject(self, id: ID, category: str, tag: str) -> NoReturn: ...
   def DetachTagFromVStorageObject(self, id: ID, category: str, tag: str) -> NoReturn: ...
   def ListVStorageObjectsAttachedToTag(self, category: str, tag: str) -> list[ID]: ...
   def ListTagsAttachedToVStorageObject(self, id: ID) -> list[TagEntry]: ...
   def ReconcileDatastoreInventory(self, datastore: Datastore) -> Task: ...
   def ScheduleReconcileDatastoreInventory(self, datastore: Datastore) -> NoReturn: ...
   def CreateSnapshot(self, id: ID, datastore: Datastore, description: str) -> Task: ...
   def DeleteSnapshot(self, id: ID, datastore: Datastore, snapshotId: ID) -> Task: ...
   def RetrieveSnapshotInfo(self, id: ID, datastore: Datastore) -> VStorageObjectSnapshotInfo: ...
   def CreateDiskFromSnapshot(self, id: ID, datastore: Datastore, snapshotId: ID, name: str, profile: list[ProfileSpec], crypto: Optional[CryptoSpec], path: Optional[str]) -> Task: ...
   def RevertVStorageObject(self, id: ID, datastore: Datastore, snapshotId: ID) -> Task: ...
   def RetrieveSnapshotDetails(self, id: ID, datastore: Datastore, snapshotId: ID) -> VStorageObjectSnapshotDetails: ...
   def QueryChangedDiskAreas(self, id: ID, datastore: Datastore, snapshotId: ID, startOffset: long, changeId: str) -> VirtualMachine.DiskChangeInfo: ...
   def DeleteVStorageObjectEx(self, id: ID, datastore: Datastore) -> Task: ...
   def UpdateVStorageObjectMetadataEx(self, id: ID, datastore: Datastore, metadata: list[KeyValue], deleteKeys: list[str]) -> Task: ...
   def SetVirtualDiskUuidEx(self, name: str, datacenter: Optional[Datacenter], uuid: Optional[str]) -> Task: ...
   def QueryVirtualDiskUuidEx(self, name: str, datacenter: Optional[Datacenter]) -> str: ...
