# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/stable/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

import os
import re
import sys
import guzzle_sphinx_theme
from configparser import ConfigParser

root = os.path.abspath(os.path.join(os.path.dirname(__file__), '..'))
sys.path.insert(0, root)


# -- Project information -----------------------------------------------------

# General project metadata is stored in project.cfg
with open(os.path.join(root, 'project.cfg')) as project_file:
    config = ConfigParser()
    config.read_file(project_file)
    project_meta = dict(config.items('project'))

project = project_meta['project']
author = project_meta['author']
copyright = project_meta['copyright']
description = project_meta['description']
url = project_meta['url']
title = project + ' Documentation'

# The full version, including alpha/beta/rc tags
release = project_meta['version']
# The short X.Y.Z version
version = re.sub('[^0-9.].*$', '', release)


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
needs_sphinx = '2.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.napoleon',
    'sphinx_autodoc_typehints',
    'guzzle_sphinx_theme',
    'sphinxcontrib_dooble',
]

# Include a separate entry for special methods, like __init__, where provided.
autodoc_default_options = {
    'member-order': 'bysource',
    'special-members': True,
    'exclude-members': '__dict__,__weakref__'
}


# Hack to get crosslinks working where things are available (and referred to) by
# several paths. E.g. we export rx.Observable but that's not its fully qualified
# name, and this causes the automatically generated links to fail for the
# argument / return types of functions (e.g. as defined in rx/__init__.py).
#
# It looks as though the intention of sphinx_autodoc_typehints is to include
# support for something like this in a future version:
#
# https://github.com/agronholm/sphinx-autodoc-typehints/issues/38

import sphinx_autodoc_typehints

qualname_overrides = {
    'rx.core.observable.observable.Observable': 'rx.Observable'
}

_format_annotation = sphinx_autodoc_typehints.format_annotation


def format_annotation(annotation, fully_qualified=False):
    if isinstance(annotation, type):
        full_name = f'{annotation.__module__}.{annotation.__qualname__}'
        override = qualname_overrides.get(full_name)
        if override is not None:
            return f':py:class:`~{override}`'
    return _format_annotation(annotation, fully_qualified)

sphinx_autodoc_typehints.format_annotation = format_annotation

# End hack.

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_translator_class = 'guzzle_sphinx_theme.HTMLTranslator'
html_theme_path = guzzle_sphinx_theme.html_theme_path()
html_theme = 'guzzle_sphinx_theme'
html_title = title
html_short_title = project + ' ' + version

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}
html_theme_options = {
    'projectlink': url
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#

html_sidebars = {
    '**': ['logo-text.html', 'globaltoc.html', 'searchbox.html']
}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = project + 'doc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, project + '.tex', title, author, 'manual')
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, project.lower(), title, [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, project, title, author, project, description, 'Miscellaneous')
]


# -- Extension configuration -------------------------------------------------
