// This file is generated by Tools/cases_generator/optimizer_generator.py
// from:
//   Python/optimizer_bytecodes.c
// Do not edit!

        case _NOP: {
            break;
        }

        case _CHECK_PERIODIC: {
            break;
        }

        case _CHECK_PERIODIC_IF_NOT_YIELD_FROM: {
            break;
        }

        /* _QUICKEN_RESUME is not a viable micro-op for tier 2 */

        /* _LOAD_BYTECODE is not a viable micro-op for tier 2 */

        case _RESUME_CHECK: {
            break;
        }

        /* _MONITOR_RESUME is not a viable micro-op for tier 2 */

        case _LOAD_FAST_CHECK: {
            JitOptSymbol *value;
            value = GETLOCAL(oparg);
            if (sym_is_null(value)) {
                ctx->done = true;
            }
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_FAST: {
            JitOptSymbol *value;
            value = GETLOCAL(oparg);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_FAST_BORROW: {
            JitOptSymbol *value;
            value = GETLOCAL(oparg);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_FAST_AND_CLEAR: {
            JitOptSymbol *value;
            value = GETLOCAL(oparg);
            JitOptSymbol *temp = sym_new_null(ctx);
            GETLOCAL(oparg) = temp;
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        /* _LOAD_CONST is not a viable micro-op for tier 2 */

        case _LOAD_CONST_MORTAL: {
            JitOptSymbol *value;
            PyObject *val = PyTuple_GET_ITEM(co->co_consts, this_instr->oparg);
            int opcode = _Py_IsImmortal(val) ? _LOAD_CONST_INLINE_BORROW : _LOAD_CONST_INLINE;
            REPLACE_OP(this_instr, opcode, 0, (uintptr_t)val);
            value = sym_new_const(ctx, val);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_CONST_IMMORTAL: {
            JitOptSymbol *value;
            PyObject *val = PyTuple_GET_ITEM(co->co_consts, this_instr->oparg);
            REPLACE_OP(this_instr, _LOAD_CONST_INLINE_BORROW, 0, (uintptr_t)val);
            value = sym_new_const(ctx, val);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_SMALL_INT: {
            JitOptSymbol *value;
            PyObject *val = PyLong_FromLong(this_instr->oparg);
            value = sym_new_const(ctx, val);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_FAST: {
            JitOptSymbol *value;
            value = stack_pointer[-1];
            GETLOCAL(oparg) = value;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _POP_TOP: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _PUSH_NULL: {
            JitOptSymbol *res;
            res = sym_new_null(ctx);
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _END_FOR: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _END_SEND: {
            JitOptSymbol *val;
            val = sym_new_not_null(ctx);
            stack_pointer[-2] = val;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _UNARY_NEGATIVE: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-1] = res;
            break;
        }

        case _UNARY_NOT: {
            JitOptSymbol *value;
            JitOptSymbol *res;
            value = stack_pointer[-1];
            sym_set_type(value, &PyBool_Type);
            res = sym_new_truthiness(ctx, value, false);
            stack_pointer[-1] = res;
            break;
        }

        case _TO_BOOL: {
            JitOptSymbol *value;
            JitOptSymbol *res;
            value = stack_pointer[-1];
            int already_bool = optimize_to_bool(this_instr, ctx, value, &res);
            if (!already_bool) {
                res = sym_new_truthiness(ctx, value, true);
            }
            stack_pointer[-1] = res;
            break;
        }

        case _TO_BOOL_BOOL: {
            JitOptSymbol *value;
            JitOptSymbol *res;
            value = stack_pointer[-1];
            int already_bool = optimize_to_bool(this_instr, ctx, value, &res);
            if (!already_bool) {
                sym_set_type(value, &PyBool_Type);
                res = sym_new_truthiness(ctx, value, true);
            }
            stack_pointer[-1] = res;
            break;
        }

        case _TO_BOOL_INT: {
            JitOptSymbol *value;
            JitOptSymbol *res;
            value = stack_pointer[-1];
            int already_bool = optimize_to_bool(this_instr, ctx, value, &res);
            if (!already_bool) {
                sym_set_type(value, &PyLong_Type);
                res = sym_new_truthiness(ctx, value, true);
            }
            stack_pointer[-1] = res;
            break;
        }

        case _GUARD_NOS_LIST: {
            JitOptSymbol *nos;
            nos = stack_pointer[-2];
            if (sym_matches_type(nos, &PyList_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(nos, &PyList_Type);
            break;
        }

        case _GUARD_TOS_LIST: {
            JitOptSymbol *tos;
            tos = stack_pointer[-1];
            if (sym_matches_type(tos, &PyList_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(tos, &PyList_Type);
            break;
        }

        case _GUARD_TOS_SLICE: {
            break;
        }

        case _TO_BOOL_LIST: {
            JitOptSymbol *value;
            JitOptSymbol *res;
            value = stack_pointer[-1];
            int already_bool = optimize_to_bool(this_instr, ctx, value, &res);
            if (!already_bool) {
                res = sym_new_type(ctx, &PyBool_Type);
            }
            stack_pointer[-1] = res;
            break;
        }

        case _TO_BOOL_NONE: {
            JitOptSymbol *value;
            JitOptSymbol *res;
            value = stack_pointer[-1];
            int already_bool = optimize_to_bool(this_instr, ctx, value, &res);
            if (!already_bool) {
                sym_set_const(value, Py_None);
                res = sym_new_const(ctx, Py_False);
            }
            stack_pointer[-1] = res;
            break;
        }

        case _GUARD_NOS_UNICODE: {
            JitOptSymbol *nos;
            nos = stack_pointer[-2];
            if (sym_matches_type(nos, &PyUnicode_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(nos, &PyUnicode_Type);
            break;
        }

        case _GUARD_TOS_UNICODE: {
            JitOptSymbol *value;
            value = stack_pointer[-1];
            if (sym_matches_type(value, &PyUnicode_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(value, &PyUnicode_Type);
            break;
        }

        case _TO_BOOL_STR: {
            JitOptSymbol *value;
            JitOptSymbol *res;
            value = stack_pointer[-1];
            int already_bool = optimize_to_bool(this_instr, ctx, value, &res);
            if (!already_bool) {
                res = sym_new_truthiness(ctx, value, true);
            }
            stack_pointer[-1] = res;
            break;
        }

        case _REPLACE_WITH_TRUE: {
            JitOptSymbol *res;
            REPLACE_OP(this_instr, _POP_TOP_LOAD_CONST_INLINE_BORROW, 0, (uintptr_t)Py_True);
            res = sym_new_const(ctx, Py_True);
            stack_pointer[-1] = res;
            break;
        }

        case _UNARY_INVERT: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-1] = res;
            break;
        }

        case _GUARD_NOS_INT: {
            JitOptSymbol *nos;
            nos = stack_pointer[-2];
            if (sym_matches_type(nos, &PyLong_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(nos, &PyLong_Type);
            break;
        }

        case _GUARD_TOS_INT: {
            JitOptSymbol *tos;
            tos = stack_pointer[-1];
            if (sym_matches_type(tos, &PyLong_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(tos, &PyLong_Type);
            break;
        }

        case _BINARY_OP_MULTIPLY_INT: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyLong_CheckExact(sym_get_const(ctx, left)));
                assert(PyLong_CheckExact(sym_get_const(ctx, right)));
                PyObject *temp = _PyLong_Multiply((PyLongObject *)sym_get_const(ctx, left),
                    (PyLongObject *)sym_get_const(ctx, right));
                if (temp == NULL) {
                    goto error;
                }
                res = sym_new_const(ctx, temp);
                stack_pointer[-2] = res;
                stack_pointer += -1;
                assert(WITHIN_STACK_BOUNDS());
                Py_DECREF(temp);
            }
            else {
                res = sym_new_type(ctx, &PyLong_Type);
                stack_pointer += -1;
            }
            stack_pointer[-1] = res;
            break;
        }

        case _BINARY_OP_ADD_INT: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyLong_CheckExact(sym_get_const(ctx, left)));
                assert(PyLong_CheckExact(sym_get_const(ctx, right)));
                PyObject *temp = _PyLong_Add((PyLongObject *)sym_get_const(ctx, left),
                    (PyLongObject *)sym_get_const(ctx, right));
                if (temp == NULL) {
                    goto error;
                }
                res = sym_new_const(ctx, temp);
                stack_pointer[-2] = res;
                stack_pointer += -1;
                assert(WITHIN_STACK_BOUNDS());
                Py_DECREF(temp);
            }
            else {
                res = sym_new_type(ctx, &PyLong_Type);
                stack_pointer += -1;
            }
            stack_pointer[-1] = res;
            break;
        }

        case _BINARY_OP_SUBTRACT_INT: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyLong_CheckExact(sym_get_const(ctx, left)));
                assert(PyLong_CheckExact(sym_get_const(ctx, right)));
                PyObject *temp = _PyLong_Subtract((PyLongObject *)sym_get_const(ctx, left),
                    (PyLongObject *)sym_get_const(ctx, right));
                if (temp == NULL) {
                    goto error;
                }
                res = sym_new_const(ctx, temp);
                stack_pointer[-2] = res;
                stack_pointer += -1;
                assert(WITHIN_STACK_BOUNDS());
                Py_DECREF(temp);
            }
            else {
                res = sym_new_type(ctx, &PyLong_Type);
                stack_pointer += -1;
            }
            stack_pointer[-1] = res;
            break;
        }

        case _GUARD_NOS_FLOAT: {
            JitOptSymbol *nos;
            nos = stack_pointer[-2];
            if (sym_matches_type(nos, &PyFloat_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(nos, &PyFloat_Type);
            break;
        }

        case _GUARD_TOS_FLOAT: {
            JitOptSymbol *tos;
            tos = stack_pointer[-1];
            if (sym_matches_type(tos, &PyFloat_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(tos, &PyFloat_Type);
            break;
        }

        case _BINARY_OP_MULTIPLY_FLOAT: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyFloat_CheckExact(sym_get_const(ctx, left)));
                assert(PyFloat_CheckExact(sym_get_const(ctx, right)));
                PyObject *temp = PyFloat_FromDouble(
                    PyFloat_AS_DOUBLE(sym_get_const(ctx, left)) *
                    PyFloat_AS_DOUBLE(sym_get_const(ctx, right)));
                if (temp == NULL) {
                    goto error;
                }
                res = sym_new_const(ctx, temp);
                stack_pointer[-2] = res;
                stack_pointer += -1;
                assert(WITHIN_STACK_BOUNDS());
                Py_DECREF(temp);
            }
            else {
                res = sym_new_type(ctx, &PyFloat_Type);
                stack_pointer += -1;
            }
            stack_pointer[-1] = res;
            break;
        }

        case _BINARY_OP_ADD_FLOAT: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyFloat_CheckExact(sym_get_const(ctx, left)));
                assert(PyFloat_CheckExact(sym_get_const(ctx, right)));
                PyObject *temp = PyFloat_FromDouble(
                    PyFloat_AS_DOUBLE(sym_get_const(ctx, left)) +
                    PyFloat_AS_DOUBLE(sym_get_const(ctx, right)));
                if (temp == NULL) {
                    goto error;
                }
                res = sym_new_const(ctx, temp);
                stack_pointer[-2] = res;
                stack_pointer += -1;
                assert(WITHIN_STACK_BOUNDS());
                Py_DECREF(temp);
            }
            else {
                res = sym_new_type(ctx, &PyFloat_Type);
                stack_pointer += -1;
            }
            stack_pointer[-1] = res;
            break;
        }

        case _BINARY_OP_SUBTRACT_FLOAT: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyFloat_CheckExact(sym_get_const(ctx, left)));
                assert(PyFloat_CheckExact(sym_get_const(ctx, right)));
                PyObject *temp = PyFloat_FromDouble(
                    PyFloat_AS_DOUBLE(sym_get_const(ctx, left)) -
                    PyFloat_AS_DOUBLE(sym_get_const(ctx, right)));
                if (temp == NULL) {
                    goto error;
                }
                res = sym_new_const(ctx, temp);
                stack_pointer[-2] = res;
                stack_pointer += -1;
                assert(WITHIN_STACK_BOUNDS());
                Py_DECREF(temp);
            }
            else {
                res = sym_new_type(ctx, &PyFloat_Type);
                stack_pointer += -1;
            }
            stack_pointer[-1] = res;
            break;
        }

        case _BINARY_OP_ADD_UNICODE: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyUnicode_CheckExact(sym_get_const(ctx, left)));
                assert(PyUnicode_CheckExact(sym_get_const(ctx, right)));
                PyObject *temp = PyUnicode_Concat(sym_get_const(ctx, left), sym_get_const(ctx, right));
                if (temp == NULL) {
                    goto error;
                }
                res = sym_new_const(ctx, temp);
                stack_pointer[-2] = res;
                stack_pointer += -1;
                assert(WITHIN_STACK_BOUNDS());
                Py_DECREF(temp);
            }
            else {
                res = sym_new_type(ctx, &PyUnicode_Type);
                stack_pointer += -1;
            }
            stack_pointer[-1] = res;
            break;
        }

        case _BINARY_OP_INPLACE_ADD_UNICODE: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            JitOptSymbol *res;
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyUnicode_CheckExact(sym_get_const(ctx, left)));
                assert(PyUnicode_CheckExact(sym_get_const(ctx, right)));
                PyObject *temp = PyUnicode_Concat(sym_get_const(ctx, left), sym_get_const(ctx, right));
                if (temp == NULL) {
                    goto error;
                }
                res = sym_new_const(ctx, temp);
                Py_DECREF(temp);
            }
            else {
                res = sym_new_type(ctx, &PyUnicode_Type);
            }
            GETLOCAL(this_instr->operand0) = res;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_BINARY_OP_EXTEND: {
            break;
        }

        case _BINARY_OP_EXTEND: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BINARY_SLICE: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-3] = res;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_SLICE: {
            stack_pointer += -4;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BINARY_OP_SUBSCR_LIST_INT: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BINARY_OP_SUBSCR_LIST_SLICE: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BINARY_OP_SUBSCR_STR_INT: {
            JitOptSymbol *res;
            res = sym_new_type(ctx, &PyUnicode_Type);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_NOS_TUPLE: {
            JitOptSymbol *nos;
            nos = stack_pointer[-2];
            if (sym_matches_type(nos, &PyTuple_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(nos, &PyTuple_Type);
            break;
        }

        case _GUARD_TOS_TUPLE: {
            JitOptSymbol *tos;
            tos = stack_pointer[-1];
            if (sym_matches_type(tos, &PyTuple_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(tos, &PyTuple_Type);
            break;
        }

        case _BINARY_OP_SUBSCR_TUPLE_INT: {
            JitOptSymbol *sub_st;
            JitOptSymbol *tuple_st;
            JitOptSymbol *res;
            sub_st = stack_pointer[-1];
            tuple_st = stack_pointer[-2];
            assert(sym_matches_type(tuple_st, &PyTuple_Type));
            if (sym_is_const(ctx, sub_st)) {
                assert(PyLong_CheckExact(sym_get_const(ctx, sub_st)));
                long index = PyLong_AsLong(sym_get_const(ctx, sub_st));
                assert(index >= 0);
                int tuple_length = sym_tuple_length(tuple_st);
                if (tuple_length == -1) {
                    res = sym_new_not_null(ctx);
                }
                else {
                    assert(index < tuple_length);
                    res = sym_tuple_getitem(ctx, tuple_st, index);
                }
            }
            else {
                res = sym_new_not_null(ctx);
            }
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_NOS_DICT: {
            JitOptSymbol *nos;
            nos = stack_pointer[-2];
            if (sym_matches_type(nos, &PyDict_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(nos, &PyDict_Type);
            break;
        }

        case _GUARD_TOS_DICT: {
            JitOptSymbol *tos;
            tos = stack_pointer[-1];
            if (sym_matches_type(tos, &PyDict_Type)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_type(tos, &PyDict_Type);
            break;
        }

        case _BINARY_OP_SUBSCR_DICT: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BINARY_OP_SUBSCR_CHECK_FUNC: {
            JitOptSymbol *getitem;
            getitem = sym_new_not_null(ctx);
            stack_pointer[0] = getitem;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BINARY_OP_SUBSCR_INIT_CALL: {
            _Py_UOpsAbstractFrame *new_frame;
            new_frame = NULL;
            ctx->done = true;
            stack_pointer[-3] = (JitOptSymbol *)new_frame;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LIST_APPEND: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _SET_ADD: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_SUBSCR: {
            stack_pointer += -3;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_SUBSCR_LIST_INT: {
            stack_pointer += -3;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_SUBSCR_DICT: {
            stack_pointer += -3;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _DELETE_SUBSCR: {
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_INTRINSIC_1: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-1] = res;
            break;
        }

        case _CALL_INTRINSIC_2: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _RETURN_VALUE: {
            JitOptSymbol *retval;
            JitOptSymbol *res;
            retval = stack_pointer[-1];
            JitOptSymbol *temp = retval;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            ctx->frame->stack_pointer = stack_pointer;
            frame_pop(ctx);
            stack_pointer = ctx->frame->stack_pointer;
            assert(corresponding_check_stack == NULL);
            assert(co != NULL);
            int framesize = co->co_framesize;
            assert(framesize > 0);
            assert(framesize <= curr_space);
            curr_space -= framesize;
            co = get_code(this_instr);
            if (co == NULL) {
                ctx->done = true;
            }
            res = temp;
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GET_AITER: {
            JitOptSymbol *iter;
            iter = sym_new_not_null(ctx);
            stack_pointer[-1] = iter;
            break;
        }

        case _GET_ANEXT: {
            JitOptSymbol *awaitable;
            awaitable = sym_new_not_null(ctx);
            stack_pointer[0] = awaitable;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GET_AWAITABLE: {
            JitOptSymbol *iter;
            iter = sym_new_not_null(ctx);
            stack_pointer[-1] = iter;
            break;
        }

        /* _SEND is not a viable micro-op for tier 2 */

        case _SEND_GEN_FRAME: {
            ctx->done = true;
            break;
        }

        case _YIELD_VALUE: {
            JitOptSymbol *res;
            res = sym_new_unknown(ctx);
            stack_pointer[-1] = res;
            break;
        }

        case _POP_EXCEPT: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_COMMON_CONSTANT: {
            JitOptSymbol *value;
            value = sym_new_not_null(ctx);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_BUILD_CLASS: {
            JitOptSymbol *bc;
            bc = sym_new_not_null(ctx);
            stack_pointer[0] = bc;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_NAME: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _DELETE_NAME: {
            break;
        }

        case _UNPACK_SEQUENCE: {
            JitOptSymbol **values;
            values = &stack_pointer[-1];
            for (int i = 0; i < oparg; i++) {
                values[i] = sym_new_unknown(ctx);
            }
            stack_pointer += -1 + oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _UNPACK_SEQUENCE_TWO_TUPLE: {
            JitOptSymbol *seq;
            JitOptSymbol *val1;
            JitOptSymbol *val0;
            seq = stack_pointer[-1];
            val0 = sym_tuple_getitem(ctx, seq, 0);
            val1 = sym_tuple_getitem(ctx, seq, 1);
            stack_pointer[-1] = val1;
            stack_pointer[0] = val0;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _UNPACK_SEQUENCE_TUPLE: {
            JitOptSymbol *seq;
            JitOptSymbol **values;
            seq = stack_pointer[-1];
            values = &stack_pointer[-1];
            for (int i = 0; i < oparg; i++) {
                values[i] = sym_tuple_getitem(ctx, seq, oparg - i - 1);
            }
            stack_pointer += -1 + oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _UNPACK_SEQUENCE_LIST: {
            JitOptSymbol **values;
            values = &stack_pointer[-1];
            for (int _i = oparg; --_i >= 0;) {
                values[_i] = sym_new_not_null(ctx);
            }
            stack_pointer += -1 + oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _UNPACK_EX: {
            JitOptSymbol **values;
            values = &stack_pointer[-1];
            int totalargs = (oparg & 0xFF) + (oparg >> 8) + 1;
            for (int i = 0; i < totalargs; i++) {
                values[i] = sym_new_unknown(ctx);
            }
            stack_pointer += (oparg & 0xFF) + (oparg >> 8);
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_ATTR: {
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _DELETE_ATTR: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_GLOBAL: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _DELETE_GLOBAL: {
            break;
        }

        case _LOAD_LOCALS: {
            JitOptSymbol *locals;
            locals = sym_new_not_null(ctx);
            stack_pointer[0] = locals;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        /* _LOAD_FROM_DICT_OR_GLOBALS is not a viable micro-op for tier 2 */

        case _LOAD_NAME: {
            JitOptSymbol *v;
            v = sym_new_not_null(ctx);
            stack_pointer[0] = v;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_GLOBAL: {
            JitOptSymbol **res;
            res = &stack_pointer[0];
            res[0] = sym_new_not_null(ctx);
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _PUSH_NULL_CONDITIONAL: {
            JitOptSymbol **null;
            null = &stack_pointer[0];
            if (oparg & 1) {
                REPLACE_OP(this_instr, _PUSH_NULL, 0, 0);
                null[0] = sym_new_null(ctx);
            }
            else {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            stack_pointer += (oparg & 1);
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_GLOBALS_VERSION: {
            break;
        }

        case _LOAD_GLOBAL_MODULE: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_GLOBAL_BUILTINS: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _DELETE_FAST: {
            break;
        }

        case _MAKE_CELL: {
            break;
        }

        case _DELETE_DEREF: {
            break;
        }

        case _LOAD_FROM_DICT_OR_DEREF: {
            JitOptSymbol *value;
            value = sym_new_not_null(ctx);
            stack_pointer[-1] = value;
            break;
        }

        case _LOAD_DEREF: {
            JitOptSymbol *value;
            value = sym_new_not_null(ctx);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_DEREF: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _COPY_FREE_VARS: {
            break;
        }

        case _BUILD_STRING: {
            JitOptSymbol *str;
            str = sym_new_type(ctx, &PyUnicode_Type);
            stack_pointer[-oparg] = str;
            stack_pointer += 1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BUILD_INTERPOLATION: {
            JitOptSymbol *interpolation;
            interpolation = sym_new_not_null(ctx);
            stack_pointer[-2 - (oparg & 1)] = interpolation;
            stack_pointer += -1 - (oparg & 1);
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BUILD_TEMPLATE: {
            JitOptSymbol *template;
            template = sym_new_not_null(ctx);
            stack_pointer[-2] = template;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BUILD_TUPLE: {
            JitOptSymbol **values;
            JitOptSymbol *tup;
            values = &stack_pointer[-oparg];
            tup = sym_new_tuple(ctx, oparg, values);
            stack_pointer[-oparg] = tup;
            stack_pointer += 1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BUILD_LIST: {
            JitOptSymbol *list;
            list = sym_new_type(ctx, &PyList_Type);
            stack_pointer[-oparg] = list;
            stack_pointer += 1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LIST_EXTEND: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _SET_UPDATE: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BUILD_SET: {
            JitOptSymbol *set;
            set = sym_new_type(ctx, &PySet_Type);
            stack_pointer[-oparg] = set;
            stack_pointer += 1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BUILD_MAP: {
            JitOptSymbol *map;
            map = sym_new_type(ctx, &PyDict_Type);
            stack_pointer[-oparg*2] = map;
            stack_pointer += 1 - oparg*2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _SETUP_ANNOTATIONS: {
            break;
        }

        case _DICT_UPDATE: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _DICT_MERGE: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _MAP_ADD: {
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_SUPER_ATTR_ATTR: {
            JitOptSymbol *attr_st;
            attr_st = sym_new_not_null(ctx);
            stack_pointer[-3] = attr_st;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_SUPER_ATTR_METHOD: {
            JitOptSymbol *attr;
            JitOptSymbol *self_or_null;
            attr = sym_new_not_null(ctx);
            self_or_null = sym_new_not_null(ctx);
            stack_pointer[-3] = attr;
            stack_pointer[-2] = self_or_null;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_ATTR: {
            JitOptSymbol *owner;
            JitOptSymbol *attr;
            JitOptSymbol **self_or_null;
            owner = stack_pointer[-1];
            self_or_null = &stack_pointer[0];
            (void)owner;
            attr = sym_new_not_null(ctx);
            if (oparg &1) {
                self_or_null[0] = sym_new_unknown(ctx);
            }
            stack_pointer[-1] = attr;
            stack_pointer += (oparg&1);
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_TYPE_VERSION: {
            JitOptSymbol *owner;
            owner = stack_pointer[-1];
            uint32_t type_version = (uint32_t)this_instr->operand0;
            assert(type_version);
            if (sym_matches_type_version(owner, type_version)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            } else {
                PyTypeObject *type = _PyType_LookupByVersion(type_version);
                if (type) {
                    if (sym_set_type_version(owner, type_version)) {
                        PyType_Watch(TYPE_WATCHER_ID, (PyObject *)type);
                        _Py_BloomFilter_Add(dependencies, type);
                    }
                }
            }
            break;
        }

        case _GUARD_TYPE_VERSION_AND_LOCK: {
            break;
        }

        case _CHECK_MANAGED_OBJECT_HAS_VALUES: {
            break;
        }

        case _LOAD_ATTR_INSTANCE_VALUE: {
            JitOptSymbol *attr;
            uint16_t offset = (uint16_t)this_instr->operand0;
            attr = sym_new_not_null(ctx);
            (void)offset;
            stack_pointer[-1] = attr;
            break;
        }

        case _LOAD_ATTR_MODULE: {
            JitOptSymbol *owner;
            JitOptSymbol *attr;
            owner = stack_pointer[-1];
            uint32_t dict_version = (uint32_t)this_instr->operand0;
            uint16_t index = (uint16_t)this_instr->operand0;
            (void)dict_version;
            (void)index;
            attr = NULL;
            if (sym_is_const(ctx, owner)) {
                PyModuleObject *mod = (PyModuleObject *)sym_get_const(ctx, owner);
                if (PyModule_CheckExact(mod)) {
                    PyObject *dict = mod->md_dict;
                    stack_pointer[-1] = attr;
                    uint64_t watched_mutations = get_mutations(dict);
                    if (watched_mutations < _Py_MAX_ALLOWED_GLOBALS_MODIFICATIONS) {
                        PyDict_Watch(GLOBALS_WATCHER_ID, dict);
                        _Py_BloomFilter_Add(dependencies, dict);
                        PyObject *res = convert_global_to_const(this_instr, dict, true);
                        if (res == NULL) {
                            attr = sym_new_not_null(ctx);
                        }
                        else {
                            attr = sym_new_const(ctx, res);
                        }
                    }
                }
            }
            if (attr == NULL) {
                attr = sym_new_not_null(ctx);
            }
            stack_pointer[-1] = attr;
            break;
        }

        case _LOAD_ATTR_WITH_HINT: {
            JitOptSymbol *attr;
            uint16_t hint = (uint16_t)this_instr->operand0;
            attr = sym_new_not_null(ctx);
            (void)hint;
            stack_pointer[-1] = attr;
            break;
        }

        case _LOAD_ATTR_SLOT: {
            JitOptSymbol *attr;
            uint16_t index = (uint16_t)this_instr->operand0;
            attr = sym_new_not_null(ctx);
            (void)index;
            stack_pointer[-1] = attr;
            break;
        }

        case _CHECK_ATTR_CLASS: {
            break;
        }

        case _LOAD_ATTR_CLASS: {
            JitOptSymbol *attr;
            PyObject *descr = (PyObject *)this_instr->operand0;
            attr = sym_new_not_null(ctx);
            (void)descr;
            stack_pointer[-1] = attr;
            break;
        }

        case _LOAD_ATTR_PROPERTY_FRAME: {
            _Py_UOpsAbstractFrame *new_frame;
            PyObject *fget = (PyObject *)this_instr->operand0;
            (void)fget;
            new_frame = NULL;
            ctx->done = true;
            stack_pointer[-1] = (JitOptSymbol *)new_frame;
            break;
        }

        /* _LOAD_ATTR_GETATTRIBUTE_OVERRIDDEN is not a viable micro-op for tier 2 */

        case _GUARD_DORV_NO_DICT: {
            break;
        }

        case _STORE_ATTR_INSTANCE_VALUE: {
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_ATTR_WITH_HINT: {
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _STORE_ATTR_SLOT: {
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _COMPARE_OP: {
            JitOptSymbol *res;
            if (oparg & 16) {
                res = sym_new_type(ctx, &PyBool_Type);
            }
            else {
                res = _Py_uop_sym_new_not_null(ctx);
            }
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _COMPARE_OP_FLOAT: {
            JitOptSymbol *res;
            res = sym_new_type(ctx, &PyBool_Type);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _COMPARE_OP_INT: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            if (sym_is_const(ctx, left) && sym_is_const(ctx, right)) {
                assert(PyLong_CheckExact(sym_get_const(ctx, left)));
                assert(PyLong_CheckExact(sym_get_const(ctx, right)));
                PyObject *tmp = PyObject_RichCompare(sym_get_const(ctx, left),
                    sym_get_const(ctx, right),
                    oparg >> 5);
                if (tmp == NULL) {
                    goto error;
                }
                assert(PyBool_Check(tmp));
                assert(_Py_IsImmortal(tmp));
                REPLACE_OP(this_instr, _POP_TWO_LOAD_CONST_INLINE_BORROW, 0, (uintptr_t)tmp);
                res = sym_new_const(ctx, tmp);
                stack_pointer[-2] = res;
                stack_pointer += -1;
                assert(WITHIN_STACK_BOUNDS());
                Py_DECREF(tmp);
            }
            else {
                res = sym_new_type(ctx, &PyBool_Type);
                stack_pointer += -1;
            }
            stack_pointer[-1] = res;
            break;
        }

        case _COMPARE_OP_STR: {
            JitOptSymbol *res;
            res = sym_new_type(ctx, &PyBool_Type);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _IS_OP: {
            JitOptSymbol *res;
            res = sym_new_type(ctx, &PyBool_Type);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CONTAINS_OP: {
            JitOptSymbol *res;
            res = sym_new_type(ctx, &PyBool_Type);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_TOS_ANY_SET: {
            JitOptSymbol *tos;
            tos = stack_pointer[-1];
            if (sym_matches_type(tos, &PySet_Type) ||
                sym_matches_type(tos, &PyFrozenSet_Type))
            {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            break;
        }

        case _CONTAINS_OP_SET: {
            JitOptSymbol *res;
            res = sym_new_type(ctx, &PyBool_Type);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CONTAINS_OP_DICT: {
            JitOptSymbol *res;
            res = sym_new_type(ctx, &PyBool_Type);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CHECK_EG_MATCH: {
            JitOptSymbol *rest;
            JitOptSymbol *match;
            rest = sym_new_not_null(ctx);
            match = sym_new_not_null(ctx);
            stack_pointer[-2] = rest;
            stack_pointer[-1] = match;
            break;
        }

        case _CHECK_EXC_MATCH: {
            JitOptSymbol *b;
            b = sym_new_not_null(ctx);
            stack_pointer[-1] = b;
            break;
        }

        case _IMPORT_NAME: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _IMPORT_FROM: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        /* _POP_JUMP_IF_FALSE is not a viable micro-op for tier 2 */

        /* _POP_JUMP_IF_TRUE is not a viable micro-op for tier 2 */

        case _IS_NONE: {
            JitOptSymbol *b;
            b = sym_new_not_null(ctx);
            stack_pointer[-1] = b;
            break;
        }

        case _GET_LEN: {
            JitOptSymbol *len;
            len = sym_new_not_null(ctx);
            stack_pointer[0] = len;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _MATCH_CLASS: {
            JitOptSymbol *attrs;
            attrs = sym_new_not_null(ctx);
            stack_pointer[-3] = attrs;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _MATCH_MAPPING: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _MATCH_SEQUENCE: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _MATCH_KEYS: {
            JitOptSymbol *values_or_none;
            values_or_none = sym_new_not_null(ctx);
            stack_pointer[0] = values_or_none;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GET_ITER: {
            JitOptSymbol *iter;
            iter = sym_new_not_null(ctx);
            stack_pointer[-1] = iter;
            break;
        }

        case _GET_YIELD_FROM_ITER: {
            JitOptSymbol *iter;
            iter = sym_new_not_null(ctx);
            stack_pointer[-1] = iter;
            break;
        }

        /* _FOR_ITER is not a viable micro-op for tier 2 */

        case _FOR_ITER_TIER_TWO: {
            JitOptSymbol *next;
            next = sym_new_not_null(ctx);
            stack_pointer[0] = next;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        /* _INSTRUMENTED_FOR_ITER is not a viable micro-op for tier 2 */

        case _ITER_CHECK_LIST: {
            break;
        }

        /* _ITER_JUMP_LIST is not a viable micro-op for tier 2 */

        case _GUARD_NOT_EXHAUSTED_LIST: {
            break;
        }

        /* _ITER_NEXT_LIST is not a viable micro-op for tier 2 */

        case _ITER_NEXT_LIST_TIER_TWO: {
            JitOptSymbol *next;
            next = sym_new_not_null(ctx);
            stack_pointer[0] = next;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _ITER_CHECK_TUPLE: {
            break;
        }

        /* _ITER_JUMP_TUPLE is not a viable micro-op for tier 2 */

        case _GUARD_NOT_EXHAUSTED_TUPLE: {
            break;
        }

        case _ITER_NEXT_TUPLE: {
            JitOptSymbol *next;
            next = sym_new_not_null(ctx);
            stack_pointer[0] = next;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _ITER_CHECK_RANGE: {
            break;
        }

        /* _ITER_JUMP_RANGE is not a viable micro-op for tier 2 */

        case _GUARD_NOT_EXHAUSTED_RANGE: {
            break;
        }

        case _ITER_NEXT_RANGE: {
            JitOptSymbol *next;
            next = sym_new_type(ctx, &PyLong_Type);
            stack_pointer[0] = next;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _FOR_ITER_GEN_FRAME: {
            ctx->done = true;
            break;
        }

        case _INSERT_NULL: {
            JitOptSymbol *self;
            JitOptSymbol **method_and_self;
            self = stack_pointer[-1];
            method_and_self = &stack_pointer[-1];
            method_and_self[0] = sym_new_null(ctx);
            method_and_self[1] = self;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_SPECIAL: {
            JitOptSymbol **method_and_self;
            method_and_self = &stack_pointer[-2];
            method_and_self[0] = sym_new_not_null(ctx);
            method_and_self[1] = sym_new_unknown(ctx);
            break;
        }

        case _WITH_EXCEPT_START: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _PUSH_EXC_INFO: {
            JitOptSymbol *prev_exc;
            JitOptSymbol *new_exc;
            prev_exc = sym_new_not_null(ctx);
            new_exc = sym_new_not_null(ctx);
            stack_pointer[-1] = prev_exc;
            stack_pointer[0] = new_exc;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_DORV_VALUES_INST_ATTR_FROM_DICT: {
            break;
        }

        case _GUARD_KEYS_VERSION: {
            break;
        }

        case _LOAD_ATTR_METHOD_WITH_VALUES: {
            JitOptSymbol *owner;
            JitOptSymbol *attr;
            JitOptSymbol *self;
            owner = stack_pointer[-1];
            PyObject *descr = (PyObject *)this_instr->operand0;
            (void)descr;
            attr = sym_new_not_null(ctx);
            self = owner;
            stack_pointer[-1] = attr;
            stack_pointer[0] = self;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_ATTR_METHOD_NO_DICT: {
            JitOptSymbol *owner;
            JitOptSymbol *attr;
            JitOptSymbol *self;
            owner = stack_pointer[-1];
            PyObject *descr = (PyObject *)this_instr->operand0;
            (void)descr;
            attr = sym_new_not_null(ctx);
            self = owner;
            stack_pointer[-1] = attr;
            stack_pointer[0] = self;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES: {
            JitOptSymbol *attr;
            attr = sym_new_not_null(ctx);
            stack_pointer[-1] = attr;
            break;
        }

        case _LOAD_ATTR_NONDESCRIPTOR_NO_DICT: {
            JitOptSymbol *attr;
            attr = sym_new_not_null(ctx);
            stack_pointer[-1] = attr;
            break;
        }

        case _CHECK_ATTR_METHOD_LAZY_DICT: {
            break;
        }

        case _LOAD_ATTR_METHOD_LAZY_DICT: {
            JitOptSymbol *owner;
            JitOptSymbol *attr;
            JitOptSymbol *self;
            owner = stack_pointer[-1];
            PyObject *descr = (PyObject *)this_instr->operand0;
            (void)descr;
            attr = sym_new_not_null(ctx);
            self = owner;
            stack_pointer[-1] = attr;
            stack_pointer[0] = self;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _MAYBE_EXPAND_METHOD: {
            JitOptSymbol **args;
            JitOptSymbol *func;
            JitOptSymbol *maybe_self;
            args = &stack_pointer[-oparg];
            args = &stack_pointer[-oparg];
            (void)args;
            func = sym_new_not_null(ctx);
            maybe_self = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = func;
            stack_pointer[-1 - oparg] = maybe_self;
            break;
        }

        /* _DO_CALL is not a viable micro-op for tier 2 */

        /* _MONITOR_CALL is not a viable micro-op for tier 2 */

        case _PY_FRAME_GENERAL: {
            _Py_UOpsAbstractFrame *new_frame;
            PyCodeObject *co = NULL;
            assert((this_instr + 2)->opcode == _PUSH_FRAME);
            co = get_code_with_logging((this_instr + 2));
            if (co == NULL) {
                ctx->done = true;
                break;
            }
            new_frame = frame_new(ctx, co, 0, NULL, 0);
            stack_pointer[-2 - oparg] = (JitOptSymbol *)new_frame;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CHECK_FUNCTION_VERSION: {
            JitOptSymbol *callable;
            callable = stack_pointer[-2 - oparg];
            uint32_t func_version = (uint32_t)this_instr->operand0;
            if (sym_is_const(ctx, callable) && sym_matches_type(callable, &PyFunction_Type)) {
                assert(PyFunction_Check(sym_get_const(ctx, callable)));
                REPLACE_OP(this_instr, _CHECK_FUNCTION_VERSION_INLINE, 0, func_version);
                this_instr->operand1 = (uintptr_t)sym_get_const(ctx, callable);
            }
            sym_set_type(callable, &PyFunction_Type);
            break;
        }

        case _CHECK_FUNCTION_VERSION_INLINE: {
            break;
        }

        case _CHECK_METHOD_VERSION: {
            break;
        }

        case _EXPAND_METHOD: {
            break;
        }

        case _CHECK_IS_NOT_PY_CALLABLE: {
            break;
        }

        case _CALL_NON_PY_GENERAL: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CHECK_CALL_BOUND_METHOD_EXACT_ARGS: {
            JitOptSymbol *null;
            JitOptSymbol *callable;
            null = stack_pointer[-1 - oparg];
            callable = stack_pointer[-2 - oparg];
            sym_set_null(null);
            sym_set_type(callable, &PyMethod_Type);
            break;
        }

        case _INIT_CALL_BOUND_METHOD_EXACT_ARGS: {
            JitOptSymbol *self_or_null;
            JitOptSymbol *callable;
            self_or_null = stack_pointer[-1 - oparg];
            callable = stack_pointer[-2 - oparg];
            callable = sym_new_not_null(ctx);
            self_or_null = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = callable;
            stack_pointer[-1 - oparg] = self_or_null;
            break;
        }

        case _CHECK_PEP_523: {
            if (_PyInterpreterState_GET()->eval_frame == NULL) {
                REPLACE_OP(this_instr, _NOP, 0 ,0);
            }
            break;
        }

        case _CHECK_FUNCTION_EXACT_ARGS: {
            JitOptSymbol *self_or_null;
            JitOptSymbol *callable;
            self_or_null = stack_pointer[-1 - oparg];
            callable = stack_pointer[-2 - oparg];
            assert(sym_matches_type(callable, &PyFunction_Type));
            if (sym_is_const(ctx, callable)) {
                if (sym_is_null(self_or_null) || sym_is_not_null(self_or_null)) {
                    PyFunctionObject *func = (PyFunctionObject *)sym_get_const(ctx, callable);
                    PyCodeObject *co = (PyCodeObject *)func->func_code;
                    if (co->co_argcount == oparg + !sym_is_null(self_or_null)) {
                        REPLACE_OP(this_instr, _NOP, 0 ,0);
                    }
                }
            }
            break;
        }

        case _CHECK_STACK_SPACE: {
            assert(corresponding_check_stack == NULL);
            corresponding_check_stack = this_instr;
            break;
        }

        case _CHECK_RECURSION_REMAINING: {
            break;
        }

        case _INIT_CALL_PY_EXACT_ARGS: {
            JitOptSymbol **args;
            JitOptSymbol *self_or_null;
            _Py_UOpsAbstractFrame *new_frame;
            args = &stack_pointer[-oparg];
            self_or_null = stack_pointer[-1 - oparg];
            int argcount = oparg;
            PyCodeObject *co = NULL;
            assert((this_instr + 2)->opcode == _PUSH_FRAME);
            co = get_code_with_logging((this_instr + 2));
            if (co == NULL) {
                ctx->done = true;
                break;
            }
            assert(self_or_null != NULL);
            assert(args != NULL);
            if (sym_is_not_null(self_or_null)) {
                args--;
                argcount++;
            }
            if (sym_is_null(self_or_null) || sym_is_not_null(self_or_null)) {
                new_frame = frame_new(ctx, co, 0, args, argcount);
            } else {
                new_frame = frame_new(ctx, co, 0, NULL, 0);
            }
            stack_pointer[-2 - oparg] = (JitOptSymbol *)new_frame;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _PUSH_FRAME: {
            _Py_UOpsAbstractFrame *new_frame;
            new_frame = (_Py_UOpsAbstractFrame *)stack_pointer[-1];
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            ctx->frame->stack_pointer = stack_pointer;
            ctx->frame = new_frame;
            ctx->curr_frame_depth++;
            stack_pointer = new_frame->stack_pointer;
            co = get_code(this_instr);
            if (co == NULL) {
                ctx->done = true;
                break;
            }
            int framesize = co->co_framesize;
            assert(framesize > 0);
            curr_space += framesize;
            if (curr_space < 0 || curr_space > INT32_MAX) {
                ctx->done = true;
                break;
            }
            max_space = curr_space > max_space ? curr_space : max_space;
            if (first_valid_check_stack == NULL) {
                first_valid_check_stack = corresponding_check_stack;
            }
            else if (corresponding_check_stack) {
                corresponding_check_stack->opcode = _NOP;
            }
            corresponding_check_stack = NULL;
            break;
        }

        case _GUARD_NOS_NULL: {
            JitOptSymbol *null;
            null = stack_pointer[-2];
            if (sym_is_null(null)) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_null(null);
            break;
        }

        case _GUARD_CALLABLE_TYPE_1: {
            JitOptSymbol *callable;
            callable = stack_pointer[-3];
            if (sym_get_const(ctx, callable) == (PyObject *)&PyType_Type) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_const(callable, (PyObject *)&PyType_Type);
            break;
        }

        case _CALL_TYPE_1: {
            JitOptSymbol *arg;
            JitOptSymbol *res;
            arg = stack_pointer[-1];
            if (sym_has_type(arg)) {
                res = sym_new_const(ctx, (PyObject *)sym_get_type(arg));
            }
            else {
                res = sym_new_not_null(ctx);
            }
            stack_pointer[-3] = res;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_CALLABLE_STR_1: {
            JitOptSymbol *callable;
            callable = stack_pointer[-3];
            if (sym_get_const(ctx, callable) == (PyObject *)&PyUnicode_Type) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_const(callable, (PyObject *)&PyUnicode_Type);
            break;
        }

        case _CALL_STR_1: {
            JitOptSymbol *arg;
            JitOptSymbol *res;
            arg = stack_pointer[-1];
            if (sym_matches_type(arg, &PyUnicode_Type)) {
                res = arg;
            }
            else {
                res = sym_new_type(ctx, &PyUnicode_Type);
            }
            stack_pointer[-3] = res;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_CALLABLE_TUPLE_1: {
            JitOptSymbol *callable;
            callable = stack_pointer[-3];
            if (sym_get_const(ctx, callable) == (PyObject *)&PyTuple_Type) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_const(callable, (PyObject *)&PyTuple_Type);
            break;
        }

        case _CALL_TUPLE_1: {
            JitOptSymbol *arg;
            JitOptSymbol *res;
            arg = stack_pointer[-1];
            if (sym_matches_type(arg, &PyTuple_Type)) {
                res = arg;
            }
            else {
                res = sym_new_type(ctx, &PyTuple_Type);
            }
            stack_pointer[-3] = res;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CHECK_AND_ALLOCATE_OBJECT: {
            JitOptSymbol **args;
            JitOptSymbol *self;
            JitOptSymbol *init;
            args = &stack_pointer[-oparg];
            args = &stack_pointer[-oparg];
            uint32_t type_version = (uint32_t)this_instr->operand0;
            (void)type_version;
            (void)args;
            self = sym_new_not_null(ctx);
            init = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = self;
            stack_pointer[-1 - oparg] = init;
            break;
        }

        case _CREATE_INIT_FRAME: {
            _Py_UOpsAbstractFrame *init_frame;
            init_frame = NULL;
            ctx->done = true;
            stack_pointer[-2 - oparg] = (JitOptSymbol *)init_frame;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _EXIT_INIT_CHECK: {
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_BUILTIN_CLASS: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_BUILTIN_O: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_BUILTIN_FAST: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_BUILTIN_FAST_WITH_KEYWORDS: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_CALLABLE_LEN: {
            JitOptSymbol *callable;
            callable = stack_pointer[-3];
            PyObject *len = _PyInterpreterState_GET()->callable_cache.len;
            if (sym_get_const(ctx, callable) == len) {
                REPLACE_OP(this_instr, _NOP, 0, 0);
            }
            sym_set_const(callable, len);
            break;
        }

        case _CALL_LEN: {
            JitOptSymbol *res;
            res = sym_new_type(ctx, &PyLong_Type);
            stack_pointer[-3] = res;
            stack_pointer += -2;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_ISINSTANCE: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_LIST_APPEND: {
            stack_pointer += -3;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_METHOD_DESCRIPTOR_O: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_METHOD_DESCRIPTOR_NOARGS: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CALL_METHOD_DESCRIPTOR_FAST: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2 - oparg] = res;
            stack_pointer += -1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        /* _MONITOR_CALL_KW is not a viable micro-op for tier 2 */

        case _MAYBE_EXPAND_METHOD_KW: {
            break;
        }

        /* _DO_CALL_KW is not a viable micro-op for tier 2 */

        case _PY_FRAME_KW: {
            _Py_UOpsAbstractFrame *new_frame;
            new_frame = NULL;
            ctx->done = true;
            stack_pointer[-3 - oparg] = (JitOptSymbol *)new_frame;
            stack_pointer += -2 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CHECK_FUNCTION_VERSION_KW: {
            break;
        }

        case _CHECK_METHOD_VERSION_KW: {
            break;
        }

        case _EXPAND_METHOD_KW: {
            break;
        }

        case _CHECK_IS_NOT_PY_CALLABLE_KW: {
            break;
        }

        case _CALL_KW_NON_PY: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-3 - oparg] = res;
            stack_pointer += -2 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _MAKE_CALLARGS_A_TUPLE: {
            break;
        }

        /* _DO_CALL_FUNCTION_EX is not a viable micro-op for tier 2 */

        case _MAKE_FUNCTION: {
            JitOptSymbol *func;
            func = sym_new_not_null(ctx);
            stack_pointer[-1] = func;
            break;
        }

        case _SET_FUNCTION_ATTRIBUTE: {
            JitOptSymbol *func_out;
            func_out = sym_new_not_null(ctx);
            stack_pointer[-2] = func_out;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _RETURN_GENERATOR: {
            JitOptSymbol *res;
            ctx->frame->stack_pointer = stack_pointer;
            frame_pop(ctx);
            stack_pointer = ctx->frame->stack_pointer;
            res = sym_new_unknown(ctx);
            assert(corresponding_check_stack == NULL);
            assert(co != NULL);
            int framesize = co->co_framesize;
            assert(framesize > 0);
            assert(framesize <= curr_space);
            curr_space -= framesize;
            stack_pointer[0] = res;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            co = get_code(this_instr);
            if (co == NULL) {
                ctx->done = true;
            }
            break;
        }

        case _BUILD_SLICE: {
            JitOptSymbol *slice;
            slice = sym_new_type(ctx, &PySlice_Type);
            stack_pointer[-oparg] = slice;
            stack_pointer += 1 - oparg;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CONVERT_VALUE: {
            JitOptSymbol *result;
            result = sym_new_not_null(ctx);
            stack_pointer[-1] = result;
            break;
        }

        case _FORMAT_SIMPLE: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-1] = res;
            break;
        }

        case _FORMAT_WITH_SPEC: {
            JitOptSymbol *res;
            res = sym_new_not_null(ctx);
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _COPY: {
            JitOptSymbol *bottom;
            JitOptSymbol *top;
            bottom = stack_pointer[-1 - (oparg-1)];
            assert(oparg > 0);
            top = bottom;
            stack_pointer[0] = top;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _BINARY_OP: {
            JitOptSymbol *right;
            JitOptSymbol *left;
            JitOptSymbol *res;
            right = stack_pointer[-1];
            left = stack_pointer[-2];
            bool lhs_int = sym_matches_type(left, &PyLong_Type);
            bool rhs_int = sym_matches_type(right, &PyLong_Type);
            bool lhs_float = sym_matches_type(left, &PyFloat_Type);
            bool rhs_float = sym_matches_type(right, &PyFloat_Type);
            if (!((lhs_int || lhs_float) && (rhs_int || rhs_float))) {
                res = sym_new_unknown(ctx);
            }
            else if (oparg == NB_POWER || oparg == NB_INPLACE_POWER) {
                if (rhs_float) {
                    res = sym_new_unknown(ctx);
                }
                else if (lhs_float) {
                    res = sym_new_type(ctx, &PyFloat_Type);
                }
                else if (!sym_is_const(ctx, right)) {
                    res = sym_new_unknown(ctx);
                }
                else if (_PyLong_IsNegative((PyLongObject *)sym_get_const(ctx, right))) {
                    res = sym_new_type(ctx, &PyFloat_Type);
                }
                else {
                    res = sym_new_type(ctx, &PyLong_Type);
                }
            }
            else if (oparg == NB_TRUE_DIVIDE || oparg == NB_INPLACE_TRUE_DIVIDE) {
                res = sym_new_type(ctx, &PyFloat_Type);
            }
            else if (lhs_int && rhs_int) {
                res = sym_new_type(ctx, &PyLong_Type);
            }
            else {
                res = sym_new_type(ctx, &PyFloat_Type);
            }
            stack_pointer[-2] = res;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _SWAP: {
            JitOptSymbol *top;
            JitOptSymbol *bottom;
            top = stack_pointer[-1];
            bottom = stack_pointer[-2 - (oparg-2)];
            JitOptSymbol *temp = bottom;
            bottom = top;
            top = temp;
            assert(oparg >= 2);
            stack_pointer[-2 - (oparg-2)] = bottom;
            stack_pointer[-1] = top;
            break;
        }

        /* _INSTRUMENTED_LINE is not a viable micro-op for tier 2 */

        /* _INSTRUMENTED_INSTRUCTION is not a viable micro-op for tier 2 */

        /* _INSTRUMENTED_JUMP_FORWARD is not a viable micro-op for tier 2 */

        /* _MONITOR_JUMP_BACKWARD is not a viable micro-op for tier 2 */

        /* _INSTRUMENTED_NOT_TAKEN is not a viable micro-op for tier 2 */

        /* _INSTRUMENTED_POP_JUMP_IF_TRUE is not a viable micro-op for tier 2 */

        /* _INSTRUMENTED_POP_JUMP_IF_FALSE is not a viable micro-op for tier 2 */

        /* _INSTRUMENTED_POP_JUMP_IF_NONE is not a viable micro-op for tier 2 */

        /* _INSTRUMENTED_POP_JUMP_IF_NOT_NONE is not a viable micro-op for tier 2 */

        case _GUARD_IS_TRUE_POP: {
            JitOptSymbol *flag;
            flag = stack_pointer[-1];
            if (sym_is_const(ctx, flag)) {
                PyObject *value = sym_get_const(ctx, flag);
                assert(value != NULL);
                eliminate_pop_guard(this_instr, value != Py_True);
            }
            sym_set_const(flag, Py_True);
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_IS_FALSE_POP: {
            JitOptSymbol *flag;
            flag = stack_pointer[-1];
            if (sym_is_const(ctx, flag)) {
                PyObject *value = sym_get_const(ctx, flag);
                assert(value != NULL);
                eliminate_pop_guard(this_instr, value != Py_False);
            }
            sym_set_const(flag, Py_False);
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_IS_NONE_POP: {
            JitOptSymbol *flag;
            flag = stack_pointer[-1];
            if (sym_is_const(ctx, flag)) {
                PyObject *value = sym_get_const(ctx, flag);
                assert(value != NULL);
                eliminate_pop_guard(this_instr, !Py_IsNone(value));
            }
            else if (sym_has_type(flag)) {
                assert(!sym_matches_type(flag, &_PyNone_Type));
                eliminate_pop_guard(this_instr, true);
            }
            sym_set_const(flag, Py_None);
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _GUARD_IS_NOT_NONE_POP: {
            JitOptSymbol *flag;
            flag = stack_pointer[-1];
            if (sym_is_const(ctx, flag)) {
                PyObject *value = sym_get_const(ctx, flag);
                assert(value != NULL);
                eliminate_pop_guard(this_instr, Py_IsNone(value));
            }
            else if (sym_has_type(flag)) {
                assert(!sym_matches_type(flag, &_PyNone_Type));
                eliminate_pop_guard(this_instr, false);
            }
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _JUMP_TO_TOP: {
            ctx->done = true;
            break;
        }

        case _SET_IP: {
            break;
        }

        case _CHECK_STACK_SPACE_OPERAND: {
            uint32_t framesize = (uint32_t)this_instr->operand0;
            (void)framesize;
            Py_UNREACHABLE();
            break;
        }

        case _SAVE_RETURN_OFFSET: {
            break;
        }

        case _EXIT_TRACE: {
            PyObject *exit_p = (PyObject *)this_instr->operand0;
            (void)exit_p;
            ctx->done = true;
            break;
        }

        case _CHECK_VALIDITY: {
            break;
        }

        case _LOAD_CONST_INLINE: {
            JitOptSymbol *value;
            PyObject *ptr = (PyObject *)this_instr->operand0;
            value = sym_new_const(ctx, ptr);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _POP_TOP_LOAD_CONST_INLINE: {
            JitOptSymbol *value;
            PyObject *ptr = (PyObject *)this_instr->operand0;
            value = sym_new_const(ctx, ptr);
            stack_pointer[-1] = value;
            break;
        }

        case _LOAD_CONST_INLINE_BORROW: {
            JitOptSymbol *value;
            PyObject *ptr = (PyObject *)this_instr->operand0;
            value = sym_new_const(ctx, ptr);
            stack_pointer[0] = value;
            stack_pointer += 1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _POP_TOP_LOAD_CONST_INLINE_BORROW: {
            JitOptSymbol *value;
            PyObject *ptr = (PyObject *)this_instr->operand0;
            value = sym_new_const(ctx, ptr);
            stack_pointer[-1] = value;
            break;
        }

        case _POP_TWO_LOAD_CONST_INLINE_BORROW: {
            JitOptSymbol *value;
            value = sym_new_not_null(ctx);
            stack_pointer[-2] = value;
            stack_pointer += -1;
            assert(WITHIN_STACK_BOUNDS());
            break;
        }

        case _CHECK_FUNCTION: {
            break;
        }

        case _START_EXECUTOR: {
            break;
        }

        case _MAKE_WARM: {
            break;
        }

        case _FATAL_ERROR: {
            break;
        }

        case _DEOPT: {
            break;
        }

        case _ERROR_POP_N: {
            break;
        }

        case _TIER2_RESUME_CHECK: {
            break;
        }

