% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrenchNorm.R
\name{wrenchNorm}
\alias{wrenchNorm}
\title{Computes normalization factors using wrench instead of cumNorm}
\usage{
wrenchNorm(obj, condition)
}
\arguments{
\item{obj}{an MRexperiment object}

\item{condition}{case control label that wrench uses to calculate 
normalization factors}
}
\value{
an MRexperiment object with updated normalization factors.
Accessible by \code{\link{normFactors}}.
}
\description{
Calculates normalization factors using method published by
M. Sentil Kumar et al. (2018) to compute normalization factors which 
considers compositional bias introduced by sequencers.
}
\examples{

data(mouseData)
mouseData <- wrenchNorm(mouseData, condition = mouseData$diet)
head(normFactors(mouseData))

}
\seealso{
\code{\link{cumNorm}} \code{\link{fitZig}}
}
