% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polishDataset.R
\name{polishDataset}
\alias{polishDataset}
\title{Polish dataset for saving}
\usage{
polishDataset(
  x,
  strip.inner.names = TRUE,
  reformat.assay.by.density = 0.3,
  attempt.integer.conversion = TRUE,
  remove.altexp.coldata = TRUE,
  forbid.nested.altexp = TRUE
)
}
\arguments{
\item{x}{A \linkS4class{SummarizedExperiment} or one of its subclasses.}

\item{strip.inner.names}{Logical scalar indicating whether to strip redundant names from internal objects, 
e.g., dimnames of the assays, row names of reduced dimensions, column names of alternative experiments.
This saves some space in the on-disk representation.}

\item{reformat.assay.by.density}{Numeric scalar indicating whether to optimize assay formats based on the density of non-zero values.
Assays with densities above this number are converted to ordinary dense arrays (if they are not already), while those with lower densities are converted to sparse matrices.
This can be disabled by setting it to \code{NULL}.}

\item{attempt.integer.conversion}{Logical scalar indicating whether to convert double-precision assays containing integer values to actually have the integer type.
This can improve efficiency of downstream applications by avoiding the need to operate in double precision.}

\item{remove.altexp.coldata}{Logical scalar indicating whether column data for alternative experiments should be removed.
This defaults to \code{TRUE} as the alternative experiment column data is usually redundant with that of the main experiment.}

\item{forbid.nested.altexp}{Logical scalar indicating whether nested alternative experiments (i.e., alternative experiments of alternative experiments) should be forbidden.
This defaults to \code{TRUE} as nested alternative experiments are usually the result of some mistake in \code{\link{altExp}} preparation.}
}
\value{
A modified copy of \code{x}.
}
\description{
Prepare a \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} to be saved with \code{\link{saveDataset}}.
This performs some minor changes to improve storage efficiency.
}
\examples{
mat <- matrix(rpois(1000, lambda=0.2), 100, 10) * 1.0
rownames(mat) <- sprintf("GENE_\%i", seq_len(nrow(mat)))
colnames(mat) <- head(LETTERS, 10)

library(SingleCellExperiment)
sce <- SingleCellExperiment(list(counts=mat))
str(assay(sce, withDimnames=FALSE))

polished <- polishDataset(sce)
str(assay(polished, withDimnames=FALSE))

}
\author{
Aaron Lun
}
