% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettycode.R
\name{code_theme_list}
\alias{code_theme_list}
\title{Syntax highlighting themes}
\usage{
code_theme_list()
}
\value{
Character vector of the built-in code theme names.
}
\description{
\code{code_theme_list()} lists the built-in code themes.
}
\section{Code themes}{
A theme is a list of character vectors, except for \code{bracket}, see below.
Each character vector must contain RGB colors (e.g. \code{"#a9a9a9"}),
and cli styles, e.g. \code{"bold"}. Entries in the list:
\itemize{
\item \code{reserved}: reserved words
\item \code{number}: numeric literals
\item \code{null}: the \code{NULL} constant
\item \code{operator}: operators, including assignment
\item \code{call}: function calls
\item \code{string}: character literals
\item \code{comment}: comments
\item \code{bracket}: brackets: \code{(){}[]} This is a list of character vectors,
to create "rainbow" brackets. It is recycled for deeply nested lists.
}
}

\section{The default code theme}{
In RStudio, it matches the current theme of the IDE.

You can use three options to customize the code theme:
\itemize{
\item If \code{cli.code_theme} is set, it is used.
\item Otherwise if R is running in RStudio and \code{cli.code_theme_rstudio} is
set, then it is used.
\item Otherwise if T is not running in RStudio and \code{cli.code_theme_terminal}
is set, then it is used.
}

You can set these options to the name of a built-in theme, or to list
that specifies a custom theme. See \code{\link[=code_theme_list]{code_theme_list()}} for the list
of the built-in themes.
}

\examples{
code_theme_list()
code_highlight(deparse(get), code_theme = "Solarized Dark")
}
\seealso{
Other syntax highlighting: 
\code{\link{code_highlight}()}
}
\concept{syntax highlighting}
