% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar_month_factor}
\alias{calendar_month_factor}
\title{Convert a calendar to an ordered factor of month names}
\usage{
calendar_month_factor(x, ..., labels = "en", abbreviate = FALSE)
}
\arguments{
\item{x}{\verb{[calendar]}

A calendar vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{labels}{\verb{[clock_labels / character(1)]}

Character representations of localized weekday names, month names, and
AM/PM names. Either the language code as string (passed on to
\code{\link[=clock_labels_lookup]{clock_labels_lookup()}}), or an object created by \code{\link[=clock_labels]{clock_labels()}}.}

\item{abbreviate}{\verb{[logical(1)]}

If \code{TRUE}, the abbreviated month names from \code{labels} will be used.

If \code{FALSE}, the full month names from \code{labels} will be used.}
}
\value{
An ordered factor representing the months.
}
\description{
\code{calendar_month_factor()} extracts the month values from a calendar and
converts them to an ordered factor of month names. This can be useful in
combination with ggplot2, or for modeling.

This function is only relevant for calendar types that use a month field,
i.e. \code{\link[=year_month_day]{year_month_day()}} and \code{\link[=year_month_weekday]{year_month_weekday()}}. The calendar type must
have at least month precision.
}
\examples{
x <- year_month_day(2019, 1:12)

calendar_month_factor(x)
calendar_month_factor(x, abbreviate = TRUE)
calendar_month_factor(x, labels = "fr")
}
