% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_metric.R
\name{maximize_gam_metric}
\alias{maximize_gam_metric}
\alias{minimize_gam_metric}
\title{Optimize a metric function in binary classification after smoothing via
generalized additive models}
\usage{
maximize_gam_metric(
  data,
  x,
  class,
  metric_func = youden,
  pos_class = NULL,
  neg_class = NULL,
  direction,
  formula = m ~ s(x.sorted),
  optimizer = c("outer", "newton"),
  tol_metric,
  use_midpoints,
  ...
)

minimize_gam_metric(
  data,
  x,
  class,
  metric_func = youden,
  pos_class = NULL,
  neg_class = NULL,
  direction,
  formula = m ~ s(x.sorted),
  optimizer = c("outer", "newton"),
  tol_metric,
  use_midpoints,
  ...
)
}
\arguments{
\item{data}{A data frame or tibble in which the columns that are given in x
and class can be found.}

\item{x}{(character) The variable name to be used for classification,
e.g. predictions or test values.}

\item{class}{(character) The variable name indicating class membership.}

\item{metric_func}{(function) A function that computes a
metric to be maximized. See description.}

\item{pos_class}{The value of class that indicates the positive class.}

\item{neg_class}{The value of class that indicates the negative class.}

\item{direction}{(character) Use ">=" or "<=" to select whether an x value
>= or <= the cutoff predicts the positive class.}

\item{formula}{A GAM formula. See \code{help("gam", package = "mgcv")} for
details.}

\item{optimizer}{An array specifying the numerical optimization method to
use to optimize the smoothing parameter estimation criterion (given by method).
See \code{help("gam", package = "mgcv")} for details.}

\item{tol_metric}{All cutpoints will be returned that lead to a metric
value in the interval [m_max - tol_metric, m_max + tol_metric] where
m_max is the maximum achievable metric value. This can be used to return
multiple decent cutpoints and to avoid floating-point problems.}

\item{use_midpoints}{(logical) If TRUE (default FALSE) the returned optimal
cutpoint will be the mean of the optimal cutpoint and the next highest
observation (for direction = ">") or the next lowest observation
(for direction = "<") which avoids biasing the optimal cutpoint.}

\item{...}{Further arguments that will be passed to metric_func or the
GAM smoother.}
}
\value{
A tibble with the columns \code{optimal_cutpoint}, the corresponding metric
value and \code{roc_curve}, a nested tibble that includes all possible cutoffs
and the corresponding numbers of true and false positives / negatives and
all corresponding metric values.
}
\description{
Given a function for computing a metric in \code{metric_func}, these functions
smooth the function of metric value per cutpoint using generalized additive
models (as implemented in \pkg{mgcv}), then
maximize or minimize the metric by selecting an optimal cutpoint. For further details
on the GAM smoothing see \code{?mgcv::gam}.
The \code{metric} function should accept the following inputs:
\itemize{
 \item \code{tp}: vector of number of true positives
 \item \code{fp}: vector of number of false positives
 \item \code{tn}: vector of number of true negatives
 \item \code{fn}: vector of number of false negatives
}
}
\details{
The above inputs are arrived at by using all unique values in \code{x}, Inf, and
-Inf as possible cutpoints for classifying the variable in class.
}
\examples{
oc <- cutpointr(suicide, dsi, suicide, gender, method = maximize_gam_metric,
metric = accuracy)
plot_metric(oc)
oc <- cutpointr(suicide, dsi, suicide, gender, method = minimize_gam_metric,
metric = abs_d_sens_spec)
plot_metric(oc)
}
\seealso{
Other method functions: 
\code{\link{maximize_boot_metric}()},
\code{\link{maximize_loess_metric}()},
\code{\link{maximize_metric}()},
\code{\link{oc_manual}()},
\code{\link{oc_mean}()},
\code{\link{oc_median}()},
\code{\link{oc_youden_kernel}()},
\code{\link{oc_youden_normal}()}
}
\concept{method functions}
